/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportAtividadeColetivaXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryAtividadeColetiva;
import br.ufsc.esus.fichaatividadecoletiva.FichaAtividadeColetivaTransport;
import br.ufsc.esus.participanterowitem.ParticipanteRowItemTransport;
import br.ufsc.esus.profissionalcborowitem.ProfissionalCboRowItemTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class AtividadeColetiva
extends BD {
    private static final Pattern REMOVE_TAGS = Pattern.compile("<.+?>");

    public void executeMain(int eehCodigo) throws SQLException, JAXBException, IOException, ParseException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosAtividadeColetiva = bdAtividadeColetiva.getDadosAtividadeColetiva();
        while (dadosAtividadeColetiva.next()) {
            AtividadeColetiva atividadeColetiva = new AtividadeColetiva();
            String uuid = atividadeColetiva.getGUID();
            FichaAtividadeColetivaTransport fichaMaster = this.atividadeColetivaMasterThrift(uuid, dadosAtividadeColetiva);
            DadoTransporteTransportAtividadeColetivaXml arrayEnvio = this.montaArrayEnvioDto(fichaMaster, uuid, dadosAtividadeColetiva, eehCodigo);
            this.zipWriter(arrayEnvio, uuid);
            bdEsusHistoricoItens.registratHistoricoItens(eehCodigo, uuid, 6);
            bdAtividadeColetiva.atualizaStatus(uuid, dadosAtividadeColetiva.getInt("co_cds_ficha_ativ_col"));
        }
    }

    private void zipWriter(DadoTransporteTransportAtividadeColetivaXml xmlText, String uuid) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryAtividadeColetiva factoryCadastroIndividual = new ObjectFactoryAtividadeColetiva();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryAtividadeColetiva.class);
        JAXBElement<DadoTransporteTransportAtividadeColetivaXml> element = factoryCadastroIndividual.createDadoTransporteTransportAtividadeColetivaXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    private static String stripTags(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Matcher m = REMOVE_TAGS.matcher(string);
        return m.replaceAll("");
    }

    private FichaAtividadeColetivaTransport atividadeColetivaMasterThrift(String uuid, ResultSet row) throws SQLException, ParseException {
        Long inep;
        String outraLocalidade;
        UnicaLotacaoHeaderTransport arrayUnica = this.montaArrayUnica(row);
        int codAtiv = row.getInt("co_cds_ficha_ativ_col");
        if (AtividadeColetiva.stripTags(row.getString("eav_local_atividade")) != null) {
            outraLocalidade = AtividadeColetiva.stripTags(row.getString("eav_local_atividade").trim());
            inep = null;
        } else {
            inep = row.getLong("eav_inep");
            outraLocalidade = null;
        }
        FichaAtividadeColetivaTransport dadosAct = new FichaAtividadeColetivaTransport();
        dadosAct.setHeaderTransport(arrayUnica);
        dadosAct.setUuidFicha(uuid);
        dadosAct.setOutraLocalidade(outraLocalidade);
        dadosAct.setInep(inep);
        dadosAct.setNumParticipantes(row.getInt("eav_num_participantes"));
        dadosAct.setNumAvaliacoesAlteradas(row.getInt("eav_num_aval_alteradas"));
        dadosAct.setAtividadeTipo(row.getLong("eav_atividade_tipo"));
        dadosAct.setTbCdsOrigem(3);
        dadosAct.setTurno(this.getTurno(row.getInt("co_cds_ficha_ativ_col")));
        dadosAct.setPseEducacao(row.getBoolean("eav_educacao"));
        dadosAct.setPseSaude(row.getBoolean("eav_saude"));
        if (!dadosAct.getPseEducacao().booleanValue() && dadosAct.getPseSaude().booleanValue()) {
            dadosAct.getProfissionais().addAll(this.profissionalCboRowItemThrift(codAtiv));
        }
        dadosAct.getTemasParaReuniao().addAll(this.temasParaReuniao(codAtiv));
        dadosAct.getPublicoAlvo().addAll(this.publicoAlvo(codAtiv));
        dadosAct.getParticipantes().addAll(this.participantes(codAtiv));
        dadosAct.getPraticasEmSaude().addAll(this.praticasTemasParaSaude(codAtiv, "pratica"));
        dadosAct.getTemasParaSaude().addAll(this.praticasTemasParaSaude(codAtiv, "tema"));
        return dadosAct;
    }

    public Long getTurno(int coCdsFichaAtivCol) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet dadosTurno = bdAtividadeColetiva.getTurno(coCdsFichaAtivCol);
        long turno = dadosTurno.next() ? dadosTurno.getLong(1) : 1L;
        return turno;
    }

    private UnicaLotacaoHeaderTransport montaArrayUnica(ResultSet row) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet cbo = bdAtividadeColetiva.getCodCbo(row.getInt("co_cds_ficha_ativ_col"));
        UnicaLotacaoHeaderTransport headerTransport = new UnicaLotacaoHeaderTransport();
        headerTransport.setProfissionalCNS(this.validaCnsBanco(row.getString("eav_responsavel_cns").trim()) ? row.getString("eav_responsavel_cns").trim() : null);
        headerTransport.setCboCodigo2002(cbo.next() ? cbo.getString(1) : null);
        headerTransport.setCnes(row.getString("eav_responsavel_cnes"));
        headerTransport.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("eav_dt_atividade")));
        headerTransport.setCodigoIbgeMunicipio(row.getString("eav_codigo_ibge"));
        return headerTransport;
    }

    private List<ProfissionalCboRowItemTransport> profissionalCboRowItemThrift(int codAtiv) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet dadosProfissional = bdAtividadeColetiva.getDadosProfissional(codAtiv);
        ArrayList<ProfissionalCboRowItemTransport> arrayGeral = new ArrayList<ProfissionalCboRowItemTransport>();
        while (dadosProfissional.next()) {
            ProfissionalCboRowItemTransport array = new ProfissionalCboRowItemTransport();
            array.setCnsProfissional(this.validaCnsBanco(dadosProfissional.getString("cnes_cod_cns")) ? dadosProfissional.getString("cnes_cod_cns") : null);
            array.setCodigoCbo2002(dadosProfissional.getString("cbo"));
            arrayGeral.add(array);
        }
        return arrayGeral;
    }

    private List<Long> temasParaReuniao(int codAtiv) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet dadosTemas = bdAtividadeColetiva.getCodigosTemas(codAtiv);
        ArrayList<Long> codsTema = new ArrayList<Long>();
        while (dadosTemas.next()) {
            codsTema.add(dadosTemas.getLong("co_cds_ativ_col_tema"));
        }
        return codsTema;
    }

    private List<Long> publicoAlvo(int codAtiv) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet dadosPublicoAlvo = bdAtividadeColetiva.getCodigosPublicoAlvo(codAtiv);
        ArrayList<Long> codsPublicoAlvo = new ArrayList<Long>();
        while (dadosPublicoAlvo.next()) {
            codsPublicoAlvo.add(dadosPublicoAlvo.getLong("co_cds_ativ_col_publico_alvo"));
        }
        return codsPublicoAlvo;
    }

    private List<Long> praticasTemasParaSaude(int codAtiv, String tipo) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet dadosPratica = null;
        if (tipo.equals("pratica")) {
            dadosPratica = bdAtividadeColetiva.getCodigosPraticaPratica(codAtiv);
        }
        if (tipo.equals("tema")) {
            dadosPratica = bdAtividadeColetiva.getCodigosPraticaTema(codAtiv);
        }
        ArrayList<Long> codsPratica = new ArrayList<Long>();
        if (dadosPratica != null) {
            while (dadosPratica.next()) {
                codsPratica.add(dadosPratica.getLong("co_cds_ativ_col_pratica"));
            }
        }
        return codsPratica;
    }

    private List<ParticipanteRowItemTransport> participantes(int codAtiv) throws SQLException, ParseException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        ResultSet dadosParticipantes = bdAtividadeColetiva.getDadosParticipantes(codAtiv);
        ArrayList<ParticipanteRowItemTransport> arrayGeral = new ArrayList<ParticipanteRowItemTransport>();
        while (dadosParticipantes.next()) {
            String usuCartaoSus = dadosParticipantes.getString("usu_cartao_sus").trim();
            if (!this.validaCnsBanco(usuCartaoSus)) continue;
            long sexo = 4L;
            if (dadosParticipantes.getString("usu_sexo").equals("M")) {
                sexo = 0L;
            } else if (dadosParticipantes.getString("usu_sexo").equals("F")) {
                sexo = 1L;
            }
            ParticipanteRowItemTransport array = new ParticipanteRowItemTransport();
            Date dtNascimento = dadosParticipantes.getDate("dt_nascimento");
            array.setCnsParticipante(this.validaCnsBanco(usuCartaoSus) ? dadosParticipantes.getString("usu_cartao_sus").trim() : null);
            if (dtNascimento != null) {
                array.setDataNascimento(DataConvert.dateToEpoch(dtNascimento));
            }
            array.setAvaliacaoAlterada(dadosParticipantes.getBoolean("st_avaliacao_alterada"));
            array.setPeso(dadosParticipantes.getDouble("nu_peso") < 1.0 ? 1.0 : dadosParticipantes.getDouble("nu_peso"));
            array.setAltura(dadosParticipantes.getDouble("nu_altura") < 20.0 ? 20.0 : dadosParticipantes.getDouble("nu_altura"));
            array.setSexo(sexo);
            arrayGeral.add(array);
        }
        return arrayGeral;
    }

    private DadoTransporteTransportAtividadeColetivaXml montaArrayEnvioDto(FichaAtividadeColetivaTransport dadosAtividadeColetivaSerializado, String uuid, ResultSet row, int eehCodigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        String eroContraChave = dadosRO.getString("ero_contra_chave");
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(eroContraChave != null ? eroContraChave : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(eroContraChave != null ? eroContraChave : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport arrayVersao = new VersaoTransport();
        arrayVersao.setMajor(3);
        arrayVersao.setMinor(0);
        arrayVersao.setRevision(1);
        DadoTransporteTransportAtividadeColetivaXml dadoTransporteTransportXml = new DadoTransporteTransportAtividadeColetivaXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(6L);
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("eav_uni_cnes"));
        dadoTransporteTransportXml.setCodIbge(row.getString("eav_codigo_ibge"));
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("eav_responsavel_ine"));
        dadoTransporteTransportXml.setNumLote(eehCodigo);
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(arrayVersao);
        dadoTransporteTransportXml.setFichaAtividadeColetivaTransport(dadosAtividadeColetivaSerializado);
        return dadoTransporteTransportXml;
    }

    private ResultSet getDadosOriginadoraRemetente() throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva bdAtividadeColetiva = new br.com.elotech.websaude.integracao.esus.model.AtividadeColetiva();
        return bdAtividadeColetiva.getDadosOriginadoraRemetente();
    }
}

