/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoCadastroDomiciliar;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.com.elotech.websaude.integracao.esus.util.Util;
import br.ufsc.esus.cadastrodomiciliar.CadastroDomiciliarTransport;
import br.ufsc.esus.condicaomoradia.CondicaoMoradiaTransport;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportCadastroDomiciliarXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryCadastroDomiciliar;
import br.ufsc.esus.enderecolocalpermanencia.EnderecoLocalPermanenciaTransport;
import br.ufsc.esus.familiarow.FamiliaRowTransport;
import br.ufsc.esus.instituicaopermanencia.InstituicaoPermanencia;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class CadastroDomiciliar
extends BD {
    public void executeMain(int eehCodigo) throws SQLException, JAXBException, IOException {
        BancoCadastroDomiciliar bdCadastroDomiciliar = new BancoCadastroDomiciliar();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        List<HashMap> dadosCadastroDomiciliar = bdCadastroDomiciliar.getDadosCadastroDomiciliar();
        ResultSet numAtend = bdCadastroDomiciliar.getNumDadosCadastroDomiciliar();
        if (!numAtend.wasNull()) {
            for (HashMap hash : dadosCadastroDomiciliar) {
                CadastroDomiciliar cadastroDomiciliar = new CadastroDomiciliar();
                String uuid = cadastroDomiciliar.getGUID();
                CadastroDomiciliarTransport fichaMaster = this.cadastroDomiciliarThrift(uuid, hash);
                DadoTransporteTransportCadastroDomiciliarXml arrayEnvio = this.montaArrayEnvioDto(fichaMaster, uuid, hash, eehCodigo);
                this.zipWriter(arrayEnvio, uuid);
                bdEsusHistoricoItens.registratHistoricoItens(eehCodigo, uuid, 2);
                Integer co_cds_cad_domiciliar = Long.valueOf(hash.get("co_cds_cad_domiciliar").toString()).intValue();
                bdCadastroDomiciliar.atualizaStatus(uuid, co_cds_cad_domiciliar);
            }
        }
    }

    public void zipWriter(DadoTransporteTransportCadastroDomiciliarXml xmlText, String uuid) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryCadastroDomiciliar factoryCadastroIndividual = new ObjectFactoryCadastroDomiciliar();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryCadastroDomiciliar.class);
        JAXBElement<DadoTransporteTransportCadastroDomiciliarXml> element = factoryCadastroIndividual.createDadoTransporteTransportCadastroDomiciliarXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    private CadastroDomiciliarTransport cadastroDomiciliarThrift(String uuid, HashMap row) throws SQLException {
        CadastroDomiciliarTransport arrayCad = new CadastroDomiciliarTransport();
        arrayCad.setHeaderTransport(this.headerCdsCadastroThrift(row));
        arrayCad.setUuid(uuid);
        arrayCad.setUuidFichaOriginadora(uuid);
        Long tipoImovel = Long.valueOf(Util.verificaNulo(row.get("tipo_imovel")));
        arrayCad.setEnderecoLocalPermanencia(this.enderecoLocalPermanenciaThrift(row));
        arrayCad.setFichaAtualizada(Boolean.TRUE);
        arrayCad.setTpCdsOrigem(3);
        arrayCad.setTipoDeImovel(tipoImovel);
        if (tipoImovel != 0L && (tipoImovel < 2L || tipoImovel > 6L) && tipoImovel != 12L && tipoImovel != 99L && row.get("localizacao") != null) {
            arrayCad.setCondicaoMoradia(this.condicaoMoradiaThrift(row));
        }
        if (tipoImovel == 1L) {
            BancoCadastroDomiciliar bdCadastroIndividual = new BancoCadastroDomiciliar();
            ResultSet dadosAnimais = bdCadastroIndividual.getAnimaisNoDomicilio(Integer.valueOf(Util.verificaNulo(row.get("co_cds_cad_domiciliar"))));
            ArrayList<Long> arrayAnimais = new ArrayList<Long>();
            if (row.get("animais_domicilio") != null) {
                arrayCad.setStAnimaisNoDomicilio(Boolean.valueOf(Util.verificaNulo(row.get("animais_domicilio"))));
                if (Boolean.valueOf(row.get("animais_domicilio").toString()).booleanValue()) {
                    if (!row.get("quantidade_animais_domicilio").equals("0")) {
                        arrayCad.setQuantosAnimaisNoDomicilio((String)row.get("quantidade_animais_domicilio"));
                    }
                    while (dadosAnimais.next()) {
                        arrayAnimais.add(dadosAnimais.getLong("co_pergunta_detalhe"));
                    }
                    arrayCad.getAnimaisNoDomicilio().addAll(arrayAnimais);
                }
            }
            arrayCad.getFamilias().add(this.familiaRowThrift(row));
        }
        if (row.get("ipe_resp_nome") != null && tipoImovel > 6L && tipoImovel < 12L) {
            arrayCad.setInstituicaoPermanencia(this.instituicaoPermanencia(row));
        }
        if (row.get("usu_recusa") != null) {
            arrayCad.setStatusTermoRecusa(Boolean.valueOf(Util.verificaNulo(row.get("usu_recusa"))));
            if (Boolean.valueOf(row.get("usu_recusa").toString()).booleanValue()) {
                arrayCad.setCondicaoMoradia(null);
                arrayCad.setStAnimaisNoDomicilio(null);
                arrayCad.setQuantosAnimaisNoDomicilio(null);
                arrayCad.setInstituicaoPermanencia(null);
                arrayCad.getAnimaisNoDomicilio().clear();
                arrayCad.getFamilias().clear();
            }
        } else {
            arrayCad.setStatusTermoRecusa(false);
        }
        return arrayCad;
    }

    public InstituicaoPermanencia instituicaoPermanencia(HashMap row) throws SQLException {
        InstituicaoPermanencia instituicaoPermanencia = new InstituicaoPermanencia();
        if (row.get("ipe_nome") != null && !row.get("ipe_nome").equals("")) {
            instituicaoPermanencia.setNomeInstituicaoPermanencia((String)row.get("ipe_nome"));
        }
        if (row.get("ipe_st_outros") != null && !row.get("ipe_st_outros").equals("")) {
            instituicaoPermanencia.setStOutrosProfissionaisVinculados(Boolean.valueOf(Util.verificaNulo(row.get("ipe_st_outros"))));
        }
        instituicaoPermanencia.setNomeResponsavelTecnico((String)row.get("ipe_resp_nome"));
        if (row.get("ipe_resp_cns") != null && !row.get("ipe_resp_cns").equals("")) {
            instituicaoPermanencia.setCnsResponsavelTecnico((String)row.get("ipe_resp_cns"));
        }
        if (row.get("ipe_resp_cargo") != null && !row.get("ipe_resp_cargo").equals("")) {
            instituicaoPermanencia.setCargoInstituicao((String)row.get("ipe_resp_cargo"));
        }
        if (row.get("ipe_resp_telefone") != null && !row.get("ipe_resp_telefone").equals("")) {
            String telefoneCelular = ((String)row.get("ipe_resp_telefone")).replaceAll("\\D", "");
            instituicaoPermanencia.setTelefoneResponsavelTecnico(telefoneCelular);
        }
        return instituicaoPermanencia;
    }

    public FamiliaRowTransport familiaRowThrift(HashMap row) throws SQLException {
        BancoCadastroDomiciliar bdCadastroDomiciliar = new BancoCadastroDomiciliar();
        ResultSet array = bdCadastroDomiciliar.getDadosFamilia((Integer)row.get("co_cds_cad_domiciliar"));
        FamiliaRowTransport dadosFamilia = new FamiliaRowTransport();
        if (array.next()) {
            dadosFamilia.setDataNascimentoResponsavel(DataConvert.dateToEpoch(array.getDate("usu_datanasc")));
            dadosFamilia.setNumeroCnsResponsavel(this.validaCnsBanco(array.getString("usu_cartao_sus")) ? array.getString("usu_cartao_sus") : null);
            dadosFamilia.setNumeroProntuario(array.getString("usu_prontuario"));
        }
        return dadosFamilia;
    }

    public CondicaoMoradiaTransport condicaoMoradiaThrift(HashMap item) throws SQLException {
        CondicaoMoradiaTransport condicaoMoradia = new CondicaoMoradiaTransport();
        Long tipoImovel = Long.valueOf(item.get("tipo_imovel").toString());
        if (item.get("situacao_moradia") != null && (tipoImovel < 7L || tipoImovel > 11L)) {
            condicaoMoradia.setSituacaoMoradiaPosseTerra(Long.valueOf(item.get("situacao_moradia").toString()));
        }
        if (item.get("localizacao") != null) {
            condicaoMoradia.setLocalizacao(Long.valueOf(item.get("localizacao").toString()));
        }
        if (item.get("tipo_domicilio") != null) {
            condicaoMoradia.setTipoDomicilio(Long.valueOf(item.get("tipo_domicilio").toString()));
        }
        condicaoMoradia.setNuMoradores((String)item.get("numero_moradores"));
        condicaoMoradia.setNuComodos((String)item.get("numero_comodos"));
        if (item.get("tipo_acesso") != null) {
            condicaoMoradia.setTipoAcessoDomicilio(Long.valueOf(item.get("tipo_acesso").toString()));
        }
        if (item.get("energia_eletrica") != null) {
            condicaoMoradia.setStDisponibilidadeEnergiaEletrica(Boolean.valueOf(item.get("energia_eletrica").toString()));
        }
        if (item.get("destino_lixo") != null) {
            condicaoMoradia.setDestinoLixo(Long.valueOf(item.get("destino_lixo").toString()));
        }
        if (item.get("tratamento_agua") != null) {
            condicaoMoradia.setAguaConsumoDomicilio(Long.valueOf(item.get("tratamento_agua").toString()));
        }
        if (item.get("posse_terra") != null) {
            condicaoMoradia.setAreaProducaoRural(Long.valueOf(item.get("posse_terra").toString()));
        }
        if (item.get("material_domicilio") != null) {
            condicaoMoradia.setMaterialPredominanteParedesExtDomicilio(Long.valueOf(item.get("material_domicilio").toString()));
        }
        if (item.get("abastecimento_agua") != null) {
            condicaoMoradia.setAbastecimentoAgua(Long.valueOf(item.get("abastecimento_agua").toString()));
        }
        if (item.get("escoamento_sanitario") != null) {
            condicaoMoradia.setFormaEscoamentoBanheiro(Long.valueOf(item.get("escoamento_sanitario").toString()));
        }
        return condicaoMoradia;
    }

    public UnicaLotacaoHeaderTransport headerCdsCadastroThrift(HashMap item) throws SQLException {
        UnicaLotacaoHeaderTransport headerCadDomiciliar = new UnicaLotacaoHeaderTransport();
        String cns_profissional = Util.verificaNulo(item.get("cns_profissional"));
        headerCadDomiciliar.setProfissionalCNS(this.validaCnsBanco(cns_profissional) ? cns_profissional : null);
        headerCadDomiciliar.setCboCodigo2002(this.getCbo(item));
        headerCadDomiciliar.setCnes(Util.verificaNulo(item.get("cnes_unidade")));
        headerCadDomiciliar.setIne(Util.verificaNulo(item.get("nu_ine")));
        headerCadDomiciliar.setDataAtendimento(DataConvert.dateToEpoch(Date.valueOf(Util.verificaNulo(item.get("data_atendimento")))));
        headerCadDomiciliar.setCodigoIbgeMunicipio(Util.verificaNulo(item.get("codigo_ibge_municipio")));
        return headerCadDomiciliar;
    }

    public String getCbo(HashMap row) throws SQLException {
        BancoCadastroDomiciliar bdCadastroDomiciliar = new BancoCadastroDomiciliar();
        ResultSet retorno = bdCadastroDomiciliar.getCbo(Integer.valueOf(Util.verificaNulo(row.get("usr_codigo"))));
        retorno.next();
        return retorno.getString(1);
    }

    public EnderecoLocalPermanenciaTransport enderecoLocalPermanenciaThrift(HashMap item) throws SQLException {
        EnderecoLocalPermanenciaTransport enderecoLocalPermanencia = new EnderecoLocalPermanenciaTransport();
        enderecoLocalPermanencia.setBairro(Util.verificaNulo(item.get("bairro")));
        enderecoLocalPermanencia.setCep(Util.verificaNulo(item.get("cep")));
        enderecoLocalPermanencia.setCodigoIbgeMunicipio(Util.verificaNulo(item.get("cid_codigo_ibge")));
        enderecoLocalPermanencia.setNomeLogradouro(Util.verificaNulo(item.get("nome_logradouro")));
        enderecoLocalPermanencia.setNumero(Util.verificaNulo(item.get("numero")));
        enderecoLocalPermanencia.setNumeroDneUf(Util.verificaNulo(item.get("estado")));
        enderecoLocalPermanencia.setTipoLogradouroNumeroDne(Util.verificaNulo(item.get("tipo_logradouro_numero_dne")));
        enderecoLocalPermanencia.setComplemento(Util.verificaNulo(item.get("complemento")));
        enderecoLocalPermanencia.setPontoReferencia(Util.verificaNulo(item.get("dom_ponto_referencia")));
        if (item.get("dom_telefone") != null) {
            String telefoneCelular = item.get("dom_telefone").toString().replaceAll("\\D", "");
            enderecoLocalPermanencia.setTelefoneResidencia(telefoneCelular);
        }
        enderecoLocalPermanencia.setStForaArea(false);
        if (item.get("dom_microarea_fa") != null) {
            if (!item.get("dom_microarea_fa").toString().contains("t")) {
                enderecoLocalPermanencia.setMicroArea(Util.verificaNulo(item.get("dom_microarea")));
                enderecoLocalPermanencia.setStForaArea(false);
            } else {
                enderecoLocalPermanencia.setStForaArea(true);
            }
        } else {
            enderecoLocalPermanencia.setMicroArea(Util.verificaNulo(item.get("dom_microarea")));
        }
        return enderecoLocalPermanencia;
    }

    private DadoTransporteTransportCadastroDomiciliarXml montaArrayEnvioDto(CadastroDomiciliarTransport fichaMasterSerializado, String uuid, HashMap row, int eehCodigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        String eroContraChave = dadosRO.getString("ero_contra_chave");
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(eroContraChave != null ? eroContraChave : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(eroContraChave != null ? eroContraChave : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport arrayVersao = new VersaoTransport();
        arrayVersao.setMajor(2);
        arrayVersao.setMinor(1);
        arrayVersao.setRevision(0);
        arrayVersao.setRevision(0);
        DadoTransporteTransportCadastroDomiciliarXml dadoTransporteTransportXml = new DadoTransporteTransportCadastroDomiciliarXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(3L);
        dadoTransporteTransportXml.setCnesDadoSerializado(row.get("cnes_unidade") != null ? row.get("cnes_unidade").toString() : null);
        dadoTransporteTransportXml.setCodIbge(row.get("codigo_ibge_municipio") != null ? row.get("codigo_ibge_municipio").toString() : null);
        dadoTransporteTransportXml.setIneDadoSerializado(row.get("nu_ine") != null ? row.get("nu_ine").toString() : null);
        dadoTransporteTransportXml.setNumLote(eehCodigo);
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(arrayVersao);
        dadoTransporteTransportXml.setCadastroDomiciliarTransport(fichaMasterSerializado);
        return dadoTransporteTransportXml;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        String sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        PreparedStatement pstmt = Conexao.CONN.prepareStatement(sql);
        return pstmt.executeQuery();
    }
}

