/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoCadastroIndividual;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.cadastroindividual.CadastroIndividualTransport;
import br.ufsc.esus.condicoesdesaude.CondicoesDeSaudeTransport;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportCadastroIndividualXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryCadastroindividual;
import br.ufsc.esus.emsituacaoderua.EmSituacaoDeRuaTransport;
import br.ufsc.esus.identificacaousuariocidadao.IdentificacaoUsuarioCidadaoTransport;
import br.ufsc.esus.informacoessociodemograficas.InformacoesSocioDemograficasTransport;
import br.ufsc.esus.saidacidadaocadastro.SaidaCidadaoCadastroTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class CadastroIndividual
extends BD {
    public void executeMain(int eeh_codigo) throws SQLException, JAXBException, IOException {
        BancoCadastroIndividual bdCadastroIndividual = new BancoCadastroIndividual();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosCadastroIndividual = bdCadastroIndividual.getDados();
        ResultSet numAtend = bdCadastroIndividual.getQtdRegistros();
        if (!numAtend.wasNull()) {
            while (dadosCadastroIndividual.next()) {
                CadastroIndividual thriftCadastroIndividual = new CadastroIndividual();
                String uuid = thriftCadastroIndividual.getGUID();
                String uuid_ficha_ori = dadosCadastroIndividual.getString("uuid_ficha_ori") != null ? dadosCadastroIndividual.getString("uuid_ficha_ori") : uuid;
                CadastroIndividualTransport ficha_master = this.cadastroIndividualThrift(uuid, dadosCadastroIndividual, uuid_ficha_ori);
                DadoTransporteTransportCadastroIndividualXml array_envio = this.montaArrayEnvioDto(ficha_master, uuid, dadosCadastroIndividual, eeh_codigo);
                this.zipWriter(array_envio, uuid, eeh_codigo);
                bdEsusHistoricoItens.registratHistoricoItens(eeh_codigo, uuid, 1);
                bdCadastroIndividual.atualizaStatus(uuid, dadosCadastroIndividual.getInt("eci_codigo"), uuid_ficha_ori);
            }
        }
    }

    public CadastroIndividualTransport cadastroIndividualThrift(String uuid, ResultSet row, String uuid_ficha_ori) throws SQLException {
        UnicaLotacaoHeaderTransport UnicaLotacaoHeader = this.headerCdsCadastroThrift(row);
        IdentificacaoUsuarioCidadaoTransport dadosCidadao = this.identificacaoUsuarioCidadaoThrift(row);
        InformacoesSocioDemograficasTransport informacoesSocioDemograficas = this.informacoesSocioDemograficasThrift(row);
        CondicoesDeSaudeTransport condicoesSaude = this.condicoesDeSaudeThrift(row);
        SaidaCidadaoCadastroTransport saidaCidadaoCadastro = this.saidaCidadaoCadastroThrift(row);
        EmSituacaoDeRuaTransport emSituacaoDeRua = this.emSituacaoDeRuaThrift(row);
        CadastroIndividualTransport ficha_master = new CadastroIndividualTransport();
        ficha_master.setHeaderTransport(UnicaLotacaoHeader);
        ficha_master.setStatusTermoRecusaCadastroIndividualAtencaoBasica(row.getBoolean("eci_usu_recusa"));
        ficha_master.setIdentificacaoUsuarioCidadao(dadosCidadao);
        if (!row.getBoolean("eci_usu_recusa")) {
            ficha_master.setInformacoesSocioDemograficas(informacoesSocioDemograficas);
            ficha_master.setCondicoesDeSaude(condicoesSaude);
            ficha_master.setEmSituacaoDeRua(emSituacaoDeRua);
            ficha_master.setSaidaCidadaoCadastro(saidaCidadaoCadastro);
        }
        ficha_master.setTpCdsOrigem(3);
        ficha_master.setUuid(uuid);
        ficha_master.setUuidFichaOriginadora(uuid_ficha_ori);
        ficha_master.setFichaAtualizada(uuid_ficha_ori != null ? uuid_ficha_ori.length() > 0 : false);
        return ficha_master;
    }

    public UnicaLotacaoHeaderTransport headerCdsCadastroThrift(ResultSet row) throws SQLException {
        UnicaLotacaoHeaderTransport headerCadDomiciliar = new UnicaLotacaoHeaderTransport();
        headerCadDomiciliar.setProfissionalCNS(this.validaCnsBanco(row.getString("eci_usr_profissional_cns")) ? row.getString("eci_usr_profissional_cns") : null);
        headerCadDomiciliar.setCboCodigo2002(row.getString("eci_usr_cbo"));
        headerCadDomiciliar.setCodigoIbgeMunicipio(row.getString("eci_usr_codigo_ibge"));
        headerCadDomiciliar.setCnes(row.getString("eci_usr_cnes"));
        headerCadDomiciliar.setIne(row.getString("eci_usr_ine"));
        headerCadDomiciliar.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("eci_usr_dtatendimento")));
        return headerCadDomiciliar;
    }

    public InformacoesSocioDemograficasTransport informacoesSocioDemograficasThrift(ResultSet row) throws SQLException {
        BancoCadastroIndividual bdCadastroIndividual = new BancoCadastroIndividual();
        InformacoesSocioDemograficasTransport infoDemo = new InformacoesSocioDemograficasTransport();
        int usu_codigo = row.getInt("usu_codigo");
        if (!row.getBoolean("eci_usu_st_responsavel_familiar") && row.getLong("eci_usu_parentesco_resp") != 0L) {
            infoDemo.setRelacaoParentescoCidadao(row.getLong("eci_usu_parentesco_resp"));
        }
        if (row.getString("eci_usu_ocupacao") != null) {
            infoDemo.setOcupacaoCodigoCbo2002(row.getString("eci_usu_ocupacao"));
        }
        if (row.getString("eci_usu_escola") != null) {
            infoDemo.setStatusFrequentaEscola(row.getBoolean("eci_usu_escola"));
        }
        if (row.getLong("eci_usu_curso_mais_elevado") != 0L) {
            infoDemo.setGrauInstrucaoCidadao(row.getLong("eci_usu_curso_mais_elevado"));
        }
        if (row.getLong("eci_usu_mercado_trabalho") != 0L) {
            infoDemo.setSituacaoMercadoTrabalhoCidadao(row.getLong("eci_usu_mercado_trabalho"));
        }
        ResultSet responsaveis = bdCadastroIndividual.getResponsavelPorCrianca(usu_codigo);
        while (responsaveis.next()) {
            infoDemo.getResponsavelPorCrianca().add(responsaveis.getLong("eci_pergunta_detalhe"));
        }
        if (row.getString("eci_usu_freq_cuidador_trad") != null) {
            infoDemo.setStatusFrequentaBenzedeira(row.getBoolean("eci_usu_freq_cuidador_trad"));
        }
        if (row.getString("eci_usu_grupo_comunitario") != null) {
            infoDemo.setStatusParticipaGrupoComunitario(row.getBoolean("eci_usu_grupo_comunitario"));
        }
        if (row.getString("eci_usu_plano_saude") != null) {
            infoDemo.setStatusPossuiPlanoSaudePrivado(row.getBoolean("eci_usu_plano_saude"));
        }
        if (row.getString("eci_usu_povo_comunidade_trad") != null) {
            infoDemo.setStatusMembroPovoComunidadeTradicional(row.getBoolean("eci_usu_povo_comunidade_trad"));
        }
        if (row.getBoolean("eci_usu_povo_comunidade_trad") && row.getBoolean("eci_usu_povo_comunidade_trad")) {
            infoDemo.setPovoComunidadeTradicional(row.getString("eci_usu_povo_comunidade_trad_nome"));
        }
        if (row.getString("eci_usu_orientacao_sexual") != null) {
            infoDemo.setStatusDesejaInformarOrientacaoSexual(row.getBoolean("eci_usu_orientacao_sexual"));
        }
        if (row.getBoolean("eci_usu_orientacao_sexual") && row.getBoolean("eci_usu_orientacao_sexual")) {
            infoDemo.setOrientacaoSexualCidadao(row.getLong("eci_usu_orientacao_sexual_nome"));
        }
        if (row.getString("eci_usu_identidade_genero") != null) {
            infoDemo.setStatusDesejaInformarIdentidadeGenero(row.getBoolean("eci_usu_identidade_genero"));
        }
        if (row.getBoolean("eci_usu_identidade_genero")) {
            infoDemo.setIdentidadeGeneroCidadao(row.getLong("eci_usu_identidade_genero_nome"));
        }
        if (row.getString("eci_usu_deficiencia") != null) {
            infoDemo.setStatusTemAlgumaDeficiencia(row.getBoolean("eci_usu_deficiencia"));
        }
        if (row.getBoolean("eci_usu_deficiencia")) {
            ResultSet deficiencias = bdCadastroIndividual.getDeficienciasCidadao(usu_codigo);
            while (deficiencias.next()) {
                infoDemo.getDeficienciasCidadao().add(deficiencias.getLong("eci_pergunta_detalhe"));
            }
        }
        return infoDemo;
    }

    public CondicoesDeSaudeTransport condicoesDeSaudeThrift(ResultSet row) throws SQLException {
        BancoCadastroIndividual bdCadastroIndividual = new BancoCadastroIndividual();
        CondicoesDeSaudeTransport condicao = new CondicoesDeSaudeTransport();
        int usu_codigo = row.getInt("usu_codigo");
        if (row.getDate("eci_usu_dtnascimento") != null && row.getDate("eci_usr_dtatendimento") != null && row.getString("usu_sexo").equals("F") && CadastroIndividual.idade(row.getDate("eci_usu_dtnascimento").toLocalDate(), row.getDate("eci_usr_dtatendimento").toLocalDate()) <= 60 && CadastroIndividual.idade(row.getDate("eci_usu_dtnascimento").toLocalDate(), row.getDate("eci_usr_dtatendimento").toLocalDate()) >= 9) {
            if (row.getString("usu_esta_gestante") != null) {
                condicao.setStatusEhGestante(row.getBoolean("usu_esta_gestante"));
            }
            if (row.getBoolean("usu_esta_gestante")) {
                condicao.setMaternidadeDeReferencia(row.getString("eci_usu_maternidade_ref"));
            }
        }
        if (Long.valueOf(row.getLong("eci_usu_peso")) != 0L) {
            condicao.setSituacaoPeso(row.getLong("eci_usu_peso"));
        }
        if (row.getString("eci_usu_fumante") != null) {
            condicao.setStatusEhFumante(row.getBoolean("eci_usu_fumante"));
        }
        if (row.getString("eci_usu_alcool") != null) {
            condicao.setStatusEhDependenteAlcool(row.getBoolean("eci_usu_alcool"));
        }
        if (row.getString("eci_usu_drogas") != null) {
            condicao.setStatusEhDependenteOutrasDrogas(row.getBoolean("eci_usu_drogas"));
        }
        if (row.getString("usu_tem_hipertensao") != null) {
            condicao.setStatusTemHipertensaoArterial(row.getBoolean("usu_tem_hipertensao"));
        }
        if (row.getString("usu_tem_diabete") != null) {
            condicao.setStatusTemDiabetes(row.getBoolean("usu_tem_diabete"));
        }
        if (row.getString("eci_usu_avc_derrame") != null) {
            condicao.setStatusTeveAvcDerrame(row.getBoolean("eci_usu_avc_derrame"));
        }
        if (row.getString("eci_usu_infarto") != null) {
            condicao.setStatusTeveInfarto(row.getBoolean("eci_usu_infarto"));
        }
        if (row.getString("eci_usu_doenca_cardiaca") != null) {
            condicao.setStatusTeveDoencaCardiaca(row.getBoolean("eci_usu_doenca_cardiaca"));
        }
        if (row.getBoolean("eci_usu_doenca_cardiaca")) {
            ResultSet cardiaca = bdCadastroIndividual.getDoencaCardiaca(usu_codigo);
            while (cardiaca.next()) {
                condicao.getDoencaCardiaca().add(cardiaca.getLong("eci_pergunta_detalhe"));
            }
        }
        if (row.getString("eci_usu_problema_rins") != null) {
            condicao.setStatusTemTeveDoencasRins(row.getBoolean("eci_usu_problema_rins"));
        }
        if (row.getBoolean("eci_usu_problema_rins")) {
            ResultSet rins = bdCadastroIndividual.getDoencaRins(usu_codigo);
            while (rins.next()) {
                condicao.getDoencaRins().add(rins.getLong("eci_pergunta_detalhe"));
            }
        }
        if (row.getString("eci_usu_doenca_respiratoria") != null) {
            condicao.setStatusTemDoencaRespiratoria(row.getBoolean("eci_usu_doenca_respiratoria"));
        }
        if (row.getBoolean("eci_usu_doenca_respiratoria")) {
            ResultSet respiratoria = bdCadastroIndividual.getDoencaRespiratoria(usu_codigo);
            while (respiratoria.next()) {
                condicao.getDoencaRespiratoria().add(respiratoria.getLong("eci_pergunta_detalhe"));
            }
        }
        if (row.getString("eci_usu_hanseniase") != null) {
            condicao.setStatusTemHanseniase(row.getBoolean("eci_usu_hanseniase"));
        }
        if (row.getString("eci_usu_tuberculose") != null) {
            condicao.setStatusTemTuberculose(row.getBoolean("eci_usu_tuberculose"));
        }
        if (row.getString("eci_usu_cancer") != null) {
            condicao.setStatusTemTeveCancer(row.getBoolean("eci_usu_cancer"));
        }
        if (row.getString("eci_usu_internacao_dose_meses") != null) {
            condicao.setStatusTeveInternadoEm12Meses(row.getBoolean("eci_usu_internacao_dose_meses"));
        }
        if (row.getBoolean("eci_usu_internacao_dose_meses")) {
            condicao.setDescricaoCausaInternacaoEm12Meses(row.getString("eci_usu_internacao_dose_meses_causa"));
        }
        if (row.getString("eci_usu_problema_saude_mental") != null) {
            condicao.setStatusDiagnosticoMental(row.getBoolean("eci_usu_problema_saude_mental"));
        }
        if (row.getString("eci_usu_acamado") != null) {
            condicao.setStatusEstaAcamado(row.getBoolean("eci_usu_acamado"));
        }
        if (row.getString("eci_usu_domiciliado") != null) {
            condicao.setStatusEstaDomiciliado(row.getBoolean("eci_usu_domiciliado"));
        }
        if (row.getString("eci_usu_plantas_medicinais") != null) {
            condicao.setStatusUsaPlantaMedicinais(row.getBoolean("eci_usu_plantas_medicinais"));
        }
        if (row.getBoolean("eci_usu_plantas_medicinais")) {
            condicao.setDescricaoPlantasMedicinaisUsadas(row.getString("eci_usu_plantas_medicinais_nome"));
        }
        if (row.getString("eci_usu_praticas_integrat_complem") != null) {
            condicao.setStatusUsaOutrasPraticasIntegrativasOuComplementares(row.getBoolean("eci_usu_praticas_integrat_complem"));
        }
        if (row.getString("eci_usu_condicao_saude1") != null) {
            condicao.setDescricaoOutraCondicao1(row.getString("eci_usu_condicao_saude1"));
        }
        if (row.getString("eci_usu_condicao_saude2") != null) {
            condicao.setDescricaoOutraCondicao2(row.getString("eci_usu_condicao_saude2"));
        }
        if (row.getString("eci_usu_condicao_saude3") != null) {
            condicao.setDescricaoOutraCondicao3(row.getString("eci_usu_condicao_saude3"));
        }
        return condicao;
    }

    public EmSituacaoDeRuaTransport emSituacaoDeRuaThrift(ResultSet row) throws SQLException {
        EmSituacaoDeRuaTransport situacao = new EmSituacaoDeRuaTransport();
        situacao.setStatusSituacaoRua(row.getBoolean("eci_usu_sit_rua"));
        if (row.getBoolean("eci_usu_sit_rua")) {
            BancoCadastroIndividual bdCadastroIndividual = new BancoCadastroIndividual();
            int usu_codigo = row.getInt("usu_codigo");
            if (Long.valueOf(row.getLong("eci_usu_situacao_rua_tempo")) != 0L) {
                situacao.setTempoSituacaoRua(row.getLong("eci_usu_situacao_rua_tempo"));
            }
            if (row.getString("eci_usu_recebe_beneficio") != null) {
                situacao.setStatusRecebeBeneficio(row.getBoolean("eci_usu_recebe_beneficio"));
            }
            if (row.getString("eci_usu_referencia_familiar") != null) {
                situacao.setStatusPossuiReferenciaFamiliar(row.getBoolean("eci_usu_referencia_familiar"));
            }
            if (Long.valueOf(row.getLong("eci_usu_vezes_alimenta_dia")) != 0L) {
                situacao.setQuantidadeAlimentacoesAoDiaSituacaoRua(row.getLong("eci_usu_vezes_alimenta_dia"));
            }
            ResultSet origem = bdCadastroIndividual.getOrigemAlimentoSituacaoRua(usu_codigo);
            while (origem.next()) {
                situacao.getOrigemAlimentoSituacaoRua().add(origem.getLong("eci_pergunta_detalhe"));
            }
            if (row.getString("eci_usu_acompanhado_intituicao") != null) {
                situacao.setStatusAcompanhadoPorOutraInstituicao(row.getBoolean("eci_usu_acompanhado_intituicao"));
            }
            if (row.getBoolean("eci_usu_acompanhado_intituicao")) {
                situacao.setOutraInstituicaoQueAcompanha(row.getString("eci_usu_acompanhado_intituicao_nome"));
            }
            if (row.getString("eci_usu_vista_familiar_frequencia") != null) {
                situacao.setStatusVisitaFamiliarFrequentemente(row.getBoolean("eci_usu_vista_familiar_frequencia"));
            }
            if (row.getBoolean("eci_usu_vista_familiar_frequencia")) {
                situacao.setGrauParentescoFamiliarFrequentado(row.getString("eci_usu_vista_familiar_grau"));
            }
            if (row.getString("eci_usu_acesso_higiene_pessoal") != null) {
                situacao.setStatusTemAcessoHigienePessoalSituacaoRua(row.getBoolean("eci_usu_acesso_higiene_pessoal"));
            }
            if (row.getBoolean("eci_usu_acesso_higiene_pessoal")) {
                ResultSet higiene = bdCadastroIndividual.getHigienePessoalSituacaoRua(usu_codigo);
                while (higiene.next()) {
                    situacao.getHigienePessoalSituacaoRua().add(higiene.getLong("eci_pergunta_detalhe"));
                }
            }
        }
        return situacao;
    }

    public SaidaCidadaoCadastroTransport saidaCidadaoCadastroThrift(ResultSet row) throws SQLException {
        SaidaCidadaoCadastroTransport saida = new SaidaCidadaoCadastroTransport();
        if (row.getBoolean("eci_usu_obito")) {
            saida.setMotivoSaidaCidadao(135L);
            saida.setDataObito(DataConvert.dateToEpoch(row.getDate("eci_usu_dt_obito")));
            saida.setNumeroDO(row.getString("eci_usu_numero_do"));
        }
        if (row.getBoolean("eci_usu_mudanca_territorio")) {
            saida.setMotivoSaidaCidadao(136L);
        }
        return saida;
    }

    public static int idade(LocalDate aniversario, LocalDate row) throws SQLException {
        LocalDate dataAtual = row;
        Period periodo = Period.between(aniversario, dataAtual);
        return periodo.getYears();
    }

    public IdentificacaoUsuarioCidadaoTransport identificacaoUsuarioCidadaoThrift(ResultSet row) throws SQLException {
        IdentificacaoUsuarioCidadaoTransport iuct = new IdentificacaoUsuarioCidadaoTransport();
        if (row.getString("eci_usu_nacionalidade").equals("1 L")) {
            iuct.setCodigoIbgeMunicipioNascimento(row.getString("eci_usu_nacionalidade").equals("1 L") ? row.getString("eci_usu_codigo_ibge") : null);
        }
        iuct.setDataNascimentoCidadao(DataConvert.dateToEpoch(row.getDate("eci_usu_dtnascimento")));
        iuct.setNacionalidadeCidadao(Long.valueOf(row.getString("eci_usu_nacionalidade").replace(" L", "")));
        if (!row.getString("eci_usu_nacionalidade").equals("2 L")) {
            iuct.setPaisNascimento(row.getString("eci_usu_nacionalidade").equals("1 L") ? 31L : this.nacionalidadeProcess(row));
        }
        if (row.getString("eci_usu_nome_social") != null) {
            iuct.setNomeSocial(row.getString("eci_usu_nome_social"));
        }
        if (row.getString("eci_usu_nome") != null) {
            iuct.setNomeCidadao(row.getString("eci_usu_nome"));
        }
        iuct.setNomeMaeCidadao(row.getString("eci_usu_mae").trim());
        if (row.getString("eci_usu_pai") != null) {
            iuct.setNomePaiCidadao(row.getString("eci_usu_pai"));
        } else {
            iuct.setDesconheceNomePai(true);
        }
        if (row.getString("eci_usu_nacionalidade").equals("2 L")) {
            iuct.setPortariaNaturalizacao(row.getString("eci_usu_nacionalidade").equals("2 L") ? row.getString("nr_portaria_naturalizacao") : null);
        }
        if (row.getString("eci_usu_nacionalidade").equals("2 L")) {
            iuct.setDtNaturalizacao(row.getString("eci_usu_nacionalidade").equals("2 L") && row.getDate("dt_naturalizacao") != null ? DataConvert.dateToEpoch(row.getDate("dt_naturalizacao")) : null);
        }
        if (row.getString("eci_usu_nacionalidade").equals("3 L")) {
            iuct.setDtEntradaBrasil(row.getString("eci_usu_nacionalidade").equals("3 L") ? DataConvert.dateToEpoch(row.getDate("usu_dt_entrada_pais")) : null);
        }
        if (this.validaCnsBanco(row.getString("eci_usu_cns"))) {
            iuct.setCnsCidadao(row.getString("eci_usu_cns"));
        }
        iuct.setRacaCorCidadao(Long.valueOf(row.getString("eci_usu_raca").replace(" L", "")));
        iuct.setSexoCidadao(Long.valueOf(row.getString("eci_usu_sexo").replace(" L", "")));
        iuct.setStatusEhResponsavel(row.getBoolean("eci_usu_st_responsavel_familiar"));
        if (row.getString("eci_usu_raca").equals("5 L")) {
            iuct.setEtnia(row.getString("eci_usu_raca").equals("5 L") ? Long.valueOf(row.getLong("etn_codigo")) : null);
        }
        iuct.setMicroArea(row.getString("eci_usu_microarea"));
        if (row.getString("eci_usu_microarea_fa") != null) {
            iuct.setStForaArea(row.getBoolean("eci_usu_microarea_fa"));
        }
        iuct.setNumeroNisPisPasep(row.getString("eci_usu_pis_pasep"));
        if (row.getString("eci_usu_celular") != null) {
            String telefoneCelular = row.getString("eci_usu_celular").replaceAll("\\D", "");
            iuct.setTelefoneCelular(telefoneCelular);
        }
        iuct.setEmailCidadao(row.getString("eci_usu_email"));
        return iuct;
    }

    protected Long nacionalidadeProcess(ResultSet row) throws SQLException {
        if (row.getString("eci_usu_nacionalidade").equals("3 L")) {
            return row.getLong("epa_codigo");
        }
        return null;
    }

    public void zipWriter(DadoTransporteTransportCadastroIndividualXml xmlText, String uuid, int eeh) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryCadastroindividual factoryCadastroIndividual = new ObjectFactoryCadastroindividual();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryCadastroindividual.class);
        JAXBElement<DadoTransporteTransportCadastroIndividualXml> element = factoryCadastroIndividual.createDadoTransporteTransportCadastroIndividualXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    public DadoTransporteTransportCadastroIndividualXml montaArrayEnvioDto(CadastroIndividualTransport ficha_master_serializado, String uuid, ResultSet row, int eeh_codigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport array_versao = new VersaoTransport();
        array_versao.setMajor(2);
        array_versao.setMinor(1);
        array_versao.setRevision(0);
        DadoTransporteTransportCadastroIndividualXml dadoTransporteTransportXml = new DadoTransporteTransportCadastroIndividualXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(Long.valueOf(row.getString("eci_tipo_dado_serializado").replace(" L", "")));
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("eci_usr_cnes"));
        dadoTransporteTransportXml.setNumLote(eeh_codigo);
        if (row.getString("eci_usu_nacionalidade").equals("1 L")) {
            dadoTransporteTransportXml.setCodIbge(row.getString("eci_usr_codigo_ibge"));
        }
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("eci_usr_ine"));
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(array_versao);
        dadoTransporteTransportXml.setCadastroIndividualTransport(ficha_master_serializado);
        return dadoTransporteTransportXml;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }
}

