/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoConsumoAlimentar;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportConsumoAlimentarXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryConsumoAlimentar;
import br.ufsc.esus.fichaconsumoalimentar.FichaConsumoAlimentarTransport;
import br.ufsc.esus.perguntacriancascommaisdoisanosenum.PerguntaCriancasComMaisDoisAnosEnumTransport;
import br.ufsc.esus.perguntacriancasdeseisvintetresmesesenum.PerguntaCriancasDeSeisVinteTresMesesEnumTransport;
import br.ufsc.esus.perguntacriancasmenoresseismesesenum.PerguntaCriancasMenoresSeisMesesEnumTransport;
import br.ufsc.esus.perguntaquestionariocriancascommaisdoisanos.PerguntaQuestionarioCriancasComMaisDoisAnosTransport;
import br.ufsc.esus.perguntaquestionariocriancasdeseisvintetresmeses.PerguntaQuestionarioCriancasDeSeisVinteTresMesesTransport;
import br.ufsc.esus.perguntaquestionariocriancasmenoresseismeses.PerguntaQuestionarioCriancasMenoresSeisMesesTransport;
import br.ufsc.esus.respostamultiplaescolhaenum.RespostaMultiplaEscolhaEnumTransport;
import br.ufsc.esus.respostaunicaescolhaenum.RespostaUnicaEscolhaEnumTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ConsumoAlimentar
extends BD {
    public void executeMain(int eehCodigo) throws SQLException, JAXBException, IOException, ParseException {
        BancoConsumoAlimentar bdConsumoAlimentar = new BancoConsumoAlimentar();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosConsumoAlimentar = bdConsumoAlimentar.getDadosConsumoAlimentar();
        while (dadosConsumoAlimentar.next()) {
            ConsumoAlimentar consumoAlimentar = new ConsumoAlimentar();
            String uuid = consumoAlimentar.getGUID();
            FichaConsumoAlimentarTransport ficha = this.consumoAlimentarThrift(uuid, dadosConsumoAlimentar);
            DadoTransporteTransportConsumoAlimentarXml arrayEnvio = this.montaArrayEnvioDto(ficha, uuid, dadosConsumoAlimentar, eehCodigo);
            this.zipWriter(arrayEnvio, uuid);
            bdEsusHistoricoItens.registratHistoricoItens(eehCodigo, uuid, 12);
            bdConsumoAlimentar.atualizaStatus(uuid, dadosConsumoAlimentar.getInt("co_cds_consumo_alimentar"));
        }
    }

    private void zipWriter(DadoTransporteTransportConsumoAlimentarXml xmlText, String uuid) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryConsumoAlimentar factoryConsumoAlimentar = new ObjectFactoryConsumoAlimentar();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryConsumoAlimentar.class);
        JAXBElement<DadoTransporteTransportConsumoAlimentarXml> element = factoryConsumoAlimentar.createDadoTransporteTransportConsumoAlimentarXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    private FichaConsumoAlimentarTransport consumoAlimentarThrift(String uuid, ResultSet row) throws SQLException, ParseException {
        UnicaLotacaoHeaderTransport arrayUnica = this.montaArrayUnica(row);
        int codAtiv = row.getInt("co_cds_consumo_alimentar");
        Integer origem = 3;
        FichaConsumoAlimentarTransport dadosCat = new FichaConsumoAlimentarTransport();
        dadosCat.setHeaderTransport(arrayUnica);
        dadosCat.setUuidFicha(uuid);
        dadosCat.setCnsCidadao(row.getString("eca_cidadao_cns"));
        dadosCat.setIdentificacaoUsuario(row.getString("eca_cidadao_nome"));
        dadosCat.setDataNascimento(DataConvert.dateToEpoch(row.getDate("eca_cidadao_dt_nasc")));
        dadosCat.setSexo(row.getLong("eca_cidadao_sexo"));
        dadosCat.setLocalAtendimento(row.getLong("eca_local_atendimento"));
        dadosCat.getPerguntasQuestionarioCriancasComMaisDoisAnos().addAll(this.PerguntasQuestionarioCriancasComMaisDoisAnos(codAtiv));
        dadosCat.getPerguntasQuestionarioCriancasDeSeisVinteTresMeses().addAll(this.PerguntasQuestionarioCriancasDeSeisVinteTresMeses(codAtiv));
        dadosCat.getPerguntasQuestionarioCriancasMenoresSeisMeses().addAll(this.PerguntaQuestionarioCriancasMenoresSeisMeses(codAtiv));
        dadosCat.setTpCdsOrigem(origem);
        return dadosCat;
    }

    private UnicaLotacaoHeaderTransport montaArrayUnica(ResultSet row) throws SQLException {
        UnicaLotacaoHeaderTransport headerTransport = new UnicaLotacaoHeaderTransport();
        headerTransport.setProfissionalCNS(this.validaCnsBanco(row.getString("eca_profissional_cns").trim()) ? row.getString("eca_profissional_cns").trim() : null);
        headerTransport.setCboCodigo2002(row.getString("eca_cbo"));
        headerTransport.setCnes(row.getString("eca_cnes"));
        headerTransport.setIne(row.getString("eca_ine"));
        headerTransport.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("eca_dt_atividade")));
        headerTransport.setCodigoIbgeMunicipio(row.getString("eca_codigo_ibge"));
        return headerTransport;
    }

    private List<PerguntaQuestionarioCriancasComMaisDoisAnosTransport> PerguntasQuestionarioCriancasComMaisDoisAnos(int codAtiv) throws SQLException {
        BancoConsumoAlimentar bdConsumoAlimentar = new BancoConsumoAlimentar();
        ResultSet dados = bdConsumoAlimentar.getPerguntasQuestionarioCriancasComMaisDoisAnos(codAtiv);
        ArrayList<PerguntaQuestionarioCriancasComMaisDoisAnosTransport> arrayGeral = new ArrayList<PerguntaQuestionarioCriancasComMaisDoisAnosTransport>();
        PerguntaQuestionarioCriancasComMaisDoisAnosTransport linha12 = new PerguntaQuestionarioCriancasComMaisDoisAnosTransport();
        while (dados.next()) {
            PerguntaQuestionarioCriancasComMaisDoisAnosTransport linha = new PerguntaQuestionarioCriancasComMaisDoisAnosTransport();
            String pergunta = dados.getString("no_qst_pergunta");
            String resposta = dados.getString("no_qst_resposta");
            if (pergunta.equals("QUAIS_REFEICOES_VOCE_FAZ_AO_LONGO_DO_DIA")) {
                linha12.setPergunta(PerguntaCriancasComMaisDoisAnosEnumTransport.valueOf(pergunta.toUpperCase()));
                linha12.getRespostaMultiplaEscolha().add(RespostaMultiplaEscolhaEnumTransport.valueOf(resposta.toUpperCase()));
                continue;
            }
            linha.setPergunta(PerguntaCriancasComMaisDoisAnosEnumTransport.valueOf(pergunta.toUpperCase()));
            linha.setRespostaUnicaEscolha(RespostaUnicaEscolhaEnumTransport.valueOf(resposta.toUpperCase()));
            arrayGeral.add(linha);
        }
        arrayGeral.add(linha12);
        return arrayGeral;
    }

    private List<PerguntaQuestionarioCriancasMenoresSeisMesesTransport> PerguntaQuestionarioCriancasMenoresSeisMeses(int codAtiv) throws SQLException {
        BancoConsumoAlimentar bdConsumoAlimentar = new BancoConsumoAlimentar();
        ResultSet dados = bdConsumoAlimentar.getPerguntasQuestionarioCriancasMenoresSeisMeses(codAtiv);
        ArrayList<PerguntaQuestionarioCriancasMenoresSeisMesesTransport> arrayGeral = new ArrayList<PerguntaQuestionarioCriancasMenoresSeisMesesTransport>();
        while (dados.next()) {
            PerguntaQuestionarioCriancasMenoresSeisMesesTransport array = new PerguntaQuestionarioCriancasMenoresSeisMesesTransport();
            String pergunta = dados.getString("no_qst_pergunta");
            String resposta = dados.getString("no_qst_resposta");
            array.setPergunta(PerguntaCriancasMenoresSeisMesesEnumTransport.valueOf(pergunta.toUpperCase()));
            array.setRespostaUnicaEscolha(RespostaUnicaEscolhaEnumTransport.valueOf(resposta.toUpperCase()));
            arrayGeral.add(array);
        }
        return arrayGeral;
    }

    private List<PerguntaQuestionarioCriancasDeSeisVinteTresMesesTransport> PerguntasQuestionarioCriancasDeSeisVinteTresMeses(int codAtiv) throws SQLException {
        BancoConsumoAlimentar bdConsumoAlimentar = new BancoConsumoAlimentar();
        ResultSet dados = bdConsumoAlimentar.getPerguntasQuestionarioCriancasDeSeisVinteTresMeses(codAtiv);
        ArrayList<PerguntaQuestionarioCriancasDeSeisVinteTresMesesTransport> arrayGeral = new ArrayList<PerguntaQuestionarioCriancasDeSeisVinteTresMesesTransport>();
        while (dados.next()) {
            PerguntaQuestionarioCriancasDeSeisVinteTresMesesTransport array = new PerguntaQuestionarioCriancasDeSeisVinteTresMesesTransport();
            String pergunta = dados.getString("no_qst_pergunta");
            String resposta = dados.getString("no_qst_resposta");
            array.setPergunta(PerguntaCriancasDeSeisVinteTresMesesEnumTransport.valueOf(pergunta.toUpperCase()));
            array.setRespostaUnicaEscolha(RespostaUnicaEscolhaEnumTransport.valueOf(resposta.toUpperCase()));
            arrayGeral.add(array);
        }
        return arrayGeral;
    }

    private DadoTransporteTransportConsumoAlimentarXml montaArrayEnvioDto(FichaConsumoAlimentarTransport dadosConsumoAlimentarSerializado, String uuid, ResultSet row, int eehCodigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        String eroContraChave = dadosRO.getString("ero_contra_chave");
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(eroContraChave != null ? eroContraChave : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(eroContraChave != null ? eroContraChave : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport arrayVersao = new VersaoTransport();
        arrayVersao.setMajor(2);
        arrayVersao.setMinor(1);
        arrayVersao.setRevision(0);
        DadoTransporteTransportConsumoAlimentarXml dadoTransporteTransportXml = new DadoTransporteTransportConsumoAlimentarXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(12L);
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("eca_cnes"));
        dadoTransporteTransportXml.setNumLote(eehCodigo);
        dadoTransporteTransportXml.setCodIbge(row.getString("eca_codigo_ibge"));
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("eca_ine"));
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(arrayVersao);
        dadoTransporteTransportXml.setFichaConsumoAlimentarTransport(dadosConsumoAlimentarSerializado);
        return dadoTransporteTransportXml;
    }

    private ResultSet getDadosOriginadoraRemetente() throws SQLException {
        BancoConsumoAlimentar bdConsumoAlimentar = new BancoConsumoAlimentar();
        return bdConsumoAlimentar.getDadosOriginadoraRemetente();
    }
}

