/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.controller.AteIndividual;
import br.com.elotech.websaude.integracao.esus.controller.AtividadeColetiva;
import br.com.elotech.websaude.integracao.esus.controller.CadastroDomiciliar;
import br.com.elotech.websaude.integracao.esus.controller.CadastroIndividual;
import br.com.elotech.websaude.integracao.esus.controller.ConsumoAlimentar;
import br.com.elotech.websaude.integracao.esus.controller.FichaComplementar;
import br.com.elotech.websaude.integracao.esus.controller.FichaVacinacao;
import br.com.elotech.websaude.integracao.esus.controller.Odonto;
import br.com.elotech.websaude.integracao.esus.controller.Procedimento;
import br.com.elotech.websaude.integracao.esus.controller.VisitaDomiciliar;
import br.com.elotech.websaude.integracao.esus.model.EsusHistorico;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.io.comparator.LastModifiedFileComparator;

public class DadosEsus {
    private Logger logg;

    public DadosEsus() {
        try {
            FileHandler fh = new FileHandler("LogEsusExportacao.log", false);
            this.logg = Logger.getLogger("LogEsusExportacao");
            this.logg.setUseParentHandlers(false);
            this.logg.addHandler(fh);
            SimpleFormatter formatter = new SimpleFormatter();
            fh.setFormatter(formatter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void geraArquivo() {
        SimpleDateFormat dt = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        this.logger("Exporta\u00e7\u00e3o e-SUS ".concat(dt.format(new Date())).concat("\n"));
        this.varreServidorArqs();
        String sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        try {
            PreparedStatement pstmt = Conexao.CONN.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            EsusHistorico bdHist = new EsusHistorico();
            int eeh_codigo = bdHist.initHistorico();
            bdHist.setDtInicial(new Date());
            if (!rs.wasNull()) {
                this.logger("Iniciando Atendimento Individual");
                AteIndividual bdAteIndividual = new AteIndividual();
                bdAteIndividual.executeMain(eeh_codigo);
                this.logger("Atendimento Individual Finalizado \n");
                this.logger("Iniciando Cadastro Domiciliar");
                CadastroDomiciliar bdCadDomiciliar = new CadastroDomiciliar();
                bdCadDomiciliar.executeMain(eeh_codigo);
                this.logger("Cadastro Domiciliar Finalizado \n");
                this.logger("Iniciando Cadastro Individual");
                CadastroIndividual bdCadIndividual = new CadastroIndividual();
                bdCadIndividual.executeMain(eeh_codigo);
                this.logger("Cadastro Individual Finalizado \n");
                this.logger("Iniciando Atividade Coletiva");
                AtividadeColetiva bdAtiColetiva = new AtividadeColetiva();
                bdAtiColetiva.executeMain(eeh_codigo);
                this.logger("Atividade Coletiva Finalizado \n");
                this.logger("Iniciando Odonto");
                Odonto bdOdonto = new Odonto();
                bdOdonto.executeMain(eeh_codigo);
                this.logger("Odonto Finalizado \n");
                this.logger("Iniciando Procedimento");
                Procedimento bdProcedimento = new Procedimento();
                bdProcedimento.executeMain(eeh_codigo);
                this.logger("Procedimento Finalizado \n");
                this.logger("Iniciando Visita Domiciliar");
                VisitaDomiciliar bdVisDomiciliar = new VisitaDomiciliar();
                bdVisDomiciliar.executeMain(eeh_codigo);
                this.logger("Visita Domiciliar Finalizado \n");
                this.logger("Iniciando Consumo Alimentar");
                ConsumoAlimentar bdConsumo = new ConsumoAlimentar();
                bdConsumo.executeMain(eeh_codigo);
                this.logger("Consumo Alimentar Finalizado \n");
                this.logger("Iniciando Ficha Complementar");
                FichaComplementar bdFichaComplementar = new FichaComplementar();
                bdFichaComplementar.executeMain(eeh_codigo);
                this.logger("Ficha Complementar ZikaMicrocefalia Finalizado \n");
                this.logger("Iniciando Ficha Vacina\u00e7\u00e3o");
                FichaVacinacao bdFichaVacinacao = new FichaVacinacao();
                bdFichaVacinacao.executeMain(eeh_codigo);
                this.logger("Ficha Vacina\u00e7\u00e3o Finalizado \n");
                this.logger("Compactando Arquivos");
                Compactador.compactarParaZip("arqs/RAS_FileZip_" + eeh_codigo + ".zip", null);
                this.logger("Arquivos Compactados \n");
                bdHist.setDtFinal(new Date());
                bdHist.gravaHistorico(eeh_codigo);
                this.logger("Processo Finalizado");
            }
        }
        catch (Exception e) {
            this.logger(e.getMessage());
        }
    }

    private void logger(String dados) {
        this.logg.info(dados);
    }

    public void varreServidorArqs() {
        File directory = new File("arqs/");
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!directory.canWrite()) {
            try {
                throw new Exception("N\u00e3o \u00e9 poss\u00edvel escrever.");
            }
            catch (Exception ex) {
                Logger.getLogger(DadosEsus.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        File[] arqs = directory.listFiles();
        Arrays.sort(arqs, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : arqs) {
            Date ultModificado = new Date(file.lastModified());
            if (ultModificado.before(new Date(ultModificado.getYear(), ultModificado.getMonth() - 4, ultModificado.getDay())) && file.canWrite()) {
                file.deleteOnExit();
            }
            if (!file.getName().contains(".esus.xml")) continue;
            file.deleteOnExit();
        }
    }
}

