/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoFichaComplementar;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportFichaComplementarXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryFichaComplementar;
import br.ufsc.esus.fichacomplementarzikamicrocefalia.FichaComplementarZikaMicrocefaliaTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class FichaComplementar
extends BD {
    public void executeMain(int eehCodigo) throws SQLException, JAXBException, IOException {
        BancoFichaComplementar bdFichaComp = new BancoFichaComplementar();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosComplementar = bdFichaComp.getDados();
        int numAtend = bdFichaComp.getQtdRegistros();
        if (numAtend > 0) {
            while (dadosComplementar.next()) {
                FichaComplementar complementar = new FichaComplementar();
                String uuid = complementar.getGUID();
                FichaComplementarZikaMicrocefaliaTransport ficha = this.fichaComplementarThrift(uuid, dadosComplementar);
                DadoTransporteTransportFichaComplementarXml arrayEnvio = this.montaArrayEnvioDto(ficha, uuid, dadosComplementar, eehCodigo);
                this.zipWriter(arrayEnvio, uuid);
                bdEsusHistoricoItens.registratHistoricoItens(eehCodigo, uuid, 13);
                bdFichaComp.atualizaStatus(uuid, dadosComplementar.getInt("codigo"));
            }
        }
    }

    public void zipWriter(DadoTransporteTransportFichaComplementarXml xmlText, String uuid) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryFichaComplementar factoryFichaComplementar = new ObjectFactoryFichaComplementar();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryFichaComplementar.class);
        JAXBElement<DadoTransporteTransportFichaComplementarXml> element = factoryFichaComplementar.createDadoTransporteTransportFichaComplementarXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    private FichaComplementarZikaMicrocefaliaTransport fichaComplementarThrift(String uuid, ResultSet row) throws SQLException, ParseException {
        UnicaLotacaoHeaderTransport arrayUnica = this.montaArrayUnica(row);
        Integer origem = 3;
        FichaComplementarZikaMicrocefaliaTransport dadosFc = new FichaComplementarZikaMicrocefaliaTransport();
        dadosFc.setHeaderTransport(arrayUnica);
        dadosFc.setUuidFicha(uuid);
        dadosFc.setTpCdsOrigem(origem);
        dadosFc.setTurno(row.getLong("turno"));
        dadosFc.setCnsCidadao(row.getString("cnsCidadao"));
        dadosFc.setCnsResponsavelFamiliar(row.getString("cnsResponsavelFamiliar"));
        dadosFc.setDataRealizacaoTesteOlhinho(DataConvert.dateToEpoch(row.getDate("dataRealizacaoTesteOlhinho")));
        if (row.getLong("coResultadoTesteOlhinho") != 0L) {
            dadosFc.setCoResultadoTesteOlhinho(row.getLong("coResultadoTesteOlhinho"));
        }
        dadosFc.setDataRealizacaoExameFundoOlho(DataConvert.dateToEpoch(row.getDate("dataRealizacaoExameFundoOlho")));
        if (row.getLong("coResultadoExameFundoOlho") != 0L) {
            dadosFc.setCoResultadoExameFundoOlho(row.getLong("coResultadoExameFundoOlho"));
        }
        dadosFc.setDataRealizacaoTesteOrelhinha(DataConvert.dateToEpoch(row.getDate("dataRealizacaoTesteOrelhinha")));
        if (row.getLong("coResultadoTesteOrelhinha") != 0L) {
            dadosFc.setCoResultadoTesteOrelhinha(row.getLong("coResultadoTesteOrelhinha"));
        }
        dadosFc.setDataRealizacaoUSTransfontanela(DataConvert.dateToEpoch(row.getDate("dataRealizacaoUSTransfontanela")));
        if (row.getLong("coResultadoUsTransfontanela") != 0L) {
            dadosFc.setCoResultadoUsTransfontanela(row.getLong("coResultadoUsTransfontanela"));
        }
        dadosFc.setDataRealizacaoTomografiaComputadorizada(DataConvert.dateToEpoch(row.getDate("dataRealizacaoTomografiaComputadorizada")));
        if (row.getLong("coResultadoTomografiaComputadorizada") != 0L) {
            dadosFc.setCoResultadoTomografiaComputadorizada(row.getLong("coResultadoTomografiaComputadorizada"));
        }
        dadosFc.setDataRealizacaoRessonanciaMagnetica(DataConvert.dateToEpoch(row.getDate("dataRealizacaoRessonanciaMagnetica")));
        if (row.getLong("coResultadoRessonanciaMagnetica") != 0L) {
            dadosFc.setCoResultadoRessonanciaMagnetica(row.getLong("coResultadoRessonanciaMagnetica"));
        }
        return dadosFc;
    }

    private UnicaLotacaoHeaderTransport montaArrayUnica(ResultSet row) throws SQLException {
        UnicaLotacaoHeaderTransport headerTransport = new UnicaLotacaoHeaderTransport();
        headerTransport.setProfissionalCNS(this.validaCnsBanco(row.getString("profissionalCNS").trim()) ? row.getString("profissionalCNS").trim() : null);
        headerTransport.setCboCodigo2002(row.getString("cboCodigo_2002"));
        headerTransport.setCnes(row.getString("cnes"));
        headerTransport.setIne(row.getString("ine"));
        headerTransport.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("dataAtendimento")));
        headerTransport.setCodigoIbgeMunicipio(row.getString("codigoIbgeMunicipio"));
        return headerTransport;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        String sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        PreparedStatement pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    private DadoTransporteTransportFichaComplementarXml montaArrayEnvioDto(FichaComplementarZikaMicrocefaliaTransport dadosComplementarSerializado, String uuid, ResultSet row, int eehCodigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        String eroContraChave = dadosRO.getString("ero_contra_chave");
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(eroContraChave != null ? eroContraChave : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(eroContraChave != null ? eroContraChave : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport arrayVersao = new VersaoTransport();
        arrayVersao.setMajor(3);
        arrayVersao.setMinor(0);
        arrayVersao.setRevision(1);
        DadoTransporteTransportFichaComplementarXml dadoTransporteTransportXml = new DadoTransporteTransportFichaComplementarXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(13L);
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("cnes"));
        dadoTransporteTransportXml.setNumLote(eehCodigo);
        dadoTransporteTransportXml.setCodIbge(row.getString("codigoIbgeMunicipio"));
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("ine"));
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(arrayVersao);
        dadoTransporteTransportXml.setFichaComplementarZikaMicrocefaliaTransport(dadosComplementarSerializado);
        return dadoTransporteTransportXml;
    }
}

