/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoFichaVacinacao;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportVacinacaoXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryVacinacao;
import br.ufsc.esus.fichavacinacaochild.FichaVacinacaoChildTransport;
import br.ufsc.esus.fichavacinacaochild.VacinaRowThriftTransport;
import br.ufsc.esus.fichavacinacaomaster.FichaVacinacaoMasterTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class FichaVacinacao
extends BD {
    public void executeMain(int eehCodigo) throws SQLException, JAXBException, IOException {
        BancoFichaVacinacao bdFichaVac = new BancoFichaVacinacao();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosVacina = bdFichaVac.getDadosFichaVacinacaoChild();
        int numAtend = bdFichaVac.getQtdRegistros();
        if (numAtend > 0) {
            while (dadosVacina.next()) {
                FichaVacinacao vacinacao = new FichaVacinacao();
                String uuid = vacinacao.getGUID();
                FichaVacinacaoMasterTransport ficha = this.fichaVacinacaoThrift(uuid, dadosVacina);
                DadoTransporteTransportVacinacaoXml arrayEnvio = this.montaArrayEnvioDto(ficha, uuid, dadosVacina, eehCodigo);
                this.zipWriter(arrayEnvio, uuid);
                bdEsusHistoricoItens.registratHistoricoItens(eehCodigo, uuid, 14);
                bdFichaVac.atualizaStatus(uuid, dadosVacina.getInt("codigo"));
            }
        }
    }

    public void zipWriter(DadoTransporteTransportVacinacaoXml xmlText, String uuid) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryVacinacao factoryFichaVacinacao = new ObjectFactoryVacinacao();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryVacinacao.class);
        JAXBElement<DadoTransporteTransportVacinacaoXml> element = factoryFichaVacinacao.createDadoTransporteTransportVacinacaoXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    private FichaVacinacaoMasterTransport fichaVacinacaoThrift(String uuid, ResultSet row) throws SQLException, ParseException {
        BancoFichaVacinacao bdFichaVac = new BancoFichaVacinacao();
        UnicaLotacaoHeaderTransport arrayUnica = this.montaArrayUnica(row);
        FichaVacinacaoMasterTransport dadosFv = new FichaVacinacaoMasterTransport();
        ArrayList<FichaVacinacaoChildTransport> fichas = new ArrayList<FichaVacinacaoChildTransport>();
        FichaVacinacaoChildTransport ficha = new FichaVacinacaoChildTransport();
        ArrayList<VacinaRowThriftTransport> vacinas = new ArrayList<VacinaRowThriftTransport>();
        Integer origem = 3;
        dadosFv.setHeaderTransport(arrayUnica);
        dadosFv.setUuidFicha(uuid);
        dadosFv.setTpCdsOrigem(origem);
        ficha.setTurno(row.getLong("turno"));
        ficha.setNumProntuario(row.getString("numProntuario"));
        ficha.setCnsCidadao(row.getString("cnsCidadao"));
        ficha.setDtNascimento(DataConvert.dateToEpoch(row.getDate("dtNascimento")));
        long sexo = 4L;
        if (row.getString("sexo").equals("M")) {
            sexo = 0L;
        } else if (row.getString("sexo").equals("F")) {
            sexo = 1L;
        }
        ficha.setSexo(sexo);
        ficha.setLocalAtendimento(row.getLong("localAtendimento"));
        ficha.setViajante(row.getBoolean("viajante"));
        ficha.setGestante(row.getBoolean("gestante"));
        ficha.setPuerpera(row.getBoolean("puerpera"));
        ResultSet dados = bdFichaVac.getDadosVacinaRowThrift(row.getInt("codigo"));
        while (dados.next()) {
            VacinaRowThriftTransport vac = new VacinaRowThriftTransport();
            vac.setImunobiologico(dados.getLong("imunobiologico"));
            vac.setEstrategiaVacinacao(dados.getLong("estrategiaVacinacao"));
            vac.setDose(dados.getLong("dose"));
            if (vac.getImunobiologico() == 15L) {
                if (row.getString("comunicanteHanseniase") != null && !row.getString("comunicanteHanseniase").isEmpty()) {
                    ficha.setComunicanteHanseniase(row.getBoolean("comunicanteHanseniase"));
                }
                if (vac.getDose() == 1L) {
                    vac.setDose(Long.parseLong("9"));
                }
                if (vac.getDose() != 9L && vac.getDose() != 1L && vac.getDose() != 10L) {
                    vac.setDose(Long.parseLong("10"));
                }
            }
            vac.setLote(dados.getString("lote"));
            vac.setFabricante(dados.getString("fabricante"));
            vacinas.add(vac);
        }
        ficha.setVacinas(vacinas);
        fichas.add(ficha);
        dadosFv.setVacinacoes(fichas);
        return dadosFv;
    }

    private UnicaLotacaoHeaderTransport montaArrayUnica(ResultSet row) throws SQLException {
        UnicaLotacaoHeaderTransport headerTransport = new UnicaLotacaoHeaderTransport();
        headerTransport.setProfissionalCNS(this.validaCnsBanco(row.getString("profissionalCNS").trim()) ? row.getString("profissionalCNS").trim() : null);
        headerTransport.setCboCodigo2002(row.getString("cboCodigo_2002"));
        headerTransport.setCnes(row.getString("cnes"));
        headerTransport.setIne(row.getString("ine"));
        headerTransport.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("dataAtendimento")));
        headerTransport.setCodigoIbgeMunicipio(row.getString("codigoIbgeMunicipio"));
        return headerTransport;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        String sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        PreparedStatement pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    private DadoTransporteTransportVacinacaoXml montaArrayEnvioDto(FichaVacinacaoMasterTransport dadosVacinacaoSerializado, String uuid, ResultSet row, int eehCodigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        String eroContraChave = dadosRO.getString("ero_contra_chave");
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(eroContraChave != null ? eroContraChave : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(eroContraChave != null ? eroContraChave : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport arrayVersao = new VersaoTransport();
        arrayVersao.setMajor(3);
        arrayVersao.setMinor(0);
        arrayVersao.setRevision(1);
        DadoTransporteTransportVacinacaoXml dadoTransporteTransportXml = new DadoTransporteTransportVacinacaoXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(14L);
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("cnes"));
        dadoTransporteTransportXml.setCodIbge(row.getString("codigoIbgeMunicipio"));
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("ine"));
        dadoTransporteTransportXml.setNumLote(eehCodigo);
        dadoTransporteTransportXml.setFichaVacinacaoMasterTransport(dadosVacinacaoSerializado);
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(arrayVersao);
        return dadoTransporteTransportXml;
    }
}

