/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoOdonto;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportOdontoXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryOdonto;
import br.ufsc.esus.fichaatendimentoodontologicochild.FichaAtendimentoOdontologicoChildTransport;
import br.ufsc.esus.fichaatendimentoodontologicomaster.FichaAtendimentoOdontologicoMasterTransport;
import br.ufsc.esus.lotacaoheader.LotacaoHeaderTransport;
import br.ufsc.esus.procedimentoquantidade.ProcedimentoQuantidadeTransport;
import br.ufsc.esus.variaslotacoesheader.VariasLotacoesHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class Odonto
extends BD {
    BancoOdonto bdOdonto = new BancoOdonto();

    public void executeMain(int eeh_codigo) throws SQLException, JAXBException, IOException {
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosOdonto = this.bdOdonto.getDados();
        int numAtend = this.bdOdonto.getQtdRegistros();
        if (numAtend > 0) {
            while (dadosOdonto.next()) {
                Odonto dadosThrift = new Odonto();
                String uuid = dadosThrift.getGUID();
                FichaAtendimentoOdontologicoMasterTransport ficha_master = this.fichaAtendimentoOdontologicoMasterThrift(uuid, dadosOdonto);
                DadoTransporteTransportOdontoXml array_envio = this.montaArrayEnvioDto(ficha_master, uuid, dadosOdonto, eeh_codigo);
                this.zipWriter(array_envio, uuid, eeh_codigo);
                bdEsusHistoricoItens.registratHistoricoItens(eeh_codigo, uuid, 7);
                this.bdOdonto.atualizaStatus(uuid, dadosOdonto.getInt("odo_pcon_codigo"));
            }
        }
    }

    public void zipWriter(DadoTransporteTransportOdontoXml xmlText, String uuid, int eeh_codigo) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryOdonto factoryCadastroIndividual = new ObjectFactoryOdonto();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryOdonto.class);
        JAXBElement<DadoTransporteTransportOdontoXml> element = factoryCadastroIndividual.createDadoTransporteTransportOdontoXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.setProperty("jaxb.schemaLocation", "");
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    public FichaAtendimentoOdontologicoMasterTransport fichaAtendimentoOdontologicoMasterThrift(String uuid, ResultSet row) throws SQLException {
        VariasLotacoesHeaderTransport variasLotacoes = this.variasLotacoes(row);
        FichaAtendimentoOdontologicoChildTransport atendimentosOdontologicos = this.fichaAtendimentoOdontologicoChildThrift(row);
        FichaAtendimentoOdontologicoMasterTransport array_dto = new FichaAtendimentoOdontologicoMasterTransport();
        array_dto.setUuidFicha(uuid);
        array_dto.setHeaderTransport(variasLotacoes);
        array_dto.setTpCdsOrigem(3);
        array_dto.getAtendimentosOdontologicos().add(atendimentosOdontologicos);
        return array_dto;
    }

    public VariasLotacoesHeaderTransport variasLotacoes(ResultSet row) throws SQLException {
        LotacaoHeaderTransport headerTransport = new LotacaoHeaderTransport();
        headerTransport.setProfissionalCNS(this.validaCnsBanco(row.getString("eo_profissional_cns")) ? row.getString("eo_profissional_cns") : null);
        headerTransport.setCboCodigo2002(row.getString("eo_cbo_codigo_2002"));
        headerTransport.setCnes(row.getString("eo_cnes"));
        headerTransport.setIne(row.getString("eo_ine"));
        VariasLotacoesHeaderTransport variasLotacoes = new VariasLotacoesHeaderTransport();
        variasLotacoes.setLotacaoFormPrincipal(headerTransport);
        variasLotacoes.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("eo_dtatendimento")));
        variasLotacoes.setCodigoIbgeMunicipio(row.getString("eo_codigo_ibge_mun"));
        return variasLotacoes;
    }

    public FichaAtendimentoOdontologicoChildTransport fichaAtendimentoOdontologicoChildThrift(ResultSet row) throws SQLException {
        Long tiposConsultaOdonto = row.getLong("eo_tipo_consulta");
        FichaAtendimentoOdontologicoChildTransport array_atend_odonto = new FichaAtendimentoOdontologicoChildTransport();
        array_atend_odonto.setDtNascimento(DataConvert.dateToEpoch(row.getDate("eo_dtnascimento")));
        array_atend_odonto.setCnsCidadao(this.validaCnsBanco(row.getString("eo_num_cartao_sus")) ? row.getString("eo_num_cartao_sus").trim() : null);
        array_atend_odonto.setNumProntuario(row.getString("eo_numprontuario"));
        if (row.getLong("co_local_atend") <= 10L) {
            array_atend_odonto.setLocalAtendimento(row.getLong("co_local_atend"));
        }
        array_atend_odonto.setTipoAtendimento(row.getLong("eo_tipo_atendimento"));
        array_atend_odonto.setSexo(Long.valueOf(row.getString("eo_sexo").replace(" L", "")));
        array_atend_odonto.setTurno(this.bdOdonto.getTurno(row.getLong("odo_pcon_codigo")));
        array_atend_odonto.getTiposEncamOdonto().addAll(this.getCondutaEncaminhamento(row.getInt("odo_pcon_codigo")));
        array_atend_odonto.getTiposVigilanciaSaudeBucal().addAll(this.getVigilanciaSaudeBucal(row.getInt("odo_pcon_codigo")));
        if (tiposConsultaOdonto > 0L) {
            array_atend_odonto.getTiposConsultaOdonto().add(tiposConsultaOdonto);
        }
        array_atend_odonto.getOutrosSiaProcedimentos().addAll(this.listaProcedimentosSigtap(row.getInt("odo_pcon_codigo")));
        return array_atend_odonto;
    }

    public List<ProcedimentoQuantidadeTransport> listaProcedimentosSigtap(int odoPconCodigo) throws SQLException {
        BancoOdonto bdOdonto = new BancoOdonto();
        ResultSet dadosProcedimentosSigtap = bdOdonto.getProcedimentos(odoPconCodigo);
        ArrayList<ProcedimentoQuantidadeTransport> arrayGeral = new ArrayList<ProcedimentoQuantidadeTransport>();
        while (dadosProcedimentosSigtap.next()) {
            ProcedimentoQuantidadeTransport array = new ProcedimentoQuantidadeTransport();
            array.setCoMsProcedimento(dadosProcedimentosSigtap.getString("proc_codigo_sus"));
            array.setQuantidade(1);
            arrayGeral.add(array);
        }
        return arrayGeral;
    }

    public List<Long> getCondutaEncaminhamento(int odoPconCodigo) throws SQLException {
        BancoOdonto bdOdonto = new BancoOdonto();
        ResultSet dadosEncaminhamento = bdOdonto.getCondutaEncaminhamento(odoPconCodigo);
        ArrayList<Long> procsRea = new ArrayList<Long>();
        while (dadosEncaminhamento.next()) {
            procsRea.add(dadosEncaminhamento.getLong("tp_cds_encam_odonto"));
        }
        return procsRea;
    }

    public List<Long> getVigilanciaSaudeBucal(int odoPconCodigo) throws SQLException {
        BancoOdonto bdOdonto = new BancoOdonto();
        ResultSet dadosVigilancia = bdOdonto.getVigilanciaSaudeBucal(odoPconCodigo);
        ArrayList<Long> procsRea = new ArrayList<Long>();
        while (dadosVigilancia.next()) {
            procsRea.add(dadosVigilancia.getLong("tp_cds_vig_saude_bucal"));
        }
        if (dadosVigilancia.wasNull()) {
            procsRea.add(99L);
        }
        return procsRea;
    }

    private DadoTransporteTransportOdontoXml montaArrayEnvioDto(FichaAtendimentoOdontologicoMasterTransport ficha_master_serializado, String uuid, ResultSet row, int eeh_codigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport array_versao = new VersaoTransport();
        array_versao.setMajor(2);
        array_versao.setMinor(1);
        array_versao.setRevision(0);
        DadoTransporteTransportOdontoXml dadoTransporteTransportXml = new DadoTransporteTransportOdontoXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(Long.valueOf(row.getString("eo_tipo_dado_serializado").replace(" L", "")));
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("eo_cnes"));
        dadoTransporteTransportXml.setCodIbge(row.getString("eo_codigo_ibge_mun"));
        dadoTransporteTransportXml.setNumLote(eeh_codigo);
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(array_versao);
        dadoTransporteTransportXml.setFichaAtendimentoOdontologicoMasterTransport(ficha_master_serializado);
        return dadoTransporteTransportXml;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }
}

