/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoProcedimentos;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.com.elotech.websaude.integracao.esus.util.Util;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportProcedimentoXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryProcedimento;
import br.ufsc.esus.fichaprocedimentochild.FichaProcedimentoChildTransport;
import br.ufsc.esus.fichaprocedimentomaster.FichaProcedimentoMasterTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class Procedimento
extends BD {
    public void executeMain(int eeh_codigo) throws SQLException, JAXBException, IOException {
        BancoProcedimentos bdProcedimentos = new BancoProcedimentos();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        List<HashMap> dadosProcedimentos = bdProcedimentos.getDadosProcedimentos();
        ResultSet numAtend = bdProcedimentos.getCountDadosProcedimentos();
        ArrayList<String> listaRepassados = new ArrayList<String>();
        if (!numAtend.wasNull()) {
            for (HashMap hash : dadosProcedimentos) {
                if (listaRepassados.contains(String.valueOf(hash.get("age_codigo")))) continue;
                Procedimento dadosThrift = new Procedimento();
                String uuid = dadosThrift.getGUID();
                FichaProcedimentoMasterTransport ficha_master = this.montaArrayFichaProcedimentoMaster(uuid, hash);
                DadoTransporteTransportProcedimentoXml ficha_master_serializa = this.montaArrayEnvioDto(ficha_master, uuid, hash, eeh_codigo);
                this.zipWriter(ficha_master_serializa, uuid, eeh_codigo);
                bdEsusHistoricoItens.registratHistoricoItens(eeh_codigo, uuid, 3);
                Integer age_codigo = Integer.parseInt(String.valueOf(hash.get("age_codigo")));
                bdProcedimentos.atualizaStatus(uuid, age_codigo);
                listaRepassados.add(String.valueOf(hash.get("age_codigo")));
            }
        }
    }

    public ResultSet getQtd() throws SQLException {
        BancoProcedimentos bdProcedimentos = new BancoProcedimentos();
        ResultSet numAtend = bdProcedimentos.getCountDadosProcedimentos();
        return numAtend;
    }

    public void zipWriter(DadoTransporteTransportProcedimentoXml xmlText, String uuid, int eeh_codigo) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryProcedimento factoryCadastroIndividual = new ObjectFactoryProcedimento();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryProcedimento.class);
        JAXBElement<DadoTransporteTransportProcedimentoXml> element = factoryCadastroIndividual.createDadoTransporteTransportProcedimentoXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    public DadoTransporteTransportProcedimentoXml montaArrayEnvioDto(FichaProcedimentoMasterTransport ficha_master_serializado, String uuid, HashMap row, int eeh_codigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport array_versao = new VersaoTransport();
        array_versao.setMajor(3);
        array_versao.setMinor(0);
        array_versao.setRevision(1);
        DadoTransporteTransportProcedimentoXml dadoTransporteTransportXml = new DadoTransporteTransportProcedimentoXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        String efp_tipo_dado_serializado = Util.verificaNulo(row.get("efp_tipo_dado_serializado"));
        if (efp_tipo_dado_serializado != "" && efp_tipo_dado_serializado != null) {
            efp_tipo_dado_serializado = efp_tipo_dado_serializado.replace(" L", "");
        }
        dadoTransporteTransportXml.setTipoDadoSerializado(Long.valueOf(efp_tipo_dado_serializado));
        dadoTransporteTransportXml.setCnesDadoSerializado(Util.verificaNulo(row.get("efp_cnes")));
        dadoTransporteTransportXml.setCodIbge(Util.verificaNulo(row.get("efp_codigo_ibge_mun")));
        dadoTransporteTransportXml.setIneDadoSerializado(Util.verificaNulo(row.get("efp_ine")));
        dadoTransporteTransportXml.setNumLote(eeh_codigo);
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(array_versao);
        dadoTransporteTransportXml.setFichaProcedimentoMasterTransport(ficha_master_serializado);
        return dadoTransporteTransportXml;
    }

    public FichaProcedimentoMasterTransport montaArrayFichaProcedimentoMaster(String uuid, HashMap row) throws SQLException {
        UnicaLotacaoHeaderTransport array_unica = this.montaArrayUnica(row);
        List<FichaProcedimentoChildTransport> array_atend_proc = this.montaArrayAtendProcedimentos(row);
        FichaProcedimentoMasterTransport array_dto = new FichaProcedimentoMasterTransport();
        array_dto.setUuidFicha(uuid);
        array_dto.setTpCdsOrigem(3);
        array_dto.setHeaderTransport(array_unica);
        array_dto.getAtendProcedimentos().addAll(array_atend_proc);
        if (Long.valueOf(row.get("numtotalafericaopa").toString()) > 0L) {
            array_dto.setNumTotalAfericaoPa(Long.valueOf(Util.verificaNulo(row.get("numtotalafericaopa"))));
        }
        if (Long.valueOf(row.get("numtotalglicemiacapilar").toString()) > 0L) {
            array_dto.setNumTotalGlicemiaCapilar(Long.valueOf(Util.verificaNulo(row.get("numtotalglicemiacapilar"))));
        }
        if (Long.valueOf(row.get("numtotalafericaotemperatura").toString()) > 0L) {
            array_dto.setNumTotalAfericaoTemperatura(Long.valueOf(Util.verificaNulo(row.get("numtotalafericaotemperatura"))));
        }
        if (Long.valueOf(row.get("numtotalmedicaoalturapeso").toString()) > 0L) {
            array_dto.setNumTotalMedicaoAltura(Long.valueOf(Util.verificaNulo(row.get("numtotalmedicaoalturapeso"))));
        }
        if (Long.valueOf(row.get("numtotalcurativo").toString()) > 0L) {
            array_dto.setNumTotalCurativoSimples(Long.valueOf(Util.verificaNulo(row.get("numtotalcurativo"))));
        }
        if (Long.valueOf(row.get("numtotalmedicaoalturapeso").toString()) > 0L) {
            array_dto.setNumTotalMedicaoPeso(Long.valueOf(Util.verificaNulo(row.get("numtotalmedicaoalturapeso"))));
        }
        if (Long.valueOf(row.get("numtotalexame").toString()) > 0L) {
            array_dto.setNumTotalColetaMaterialParaExameLaboratorial(Long.valueOf(Util.verificaNulo(row.get("numtotalexame"))));
        }
        return array_dto;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        String sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        PreparedStatement pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public UnicaLotacaoHeaderTransport montaArrayUnica(HashMap row) throws SQLException {
        UnicaLotacaoHeaderTransport array_unica = new UnicaLotacaoHeaderTransport();
        String efp_profissional_cns = Util.verificaNulo(row.get("efp_profissional_cns"));
        array_unica.setProfissionalCNS(this.validaCnsBanco(efp_profissional_cns) ? efp_profissional_cns : null);
        array_unica.setCboCodigo2002(Util.verificaNulo(row.get("efp_cbo_codigo_2002")));
        array_unica.setCnes(Util.verificaNulo(row.get("efp_cnes")));
        array_unica.setIne(Util.verificaNulo(row.get("efp_ine")));
        array_unica.setDataAtendimento(DataConvert.dateToEpoch(Date.valueOf(Util.verificaNulo(row.get("efp_dtatendimento")))));
        array_unica.setCodigoIbgeMunicipio(Util.verificaNulo(row.get("efp_codigo_ibge_mun")));
        return array_unica;
    }

    public List<FichaProcedimentoChildTransport> montaArrayAtendProcedimentos(HashMap row) throws SQLException {
        FichaProcedimentoChildTransport array_atend_proced = new FichaProcedimentoChildTransport();
        array_atend_proced.setNumProntuario(Util.verificaNulo(row.get("efp_numprontuario")));
        String efp_num_cartao_sus = Util.verificaNulo(row.get("efp_num_cartao_sus"));
        array_atend_proced.setCnsCidadao(this.validaCnsBanco(efp_num_cartao_sus) ? efp_num_cartao_sus : null);
        array_atend_proced.setDtNascimento(DataConvert.dateToEpoch(Date.valueOf(Util.verificaNulo(row.get("efp_dtnascimento")))));
        String efp_sexo = Util.verificaNulo(row.get("efp_sexo"));
        if (efp_sexo != "" && efp_sexo != null) {
            efp_sexo = efp_sexo.replace(" L", "");
        }
        array_atend_proced.setSexo(Long.valueOf(efp_sexo));
        if (Long.valueOf(row.get("co_local_atend").toString()).intValue() <= 10) {
            array_atend_proced.setLocalAtendimento(Long.valueOf(Util.verificaNulo(row.get("co_local_atend"))));
        }
        array_atend_proced.setTurno(this.getTurno(Integer.parseInt(Util.verificaNulo(row.get("efp_codigo")))));
        array_atend_proced.getProcedimentos().addAll(this.listaProcedimentosFicha(Integer.parseInt(Util.verificaNulo(row.get("age_codigo")))));
        array_atend_proced.getOutrosSiaProcedimentos().addAll(this.listaProcedimentosSigtap(Integer.parseInt(Util.verificaNulo(row.get("age_codigo")))));
        ArrayList<FichaProcedimentoChildTransport> lista = new ArrayList<FichaProcedimentoChildTransport>();
        lista.add(array_atend_proced);
        return lista;
    }

    public Long getTurno(int efp_codigo) throws SQLException {
        BancoProcedimentos bdProcedimentos = new BancoProcedimentos();
        ResultSet dadosTurno = bdProcedimentos.getTurno(efp_codigo);
        long turno = dadosTurno.next() ? dadosTurno.getLong(1) : 1L;
        return turno;
    }

    public List<String> listaProcedimentosSigtap(int ageCodigo) throws SQLException {
        String[] arrayCiaps = new String[]{"ABPG001", "ABPG002", "ABPG003", "ABPG004", "ABPG005", "ABPG006", "ABPG007", "ABPG008", "ABPG010", "ABPG011", "ABPG012", "ABPG013", "ABPG014", "ABPG015", "ABPG016", "ABPG017", "ABPG018", "ABPG019", "ABPG020", "ABPG021", "ABPG022", "ABPG040", "ABPG024", "ABPG025", "ABPG026", "ABPG027", "ABPG028", "ABPG029", "ABPG030", "ABPG031", "ABPG032", "ABPG041"};
        BancoProcedimentos bdProcedimentos = new BancoProcedimentos();
        ResultSet dadosProcedimentosSigtap = bdProcedimentos.getProcedimentosSigtap(ageCodigo);
        ArrayList<String> procsRea = new ArrayList<String>();
        while (dadosProcedimentosSigtap.next()) {
            boolean r = false;
            for (String text : arrayCiaps) {
                if (dadosProcedimentosSigtap.getString("proc_codigo_sus") == null || !dadosProcedimentosSigtap.getString("proc_codigo_sus").contains(text)) continue;
                r = true;
            }
            if (r) continue;
            procsRea.add(dadosProcedimentosSigtap.getString("proc_codigo_sus"));
        }
        return procsRea;
    }

    public List<String> listaProcedimentosFicha(int ageCodigo) throws SQLException {
        String[] arrayCiaps = new String[]{"ABPG001", "ABPG002", "ABPG003", "ABPG004", "ABPG005", "ABPG006", "ABPG007", "ABPG008", "ABEX004", "ABPG010", "ABPG011", "ABPG012", "ABPG013", "ABPG014", "ABPG015", "ABPG016", "ABPG017", "ABPG018", "ABPG019", "ABPG020", "ABPG021", "ABEX022", "ABPG022", "ABPG024", "ABPG025", "ABPG026", "ABPG027", "ABPG028", "ABPG029", "ABPG030", "ABPG031", "ABPG032", "ABPG040", "ABPG041"};
        BancoProcedimentos bdProcedimentos = new BancoProcedimentos();
        ResultSet dadosProcedimentos = bdProcedimentos.getProcedimentosSigtap(ageCodigo);
        ArrayList<String> procsFicha = new ArrayList<String>();
        while (dadosProcedimentos.next()) {
            for (String text : arrayCiaps) {
                if (dadosProcedimentos.getString("proc_codigo_sus") == null || !dadosProcedimentos.getString("proc_codigo_sus").contains(text)) continue;
                procsFicha.add(text);
            }
        }
        return procsFicha;
    }
}

