/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportVisitaDomiciliarXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryVisitaDomiciliar;
import br.ufsc.esus.fichavisitadomiciliarchild.FichaVisitaDomiciliarChildTransport;
import br.ufsc.esus.fichavisitadomiciliarmaster.FichaVisitaDomiciliarMasterTransport;
import br.ufsc.esus.unicalotacaoheader.UnicaLotacaoHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class VisitaDomiciliar
extends BD {
    public void executeMain(int eeh_codigo) throws SQLException, JAXBException, IOException {
        br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar bdVisitaDomiciliar = new br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosVisitaDomiciliar = bdVisitaDomiciliar.getDadosVisitaDomiciliar();
        ResultSet numAtend = bdVisitaDomiciliar.numDadosVisitaDomiciliar();
        if (!numAtend.wasNull()) {
            while (dadosVisitaDomiciliar.next()) {
                VisitaDomiciliar VisitaDomiciliar2 = new VisitaDomiciliar();
                String uuid = VisitaDomiciliar2.getGUID();
                FichaVisitaDomiciliarMasterTransport ficha_master = this.visitaDomiciliarMasterThrift(uuid, dadosVisitaDomiciliar);
                DadoTransporteTransportVisitaDomiciliarXml array_envio = this.montaArrayEnvioDto(ficha_master, uuid, dadosVisitaDomiciliar, eeh_codigo);
                this.zipWriter(array_envio, uuid, eeh_codigo);
                bdEsusHistoricoItens.registratHistoricoItens(eeh_codigo, uuid, 5);
                bdVisitaDomiciliar.atualizaStatus(uuid, dadosVisitaDomiciliar.getInt("ate_codigo"));
            }
        }
    }

    public void zipWriter(DadoTransporteTransportVisitaDomiciliarXml xmlText, String uuid, int eeh_codigo) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryVisitaDomiciliar factoryCadastroIndividual = new ObjectFactoryVisitaDomiciliar();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryVisitaDomiciliar.class);
        JAXBElement<DadoTransporteTransportVisitaDomiciliarXml> element = factoryCadastroIndividual.createDadoTransporteTransportVisitaDomiciliarXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    public FichaVisitaDomiciliarMasterTransport visitaDomiciliarMasterThrift(String uuid, ResultSet row) throws SQLException {
        UnicaLotacaoHeaderTransport dadosHeaderTransport = this.headerTransport(row);
        FichaVisitaDomiciliarChildTransport dadosFichaVisitaDomiciliar = this.fichaVisitaDomiciliarChildThrift(row);
        FichaVisitaDomiciliarMasterTransport array = new FichaVisitaDomiciliarMasterTransport();
        array.setUuidFicha(uuid);
        array.setTpCdsOrigem(3);
        array.setHeaderTransport(dadosHeaderTransport);
        array.getVisitasDomiciliares().add(dadosFichaVisitaDomiciliar);
        return array;
    }

    public UnicaLotacaoHeaderTransport headerTransport(ResultSet row) throws SQLException {
        UnicaLotacaoHeaderTransport array = new UnicaLotacaoHeaderTransport();
        array.setProfissionalCNS(this.validaCnsBanco(row.getString("esv_profissional_cns")) ? row.getString("esv_profissional_cns").trim() : null);
        array.setCboCodigo2002(row.getString("esv_cbo_codigo_2002"));
        array.setCnes(row.getString("esv_cnes"));
        array.setIne(row.getString("nu_ine"));
        array.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("esv_dtatendimento")));
        array.setCodigoIbgeMunicipio(row.getString("esv_codigo_ibge_mun"));
        return array;
    }

    public FichaVisitaDomiciliarChildTransport fichaVisitaDomiciliarChildThrift(ResultSet row) throws SQLException {
        boolean st_visita_compartilhada = this.getStVisitaCompartilhada(row.getInt("ate_codigo"));
        FichaVisitaDomiciliarChildTransport array = new FichaVisitaDomiciliarChildTransport();
        array.setNumProntuario(row.getString("esv_num_prontuario"));
        array.setCnsCidadao(this.validaCnsBanco(row.getString("esv_usu_cns")) ? row.getString("esv_usu_cns").trim() : null);
        array.setDtNascimento(DataConvert.dateToEpoch(row.getDate("esv_usu_datanasc")));
        array.setSexo(Long.valueOf(row.getString("esv_usu_sexo").replace(" L", "")));
        array.setStatusVisitaCompartilhadaOutroProfissional(st_visita_compartilhada);
        array.setDesfecho(Long.valueOf(row.getString("esv_desfecho").replace(" L", "")));
        array.setTurno(this.getTurno(row.getInt("esv_turno")));
        array.setTipoDeImovel(this.getTipoDeImovel(row.getInt("ate_codigo")));
        ArrayList<Long> tipoImovel = new ArrayList<Long>();
        tipoImovel.add(2L);
        tipoImovel.add(3L);
        tipoImovel.add(4L);
        tipoImovel.add(5L);
        tipoImovel.add(6L);
        tipoImovel.add(12L);
        if (!tipoImovel.contains(array.getTipoDeImovel())) {
            if (row.getDouble("vd_altura") > 0.0) {
                array.setAlturaAcompanhamentoNutricional(row.getDouble("vd_altura"));
            }
            if (row.getDouble("vd_peso") > 0.0) {
                array.setPesoAcompanhamentoNutricional(row.getDouble("vd_peso"));
            }
        }
        if (row.getString("usu_microarea_fa") != null) {
            if (row.getString("usu_microarea_fa").contains("t")) {
                array.setStForaArea(true);
            } else {
                array.setStForaArea(false);
                array.setMicroArea(row.getString("usu_microarea"));
            }
        } else {
            array.setMicroArea(row.getString("usu_microarea"));
        }
        array.getMotivosVisita().addAll(this.motivoVisita(row.getInt("co_cds_visita_domiciliar")));
        return array;
    }

    public long getTurno(int ate_codigo) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar bdVisitaDomiciliar = new br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar();
        ResultSet dadosTurno = bdVisitaDomiciliar.getTurno(ate_codigo);
        long turno = dadosTurno.next() ? dadosTurno.getLong(1) : 1L;
        return turno;
    }

    public long getTipoDeImovel(int ate_codigo) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar bdVisitaDomiciliar = new br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar();
        ResultSet dadosTipoDeImovel = bdVisitaDomiciliar.getTipoDeImovel(ate_codigo);
        long tipoDeImovel = dadosTipoDeImovel.next() ? dadosTipoDeImovel.getLong(1) : 99L;
        return tipoDeImovel;
    }

    public boolean getStVisitaCompartilhada(int ate_codigo) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar bdVisitaDomiciliar = new br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar();
        ResultSet dadosStVisitaCompartilhada = bdVisitaDomiciliar.getStVisitaCompartilhada(ate_codigo);
        boolean StVisitaCompartilhada = dadosStVisitaCompartilhada.next() ? dadosStVisitaCompartilhada.getBoolean(1) : false;
        return StVisitaCompartilhada;
    }

    public List<Long> motivoVisita(int codVisita) throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar bdVisitaDomiciliar = new br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar();
        ResultSet dadosVisitaDomiciliar = bdVisitaDomiciliar.getCodigosVisita(codVisita);
        ArrayList<Long> codsVis = new ArrayList<Long>();
        while (dadosVisitaDomiciliar.next()) {
            codsVis.add(dadosVisitaDomiciliar.getLong("co_cds_visita_dom_motivo"));
        }
        return codsVis;
    }

    private DadoTransporteTransportVisitaDomiciliarXml montaArrayEnvioDto(FichaVisitaDomiciliarMasterTransport dadosVisitaDomiciliarSerializado, String uuid, ResultSet row, int eeh_codigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport array_versao = new VersaoTransport();
        array_versao.setMajor(2);
        array_versao.setMinor(1);
        array_versao.setRevision(0);
        DadoTransporteTransportVisitaDomiciliarXml dadoTransporteTransportXml = new DadoTransporteTransportVisitaDomiciliarXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(8L);
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("esv_cnes"));
        dadoTransporteTransportXml.setCodIbge(row.getString("esv_codigo_ibge_mun"));
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("esv_ine"));
        dadoTransporteTransportXml.setNumLote(eeh_codigo);
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(array_versao);
        dadoTransporteTransportXml.setFichaVisitaDomiciliarMasterTransport(dadosVisitaDomiciliarSerializado);
        return dadoTransporteTransportXml;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar bdVisitaDomiciliar = new br.com.elotech.websaude.integracao.esus.model.VisitaDomiciliar();
        ResultSet dadosOriginadoraRemetente = bdVisitaDomiciliar.getDadosOriginadoraRemetente();
        return dadosOriginadoraRemetente;
    }
}

