/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.model;

import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Util;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BancoProcedimentos {
    protected static String sql = "";
    protected static PreparedStatement pstmt;
    private StringBuilder builder;

    public List<HashMap> getDadosProcedimentos() throws SQLException {
        this.builder = new StringBuilder("SELECT DISTINCT ");
        this.builder.append("  efp.age_codigo, ").append("  efp.co_local_atend, ").append("  efp.efp_profissional_cns, ").append("  efp.efp_cbo_codigo_2002, ").append("  efp.efp_cnes, ").append("  efp.efp_ine, ").append("  efp_dtatendimento, ").append("  efp.efp_codigo_ibge_mun, ").append("  efp.efp_num_cartao_sus, ").append("  efp.efp_dtnascimento, ").append("  efp.efp_sexo, ").append("  efp.efp_tipo_dado_serializado, ").append("  efp.efp_dtcadastro, ").append("  efp.efp_codigo, ").append("  efp_numprontuario ").append("FROM esus_ficha_procedimento AS efp ").append("WHERE uuid_ficha IS NULL OR uuid_ficha = '' ").append("GROUP BY age_codigo, co_local_atend, efp_profissional_cns, efp_cbo_codigo_2002, ").append("  efp_cnes, efp_ine, efp_dtatendimento, efp_codigo_ibge_mun, efp_num_cartao_sus, ").append("  efp_dtnascimento, efp_sexo, efp_tipo_dado_serializado, efp_dtcadastro, efp.efp_codigo;");
        pstmt = Conexao.CONN.prepareStatement(this.builder.toString());
        ResultSet rs = pstmt.executeQuery();
        List<HashMap> list_aux = Util.resultSetToArrayList(rs);
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        for (HashMap hash : list_aux) {
            list.add(this.getSubDadosProcedimentos(hash));
            Integer atual = list_aux.indexOf(hash) + 1;
            Integer total = list_aux.size();
            Util.showLoading("Procedimentos", atual, total);
        }
        return list;
    }

    public ResultSet getCountDadosProcedimentos() throws SQLException {
        sql = "SELECT DISTINCT efp.age_codigo FROM esus_ficha_procedimento AS efp WHERE uuid_ficha IS NULL OR uuid_ficha = '' GROUP BY age_codigo,co_local_atend,efp_profissional_cns,efp_cbo_codigo_2002,efp_cnes,efp_ine,efp_dtatendimento,efp_codigo_ibge_mun,efp_num_cartao_sus,efp_dtnascimento,efp_sexo,efp_tipo_dado_serializado,efp_dtcadastro,efp_codigo";
        pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public ResultSet getProcedimentosSigtap(int ageCodigo) throws SQLException {
        sql = "SELECT proc.proc_codigo_sus FROM esus_ficha_procedimento AS esf INNER JOIN procedimento AS proc ON esf.proc_codigo=proc.proc_codigo AND proc.proc_codigo_sus IS NOT NULL WHERE esf.age_codigo = ?";
        pstmt = Conexao.CONN.prepareStatement(sql);
        pstmt.setInt(1, ageCodigo);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public ResultSet getTurno(int efp_codigo) throws SQLException {
        sql = "select turno from atendimento as ate join esus_ficha_procedimento as efp on efp.age_codigo = ate.age_codigo where efp.efp_codigo = ?";
        pstmt = Conexao.CONN.prepareStatement(sql);
        pstmt.setInt(1, efp_codigo);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public boolean atualizaStatus(String uuid, int codigo) throws SQLException {
        sql = "UPDATE esus_ficha_procedimento SET uuid_ficha = ? WHERE age_codigo = ?";
        pstmt = Conexao.CONN.prepareStatement(sql);
        pstmt.setString(1, uuid);
        pstmt.setInt(2, codigo);
        pstmt.executeUpdate();
        return true;
    }

    private HashMap getSubDadosProcedimentos(HashMap hash) throws SQLException {
        this.builder = new StringBuilder("SELECT");
        this.builder.append("  (SELECT COUNT(*) ").append("   FROM procedimento_atendimento AS pat ").append("     INNER JOIN atendimento AS ate ON pat.ate_codigo = ate.ate_codigo ").append("     INNER JOIN agendamento AS age ON ate.age_codigo = age.age_codigo ").append("     INNER JOIN procedimento AS proc ON pat.proc_codigo = proc.proc_codigo ").append("   WHERE age.age_codigo = ? AND proc.proc_codigo_sus = '0301100039') ").append("    AS numTotalAfericaoPa, ").append("  (SELECT COUNT(*) ").append("   FROM procedimento_atendimento AS pat ").append("     INNER JOIN atendimento AS ate ON pat.ate_codigo = ate.ate_codigo ").append("     INNER JOIN agendamento AS age ON ate.age_codigo = age.age_codigo ").append("     INNER JOIN procedimento AS proc ON pat.proc_codigo = proc.proc_codigo ").append("   WHERE age.age_codigo = ? AND proc.proc_codigo_sus = '0214010015') ").append("    AS numTotalGlicemiaCapilar, ").append("  (SELECT COUNT(*) ").append("   FROM procedimento_atendimento AS pat ").append("     INNER JOIN atendimento AS ate ON pat.ate_codigo = ate.ate_codigo ").append("     INNER JOIN agendamento AS age ON ate.age_codigo = age.age_codigo ").append("     INNER JOIN procedimento AS proc ON pat.proc_codigo = proc.proc_codigo ").append("   WHERE age.age_codigo = ? AND proc.proc_codigo_sus = '0101040024') ").append("    AS numTotalMedicaoAlturaPeso, ").append("  (SELECT COUNT(*) ").append("   FROM procedimento_atendimento AS pat ").append("     INNER JOIN atendimento AS ate ON pat.ate_codigo = ate.ate_codigo ").append("     INNER JOIN agendamento AS age ON ate.age_codigo = age.age_codigo ").append("     INNER JOIN procedimento AS proc ON pat.proc_codigo = proc.proc_codigo ").append("   WHERE age.age_codigo = ? AND proc.proc_codigo_sus = '0201020041') ").append("    AS numTotalExame, ").append("  (SELECT COUNT(*) ").append("   FROM procedimento_atendimento AS pat ").append("     INNER JOIN atendimento AS ate ON pat.ate_codigo = ate.ate_codigo ").append("     INNER JOIN agendamento AS age ON ate.age_codigo = age.age_codigo ").append("     INNER JOIN procedimento AS proc ON pat.proc_codigo = proc.proc_codigo ").append("   WHERE age.age_codigo = ? AND proc.proc_codigo_sus = '0401010023') ").append("    AS numTotalCurativo, ").append("  (SELECT COUNT(*) ").append("   FROM procedimento_atendimento AS pat ").append("     INNER JOIN atendimento AS ate ON pat.ate_codigo = ate.ate_codigo ").append("     INNER JOIN agendamento AS age ON ate.age_codigo = age.age_codigo ").append("     INNER JOIN procedimento AS proc ON pat.proc_codigo = proc.proc_codigo ").append("   WHERE age.age_codigo = ? AND proc.proc_codigo_sus = 'ABPG034') ").append("    AS numTotalAfericaoTemperatura");
        pstmt = Conexao.CONN.prepareStatement(this.builder.toString());
        for (int i = 1; i <= pstmt.getParameterMetaData().getParameterCount(); ++i) {
            pstmt.setInt(i, ((Long)hash.get("age_codigo")).intValue());
        }
        ResultSet rs = pstmt.executeQuery();
        return Util.addToHashMap(hash, rs);
    }
}

