/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.elosaude.websaude.integracao.sigtap.controller.ftp;

import br.com.elotech.elosaude.websaude.integracao.sigtap.controller.zip.ZipFile;
import br.com.elotech.elosaude.websaude.integracao.sigtap.model.dao.Conexao;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SigtapFtp {
    static final String URL = "ftp://ftp2.datasus.gov.br/pub/sistemas/tup/downloads/";
    static Map<String, String> lista = new HashMap<String, String>();
    public static String VERSAO = "";

    public static synchronized void obterUltimaVersao() throws IOException, SQLException {
        boolean prosseguir = true;
        PreparedStatement pstmt = Conexao.CONN.prepareStatement("SELECT * FROM sigtap_historico ORDER BY sig_codigo DESC LIMIT 1");
        ResultSet rs = pstmt.executeQuery();
        if (rs.next() && rs.getDate("sig_data_tentativa").toLocalDate().isEqual(LocalDate.now())) {
            prosseguir = false;
        }
        if (prosseguir) {
            String inputLine;
            URL url = null;
            url = new URL(URL);
            Map<String, String> env = System.getenv();
            String PWD = env.get("PWD");
            URLConnection con = null;
            boolean pro = false;
            if (PWD != null) {
                if (PWD.toLowerCase().contains("elovirtual")) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("192.168.1.250", 3128));
                    con = url.openConnection(proxy);
                    pro = true;
                    System.out.println("USANDO PROXY");
                } else {
                    con = url.openConnection();
                }
            } else {
                con = url.openConnection();
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                String[] tabela;
                if (!inputLine.contains("TabelaUnificada")) continue;
                if (!pro) {
                    tabela = inputLine.split("_");
                    lista.put(inputLine.substring(72, 78), inputLine.substring(56));
                    System.out.println(inputLine.substring(72, 78) + ", " + inputLine.substring(56));
                    continue;
                }
                tabela = inputLine.split("_");
                lista.put(inputLine.substring(60, 66), inputLine.substring(44, 82));
                System.out.println(inputLine.substring(60, 66) + ", " + inputLine.substring(44, 82));
            }
            in.close();
            Optional stream = lista.keySet().stream().max((o1, o2) -> {
                if (SigtapFtp.onlyInteger(o1) && SigtapFtp.onlyInteger(o2)) {
                    return Integer.valueOf(o1) - Integer.valueOf(o2);
                }
                return 0;
            });
            System.out.println("\u00daLTIMA VERS\u00c3O: " + (String)stream.get() + " LINK: " + URL + lista.get(stream.get()));
            pstmt = Conexao.CONN.prepareStatement("SELECT * FROM sigtap_historico ORDER BY sig_codigo DESC LIMIT 1");
            rs = pstmt.executeQuery();
            VERSAO = (String)stream.get();
            if (rs.next()) {
                if (rs.getString("sig_status").equalsIgnoreCase("em execu\u00e7\u00e3o")) {
                    if (rs.getDate("sig_data_tentativa").toLocalDate().isBefore(LocalDate.now())) {
                        SigtapFtp.executeDownload((String)stream.get(), URL + lista.get(stream.get()));
                    }
                } else if (!rs.getString("sig_versao").equals(stream.get())) {
                    SigtapFtp.executeDownload((String)stream.get(), URL + lista.get(stream.get()));
                }
            } else {
                SigtapFtp.executeDownload((String)stream.get(), URL + lista.get(stream.get()));
            }
        }
    }

    private static boolean onlyInteger(String text) {
        if (text == null) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static synchronized void download(String URL2) throws IOException {
        System.out.println("Abrindo conex\u00e3o site sigtap...");
        URL url = new URL(URL2);
        Map<String, String> env = System.getenv();
        String PWD = env.get("PWD");
        URLConnection con = null;
        boolean pro = false;
        if (PWD != null) {
            if (PWD.toLowerCase().contains("elovirtual")) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("192.168.1.250", 3128));
                con = url.openConnection(proxy);
                pro = true;
                System.out.println("USANDO PROXY DOWN");
            } else {
                con = url.openConnection();
                System.out.println("N\u00c3O USANDO PROXY DOWN");
            }
        } else {
            con = url.openConnection();
        }
        InputStream in = con.getInputStream();
        FileOutputStream fos = new FileOutputStream(new File("sigtap.zip"));
        System.out.println("Lendo e escrevendo arquivo...");
        int length = -1;
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > -1) {
            fos.write(buffer, 0, length);
        }
        fos.close();
        in.close();
        System.out.println("Download realizado.");
        File diretorio = new File("tmp");
        if (diretorio.exists()) {
            if (!diretorio.isDirectory()) {
                if (!diretorio.canWrite()) {
                    System.out.println("1 - N\u00e3o h\u00e1 permiss\u00e3o de ESCRITA!");
                    System.exit(0);
                }
                diretorio.mkdir();
            }
        } else {
            diretorio.mkdir();
        }
        System.out.println("Descompactando arquivo...");
        ZipFile.descompactar("sigtap.zip", "tmp", null);
    }

    private static synchronized void executeDownload(String versao, String urlDownload) throws SQLException, IOException {
        System.out.println("Gravando status inic\u00edo processo ...");
        PreparedStatement pstmt = Conexao.CONN.prepareStatement("INSERT INTO sigtap_historico(sig_versao,sig_status,sig_data_tentativa) VALUES (?,?,now())");
        pstmt.setString(1, versao);
        pstmt.setString(2, "Em Execu\u00e7\u00e3o");
        pstmt.executeUpdate();
        Conexao.CONN.commit();
        System.out.println("Iniciando Download...");
        SigtapFtp.download(urlDownload);
        pstmt = Conexao.CONN.prepareStatement("UPDATE sigtap_historico SET sig_status='Conclu\u00eddo',sig_data_atualizacao=now() WHERE sig_versao=?");
        pstmt.setString(1, VERSAO);
        pstmt.executeUpdate();
    }
}

