/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderReplacer {
    public static final PlaceholderReplacer NO_PLACEHOLDERS = new PlaceholderReplacer(new HashMap<String, String>(), "", "");
    private final Map<String, String> placeholders;
    private final String placeholderPrefix;
    private final String placeholderSuffix;

    public PlaceholderReplacer(Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        this.placeholders = placeholders;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public String replacePlaceholders(String input) {
        String noPlaceholders = input;
        for (String placeholder : this.placeholders.keySet()) {
            String searchTerm = this.placeholderPrefix + placeholder + this.placeholderSuffix;
            noPlaceholders = StringUtils.replaceAll(noPlaceholders, searchTerm, this.placeholders.get(placeholder));
        }
        return noPlaceholders;
    }
}

