/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.validation;

import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbValidator {
    private static final Log LOG = LogFactory.getLog(DbValidator.class);
    private final ValidationMode validationMode;
    private final MetaDataTable metaDataTable;

    public DbValidator(ValidationMode validationMode, MetaDataTable metaDataTable) {
        this.validationMode = validationMode;
        this.metaDataTable = metaDataTable;
    }

    public String validate(List<Migration> resolvedMigrations) {
        if (ValidationMode.NONE.equals((Object)this.validationMode)) {
            return null;
        }
        LOG.debug((Object)String.format("Validating (mode %s) migrations ...", new Object[]{this.validationMode}));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ArrayList<MetaDataTableRow> appliedMigrations = new ArrayList<MetaDataTableRow>(this.metaDataTable.allAppliedMigrations());
        if (appliedMigrations.isEmpty()) {
            LOG.info((Object)"No migrations applied yet. No validation necessary.");
            return null;
        }
        ArrayList<Migration> migrations = new ArrayList<Migration>(resolvedMigrations);
        Collections.reverse(migrations);
        MetaDataTableRow firstAppliedMigration = (MetaDataTableRow)appliedMigrations.get(0);
        if (MigrationType.INIT.equals((Object)firstAppliedMigration.getMigrationType())) {
            SchemaVersion initVersion = firstAppliedMigration.getVersion();
            appliedMigrations.remove(firstAppliedMigration);
            Iterator iterator = migrations.iterator();
            while (iterator.hasNext()) {
                Migration migration = (Migration)iterator.next();
                if (migration.getVersion().compareTo(initVersion) > 0) continue;
                iterator.remove();
            }
        }
        if (appliedMigrations.size() > migrations.size()) {
            ArrayList<SchemaVersion> schemaVersions = new ArrayList<SchemaVersion>();
            for (MetaDataTableRow metaDataTableRow : appliedMigrations) {
                schemaVersions.add(metaDataTableRow.getVersion());
            }
            for (Migration migration : migrations) {
                schemaVersions.remove(migration.getVersion());
            }
            String diff = StringUtils.collectionToCommaDelimitedString(schemaVersions);
            return String.format("More applied migrations than classpath migrations: DB=%s, Classpath=%s, Missing migrations=(%s)", appliedMigrations.size(), migrations.size(), diff);
        }
        for (int i = 0; i < appliedMigrations.size(); ++i) {
            Integer classpathChecksum;
            MetaDataTableRow appliedMigration = (MetaDataTableRow)appliedMigrations.get(i);
            Migration classpathMigration = (Migration)migrations.get(i);
            if (!appliedMigration.getVersion().equals(classpathMigration.getVersion())) {
                return String.format("Version mismatch for migration %s: DB=%s, Classpath=%s", appliedMigration.getScript(), appliedMigration.getVersion(), classpathMigration.getVersion());
            }
            if (!appliedMigration.getMigrationType().equals((Object)classpathMigration.getMigrationType())) {
                return String.format("Migration Type mismatch for migration %s: DB=%s, Classpath=%s", new Object[]{appliedMigration.getScript(), appliedMigration.getMigrationType(), classpathMigration.getMigrationType()});
            }
            Integer appliedChecksum = appliedMigration.getChecksum();
            if (ObjectUtils.nullSafeEquals((Object)appliedChecksum, (Object)(classpathChecksum = classpathMigration.getChecksum()))) continue;
            return String.format("Checksum mismatch for migration %s: DB=%s, Classpath=%s", appliedMigration.getScript(), appliedChecksum, classpathMigration.getChecksum());
        }
        stopWatch.stop();
        if (appliedMigrations.size() == 1) {
            LOG.info((Object)String.format("Validated 1 migration (mode: %s) (execution time %s)", new Object[]{this.validationMode, TimeFormat.format(stopWatch.getTotalTimeMillis())}));
        } else {
            LOG.info((Object)String.format("Validated %d migrations (mode: %s) (execution time %s)", new Object[]{appliedMigrations.size(), this.validationMode, TimeFormat.format(stopWatch.getTotalTimeMillis())}));
        }
        return null;
    }
}

