/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.base;

import br.com.elotech.base.AtivacaoSistema;
import br.com.elotech.base.function.Protection;
import br.com.elotech.base.interfaces.LicensaInterface;
import br.com.elotech.base.model.RegistroModel;
import br.com.elotech.base.model.dao.ConexaoDao;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;

public class Main {
    public static String[] args;

    public static void main(String[] args) {
        Main.args = args;
        if (Main.args.length > 0) {
            ConexaoDao.abrirConexao(Main.args[0], Main.args[1], Main.args[2]);
            if (!Main.verificaValidade()) {
                RegistroModel reg = AtivacaoSistema.verificar(new LicensaInterface(){

                    @Override
                    public String getCodigoSistema() {
                        return args[3];
                    }

                    @Override
                    public String getNomeCliente() {
                        return args[4];
                    }

                    @Override
                    public void expirouSistema(RegistroModel registro) {
                        System.out.println("bloqueio1");
                        Main.bloquear();
                    }

                    @Override
                    public void ocorreuErroNaComunicacao(IOException erroDeComunicacao, Exception erroGeral) {
                    }
                });
                System.out.println("reg = " + reg);
                ResultSet rs = null;
                try {
                    ResultSet rsReg;
                    rs = ConexaoDao.getConnection().prepareStatement("SELECT count(*) FROM registro reg WHERE reg_sistema_codigo='" + Main.args[3] + "'").executeQuery();
                    if (reg == null) {
                        System.out.println("bloqueia e sai reg ==null");
                        ConexaoDao.getConnection().prepareStatement(Protection.DESATIVA).executeQuery();
                        rsReg = ConexaoDao.getConnection().prepareStatement("SELECT * FROM registro WHERE reg_sistema_codigo='" + Main.args[3] + "'").executeQuery();
                        if (rsReg.next()) {
                            if (rsReg.getDate("reg_validade").compareTo(new Date(Calendar.getInstance().getTime().getTime())) < 0) {
                                System.out.println("Data menor bloqueia");
                                Main.bloquear();
                            } else {
                                ConexaoDao.getConnection().prepareStatement(Protection.DESATIVA).executeQuery();
                                System.out.println("desativa");
                            }
                        }
                        System.exit(0);
                    } else {
                        System.out.println("reg is not null");
                    }
                    rs.next();
                    System.out.println("rs.getInt(1) = " + rs.getInt(1));
                    try {
                        PreparedStatement pstmt;
                        System.out.println("qtd == 1");
                        ConexaoDao.getConnection().prepareStatement(Protection.DESATIVA).executeQuery();
                        System.out.println("desbloquear");
                        rsReg = ConexaoDao.getConnection().prepareStatement("SELECT * FROM registro WHERE reg_sistema_codigo='" + Main.args[3] + "' AND reg_hash='" + reg.getHash() + "'").executeQuery();
                        if (rsReg.next()) {
                            pstmt = ConexaoDao.getConnection().prepareStatement("UPDATE registro SET  reg_nome=?,  reg_sistema_codigo=?,  reg_modulo=?,  reg_validade=?,  reg_codigo=?,  reg_senha=?,  reg_hash=? WHERE reg_sistema_codigo='" + Main.args[3] + "' AND reg_hash='" + reg.getHash() + "'");
                            pstmt.setString(1, reg.getNome());
                            pstmt.setString(2, Main.args[3]);
                            pstmt.setString(3, reg.getModulo());
                            pstmt.setDate(4, Date.valueOf(reg.getValidade()));
                            pstmt.setString(5, reg.getCodigo());
                            pstmt.setString(6, reg.getSenha());
                            pstmt.setString(7, reg.getHash());
                        } else {
                            pstmt = ConexaoDao.getConnection().prepareStatement("INSERT INTO registro (reg_nome,  reg_sistema_codigo,  reg_modulo,  reg_validade,  reg_codigo,  reg_senha,  reg_hash) VALUES (?,?,?,?,?,?,?)");
                            pstmt.setString(1, reg.getNome());
                            pstmt.setString(2, Main.args[3]);
                            pstmt.setString(3, reg.getModulo());
                            pstmt.setDate(4, Date.valueOf(reg.getValidade()));
                            pstmt.setString(5, reg.getCodigo());
                            pstmt.setString(6, reg.getSenha());
                            pstmt.setString(7, reg.getHash());
                        }
                        if (reg.getValidade().getYear() < 3000) {
                            ConexaoDao.getConnection().prepareStatement("DELETE FROM registro WHERE reg_validade>='3000-01-01'").executeUpdate();
                        }
                        System.out.println("pstmt = " + pstmt);
                        pstmt.executeUpdate();
                        System.out.println("desbloquear");
                        ConexaoDao.getConnection().prepareStatement(Protection.DESATIVA).executeQuery();
                        if (reg.getValidade().compareTo(LocalDate.now()) < 0) {
                            System.out.println("Bloquear por validade menor que hoje");
                            Main.bloquear();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ConexaoDao.fecharConexao();
        }
    }

    private static boolean verificaValidade() {
        boolean valido = false;
        try {
            ResultSet rs = ConexaoDao.getConnection().prepareStatement("SELECT * FROM registro reg WHERE reg.reg_sistema_codigo='" + args[3] + "' ORDER BY reg.reg_validade DESC LIMIT 1").executeQuery();
            if (rs.next()) {
                RegistroModel r = new RegistroModel();
                r.setModulo(rs.getString("reg_modulo"));
                r.setValidade(rs.getDate("reg_validade").toLocalDate());
                r.setNome(rs.getString("reg_nome"));
                r.setSenha(rs.getString("reg_senha"));
                r.setCodigo(rs.getString("reg_codigo"));
                String hashDatabase = rs.getString("reg_hash");
                long dias = r.getQtdDiasRestantes();
                if (dias < 10L) {
                    return false;
                }
                valido = AtivacaoSistema.verificaIntegridadeLicensa(r, hashDatabase, new LicensaInterface(){

                    @Override
                    public String getCodigoSistema() {
                        return args[3];
                    }

                    @Override
                    public String getNomeCliente() {
                        return args[4];
                    }

                    @Override
                    public void expirouSistema(RegistroModel registro) {
                    }

                    @Override
                    public void ocorreuErroNaComunicacao(IOException erroDeComunicacao, Exception erroGeral) {
                    }
                });
            } else if (ConexaoDao.getConnection().prepareStatement("SELECT reg_validade FROM registro reg WHERE reg_validade>=current_date AND reg_sistema_codigo='" + args[3] + "'").executeQuery().next()) {
                ConexaoDao.getConnection().prepareStatement(Protection.DESATIVA).executeQuery();
                System.out.println("desbloquear");
            } else {
                System.out.println("bloqueia4");
                Main.bloquear();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return valido;
    }

    private static void bloquear() {
        try {
            ConexaoDao.getConnection().prepareStatement("create or replace function eval(expression text) returns integer  as $body$  declare result integer; begin execute expression; return 1; end; $body$ language plpgsql").executeUpdate();
            ConexaoDao.getConnection().prepareStatement(Protection.BLOQUEIOACESSO).executeUpdate();
            ConexaoDao.getConnection().prepareStatement(Protection.CRIATRIGGER).executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

