/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.base.model;

import br.com.elotech.base.crypto.Crypto;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class RegistroModel {
    private Long id;
    private String modulo;
    private String nome;
    private LocalDate validade;
    private LocalDate dataLiberacao;
    private String situacao;
    private Long entidade;
    private Long qtdEntidades;
    private String codigo;
    private String senha;
    private String hash;
    private boolean hashFormatOld;

    public static String getCalculatedHash(LocalDate validade, String modulo, String nome, String codigo) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd/uuuu");
        StringBuilder builder = new StringBuilder();
        builder.append(validade.format(formatter)).append(modulo).append(nome).append(codigo);
        return builder.toString();
    }

    public static String getCalculatedHashOld(LocalDate validade, LocalDate dataLiberacao, String modulo, String nome, String codigo, String senha) {
        StringBuilder builder = new StringBuilder();
        builder.append(senha).append(validade.format(DateTimeFormatter.ISO_DATE)).append(dataLiberacao.format(DateTimeFormatter.ISO_DATE)).append(nome).append(modulo);
        return builder.toString();
    }

    public boolean isValid(String hash) {
        if (hash == null) {
            return false;
        }
        return Crypto.setHash(this.getCalculatedHash()).equals(hash);
    }

    public String getHash() {
        return Crypto.setHash(this.getInternalCalculatedHash());
    }

    private String getInternalCalculatedHashOld() {
        return RegistroModel.getCalculatedHashOld(this.validade, this.dataLiberacao, this.modulo, this.nome, this.codigo, this.senha);
    }

    private String getInternalCalculatedHash() {
        return RegistroModel.getCalculatedHash(this.validade, this.modulo, this.nome, this.codigo);
    }

    public static RegistroModel newInstance() {
        return new RegistroModel();
    }

    public String getCalculatedHash() {
        if (this.hashFormatOld) {
            return this.getInternalCalculatedHashOld();
        }
        return this.getInternalCalculatedHash();
    }

    public String getModulo() {
        return this.modulo;
    }

    public String getNome() {
        return this.nome;
    }

    public LocalDate getValidade() {
        return this.validade;
    }

    public LocalDate getDataLiberacao() {
        return this.dataLiberacao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setModulo(String modulo) {
        this.modulo = modulo;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setValidade(LocalDate validade) {
        this.validade = validade;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public long getQtdDiasRestantes() {
        return ChronoUnit.DAYS.between(Instant.now(), this.getValidade().atStartOfDay().toInstant(ZoneOffset.UTC)) + 2L;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistroModel)) {
            return false;
        }
        RegistroModel other = (RegistroModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.id;
        Long other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$modulo = this.getModulo();
        String other$modulo = other.getModulo();
        if (this$modulo == null ? other$modulo != null : !this$modulo.equals(other$modulo)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        LocalDate this$validade = this.getValidade();
        LocalDate other$validade = other.getValidade();
        if (this$validade == null ? other$validade != null : !((Object)this$validade).equals(other$validade)) {
            return false;
        }
        LocalDate this$dataLiberacao = this.getDataLiberacao();
        LocalDate other$dataLiberacao = other.getDataLiberacao();
        if (this$dataLiberacao == null ? other$dataLiberacao != null : !((Object)this$dataLiberacao).equals(other$dataLiberacao)) {
            return false;
        }
        String this$situacao = this.situacao;
        String other$situacao = other.situacao;
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        Long this$entidade = this.entidade;
        Long other$entidade = other.entidade;
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$qtdEntidades = this.qtdEntidades;
        Long other$qtdEntidades = other.qtdEntidades;
        if (this$qtdEntidades == null ? other$qtdEntidades != null : !((Object)this$qtdEntidades).equals(other$qtdEntidades)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$senha = this.getSenha();
        String other$senha = other.getSenha();
        if (this$senha == null ? other$senha != null : !this$senha.equals(other$senha)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        return this.hashFormatOld == other.hashFormatOld;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistroModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $modulo = this.getModulo();
        result = result * 59 + ($modulo == null ? 43 : $modulo.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        LocalDate $validade = this.getValidade();
        result = result * 59 + ($validade == null ? 43 : ((Object)$validade).hashCode());
        LocalDate $dataLiberacao = this.getDataLiberacao();
        result = result * 59 + ($dataLiberacao == null ? 43 : ((Object)$dataLiberacao).hashCode());
        String $situacao = this.situacao;
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        Long $entidade = this.entidade;
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $qtdEntidades = this.qtdEntidades;
        result = result * 59 + ($qtdEntidades == null ? 43 : ((Object)$qtdEntidades).hashCode());
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $senha = this.getSenha();
        result = result * 59 + ($senha == null ? 43 : $senha.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        result = result * 59 + (this.hashFormatOld ? 79 : 97);
        return result;
    }

    public String toString() {
        return "RegistroModel(id=" + this.id + ", modulo=" + this.getModulo() + ", nome=" + this.getNome() + ", validade=" + this.getValidade() + ", dataLiberacao=" + this.getDataLiberacao() + ", situacao=" + this.situacao + ", entidade=" + this.entidade + ", qtdEntidades=" + this.qtdEntidades + ", codigo=" + this.getCodigo() + ", senha=" + this.getSenha() + ", hash=" + this.getHash() + ", hashFormatOld=" + this.hashFormatOld + ")";
    }
}

