/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.base.util;

import java.io.ByteArrayOutputStream;

public class EloPaddingUtils {
    private ByteArrayOutputStream data;
    private int blockSize;
    private static final int BLOCKSIZE_8 = 8;

    public EloPaddingUtils() {
        this.setBlockSize(8);
    }

    public void addData(byte[] data) {
        this.data.write(data);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
        this.reset();
    }

    public int getPaddedSize() {
        return (this.data.size() / this.blockSize + 1) * this.blockSize;
    }

    public int getUnpaddedSize() {
        byte[] data = this.data.toByteArray();
        return data.length - data[data.length - 1];
    }

    public byte[] getPaddedData() {
        byte[] bfr = this.data.toByteArray();
        byte padSize = (byte)(this.getPaddedSize() - bfr.length);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(bfr);
        bfr = new byte[padSize];
        for (int i = 0; i < padSize - 1; ++i) {
            bfr[i] = 0;
        }
        bfr[bfr.length - 1] = padSize;
        data.write(bfr);
        return data.toByteArray();
    }

    public byte[] getUnpaddedData() {
        byte[] bfr = this.data.toByteArray();
        byte padSize = bfr[bfr.length - 1];
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(bfr, 0, bfr.length - padSize);
        return data.toByteArray();
    }

    public void reset() {
        this.data = new ByteArrayOutputStream();
    }
}

