/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.monoid.web.AbstractResource;
import us.monoid.web.Resty;

public class TextResource
extends AbstractResource {
    static final Pattern charsetPattern = Pattern.compile("charset=([^ ;]+);?");
    protected String text;

    public TextResource(Resty.Option ... options) {
        super(options);
    }

    public String toString() {
        if (this.text == null && this.inputStream != null) {
            this.text = this.readTextFromStream(this.inputStream);
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.text;
    }

    protected String readTextFromStream(InputStream aTextStream) {
        Charset charset = this.getCharSet();
        int size = this.urlConnection.getContentLength();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size != -1 ? size : 1024);
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = aTextStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String streamedText = "";
        try {
            streamedText = bos.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return streamedText;
    }

    protected Charset getCharSet() {
        Matcher m;
        String contentType = this.urlConnection.getContentType();
        Charset charset = Charset.forName("iso-8859-1");
        if (contentType != null && (m = charsetPattern.matcher(contentType)).find()) {
            String charsetString = m.group(1);
            try {
                charset = Charset.forName(charsetString);
            }
            catch (IllegalCharsetNameException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return charset;
    }

    @Override
    String getAcceptedTypes() {
        return "text/html,text/plain,text/*";
    }
}

