/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.base;

import br.com.elotech.base.interfaces.LicensaInterface;
import br.com.elotech.base.model.RegistroModel;
import br.com.elotech.base.model.dao.ConexaoDao;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import us.monoid.web.JSONResource;
import us.monoid.web.Resty;

public class AtivacaoSistema {
    static final String HOST = "ativador.elotech.com.br";
    static final String PATH = "/ativacao/";

    public static synchronized RegistroModel verificar(LicensaInterface licensa) {
        System.out.println("verificar");
        RegistroModel registro = new RegistroModel();
        try {
            JSONResource json;
            URI myUri = new URI("http", HOST, PATH + licensa.getCodigoSistema() + "/" + licensa.getNomeCliente(), null);
            System.out.println(PATH + licensa.getCodigoSistema() + "/" + licensa.getNomeCliente());
            Map<String, String> env = System.getenv();
            String PWD = env.get("PWD");
            Object con = null;
            boolean pro = false;
            Object proxy = null;
            if (PWD != null && PWD.toLowerCase().contains("elovirtual")) {
                Resty.Proxy.proxy("192.168.1.250", 3128);
            }
            ResultSet rs = ConexaoDao.getConnection().prepareStatement("show LC_COLLATE").executeQuery();
            rs.next();
            if (rs.getString(1).contains("UTF-8")) {
                json = new Resty(new Resty.Option[0]).json(myUri.toASCIIString());
                System.out.println("1myUri.toASCIIString() = " + myUri.toASCIIString());
            } else {
                String retValue = new String(licensa.getNomeCliente().getBytes(), Charset.forName("Windows-1252"));
                myUri = new URI("http", HOST, PATH + licensa.getCodigoSistema() + "/" + retValue, null);
                json = new Resty(new Resty.Option[0]).json(myUri.toASCIIString());
            }
            registro.setNome(json.get("cliente").toString());
            registro.setCodigo(json.get("code").toString());
            registro.setModulo(json.get("module").toString());
            registro.setNome(json.get("name").toString());
            registro.setSenha(json.get("password").toString());
            registro.setValidade(LocalDate.parse(json.get("date").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            if (registro.getValidade().isBefore(LocalDate.now())) {
                licensa.expirouSistema(registro);
            }
            return registro;
        }
        catch (IOException e) {
            e.printStackTrace();
            licensa.ocorreuErroNaComunicacao(e, null);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            licensa.ocorreuErroNaComunicacao(null, e);
            return null;
        }
    }

    public static boolean verificaIntegridadeLicensa(RegistroModel registro, String hashDatabase, LicensaInterface licensa) {
        if (!hashDatabase.equals(registro.getHash())) {
            licensa.expirouSistema(registro);
            return false;
        }
        return true;
    }
}

