/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.controller;

import br.com.elotech.model.AtivacaoParams;
import br.com.elotech.model.Registro;
import br.com.elotech.services.AtivadorService;
import br.com.elotech.services.impl.AtivadorServiceImpl;
import br.com.elotech.util.Crypto;
import br.com.elotech.util.Util;
import org.apache.commons.lang3.StringUtils;

public class AtivadorCtrl {
    private AtivadorService service = new AtivadorServiceImpl();
    private Registro tab_registro = null;
    private Registro bluemix_registro = null;

    public void carregaVerificacaoDeSistema(AtivacaoParams params) throws Exception {
        if (StringUtils.isBlank(params.getChave())) {
            this.service.bloquearSistema(params);
            throw new Exception("Chave do sistema n\u00e3o foi configurada! Por favor, solicite apoio t\u00e9cnico.");
        }
        this.service.liberarSistema(params);
        this.tab_registro = this.service.verificaRegistro(params);
        if (this.tab_registro == null) {
            this.bluemix_registro = this.service.verificaBluemix(params);
            if (this.bluemix_registro != null) {
                this.service.gravaRegistroValido(this.bluemix_registro);
            }
        } else if (Crypto.checkHash(this.tab_registro)) {
            if (!this.service.verificaValidadeRegistro(this.tab_registro.getValidade())) {
                this.bluemix_registro = this.service.verificaBluemix(params);
                if (this.bluemix_registro != null) {
                    if (this.bluemix_registro.getValidade().after(Util.adicionaDia(this.tab_registro.getValidade()))) {
                        this.service.atualizaRegistro(this.bluemix_registro);
                        this.carregaVerificacaoDeSistema(params);
                    } else {
                        this.service.bloquearSistema(params);
                    }
                }
            }
        } else {
            this.bluemix_registro = this.service.verificaBluemix(params);
            if (this.bluemix_registro != null) {
                this.service.atualizaRegistro(this.bluemix_registro);
                this.carregaVerificacaoDeSistema(params);
            }
        }
    }
}

