/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.dao.impl;

import br.com.elotech.dao.AtivadorDao;
import br.com.elotech.dao.impl.Bluemix;
import br.com.elotech.model.AtivacaoParams;
import br.com.elotech.model.Registro;
import br.com.elotech.scripts.Script;
import br.com.elotech.util.Crypto;
import br.com.elotech.util.Util;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AtivadorDaoImpl
implements AtivadorDao {
    private ResultSet rs;
    private Map<String, Object> param = new HashMap<String, Object>();

    @Override
    public Registro verificaRegistro(AtivacaoParams params) throws Exception {
        Registro registro = null;
        this.param.put("codigo", params.getCodigo());
        this.rs = Util.resolveResultSet(Script.scriptSelectRegistro(), this.param);
        if (this.rs.next()) {
            registro = new Registro();
            registro.setNome(this.rs.getString("reg_nome"));
            registro.setSistemaCodigo(this.rs.getString("reg_sistema_codigo"));
            registro.setModulo(this.rs.getString("reg_modulo"));
            registro.setValidade(this.rs.getDate("reg_validade"));
            registro.setCodigo(this.rs.getString("reg_codigo"));
            registro.setSenha(this.rs.getString("reg_senha"));
            registro.setHash(this.rs.getString("reg_hash"));
        }
        return registro;
    }

    @Override
    public Registro verificaBluemix(AtivacaoParams params) throws Exception {
        return Bluemix.verificar(params);
    }

    @Override
    public void bloquearSistema(AtivacaoParams params) throws Exception {
        this.rs = Util.resolveResultSet(Script.BLOQUEIO_STEP_3(), this.param);
        while (this.rs.next()) {
            System.out.println("Bloqueado: " + this.rs.getString("qtd_bloqueados"));
        }
        throw new Exception("N\u00e3o \u00e9 possivel salvar, editar ou deletar registros do sistema!\n\n Contate o suporte t\u00e9cnico.");
    }

    @Override
    public void liberarSistema(AtivacaoParams params) throws Exception {
        Util.insertOrUpdate(Script.BLOQUEIO_STEP_1().concat(Script.BLOQUEIO_STEP_2()), this.param);
        this.rs = Util.resolveResultSet(Script.DESBLOQUEIO(), this.param);
        while (this.rs.next()) {
            System.out.println("Desbloqueado: " + this.rs.getString("qtd_desbloqueados"));
        }
    }

    @Override
    public void gravaRegistroValido(Registro registro) throws Exception {
        this.param.put("reg_nome", registro.getNome());
        this.param.put("reg_sistema_codigo", registro.getSistemaCodigo());
        this.param.put("reg_modulo", registro.getModulo());
        this.param.put("reg_validade", Util.dateToSqlDate(registro.getValidade()));
        this.param.put("reg_codigo", registro.getCodigo());
        this.param.put("reg_senha", registro.getSenha());
        this.param.put("reg_hash", registro.getHash());
        Util.insertOrUpdate(Script.scriptInsertRegistro(), this.param);
    }

    @Override
    public boolean verificaValidadeRegistro(Date validade) {
        return Util.adicionaDia(validade).after(Calendar.getInstance().getTime());
    }

    @Override
    public void atualizaRegistro(Registro registro) throws Exception {
        this.param.put("reg_nome", registro.getNome());
        this.param.put("reg_modulo", registro.getModulo());
        this.param.put("reg_validade", Util.dateToSqlDate(registro.getValidade()));
        this.param.put("reg_codigo", registro.getCodigo());
        this.param.put("reg_senha", registro.getSenha());
        this.param.put("reg_hash", Crypto.geraHash(registro));
        this.param.put("reg_sistema_codigo", registro.getSistemaCodigo());
        Util.insertOrUpdate(Script.scriptUpdateRegistro(), this.param);
    }
}

