/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.dao.impl;

import br.com.elotech.model.AtivacaoParams;
import br.com.elotech.model.Registro;
import br.com.elotech.util.Crypto;
import br.com.elotech.util.CustomException;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import us.monoid.web.JSONResource;
import us.monoid.web.Resty;

public abstract class Bluemix {
    private static final String HOST = "license.elotech.com.br";
    private static final String REST = "/rest/licenses/";
    private static final String scheme = "http";
    private static final String internalHostName = "192.168.1.250";
    private static final Integer internalPort = 3128;
    private static Map<String, String> env = System.getenv();
    private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public static synchronized Registro verificar(AtivacaoParams params) throws Exception {
        Registro registro = null;
        try {
            String PATH = REST.concat(params.getCodigo()).concat("/").concat(params.getChave());
            URI uri = new URI(scheme, HOST, PATH, null);
            String PWD = env.get("PWD");
            if (StringUtils.isNotBlank(PWD) && PWD.toLowerCase().contains("elovirtual")) {
                Resty.Proxy.proxy(internalHostName, internalPort);
            }
            JSONResource res = new Resty(new Resty.Option[0]).json(uri.toASCIIString());
            registro = new Registro();
            registro.setCodigo(res.get("cliente").toString());
            registro.setNome(res.get("name").toString());
            registro.setSistemaCodigo(res.get("code").toString().replace(res.get("cliente").toString(), ""));
            registro.setModulo(res.get("module").toString());
            registro.setSenha(res.get("password").toString());
            registro.setValidade(formatter.parse(res.get("date").toString()));
            String hash = Crypto.geraHash(registro);
            registro.setHash(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            new CustomException(e, params);
        }
        return registro;
    }
}

