/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JSONDecoder {
    private int c = -1;
    private LinkedList<Object> collections = new LinkedList();
    private static final String TRUE_KEYWORD = "true";
    private static final String FALSE_KEYWORD = "false";
    private static final String NULL_KEYWORD = "null";
    private static final int EOF = -1;

    public <T> T readValue(InputStream inputStream) throws IOException {
        return this.readValue(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
    }

    public <T> T readValue(Reader reader) throws IOException {
        this.c = reader.read();
        Object value = null;
        this.skipWhitespace(reader);
        while (this.c != -1) {
            String key = null;
            if (this.c == 93) {
                value = this.collections.pop();
                if (!(value instanceof List)) {
                    throw new IOException("Unexpected closing bracket.");
                }
                this.c = reader.read();
            } else if (this.c == 125) {
                value = this.collections.pop();
                if (!(value instanceof Map)) {
                    throw new IOException("Unexpected closing brace.");
                }
                this.c = reader.read();
            } else if (this.c == 44) {
                this.c = reader.read();
            } else {
                Object collection = this.collections.peek();
                if (collection instanceof Map) {
                    key = this.readString(reader);
                    this.skipWhitespace(reader);
                    if (this.c != 58) {
                        throw new IOException("Missing key/value delimiter.");
                    }
                    this.c = reader.read();
                    this.skipWhitespace(reader);
                }
                if (this.c == 34) {
                    value = this.readString(reader);
                } else if (this.c == 43 || this.c == 45 || Character.isDigit(this.c)) {
                    value = this.readNumber(reader);
                } else if (this.c == 116) {
                    if (!this.readKeyword(reader, TRUE_KEYWORD)) {
                        throw new IOException();
                    }
                    value = Boolean.TRUE;
                } else if (this.c == 102) {
                    if (!this.readKeyword(reader, FALSE_KEYWORD)) {
                        throw new IOException();
                    }
                    value = Boolean.FALSE;
                } else if (this.c == 110) {
                    if (!this.readKeyword(reader, NULL_KEYWORD)) {
                        throw new IOException();
                    }
                    value = null;
                } else if (this.c == 91) {
                    value = new ArrayList();
                    this.collections.push(value);
                    this.c = reader.read();
                } else if (this.c == 123) {
                    value = new HashMap();
                    this.collections.push(value);
                    this.c = reader.read();
                } else {
                    throw new IOException("Unexpected character in input stream.");
                }
                if (collection != null) {
                    if (key != null) {
                        ((Map)collection).put(key, value);
                    } else {
                        ((List)collection).add(value);
                    }
                    if (!(value instanceof List) && !(value instanceof Map)) {
                        this.skipWhitespace(reader);
                        if (this.c != 93 && this.c != 125 && this.c != 44) {
                            throw new IOException("Undelimited or unterminated collection.");
                        }
                    }
                }
            }
            this.skipWhitespace(reader);
        }
        return (T)value;
    }

    private void skipWhitespace(Reader reader) throws IOException {
        while (this.c != -1 && Character.isWhitespace(this.c)) {
            this.c = reader.read();
        }
    }

    private String readString(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.c = reader.read();
        while (this.c != -1 && this.c != 34) {
            if (Character.isISOControl(this.c)) {
                throw new IOException("Illegal character in input stream.");
            }
            if (this.c == 92) {
                this.c = reader.read();
                if (this.c == 98) {
                    this.c = 8;
                } else if (this.c == 102) {
                    this.c = 12;
                } else if (this.c == 114) {
                    this.c = 13;
                } else if (this.c == 110) {
                    this.c = 10;
                } else if (this.c == 116) {
                    this.c = 9;
                } else if (this.c == 117) {
                    StringBuilder unicodeValueBuilder = new StringBuilder();
                    while (this.c != -1 && unicodeValueBuilder.length() < 4) {
                        this.c = reader.read();
                        unicodeValueBuilder.append((char)this.c);
                    }
                    if (this.c == -1) {
                        throw new IOException("Invalid Unicode escape sequence.");
                    }
                    String unicodeValue = unicodeValueBuilder.toString();
                    this.c = (char)Integer.parseInt(unicodeValue, 16);
                } else if (this.c != 34 && this.c != 92 && this.c != 47) {
                    throw new IOException("Unsupported escape sequence in input stream.");
                }
            }
            stringBuilder.append((char)this.c);
            this.c = reader.read();
        }
        if (this.c != 34) {
            throw new IOException("Unterminated string in input stream.");
        }
        this.c = reader.read();
        return stringBuilder.toString();
    }

    private Number readNumber(Reader reader) throws IOException {
        boolean decimal = false;
        StringBuilder numberBuilder = new StringBuilder();
        while (this.c != -1 && (Character.isDigit(this.c) || this.c == 46 || this.c == 101 || this.c == 69 || this.c == 45)) {
            numberBuilder.append((char)this.c);
            decimal |= this.c == 46;
            this.c = reader.read();
        }
        Number value = decimal ? (Number)Double.valueOf(numberBuilder.toString()) : (Number)Long.valueOf(numberBuilder.toString());
        return new NumberAdapter(value);
    }

    private boolean readKeyword(Reader reader, String keyword) throws IOException {
        int i;
        int n = keyword.length();
        for (i = 0; this.c != -1 && i < n && keyword.charAt(i) == this.c; ++i) {
            this.c = reader.read();
        }
        return i == n;
    }

    private static class NumberAdapter
    extends Number {
        private static final long serialVersionUID = 0L;
        private Number number;

        public NumberAdapter(Number number) {
            this.number = number;
        }

        @Override
        public int intValue() {
            return this.number.intValue();
        }

        @Override
        public long longValue() {
            return this.number.longValue();
        }

        @Override
        public float floatValue() {
            return this.number.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.number.doubleValue();
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.doubleValue());
            return (int)(bits ^ bits >>> 32);
        }

        public boolean equals(Object object) {
            return object instanceof Number && this.equals((Number)object);
        }

        private boolean equals(Number number) {
            long l2;
            long l1 = Double.doubleToLongBits(this.doubleValue());
            return l1 == (l2 = Double.doubleToLongBits(number.doubleValue()));
        }

        public String toString() {
            return this.number.toString();
        }
    }
}

