/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;

public class JSONEncoder {
    private int depth = 0;

    public void writeValue(Object value, OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        this.writeValue(value, writer);
        ((Writer)writer).flush();
    }

    public void writeValue(Object value, Writer writer) throws IOException {
        if (value instanceof CharSequence) {
            CharSequence text = (CharSequence)value;
            writer.append("\"");
            int n = text.length();
            for (int i = 0; i < n; ++i) {
                char c = text.charAt(i);
                if (c == '\"' || c == '\\') {
                    writer.append("\\" + c);
                    continue;
                }
                if (c == '\b') {
                    writer.append("\\b");
                    continue;
                }
                if (c == '\f') {
                    writer.append("\\f");
                    continue;
                }
                if (c == '\n') {
                    writer.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    writer.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    writer.append("\\t");
                    continue;
                }
                writer.append(c);
            }
            writer.append("\"");
        } else if (value instanceof Number || value instanceof Boolean) {
            writer.append(String.valueOf(value));
        } else if (value instanceof Date) {
            this.writeValue((Object)((Date)value).getTime(), writer);
        } else if (value instanceof LocalDate) {
            this.writeValue((Object)((LocalDate)value).toString(), writer);
        } else if (value instanceof LocalTime) {
            this.writeValue((Object)((LocalTime)value).toString(), writer);
        } else if (value instanceof LocalDateTime) {
            this.writeValue((Object)((LocalDateTime)value).toString(), writer);
        } else if (value instanceof Iterable) {
            writer.append("[");
            ++this.depth;
            int i = 0;
            for (Object element : (Iterable)value) {
                if (i > 0) {
                    writer.append(",");
                }
                writer.append("\n");
                this.indent(writer);
                this.writeValue(element, writer);
                ++i;
            }
            --this.depth;
            writer.append("\n");
            this.indent(writer);
            writer.append("]");
        } else if (value instanceof Map) {
            writer.append("{");
            ++this.depth;
            int i = 0;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (i > 0) {
                    writer.append(",");
                }
                writer.append("\n");
                Object key = entry.getKey();
                if (key == null) continue;
                this.indent(writer);
                this.writeValue((Object)key.toString(), writer);
                writer.append(": ");
                this.writeValue(entry.getValue(), writer);
                ++i;
            }
            --this.depth;
            writer.append("\n");
            this.indent(writer);
            writer.append("}");
        } else {
            writer.append(null);
        }
    }

    private void indent(Writer writer) throws IOException {
        for (int i = 0; i < this.depth; ++i) {
            writer.append("  ");
        }
    }
}

