/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.beans;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.httprpc.beans.Key;

public class BeanAdapter
extends AbstractMap<String, Object> {
    private Object bean;
    private HashMap<Class<?>, HashMap<String, Method>> accessorCache;
    private HashMap<String, Method> accessors;
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    public BeanAdapter(Object bean) {
        this(bean, new HashMap());
    }

    private BeanAdapter(Object bean, HashMap<Class<?>, HashMap<String, Method>> accessorCache) {
        if (bean == null) {
            throw new IllegalArgumentException();
        }
        this.bean = bean;
        this.accessorCache = accessorCache;
        Class<?> type = bean.getClass();
        if (this.accessors == null) {
            this.accessors = new HashMap();
            Method[] methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String key;
                Method method = methods[i];
                if (method.getDeclaringClass() == Object.class || (key = BeanAdapter.getKey(method)) == null) continue;
                this.accessors.put(key, method);
            }
            accessorCache.put(type, this.accessors);
        }
    }

    private static String getKey(Method method) {
        if (method.getParameterCount() > 0) {
            return null;
        }
        Key key = method.getAnnotation(Key.class);
        if (key == null) {
            String prefix;
            String methodName = method.getName();
            if (methodName.startsWith(GET_PREFIX)) {
                prefix = GET_PREFIX;
            } else if (methodName.startsWith(IS_PREFIX)) {
                prefix = IS_PREFIX;
            } else {
                return null;
            }
            int j = prefix.length();
            int n = methodName.length();
            if (j == n) {
                return null;
            }
            char c = methodName.charAt(j++);
            if (j == n || Character.isLowerCase(methodName.charAt(j))) {
                c = Character.toLowerCase(c);
            }
            return c + methodName.substring(j);
        }
        return key.value();
    }

    @Override
    public Object get(Object key) {
        Object value;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Method method = this.accessors.get(key);
        if (method != null) {
            try {
                value = BeanAdapter.adapt(method.invoke(this.bean, new Object[0]), this.accessorCache);
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public int size() {
                return BeanAdapter.this.accessors.size();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    private Iterator<String> keys;
                    {
                        this.keys = BeanAdapter.this.accessors.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        String key = this.keys.next();
                        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, BeanAdapter.this.get(key));
                    }
                };
            }
        };
    }

    public static List<?> adapt(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        return new ListAdapter(list, new HashMap());
    }

    public static Map<?, ?> adapt(Map<?, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        return new MapAdapter(map, new HashMap());
    }

    private static Object adapt(Object value, HashMap<Class<?>, HashMap<String, Method>> accessorCache) {
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Date || value instanceof LocalDate || value instanceof LocalTime || value instanceof LocalDateTime) {
            return value;
        }
        if (value instanceof List) {
            return new ListAdapter((List)value, accessorCache);
        }
        if (value instanceof Map) {
            return new MapAdapter((Map)value, accessorCache);
        }
        return new BeanAdapter(value, accessorCache);
    }

    public static <T> T adapt(Object value, Type type) {
        if (type instanceof Class) {
            return (T)BeanAdapter.adapt(value, (Class)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return BeanAdapter.adapt(value, wildcardType.getUpperBounds()[0]);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType == List.class) {
                return (T)BeanAdapter.adaptList((List)value, parameterizedType.getActualTypeArguments()[0]);
            }
            if (rawType == Map.class) {
                return (T)BeanAdapter.adaptMap((Map)value, parameterizedType.getActualTypeArguments()[1]);
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static Object adapt(final Object value, Class<?> type) {
        if (type.isInstance(value)) {
            return value;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return value == null ? (byte)0 : ((Number)value).byteValue();
        }
        if (type == Short.TYPE || type == Short.class) {
            return value == null ? (short)0 : ((Number)value).shortValue();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return value == null ? 0 : ((Number)value).intValue();
        }
        if (type == Long.TYPE || type == Long.class) {
            return value == null ? 0L : ((Number)value).longValue();
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(value == null ? 0.0f : ((Number)value).floatValue());
        }
        if (type == Double.TYPE || type == Double.class) {
            return value == null ? 0.0 : ((Number)value).doubleValue();
        }
        if (type == Boolean.TYPE) {
            return value == null ? false : (Boolean)value;
        }
        if (type == Date.class) {
            return value == null ? null : new Date(((Number)value).longValue());
        }
        if (type == LocalDate.class) {
            return value == null ? null : LocalDate.parse(value.toString());
        }
        if (type == LocalTime.class) {
            return value == null ? null : LocalTime.parse(value.toString());
        }
        if (type == LocalDateTime.class) {
            return value == null ? null : LocalDateTime.parse(value.toString());
        }
        if (type.isInterface()) {
            return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                    String key = BeanAdapter.getKey(method);
                    if (key == null) {
                        throw new UnsupportedOperationException();
                    }
                    return BeanAdapter.adapt(((Map)value).get(key), method.getGenericReturnType());
                }
            }));
        }
        throw new IllegalArgumentException();
    }

    public static <E> List<E> adaptList(final List<?> list, final Type elementType) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (elementType == null) {
            throw new IllegalArgumentException();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return BeanAdapter.adapt(list.get(index), elementType);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    private Iterator<?> iterator;
                    {
                        this.iterator = list.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return BeanAdapter.adapt(this.iterator.next(), elementType);
                    }
                };
            }
        };
    }

    public static <K, V> Map<K, V> adaptMap(final Map<K, ?> map, final Type valueType) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        if (valueType == null) {
            throw new IllegalArgumentException();
        }
        return new AbstractMap<K, V>(){

            @Override
            public V get(Object key) {
                return BeanAdapter.adapt(map.get(key), valueType);
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public int size() {
                        return map.size();
                    }

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){
                            private Iterator<? extends Map.Entry<K, ?>> iterator;
                            {
                                this.iterator = map.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.iterator.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                return new Map.Entry<K, V>(){
                                    private Map.Entry<K, ?> entry;
                                    {
                                        this.entry = (Map.Entry)iterator.next();
                                    }

                                    @Override
                                    public K getKey() {
                                        return this.entry.getKey();
                                    }

                                    @Override
                                    public V getValue() {
                                        return BeanAdapter.adapt(this.entry.getValue(), valueType);
                                    }

                                    @Override
                                    public V setValue(V value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    private static class MapAdapter
    extends AbstractMap<Object, Object> {
        private Map<?, ?> map;
        private HashMap<Class<?>, HashMap<String, Method>> accessorCache;

        public MapAdapter(Map<?, ?> map, HashMap<Class<?>, HashMap<String, Method>> accessorCache) {
            this.map = map;
            this.accessorCache = accessorCache;
        }

        @Override
        public Object get(Object key) {
            return BeanAdapter.adapt(this.map.get(key), this.accessorCache);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new AbstractSet<Map.Entry<Object, Object>>(){

                @Override
                public int size() {
                    return map.size();
                }

                @Override
                public Iterator<Map.Entry<Object, Object>> iterator() {
                    return new Iterator<Map.Entry<Object, Object>>(){
                        private Iterator<? extends Map.Entry<?, ?>> iterator;
                        {
                            this.iterator = map.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<Object, Object> next() {
                            return new Map.Entry<Object, Object>(){
                                private Map.Entry<?, ?> entry;
                                {
                                    this.entry = (Map.Entry)iterator.next();
                                }

                                @Override
                                public Object getKey() {
                                    return this.entry.getKey();
                                }

                                @Override
                                public Object getValue() {
                                    return BeanAdapter.adapt(this.entry.getValue(), accessorCache);
                                }

                                @Override
                                public Object setValue(Object value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                }
            };
        }
    }

    private static class ListAdapter
    extends AbstractList<Object> {
        private List<?> list;
        private HashMap<Class<?>, HashMap<String, Method>> accessorCache;

        public ListAdapter(List<?> list, HashMap<Class<?>, HashMap<String, Method>> accessorCache) {
            this.list = list;
            this.accessorCache = accessorCache;
        }

        @Override
        public Object get(int index) {
            return BeanAdapter.adapt(this.list.get(index), this.accessorCache);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private Iterator<?> iterator;
                {
                    this.iterator = list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Object next() {
                    return BeanAdapter.adapt(this.iterator.next(), accessorCache);
                }
            };
        }
    }
}

