/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.sql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Parameters
extends AbstractMap<String, Object> {
    private String sql;
    private LinkedList<String> keys;
    private HashMap<String, Object> values = new HashMap();
    private static final int EOF = -1;

    private Parameters(String sql, LinkedList<String> keys) {
        this.sql = sql;
        this.keys = keys;
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    public Object get(Object key) {
        return this.values.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.values.put(key, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    public void apply(PreparedStatement statement) throws SQLException {
        int i = 1;
        for (String key : this.keys) {
            statement.setObject(i++, this.values.get(key));
        }
    }

    public static Parameters parse(String sql) {
        Parameters parameters;
        if (sql == null) {
            throw new IllegalArgumentException();
        }
        try (StringReader sqlReader = new StringReader(sql);){
            parameters = Parameters.parse(sqlReader);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return parameters;
    }

    public static Parameters parse(Reader sqlReader) throws IOException {
        if (sqlReader == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<String> keys = new LinkedList<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        int c = sqlReader.read();
        while (c != -1) {
            if (c == 58) {
                c = sqlReader.read();
                StringBuilder keyBuilder = new StringBuilder();
                while (c != -1 && Character.isJavaIdentifierPart(c)) {
                    keyBuilder.append((char)c);
                    c = sqlReader.read();
                }
                keys.add(keyBuilder.toString());
                sqlBuilder.append("?");
                continue;
            }
            sqlBuilder.append((char)c);
            c = sqlReader.read();
        }
        return new Parameters(sqlBuilder.toString(), keys);
    }
}

