<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 07/01/2019
 * Time: 09:05
 */

session_start();
include_once "../../library/php/db.inc.php";

class Flyway {
//	private $CMD_LINUX = "cd ".__DIR__."/ && ./flyway.sh migrate";
	private $CMD_LINUX = "./flyway.sh migrate";
	private $CMD_WIN = "flyway.cmd migrate";
	private $retorno = [
		"status" => false,
		"message" => "Erro ao executar o comando"
	];

	public function execute(){
		$dir = __DIR__."/logs";
		$file = $dir . "/log-".date('Ymd').".log";
		$header = "========= Erro Flyway (". date("d/m/Y H:i:s") .") ========= \n\n ";
		if(!is_dir($dir)){
			mkdir($dir, 0777, true);
		}

		if(file_exists($file)){
			unlink($file);
		}

		$command = strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' ? $this->CMD_WIN : $this->CMD_LINUX;
		$descriptorspec = array(
			0 => array("pipe", "r"),
			1 => array("pipe", "w"),
			2 => array("pipe", "w")
		);

		$process = proc_open($command, $descriptorspec, $pipes);
		if (is_resource($process)) {
			fwrite($pipes[0], '<?php print_r($_ENV); ?>');
			fclose($pipes[0]);

			$stdout = stream_get_contents($pipes[1]);
			$stderr = stream_get_contents($pipes[2]);

			if(strpos($stdout, "No migration necessary") === false){
				$this->retorno['status'] = false;
				$this->retorno['message'] = "Erro na atualização do banco de dados.";
				$this->retorno['error'] = $stderr;
				$fh_pipe = fopen($file, "a");
				fwrite($fh_pipe, $header . $stderr);
				fclose($fh_pipe);
			}else{
				$this->retorno['status'] = true;
				$this->retorno['message'] = $stdout;
				$query = pg_query("SELECT version, to_char(installed_on, 'DD/MM/YYYY HH24:mm') as dt_install FROM schema_version ORDER BY version DESC LIMIT 1");
				$result = pg_fetch_array($query);
				$this->retorno['version'] = "Flyway(v. $result[version] | $result[dt_install])";
			}


			fclose($pipes[1]);
			fclose($pipes[2]);

			$this->retorno['processo'] = proc_close($process);
		}


		return $this->retorno;
	}
}

echo json_encode((new Flyway())->execute());