UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.133.132' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.60.58' WHERE conf_chave='VERSAO_SOCIAL';

UPDATE config SET conf_valor_data = CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.111.110' WHERE conf_chave='VERSAO_COMUM';

--criando sequência para nova tabela de motivo
CREATE SEQUENCE seq_asam_codigo
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;
ALTER TABLE seq_asam_codigo
  OWNER TO postgres;
GRANT ALL ON SEQUENCE seq_asam_codigo TO postgres;
GRANT SELECT, UPDATE ON SEQUENCE seq_asam_codigo TO public;

--criando tabela motivo atendimento
CREATE TABLE as_atendimento_motivo(
 asam_codigo bigint NOT NULL DEFAULT nextval(('seq_asam_codigo'::text)::regclass) PRIMARY KEY,
 asam_nome character varying
);

--adicionando coluna no basicocras para o motivo do atendimento
ALTER TABLE as_atendimento_basicocras ADD COLUMN asam_codigo BIGINT;

--criando relacionamento motivo atendimento
ALTER TABLE as_atendimento_basicocras
  ADD CONSTRAINT fk_asam_codigo FOREIGN KEY (asam_codigo)
      REFERENCES as_atendimento_motivo (asam_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;

--relacionando tipos de atendimento compátiveis com motivos de atendimentos
CREATE TABLE as_atendimento_tipo_motivo (
 asam_codigo bigint not null,
 asat_codigo bigint not null,
 primary key(asam_codigo,asat_codigo)
);

--criando relacionamento com motivo
ALTER TABLE as_atendimento_tipo_motivo
  ADD CONSTRAINT fk_asatmm_codigo FOREIGN KEY (asam_codigo)
      REFERENCES as_atendimento_motivo (asam_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;

--criando relacionamento com tipo
ALTER TABLE as_atendimento_tipo_motivo
  ADD CONSTRAINT fk_asatmt_codigo FOREIGN KEY (asat_codigo)
      REFERENCES as_atendimento_tipo (asat_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION;

--cadastrar permissão de acesso
INSERT INTO acesso(ace_descricao, ace_caminho, ace_modulo)
    VALUES ('Motivo Atendimento',  'zf/atendimentocras/atendimento-basico/form-cadastro-motivo-geral-salvar', 13);

--constraint pode dar problema em migração de dados
ALTER TABLE resultadoexame DROP CONSTRAINT resultadoexame_age_codigo_fkey;
    
--Inserindo novas opções de código de encaminhamento para o Social

INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('SINE', 90, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('COPEL', 91, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('SANEPAR', 92, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('NASF', 93, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('Secretaria Municipal de Saude', 94, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('UBS', 95, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('CAPS', 96, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('Passe Livre Intermunicipal (DEDIHC)', 97, CURRENT_DATE);
INSERT INTO as_encaminhamento_codigos(asec_titulo, asec_num, asec_dtcadastro) VALUES ('Passe Livre Interestadual (Ministerio dos Transportes)', 98, CURRENT_DATE);
                                                                                      

--Inserindo novos tipos de atendimento para o Social

INSERT INTO as_atendimento_tipo(asat_codigo_num, asat_nome, asat_situacao, asat_data) VALUES (10, 'Atendimento Psicológico', TRUE, CURRENT_DATE);
INSERT INTO as_atendimento_tipo(asat_codigo_num, asat_nome, asat_situacao, asat_data) VALUES (11, 'Atendimento Psicossocial', TRUE, CURRENT_DATE);


--Alterando tabela de primeiro atendimento do Social

ALTER TABLE asps_primeiro_atendimento ADD COLUMN aspt_paif BOOLEAN;
ALTER TABLE asps_primeiro_atendimento ADD COLUMN aspt_scfv BOOLEAN;


--Inserindo nova configuração no Social
INSERT INTO config(conf_chave, conf_label, conf_readonly, conf_tipo, conf_valor_bool, cac_codigo) VALUES ('MOSTRA_VALOR_BENEFICIO', 'Exibe valor do benefício?', FALSE, 2, TRUE, 6);
INSERT INTO config(conf_chave, conf_label, conf_readonly, conf_tipo, conf_valor_int, cac_codigo) VALUES ('BENEFICIO_RETROATIVO', 'Qtde de dias para Benefício Eventual retroativo?', FALSE, 3, 0, 6);


--coluna de c?digo de barras para ?tens de entrada e sa?da de medicamnetos
ALTER TABLE itens_movimento ADD COLUMN ite_codbarras character varying(255) DEFAULT ' ';



--adiciona coluna de data da inser??o
ALTER TABLE movimento ADD COLUMN mov_data_insercao timestamp;



--cria procedure insere somente no insert a data atual de grava??o do registro
  CREATE OR REPLACE FUNCTION social.movimentodatainsercao()
  RETURNS trigger AS
$BODY$
    
BEGIN

	NEW.mov_data_insercao = NOW();
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

--cria trigger para insercao no movimento
CREATE TRIGGER movimento
  BEFORE INSERT
  ON social.movimento
  FOR EACH ROW
  EXECUTE PROCEDURE social.movimentodatainsercao();
  

--configura??o de dias retroativos para dispensa??o de materiais padr?o 0
INSERT INTO config(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_int,cac_codigo) VALUES('DISPENSACAO RETROATIVA EM DIAS','Dispensação retroativa em dias',false,3,0,11);            


--veiculo inativo
INSERT INTO veiculo_situacao(veis_descricao) VALUES('Inativo');

ALTER TABLE usuarios ADD COLUMN usr_restringe_atendimento_simplificado character varying(1) DEFAULT 'N';
