UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.134.133' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE config SET conf_valor_string='3.61.59' WHERE conf_chave='VERSAO_SOCIAL';

ALTER TABLE usuarios DROP COLUMN usr_restringe_atendimento_simplificado;
ALTER TABLE usuarios ADD COLUMN usr_restringe_atendimento_simplificado character varying(1) DEFAULT 'N';

ALTER TABLE atendimento ADD COLUMN st_visita_compartilhada BOOLEAN;

CREATE TABLE historico_data_hora(
    hdh_codigo serial primary key,
    age_codigo bigint not null references agendamento(age_codigo),
    hdh_agendamento_cadastro timestamp without time zone,
    hdh_agendamento_recepcionado timestamp without time zone,
    hdh_preconsulta_inicio timestamp without time zone,
    hdh_preconsulta_fim timestamp without time zone,
    hdh_atendimento_inicio timestamp without time zone,
    hdh_atendimento_fim timestamp without time zone
);

CREATE OR REPLACE FUNCTION historico_data_hora_agendamento()
  RETURNS trigger AS
$BODY$
BEGIN

IF (TG_OP = 'INSERT') THEN
INSERT INTO historico_data_hora(age_codigo,hdh_agendamento_cadastro) VALUES(NEW.age_codigo,NOW());
IF (NEW.age_atendido = 'S') THEN
UPDATE historico_data_hora SET hdh_agendamento_recepcionado=NOW() WHERE age_codigo=NEW.age_codigo;
END IF;
IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
				UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
END IF;	
ELSIF (TG_OP = 'UPDATE') THEN
IF ((OLD.age_atendido = 'N' AND NEW.age_atendido = 'S') OR (OLD.age_atendido = 'N' AND NEW.age_atendido = 'A') OR (OLD.age_atendido = 'S' AND NEW.age_atendido = 'A') OR (OLD.age_atendido is null AND NEW.age_atendido = 'A')) THEN
UPDATE historico_data_hora SET hdh_agendamento_recepcionado=NOW() WHERE age_codigo=NEW.age_codigo;
	
END IF;
IF (NEW.age_atendido = 'P') THEN
IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
				UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
END IF;
END IF;
END IF;

RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE TRIGGER historico_data_hora_agendamento
AFTER INSERT OR UPDATE
ON agendamento
FOR EACH ROW
EXECUTE PROCEDURE historico_data_hora_agendamento();






CREATE OR REPLACE FUNCTION historico_data_hora_pre_consulta()
RETURNS trigger AS
$BODY$
BEGIN

IF (TG_OP = 'INSERT') THEN
UPDATE historico_data_hora SET hdh_preconsulta_inicio=NOW() WHERE age_codigo=NEW.age_codigo;
ELSIF (TG_OP = 'UPDATE') THEN
UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo AND hdh_preconsulta_fim IS NULL;
END IF;

RETURN NEW;

END
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;


CREATE TRIGGER historico_data_hora_pre_consulta
AFTER INSERT OR UPDATE
ON pre_consulta
FOR EACH ROW
EXECUTE PROCEDURE historico_data_hora_pre_consulta();








CREATE OR REPLACE FUNCTION historico_data_hora_atendimento()
  RETURNS trigger AS
$BODY$
BEGIN

	IF (TG_OP = 'INSERT') THEN
		UPDATE historico_data_hora SET hdh_atendimento_inicio=NOW() WHERE age_codigo=NEW.age_codigo;
		IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
			UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
		END IF;
        ELSIF (TG_OP = 'UPDATE') THEN
		IF (OLD.ate_horafinal is null AND NEW.ate_horafinal is not null AND NEW.ate_horafinal <> '') THEN
			UPDATE historico_data_hora SET hdh_atendimento_fim=NOW() WHERE age_codigo=NEW.age_codigo;
			IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
				UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
			END IF;	
		END IF;
	END IF;
				
	RETURN NEW;

END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE TRIGGER historico_data_hora_atendimento
AFTER INSERT OR UPDATE
ON atendimento
FOR EACH ROW
EXECUTE PROCEDURE historico_data_hora_atendimento();

UPDATE config SET conf_valor_string = 'Compatível com a versão PEC: 2.1.11 do e-SUS' WHERE conf_chave='VERSAO_ESUS';



