UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.136.135' WHERE conf_chave='VERSAO_SAUDE';

UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE social.config SET conf_valor_string='3.63.61' WHERE conf_chave='VERSAO_SOCIAL';


UPDATE config SET conf_valor_data = CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.112.111' WHERE conf_chave='VERSAO_COMUM';

-- novo modulo prestador
INSERT INTO config(conf_chave,conf_label,conf_readonly,conf_tipo, conf_valor_data,cac_codigo) VALUES('DATA_INSTALACAO_PRESTADOR','Data de instalação Prestador',true,4,NOW(),6);
INSERT INTO config(conf_chave,conf_label,conf_readonly,conf_tipo, conf_valor_string,cac_codigo) VALUES('VERSAO_PRESTADOR','Versão Prestador',true,1,'3.1.1',6);


--insercao menu habitacional
INSERT INTO social.acesso(ace_descricao,ace_modulo) VALUES('Habitacional',13);
INSERT INTO social.acesso(ace_descricao,ace_pai,ace_modulo,ace_caminho) VALUES('Dados Habitacional',(SELECT ace_codigo FROM social.acesso WHERE ace_descricao = 'Habitacional' LIMIT 1),13,'zf/habitacional/familia/index');

UPDATE social.acesso SET ace_ordem = 5 WHERE ace_descricao = 'Habitacional';


ALTER TABLE social.as_prontuario_suas ADD COLUMN asps_situacao_habitacional character(1);
ALTER TABLE social.as_prontuario_suas ADD COLUMN asps_data date;
ALTER TABLE social.as_prontuario_suas ADD COLUMN usr_codigo integer references social.usuarios(usr_codigo);

CREATE OR REPLACE FUNCTION social.gerar_codbarras(VALUE bigint) returns bigint AS $$
DECLARE
l1 int;
l2 int;
r1 int;
r2 int;
i int:=0;
BEGIN
 l1:= (VALUE >> 16) & 65535;
 r1:= VALUE & 65535;
 WHILE i < 3 LOOP
   l2 := r1;
   r2 := l1 # ((((1366.0 * r1 + 150889) % 714025) / 714025.0) * 32767)::int;
   l1 := l2;
   r1 := r2;
   i := i + 1;
 END LOOP;
 RETURN ((l1::bigint << 16) + r1);
END;
$$ LANGUAGE plpgsql strict immutable;



INSERT INTO social.tb_cds_tipo_encam_odonto(co_cds_tipo_encam_odonto, no_cds_tipo_encam_odonto, no_identificador) VALUES (17, 'ALTA DO EPISODIO', 'ALTA_EPISODIO');


CREATE TABLE social.prestador(
	pres_codigo serial primary key,
	pres_usuario character varying(60) not null,
	pres_senha character varying(250) not null,
	usr_codigo bigint references usuarios(usr_codigo),
	med_codigo bigint references medico(med_codigo),
	pres_data timestamp default now()
);


-- Function: esus_ficha_procedimentos()

-- DROP FUNCTION esus_ficha_procedimentos();

CREATE OR REPLACE FUNCTION social.esus_ficha_procedimentos()
  RETURNS trigger AS
$BODY$
DECLARE 
	-- Dados do Atendimento
	linha_ate RECORD;
	-- Dados da Pré-Consulta
	linha_pc RECORD;
	efp_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		--RAISE NOTICE '1111111111''.',OLD.pat_codigo;
		DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
		RETURN OLD;
	ELSE
		IF ((SELECT usr_tipo_medico FROM usuarios WHERE usr_codigo = NEW.usr_codigo) <> 'D') THEN
		-- Valida se o procedimento está vindo do Atendimento ou da Pré-Consulta
			IF (NEW.ate_codigo IS NOT NULL) THEN
			FOR linha_ate IN
				SELECT 
					ate.age_codigo,
					pat.pat_codigo,
					pat.proc_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS efp_profissional_cns,
					esp.cod_cbo AS efp_cbo_codigo_2002,
					uni.uni_cnes AS efp_cnes,
					tbe.nu_ine AS efp_ine,
					ate.ate_data AS efp_dtatendimento,
					uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
					usu.usu_cartao_sus AS efp_num_cartao_sus,
					usu.usu_datanasc AS efp_dtnascimento,
					usu.usu_prontuario AS efp_numprontuario, 
					usu.usu_sexo
				FROM 
					procedimento_atendimento AS pat 
				INNER JOIN 
					atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
				INNER JOIN 
					agendamento AS age ON ate.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON ate.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON ate.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
				INNER JOIN 
					tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
				WHERE 
					pat.pat_codigo = NEW.pat_codigo LOOP
					
				IF (linha_ate.age_codigo IS NOT NULL AND linha_ate.proc_codigo IS NOT NULL AND linha_ate.co_local_atend IS NOT NULL AND linha_ate.efp_profissional_cns IS NOT NULL AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL AND linha_ate.efp_cnes IS NOT NULL AND linha_ate.efp_codigo_ibge_mun IS NOT NULL AND linha_ate.efp_dtnascimento IS NOT NULL) THEN			
					-- Validação de sexo
					IF (linha_ate.usu_sexo='M') THEN 
						efp_sexo = '0 L';
					ELSE
						efp_sexo = '1 L';
					END IF;
					-- Realiza a inserção dos da ficha de procedimento do E-SUS
					INSERT INTO esus_ficha_procedimento(
						age_codigo,
						pat_codigo,
						proc_codigo,
						co_local_atend,
						efp_profissional_cns,
						efp_cbo_codigo_2002,
						efp_cnes,
						efp_ine,
						efp_dtatendimento,
						efp_codigo_ibge_mun,
						efp_num_cartao_sus,
						efp_dtnascimento,
						efp_numprontuario,
						efp_sexo,
						efp_tipo_dado_serializado,
						efp_dtcadastro
					) VALUES (
						linha_ate.age_codigo,
						linha_ate.pat_codigo,
						linha_ate.proc_codigo,
						linha_ate.co_local_atend,
						linha_ate.efp_profissional_cns,
						linha_ate.efp_cbo_codigo_2002,
						linha_ate.efp_cnes,
						linha_ate.efp_ine,
						linha_ate.efp_dtatendimento,
						linha_ate.efp_codigo_ibge_mun,
						linha_ate.efp_num_cartao_sus,
						linha_ate.efp_dtnascimento,
						linha_ate.efp_numprontuario,
						efp_sexo,
						'7 L',
						'NOW()'
					);
					RETURN NEW;
					RAISE NOTICE 'Registro inserido com sucesso''.';
				END IF;	
			END LOOP;
		END IF;
			IF (NEW.pc_codigo IS NOT NULL) THEN

		
			--RAISE NOTICE '1111111111''.';
			FOR linha_pc IN
				SELECT 
					pc.age_codigo,
					pat.pat_codigo,
					pat.proc_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS efp_profissional_cns,
					esp.cod_cbo AS efp_cbo_codigo_2002,
					uni.uni_cnes AS efp_cnes,
					tbe.nu_ine AS efp_ine,
					pc.pc_data AS efp_dtatendimento,
					uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
					usu.usu_cartao_sus AS efp_num_cartao_sus,
					usu.usu_datanasc AS efp_dtnascimento,
					usu.usu_prontuario AS efp_numprontuario, 
					usu.usu_sexo
				FROM 
					procedimento_atendimento AS pat 
				INNER JOIN 
					pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
				INNER JOIN 
					agendamento AS age ON pc.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON age.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON age.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
				INNER JOIN 
					tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
				WHERE 
					pat.pat_codigo = NEW.pat_codigo LOOP
				
				IF (linha_pc.age_codigo IS NOT NULL AND linha_pc.proc_codigo IS NOT NULL AND linha_pc.co_local_atend IS NOT NULL AND linha_pc.efp_profissional_cns IS NOT NULL AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL AND linha_pc.efp_cnes IS NOT NULL AND linha_pc.efp_codigo_ibge_mun IS NOT NULL AND linha_pc.efp_dtnascimento IS NOT NULL) THEN
					-- Validação de sexo
					IF (linha_pc.usu_sexo='M') THEN 
						efp_sexo = '0 L';
					ELSE
						efp_sexo = '1 L';
					END IF;
					-- Realiza a inserção dos da ficha de procedimento do E-SUS
					INSERT INTO esus_ficha_procedimento(
						age_codigo,
						pat_codigo,
						proc_codigo,
						co_local_atend,
						efp_profissional_cns,
						efp_cbo_codigo_2002,
						efp_cnes,
						efp_ine,
						efp_dtatendimento,
						efp_codigo_ibge_mun,
						efp_num_cartao_sus,
						efp_dtnascimento,
						efp_sexo,
						efp_tipo_dado_serializado,
						efp_numprontuario,
						efp_dtcadastro
					) VALUES (
						linha_pc.age_codigo,
						linha_pc.pat_codigo,
						linha_pc.proc_codigo,
						linha_pc.co_local_atend,
						linha_pc.efp_profissional_cns,
						linha_pc.efp_cbo_codigo_2002,
						linha_pc.efp_cnes,
						linha_pc.efp_ine,
						linha_pc.efp_dtatendimento,
						linha_pc.efp_codigo_ibge_mun,
						linha_pc.efp_num_cartao_sus,
						linha_pc.efp_dtnascimento,
						efp_sexo,
						'7 L',
						linha_pc.efp_numprontuario,
						'NOW()'
					);
					RETURN NEW;
					RAISE NOTICE 'Registro inserido com sucesso''.';
				END IF;
			END LOOP;
		END IF;

		END IF;
	END IF;	
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION esus_ficha_procedimentos()
  OWNER TO postgres;


--permissao administrador habitacional
INSERT INTO social.acesso_usuarios(ace_codigo,usr_codigo) VALUES((SELECT ace_codigo FROM social.acesso WHERE ace_descricao='Dados Habitacional' LIMIT 1),(SELECT usr_codigo FROM social.usuarios WHERE usr_nome='ADMINISTRADOR'));



CREATE TABLE social.esus_pais(
    epa_codigo integer primary key,
    epa_nome character varying(100)
);

INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (1,'AFEGANISTÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (2,'ÁFRICA DO SUL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (3,'ALBÂNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (4,'ALEMANHA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (5,'ANDORRA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (6,'ANGOLA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (7,'ANGUILLA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (8,'ANTÁRCTICA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (9,'ANTIGUA E BARBUDA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (10,'ANTILHAS HOLANDESAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (11,'ARÁBIA SAUDITA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (12,'ARGÉLIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (13,'ARGENTINA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (14,'ARMÊNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (15,'ARUBA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (16,'AUSTRÁLIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (17,'ÁUSTRIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (18,'AZERBAIDJÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (19,'BAHAMAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (20,'BANGLADESH');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (21,'BARBADOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (22,'BAREIN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (23,'BELARUS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (24,'BÉLGICA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (25,'BELIZE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (26,'BENIN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (27,'BERMUDA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (28,'BOLÍVIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (29,'BÓSNIA E HERZEGÓVINA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (30,'BOTSWANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (31,'BRASIL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (32,'BRUNEI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (33,'BULGÁRIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (34,'BURKINA FASSO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (35,'BURUNDI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (36,'BUTÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (37,'CABO VERDE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (38,'CAMARÕES');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (39,'CAMBOJA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (40,'CANADÁ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (41,'CATAR');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (42,'CAZAQUISTÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (43,'CHADE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (44,'CHILE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (45,'CHINA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (46,'CHIPRE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (47,'CINGAPURA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (48,'COLÔMBIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (49,'COMORES');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (50,'CONGO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (51,'CORÉIA DO NORTE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (52,'CORÉIA DO SUL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (53,'COSTA DO MARFIM');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (54,'COSTA RICA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (55,'CROÁCIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (56,'CUBA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (57,'DINAMARCA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (58,'DJIBUTI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (59,'DOMINICA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (60,'EGITO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (61,'EL SALVADOR');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (62,'EMIRADOS ÁRABES UNIDOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (63,'EQUADOR');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (64,'ERITRÉIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (65,'ESLOVÁQUIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (66,'ESLOVÊNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (67,'ESPANHA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (68,'ESTADOS UNIDOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (69,'ESTÔNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (70,'ETIÓPIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (71,'FEDERAÇÃO RUSSA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (72,'FIJI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (73,'FILIPINAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (74,'FINLÂNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (75,'FRANÇA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (76,'FRANÇA METROPOLITANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (77,'GABÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (78,'GÂMBIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (79,'GANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (80,'GEÓRGIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (81,'GIBRALTAR');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (82,'GRÃ-BRETANHA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (83,'GRANADA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (84,'GRÉCIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (85,'GROENLÂNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (86,'GUADALUPE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (87,'GUAM');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (88,'GUATEMALA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (89,'GUIANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (90,'GUIANA FRANCESA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (91,'GUINÉ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (92,'GUINÉ EQUATORIAL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (93,'GUINÉ-BISSAU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (94,'HAITI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (95,'HOLANDA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (96,'HONDURAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (97,'HONG KONG');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (98,'HUNGRIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (99,'IÊMEN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (100,'ILHA BOUVET');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (101,'ILHA CHRISTMAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (102,'ILHA NORFOLK');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (103,'ILHAS CAYMAN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (104,'ILHAS COCOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (105,'ILHAS COOK');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (106,'ILHAS DE GUERNSEY');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (107,'ILHAS DE JERSEY');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (108,'ILHAS FAROE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (109,'ILHAS GEÓRGIA DO SUL E ILHAS SANDWICH DO SUL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (110,'ILHAS HEARD E MAC DONALD');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (111,'ILHAS MALVINAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (112,'ILHAS MARIANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (113,'ILHAS MARSHALL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (114,'ILHAS PITCAIRN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (115,'ILHAS REUNIÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (116,'ILHAS SALOMÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (117,'ILHAS SANTA HELENA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (118,'ILHAS SVALBARD E JAN MAYEN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (119,'ILHAS TOKELAU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (120,'ILHAS TURKS E CAICOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (121,'ILHAS VIRGENS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (122,'ILHAS VIRGENS BRITÂNICAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (123,'ILHAS WALLIS E FUTUNA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (124,'ÍNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (125,'INDONÉSIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (126,'IRÃ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (127,'IRAQUE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (128,'IRLANDA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (129,'ISLÂNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (130,'ISRAEL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (131,'ITÁLIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (132,'IUGOSLÁVIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (133,'JAMAICA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (134,'JAPÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (135,'JORDÂNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (136,'KIRIBATI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (137,'KUWEIT');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (138,'LAOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (139,'LESOTO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (140,'LETÔNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (141,'LÍBANO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (142,'LIBÉRIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (143,'LÍBIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (144,'LIECHTENSTEIN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (145,'LITUÂNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (146,'LUXEMBURGO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (147,'MACAU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (148,'MACEDÔNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (149,'MADAGASCAR');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (150,'MALÁSIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (151,'MALAUÍ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (152,'MALDIVAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (153,'MALI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (154,'MALTA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (155,'MARROCOS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (156,'MARTINICA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (157,'MAURÍCIO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (158,'MAURITÂNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (159,'MAYOTTE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (160,'MÉXICO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (161,'MIANMAR');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (162,'MICRONÉSIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (163,'MOÇAMBIQUE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (164,'MOLDÁVIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (165,'MÔNACO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (166,'MONGÓLIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (167,'MONTSERRAT');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (168,'NAMÍBIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (169,'NAURU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (170,'NEPAL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (171,'NICARÁGUA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (172,'NIGER');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (173,'NIGÉRIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (174,'NIUE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (175,'NORUEGA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (176,'NOVA CALEDÔNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (177,'NOVA ZELÂNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (178,'OMÃ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (179,'PALAU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (180,'PANAMÁ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (181,'PAPUA NOVA GUINÉ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (182,'PAQUISTÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (183,'PARAGUAI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (184,'PERU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (185,'POLINÉSIA FRANCESA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (186,'POLÔNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (187,'PORTO RICO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (188,'PORTUGAL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (189,'QUÊNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (190,'QUIRGUÍZIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (191,'REPÚBLICA CENTRO-AFRICANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (192,'REPÚBLICA DOMINICANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (193,'REPÚBLICA TCHECA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (194,'ROMÊNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (195,'RUANDA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (196,'SAHARA OCIDENTAL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (197,'SAMOA AMERICANA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (198,'SAMOA OCIDENTAL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (199,'SAN MARINO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (200,'SANTA LÚCIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (201,'SÃO CRISTÓVÃO E NÉVIS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (202,'SÃO PIERRE E MIQUELON');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (203,'SÃO TOMÉ E PRÍNCIPE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (204,'SÃO VICENTE E GRANADINAS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (205,'SEICHELES');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (206,'SENEGAL');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (207,'SERRA LEOA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (208,'SÍRIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (209,'SOMÁLIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (210,'SRI LANKA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (211,'SUAZILÂNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (212,'SUDÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (213,'SUÉCIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (214,'SUÍÇA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (215,'SURINAME');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (216,'TADJIQUISTÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (217,'TAILÂNDIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (218,'TAIWAN');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (219,'TANZÂNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (220,'TERRITÓRIOS FRANCESES MERIDIONAIS');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (221,'TIMOR LESTE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (222,'TOGO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (223,'TONGA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (224,'TRINIDAD E TOBAGO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (225,'TUNÍSIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (226,'TURCOMÊNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (227,'TURQUIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (228,'TUVALU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (229,'UCRÂNIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (230,'UGANDA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (231,'URUGUAI');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (232,'UZBEQUISTÃO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (233,'VANUATU');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (234,'VATICANO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (235,'VENEZUELA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (236,'VIETNÃ');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (237,'ZÂMBIA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (238,'ZIMBÁBUE');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (239,'ILHAS GUERNSEY');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (240,'JERSEY');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (241,'MONTENEGRO');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (242,'ESTADO DA PALESTINA');
INSERT INTO social.esus_pais (epa_codigo,epa_nome) VALUES (243,'SÉRVIA');


ALTER TABLE social.usuario ADD COLUMN epa_codigo integer REFERENCES esus_pais(epa_codigo);

ALTER TABLE social.as_aspectos_sociais_familia ALTER COLUMN assofa_deficiencia TYPE character varying(255);

ALTER TABLE social.as_aspectos_sociais_familia DROP COLUMN assofa_ha_membro_deficiencia;
ALTER TABLE social.as_aspectos_sociais_familia ADD COLUMN assofa_ha_membro_deficiencia char(1);
ALTER TABLE social.as_aspectos_sociais_familia DROP COLUMN assofa_imovel_necessita_adaptacao;
ALTER TABLE social.as_aspectos_sociais_familia ADD COLUMN assofa_imovel_necessita_adaptacao char(1);
ALTER TABLE social.as_aspectos_sociais_familia DROP COLUMN assofa_cadastro_cadunico;
ALTER TABLE social.as_aspectos_sociais_familia ADD COLUMN assofa_cadastro_cadunico char(1);


--criar tabela de versionamento

DROP TABLE IF EXISTS social.schema_version;

CREATE TABLE IF NOT EXISTS social.schema_version
(
  installed_rank integer NOT NULL,
  version character varying(50),
  description character varying(200) NOT NULL,
  type character varying(20) NOT NULL,
  script character varying(1000) NOT NULL,
  checksum integer,
  installed_by character varying(100) NOT NULL,
  installed_on timestamp without time zone NOT NULL DEFAULT now(),
  execution_time integer NOT NULL,
  success boolean NOT NULL,
  CONSTRAINT schema_version_pk PRIMARY KEY (installed_rank)
);
INSERT INTO social.schema_version(installed_rank,version,description,type,script,checksum,installed_by,installed_on,execution_time,success)
VALUES ((SELECT coalesce(max(installed_rank),0)+1 from schema_version),'103','init','SQL','V103__3.136.135.sql',395879748,'postgres',NOW(),1182,TRUE);




CREATE OR REPLACE FUNCTION social.esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			LEFT JOIN 
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo 
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN
													
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua,
						uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua,
						(select uuid_ficha 
						 from esus_cadastro_individual 
						 where usu_codigo = linha.usu_codigo
						 order by eci_codigo asc 
						 limit 1));	
								
						RAISE NOTICE 'UPDATE''.';
					 
				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						linha.eci_dtatendimento,
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


ALTER TABLE social.esus_cadastro_individual ALTER COLUMN eci_usu_codigo_ibge DROP NOT NULL;

UPDATE config SET conf_valor_string = 'Compatível com a versão PEC: 2.1.11 do e-SUS' WHERE conf_chave='VERSAO_ESUS';
