/***************
** OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
--UPDATE social.schema_version SET version='107', script='V107__3.140.139.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.140.139' WHERE conf_chave='VERSAO_SAUDE';

CREATE TABLE IF NOT EXISTS social.sigtap_historico(
    sig_codigo bigserial primary key,
    sig_versao character varying(6),
    sig_status character varying(30),
    sig_data_tentativa timestamp,
    sig_data_atualizacao timestamp,
    sig_erro character varying(5000)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_grupo(
    co_grupo character varying(2),
    no_grupo character varying(100),
    dt_competencia character varying(8)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_sub_grupo(
  co_grupo character varying(2),
  co_sub_grupo character varying(2) NOT NULL,
  no_sub_grupo character varying(100) NOT NULL,
  dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_forma_organizacao(
 co_grupo character varying(2),
co_sub_grupo character varying(2),
co_forma_organizacao character varying(2),
no_forma_organizacao character varying(100) NOT NULL,
dt_competencia character varying(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_procedimento(
  co_procedimento character varying(10) NOT NULL,
  no_procedimento character varying(250) NOT NULL,
  tp_complexibilidade character varying(1) NOT NULL,
  tp_sexo character varying(1) NOT NULL,
  qt_maxima_execucao numeric(4,0),
  qt_dias_permanencia numeric(4,0),
  qt_pontos numeric(4,0) NOT NULL,
  vl_idade_minima numeric(4,0) NOT NULL,
  vl_idade_maxima numeric(4,0) NOT NULL,
  vl_sh numeric(10,0) NOT NULL,
  vl_sa numeric(10,0) NOT NULL,
  vl_sp numeric(10,0) NOT NULL,
  co_financiamento character varying(2) NOT NULL,
  co_rubrica character varying(6),
  qt_tempo_permanencia numeric(4,0),
  dt_competencia character(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_financiamento(
  co_financiamento character varying(2) NOT NULL,
  no_financiamento character varying(100),
  dt_competencia character varying(6),
  CONSTRAINT tb_financiamento_pkey PRIMARY KEY (co_financiamento)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_compativel(
co_procedimento_principal character varying(10),
co_registro_principal character varying(2),
co_procedimento_compativel character varying(10),
co_registro_compativel character varying(2),
tp_compatibilidade character varying(1),
qt_permitida character varying(4),
dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.rl_excecao_compatibilidade(
co_procedimento_restricao character varying(10),
co_procedimento_principal character varying(10),
co_registro_principal character varying(2),
co_procedimento_compativel character varying(10),
co_registro_compativel character varying(2),
tp_compatibilidade character varying(1),
dt_competencia character varying(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_cid(
  no_cid character varying(100) NOT NULL,
  tp_agravo character(1) NOT NULL,
  tp_sexo character(1) NOT NULL,
  tp_estadio character(1),
  vl_campos_irradiados integer,
  co_cid character varying(4)
);

--existe
CREATE TABLE IF NOT EXISTS social.rl_procedimento_cid(
  co_procedimento character varying(10),
  co_cid character varying(4),
  st_principal character varying(1),
  dt_competencia character varying(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_detalhe(
  co_detalhe character varying(3),
  no_detalhe character varying(100),
  dt_competencia character(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.rl_procedimento_detalhe(
  co_procedimento character varying(10),
  co_detalhe character varying(3),
  dt_competencia character(6)
);

CREATE TABLE IF NOT EXISTS social.tb_habilitacao(
co_habilitacao character varying(4),
no_habilitacao character varying(150),
dt_competencia character(6)
);

CREATE TABLE IF NOT EXISTS social.tb_grupo_habilitacao(
nu_grupo_habilitacao character varying(4),
no_grupo_habilitacao character varying(20),
ds_grupo_habilitacao character varying(25)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_habilitacao(
co_habilitacao character varying(4),
  co_procedimento character varying(10),
nu_grupo_habilitacao character varying(4),
dt_competencia character(6)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_incremento(
  co_procedimento character varying(10),
co_habilitacao character varying(4),
vl_percentual_sh numeric(7,0),
vl_percentual_sa numeric(7,0),
vl_percentual_sp numeric(7,0),
dt_competencia character(6)
);

CREATE TABLE IF NOT EXISTS social.tb_tipo_leito(
co_tipo_leito character varying(2),
no_tipo_leito character varying(2),
dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_leito(
co_procedimento character varying(10),
co_tipo_leito character varying(2),
dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_modalidade(
co_modalidade character varying(2),
no_modalidade character varying(100),
dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_modalidade(
co_procedimento character varying(10),
co_modalidade character varying(2),
dt_competencia character varying(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_registro(
  co_registro character varying(2),
  no_registro character varying(50),
  dt_competencia character(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.rl_procedimento_registro(
  co_procedimento character(10),
  co_registro smallint,
  dt_competencia character(6)
);

CREATE TABLE IF NOT EXISTS social.tb_servico(
co_servico character varying(3),
no_servico character varying(120),
dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_servico_classificacao(
co_servico character varying(3),
co_classificacao character varying(3),
no_classificacao  character varying(150),
dt_competencia character varying(6)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_servico(
co_procedimento character varying(10),
co_servico character varying(3),
 co_classificacao character varying(3),
 dt_competencia character varying(6)
);

--existe
CREATE TABLE IF NOT EXISTS social.tb_ocupacao(
  co_ocupacao character varying(6) NOT NULL,
  no_ocupacao character varying(150) NOT NULL
);

--existe
CREATE TABLE IF NOT EXISTS social.rl_procedimento_ocupacao(
  co_procedimento character varying(10) NOT NULL,
  co_ocupacao character varying(6) NOT NULL,
  dt_competencia character varying(6) NOT NULL
);

CREATE TABLE IF NOT EXISTS social.tb_rubrica(
co_rubrica character varying(6),
no_rubrica  character varying(100),
dt_competencia  character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_sia_sih(
co_procedimento_sia_sih character varying(10),
no_procedimento_sia_sih  character varying(100),
dt_competencia  character varying(6),
tp_procedimento  character varying(1)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_sia_sih(
co_procedimento character varying(10) NOT NULL,
co_procedimento_sia_sih character varying(10),
dt_competencia character varying(6),
tp_procedimento  character varying(1)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_origem(
co_procedimento character varying(10),
co_procedimento_origem character varying(10),
dt_competencia  character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_descricao(
co_procedimento character varying(10),
ds_procedimento character varying(4000),
dt_competencia  character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_descricao_detalhe(
co_detalhe character varying(10),
ds_detalhe character varying(4000),
dt_competencia  character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_descricao_detalhe(
co_detalhe character varying(10),
ds_detalhe character varying(4000),
dt_competencia  character varying(6)
);

CREATE TABLE IF NOT EXISTS social.tb_regra_condicionada(
co_regra_condicionada character varying(4),
no_regra_condicionada character varying(150),
ds_regra_condicionada character varying(4000)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_regra_cond(
co_regra_condicionada character varying(4),
co_procedimento character varying(10)
);

CREATE TABLE IF NOT EXISTS social.tb_componente_rede(
co_componente_rede character varying(10),
no_componente_rede character varying(150),
co_rede_atencao character varying(3)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_comp_rede(
co_procedimento character varying(10),
co_componente_rede character varying(10)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_renases(
co_procedimento character varying(10),
co_renases character varying(10)
);

CREATE TABLE IF NOT EXISTS social.rl_procedimento_tuss(
co_procedimento character varying(10),
co_tuss character varying(10)
);

CREATE TABLE IF NOT EXISTS social.tb_rede_atencao(
co_rede_atencao character varying(3),
no_rede_atencao character varying(50)
);

CREATE TABLE IF NOT EXISTS social.tb_renases(
 co_renases character varying(10),
no_renases character varying(150)
);

CREATE TABLE IF NOT EXISTS social.tb_tuss(
co_tuss character varying(10),
no_tuss character varying(450)
);

 UPDATE social.procedimento SET proc_ativo = 'A' WHERE proc_ativo is null;

--acessos fichas odontológicas restrição por CBO
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223204','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223208','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223280','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223284','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223212','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223216','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223220','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223224','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223228','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223276','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223288','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223232','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223236','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223240','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223244','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223248','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223252','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223256','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223260','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223264','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223268','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223272','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('223293','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('322415','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('322430','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('322405','o') ;
INSERT INTO social.acessos_ficha_esus(afe_cbo,afe_ficha) VALUES('322425','o') ;



CREATE OR REPLACE FUNCTION social.esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			LEFT JOIN 
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo 
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN
													
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua,
						uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						NOW(),
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua,
						(select uuid_ficha 
						 from esus_cadastro_individual 
						 where usu_codigo = linha.usu_codigo
						 order by eci_codigo asc 
						 limit 1));	
								
						RAISE NOTICE 'UPDATE''.';
					 
				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						NOW(),
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

ALTER TABLE social.tb_cds_domicilio_resposta ADD COLUMN co_data_atendimento date;

--DOMICILIO
CREATE OR REPLACE FUNCTION social.src_esus_cadastro_domiciliar()
  RETURNS trigger AS
$BODY$
DECLARE 
BEGIN 
	UPDATE tb_cds_domicilio_resposta SET uuid_ficha = null, co_data_atendimento = current_date WHERE co_cds_cad_domiciliar=NEW.dom_codigo;
	RETURN NEW;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
CREATE TRIGGER esus_cadastro_domiciliar
  AFTER UPDATE
  ON social.domicilio
  FOR EACH ROW
  EXECUTE PROCEDURE social.src_esus_cadastro_domiciliar();


 
INSERT INTO social.tb_cds_ativ_col_pratica VALUES (29, 'AÇÕES DE COMBATE AO AEDES AEGYPTI', 'ACOES_DE_COMBATE_AO_AEDES_AEGYPTI');
INSERT INTO social.tb_cds_ativ_col_pratica VALUES (30, 'OUTRO PROCEDIMENTO COLETIVO', 'OUTRO_PROCEDIMENTO_COLETIVO');
UPDATE social.tb_cds_ativ_col_pratica SET no_cds_ativ_col_pratica = 'SAÚDE AUDITIVA' WHERE co_cds_ativ_col_pratica = 22;
UPDATE social.tb_cds_ativ_col_pratica SET no_cds_ativ_col_pratica = 'OUTRAS' WHERE co_cds_ativ_col_pratica = 12;

ALTER TABLE social.tb_cds_ficha_ativ_col ADD COLUMN outro_procedimento_coletivo INTEGER;

--CORRIGE TIPO DE ATENDIMENTO DAS VISITAS DOMICILIARES
UPDATE social.agendamento SET tat_codigo = null FROM atendimento WHERE atendimento.age_codigo = agendamento.age_codigo AND atendimento.ate_tipo = 'V';
  
/***************
* MODULO SOCIAL*
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE social.config SET conf_valor_string='3.65.63' WHERE conf_chave='VERSAO_SOCIAL';
