SET search_path = social;
/***************
** OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
--UPDATE social.schema_version SET version='108', script='V106__3.141.140.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.141.140' WHERE conf_chave='VERSAO_SAUDE';

UPDATE raca SET rac_ativacao = 'I' WHERE rac_codigo IN ('X', '9');

ALTER TABLE cid10 ADD COLUMN cd10_ativo CHAR(1) DEFAULT 'A';

CREATE OR REPLACE FUNCTION atetobpa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN    SELECT age.uni_codigo,
						   ate.med_codigo,
						   ate.usu_codigo,
						   ate.ate_data,
						   proc.proc_codigo,
						   proc.proc_bpa_tipo,
						   cd10.cd10_codigo,
						   sispn_codigo,
						   age.age_emergencia,
						   age.esp_codigo
					  FROM atendimento AS ate
					  JOIN agendamento AS age
						ON age.age_codigo=ate.age_codigo
					  JOIN procedimento AS proc
						ON proc.proc_codigo_sus='0301010110'
					 LEFT JOIN cid10 AS cd10
						ON cd10.cd10_codigo=ate.cd10_codigo
					 WHERE ate.ate_codigo=NEW.ate_codigo LOOP
					 
				-- verificar ci
				IF linha.age_emergencia = 'S' THEN 
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Urgencia' AND ci_ativo='S' INTO ciCodigo;
				ELSE
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				END IF;
		
				-- somente se há um sispn_codigo (FK com Pré-Natal)
				IF linha.sispn_codigo IS NOT NULL THEN
					  
					INSERT INTO BPA (uni_codigo,
									 usr_codigo,
									 usu_codigo,
									 bpa_data,
									 proc_codigo,
									 ci_codigo,
									 bpa_tipo,
									 bpa_cd10_codigo, 
									 bpa_origem,
									 bpa_origem_codigo,
									 esp_codigo)
							 VALUES (linha.uni_codigo,
									 linha.med_codigo,
									 linha.usu_codigo,
									 linha.ate_data,
									 NEW.proc_codigo,
									 ciCodigo,
									 linha.proc_bpa_tipo,
									 NEW.cd10_codigo,
									 'atendimento',
									 NEW.ate_codigo,
									 linha.esp_codigo);
					RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma inserção na tabela ''atendimento'', informando um código do ''sis pré-natal''.';				 
					
				END IF;

				
			END LOOP;
				
	RETURN NEW;

END
$$;


--
-- TOC entry 1140 (class 1255 OID 17240819)
-- Name: atetobpadel(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atetobpadel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    
BEGIN

	DELETE FROM bpa WHERE bpa_origem='atendimento' AND bpa_origem_codigo=OLD.ate_codigo;
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma exclusão na tabela ''atendimento''.*';
	RETURN OLD;

END
$$;


--
-- TOC entry 1141 (class 1255 OID 17240820)
-- Name: atetobpaup(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atetobpaup() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN    SELECT age.uni_codigo,
						   ate.med_codigo,
						   ate.usu_codigo,
						   ate.ate_data,
						   proc.proc_codigo,
						   proc.proc_bpa_tipo,
						   cd10.cd10_codigo,
						   sispn_codigo,
						   age.age_emergencia
					  FROM atendimento AS ate
					  JOIN agendamento AS age
						ON age.age_codigo=ate.age_codigo
					  JOIN procedimento AS proc
						ON proc.proc_codigo_sus='0301010110'
					 LEFT JOIN cid10 AS cd10
						ON cd10.cd10_codigo=ate.cd10_codigo
					 WHERE ate.ate_codigo=NEW.ate_codigo LOOP
					 
				-- verificar ci
				IF linha.age_emergencia = 'S' THEN 
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Urgencia' AND ci_ativo='S' INTO ciCodigo;
				ELSE
					SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				END IF;
		
				-- somente se há um sispn_codigo (FK com Pré-Natal)
				IF linha.sispn_codigo IS NOT NULL THEN
				
					-- procura na tabela bpa
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'atendimento'
					   AND bpa_origem_codigo = NEW.ate_codigo
					  INTO bpaCodigo;
					  
					INSERT INTO BPA (uni_codigo,
									 usr_codigo,
									 usu_codigo,
									 bpa_data,
									 proc_codigo,
									 ci_codigo,
									 bpa_tipo,
									 bpa_cd10_codigo, 
									 bpa_origem,
									 bpa_origem_codigo)
							 VALUES (linha.uni_codigo,
									 linha.med_codigo,
									 linha.usu_codigo,
									 linha.ate_data,
									 NEW.proc_codigo,
									 ciCodigo,
									 linha.proc_bpa_tipo,
									 NEW.cd10_codigo,
									 'atendimento',
									 NEW.ate_codigo);
					RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma inserção na tabela ''atendimento'', informando um código do ''sis pré-natal''.';				 
					
				END IF;

				
			END LOOP;
				
	RETURN NEW;

END
$$;


--
-- TOC entry 1226 (class 1255 OID 62547446)
-- Name: attespcodigonabpa(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION attespcodigonabpa() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE 
	linha RECORD;
	cont integer = 0;
BEGIN
	FOR linha IN
		SELECT  b.bpa_codigo,
			b.esp_codigo,
			b.usr_codigo,
			ag.esp_codigo as age_esp,
			ag.med_codigo as age_med
		FROM bpa b
		INNER JOIN procedimento_atendimento pa ON b.bpa_origem_codigo = pa.pat_codigo AND b.bpa_origem = 'procedimento_atendimento'
		INNER JOIN atendimento a ON a.ate_codigo = pa.ate_codigo
		INNER JOIN agendamento ag ON ag.age_codigo = a.age_codigo
		INNER JOIN especialidade e ON e.esp_codigo = b.esp_codigo
		WHERE b.usr_codigo = ag.med_codigo 
		     AND b.esp_codigo != ag.esp_codigo
		ORDER BY b.bpa_codigo desc
	LOOP
		cont := cont+1;
		UPDATE bpa
			SET esp_codigo = linha.age_esp
		WHERE bpa_codigo = linha.bpa_codigo;
	END LOOP;
	RETURN cont;
END;
$$;


--
-- TOC entry 1143 (class 1255 OID 17240821)
-- Name: atualiza_inventario(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atualiza_inventario(bigint) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    codinventario   integer := 0;
    centroestocador integer := 0;
    datamovim       date;
    proximaentrada  integer := 0;
    proximasaida    integer := 0;
    qtdeentrada     numeric := 0;
    qtdesaida       numeric := 0;
    qtde            numeric := 0;    

BEGIN

    CODINVENTARIO:= $1;

--verificar as diferencas dos produtos para o inventario cadastrado DE ENTRADA


   SELECT COUNT(*) INTO QTDEENTRADA
   FROM   V_INVENTARIO 
   WHERE  ESTOQUEATUAL < INVP_QUANTIDADE 
   AND    INV_CODIGO = CODINVENTARIO;

   SELECT INV_DATA, SET_CODIGO INTO DATAMOVIM, CENTROESTOCADOR FROM INVENTARIO
   WHERE INV_CODIGO = CODINVENTARIO;
   
   IF  QTDEENTRADA >= 0 THEN
       SELECT NEXTVAL('SEQ_MOV_CODIGO') INTO PROXIMAENTRADA;
       INSERT INTO MOVIMENTO
         (MOV_CODIGO, MOV_DATA, MOV_TIPO, MOV_OBSERVACAO, SET_ENTRADA, SET_SAIDA, MOV_NR_NOTA, MOV_ENTRADA, MOV_DATA_INCLUSAO, INV_CODIGO, for_codigo)
       VALUES 
          (PROXIMAENTRADA, datamovim, 'E', 'MOVIMENTACAO DE INVENTARIO', centroestocador, centroestocador, PROXIMAENTRADA, 'I', DATE(NOW()), CODINVENTARIO, 5003);
       FOR row IN SELECT * FROM V_INVENTARIO
                  WHERE  ESTOQUEATUAL < INVP_QUANTIDADE
                  AND    INV_CODIGO = CODINVENTARIO LOOP
           qtde := row.invp_quantidade - row.estoqueatual;       
           IF QTDE > 0 THEN
              INSERT INTO ITENS_MOVIMENTO
                    (MOV_CODIGO, PRO_CODIGO, ITE_QUANTIDADE, ITE_CONSOLIDADO, ITE_STATUS, ITE_VLRUNIT)
              VALUES 
                     (PROXIMAENTRADA, row.PRO_CODIGO, qtde, 'S', 'A', verifica_preco(row.pro_codigo, row.set_codigo, row.inv_data));
           END IF;          
       END LOOP;
   END IF;       
   

--verificar as diferencas dos produtos para o inventario cadastrado DE SAIDA


   SELECT COUNT(*) INTO QTDESAIDA
   FROM   V_INVENTARIO 
   WHERE  ESTOQUEATUAL > INVP_QUANTIDADE 
   AND    INV_CODIGO = CODINVENTARIO;
   
   IF  QTDESAIDA >= 0 THEN
       SELECT NEXTVAL('SEQ_MOV_CODIGO') INTO PROXIMASAIDA;
       INSERT INTO MOVIMENTO
         (MOV_CODIGO, MOV_DATA, MOV_TIPO, MOV_OBSERVACAO, SET_ENTRADA, SET_SAIDA, MOV_NR_NOTA, MOV_SAIDA, MOV_DATA_INCLUSAO, INV_CODIGO)
       VALUES 
          (PROXIMASAIDA, datamovim, 'S', 'MOVIMENTACAO DE INVENTARIO', centroestocador, centroestocador, PROXIMASAIDA, 'I', DATE(NOW()), CODINVENTARIO);
       FOR row IN SELECT * FROM V_INVENTARIO
                  WHERE  ESTOQUEATUAL > INVP_QUANTIDADE
                  AND    INV_CODIGO = CODINVENTARIO LOOP
           qtde := row.estoqueatual - row.invp_quantidade;       
           IF QTDE > 0 THEN
              INSERT INTO ITENS_MOVIMENTO
                    (MOV_CODIGO, PRO_CODIGO, ITE_QUANTIDADE, ITE_CONSOLIDADO, ITE_STATUS)
              VALUES 
                    (PROXIMASAIDA, row.PRO_CODIGO, qtde, 'S', 'A');
           END IF;         
       END LOOP;
   END IF;       
       
   RETURN 0;
END; $_$;


--
-- TOC entry 1144 (class 1255 OID 17240822)
-- Name: atualiza_inventario_BKP(bigint); Type: FUNCTION; Schema: social; Owner: -
--


CREATE OR REPLACE FUNCTION social.atualiza_inventario_BKP(
	bigint)
    RETURNS numeric
    LANGUAGE 'plpgsql'
    COST 100.0
    VOLATILE 
AS $function$

DECLARE
    row RECORD;
    codinventario   integer := 0;
    centroestocador integer := 0;
    datamovim date;
    proximaentrada integer := 0;
    proximasaida integer := 0;
	QTDEENTRADA integer := 0;
    QTDESAIDA integer := 0;
BEGIN

    CODINVENTARIO:= $1;

--verificar as diferencas dos produtos para o inventario cadastrado DE ENTRADA

   SELECT COUNT(*) INTO QTDEENTRADA
   FROM   SAUDE.V_INVENTARIO 
   WHERE  ESTOQUEATUAL < INVP_QUANTIDADE 
   AND    INV_CODIGO = CODINVENTARIO;
   
   IF  QTDEENTRADA > 1 THEN
       SELECT NEXTVAL('SAUDE.SEQ_MOV_CODIGO') INTO PROXIMAENTRADA;
       INSERT INTO SAUDE.MOVIMENTO
         (MOV_CODIGO, MOV_DATA, MOV_TIPO, MOV_OBSERVACAO, SET_ENTRADA, MOV_NR_NOTA, MOV_ENTRADA, MOV_DATA_INCLUSAO, INV_CODIGO)
       VALUES 
          (PROXIMAENTRADA, datamovim, 'E', 'MOVIMENTACAO DE INVENTARIO', centroestocador, PROXIMAENTRADA, 'I', DATE(NOW()), CODINVENTARIO);
       FOR row IN SELECT * FROM SAUDE.V_INVENTARIO
                  WHERE  ESTOQUEATUAL < INVP_QUANTIDADE
                  AND    INV_CODIGO = CODINVENTARIO LOOP
           INSERT INTO SAUDE.ITENS_MOVIMENTO
              (MOV_CODIGO, PRO_CODIGO, ITE_QUANTIDADE, ITE_CONSOLIDADO, ITE_STATUS, ITE_VLRUNIT)
           VALUES 
              (PROXIMAENTRADA, row.PRO_CODIGO, row.invp_quantidade, 'S', 'A', saude.verifica_preco(row.pro_codigo, row.set_codigo, row.inv_data));
       END LOOP;
   END IF;       
   

--verificar as diferencas dos produtos para o inventario cadastrado DE SAIDA

   SELECT COUNT(*) INTO QTDESAIDA
   FROM   SAUDE.V_INVENTARIO 
   WHERE  ESTOQUEATUAL > INVP_QUANTIDADE 
   AND    INV_CODIGO = CODINVENTARIO;
   
   IF  QTDESAIDA > 1 THEN
       SELECT NEXTVAL('SAUDE.SEQ_MOV_CODIGO') INTO PROXIMASAIDA;
       INSERT INTO SAUDE.MOVIMENTO
         (MOV_CODIGO, MOV_DATA, MOV_TIPO, MOV_OBSERVACAO, SET_ENTRADA, MOV_NR_NOTA, MOV_SAIDA, MOV_DATA_INCLUSAO, INV_CODIGO)
       VALUES 
          (PROXIMASAIDA, datamovim, 'S', 'MOVIMENTACAO DE INVENTARIO', centroestocador, PROXIMASAIDA, 'I', DATE(NOW()), CODINVENTARIO);
       FOR row IN SELECT * FROM SAUDE.V_INVENTARIO
                  WHERE  ESTOQUEATUAL > INVP_QUANTIDADE
                  AND    INV_CODIGO = CODINVENTARIO LOOP
           INSERT INTO SAUDE.ITENS_MOVIMENTO
              (MOV_CODIGO, PRO_CODIGO, ITE_QUANTIDADE, ITE_CONSOLIDADO, ITE_STATUS)
           VALUES 
              (PROXIMASAIDA, row.PRO_CODIGO, row.invp_quantidade, 'S', 'A');
       END LOOP;
   END IF;       
       
   RETURN 0;
END; 
$function$;

--
-- TOC entry 1145 (class 1255 OID 17240823)
-- Name: atualiza_permissoes(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atualiza_permissoes(usr bigint) RETURNS void
    LANGUAGE plpgsql
    AS $$

DECLARE

	rec RECORD;
	teste INT8 := -1;


BEGIN
	-- limpa permissoes sem vinculo (td mundo)
	DELETE FROM usuarios_permissoes 
		WHERE perm_codigo NOT IN ( SELECT perm_codigo FROM permissoes );

	-- varre as permissoes
	FOR rec IN
		SELECT perm_codigo FROM permissoes ORDER BY 1
	LOOP
		
		-- verifica se aquele usuario tem aquela permissao
		SELECT COUNT(perus_codigo) INTO teste
			FROM usuarios_permissoes 
			WHERE usr_codigo = usr AND perm_codigo = rec.perm_codigo;

		--RAISE NOTICE 'teste = (%)', teste;

		-- insere 'negando' tudo
		IF( teste < 1 ) THEN

			INSERT INTO usuarios_permissoes 
				( usr_codigo, perm_set, nivel_i, nivel_a, nivel_d, nivel_l,  nivel_b, perm_codigo )
				VALUES 
				( usr, 'S', 'S', 'S', 'S', 'S', 'S', rec.perm_codigo);

		END IF;


	END LOOP;

END
$$;


--
-- TOC entry 1146 (class 1255 OID 17240824)
-- Name: atualiza_permissoes_todos(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atualiza_permissoes_todos() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
	rec RECORD;
BEGIN
	-- varre os usuarios
	FOR rec IN
		SELECT usr_codigo FROM usuarios ORDER BY 1
	LOOP
		
		PERFORM atualiza_permissoes( rec.usr_codigo );

	END LOOP;
END
$$;


--
-- TOC entry 1147 (class 1255 OID 17240825)
-- Name: atualiza_prontuarios_nulos(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atualiza_prontuarios_nulos() RETURNS numeric
    LANGUAGE plpgsql
    AS $$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
            SELECT usu_codigo,nnumepaci, usu_prontuario, cambupaci 
            FROM PUBLIC.INTPACI, usuario 
            WHERE nnumepaci=usu_codigo and 
                  usu_prontuario is null and 
                  cambupaci is not null
       LOOP
       update usuario set usu_prontuario=row.cambupaci
              where row.nnumepaci=usu_codigo;
       linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$$;


--
-- TOC entry 1148 (class 1255 OID 17240826)
-- Name: atualiza_prontuarios_nulos(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atualiza_prontuarios_nulos(bigint) RETURNS numeric
    LANGUAGE plpgsql
    AS $$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN
linhas = 0;
    
    FOR row IN 
            SELECT usu_codigo,nnumepaci, usu_prontuario, cambupaci 
            FROM PUBLIC.INTPACI, usuario 
            WHERE nnumepaci=usu_codigo and 
                  usu_prontuario is null and 
                  cambupaci is not null
       LOOP
       update usuario set usu_prontuario=row.cambupaci
              where row.numepaci=usu_codigo;
       linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$$;


--
-- TOC entry 1219 (class 1255 OID 31017024)
-- Name: atualizabpa(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION atualizabpa() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
    row   RECORD;
BEGIN
   FOR row in SELECT * FROM bpa WHERE bpa_data is null LOOP

      UPDATE bpa set bpa_data = row.bpa_data_alt where bpa_codigo = row.bpa_codigo;

   END LOOP;
   return null;
END;

$$;


--
-- TOC entry 1149 (class 1255 OID 17240827)
-- Name: backup_tabela(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION backup_tabela(tb text) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
	sql TEXT;
	bkp TEXT := '_bkp_' || TO_CHAR( NOW(), 'yyyymmdd_hh24mi' );
BEGIN
	sql := 'CREATE TABLE ' || tb || bkp || ' AS SELECT * FROM ' || tb || ';';
	EXECUTE sql;
	--RAISE NOTICE 'sql = %', sql;

END
$$;


--
-- TOC entry 1150 (class 1255 OID 17240828)
-- Name: bytea_import(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION bytea_import(p_path text, OUT p_result bytea) RETURNS bytea
    LANGUAGE plpgsql
    AS $$
declare
 l_oid oid;
 r record;
begin
 p_result := '';
 select lo_import(p_path) into l_oid;
 for r in ( select data 
            from pg_largeobject 
            where loid = l_oid 
            order by pageno ) loop
   p_result = p_result || r.data;
 end loop;
 perform lo_unlink(l_oid);
end;$$;


--
-- TOC entry 1151 (class 1255 OID 17240829)
-- Name: calcula_estoque(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_estoque(bigint, bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    PRODUTO       alias for $1;
    SETOR         alias for $2;
    DATAESTOQ     alias for $3;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    data_saldoini date;

BEGIN

 -- PEGA SALDO INICIAL

    SELECT sal_data, sal_qtde INTO DATA_SALDOINI, SALDOINI
      FROM saldo
     WHERE pro_codigo = PRODUTO
       AND set_codigo = SETOR
       AND sal_data  <= DATAESTOQ
     ORDER BY sal_data DESC LIMIT 1;

    if SALDOINI      is null then SALDOINI := 0; end if;  
    if DATA_SALDOINI is null then DATA_SALDOINI := '01-01-2006'; end if;

 -- CALCULAR AS ENTRADAS

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
       AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_ENTRADA = SETOR
       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
       AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;
    
 -- CALCULAR AS SAIDAS

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE       
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_SAIDA = SETOR
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;
    
    SALDOFINAL := SALDOINI + ENTRADAS - SAIDAS;
    RAISE NOTICE 'Saldo inicial: %', SALDOINI;
    RAISE NOTICE 'Entradas: %', ENTRADAS;
    RAISE NOTICE 'Saidas: %', SAIDAS;

    if saldofinal is null then saldofinal:=0;
    end if;  
       
    RETURN SALDOFINAL;
END; $_$;


--
-- TOC entry 1152 (class 1255 OID 17240830)
-- Name: calcula_estoque2(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_estoque2(bigint, bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    produto       integer := 0;
    setor         integer := 0;
    dataestoq     date;
    data_saldoini date;

BEGIN


    SETOR := $2;
    PRODUTO := $1;
    DATAESTOQ := $3;
    
-- calcula o saldo inicial do individuo (produto)    
    IF SETOR = 0 THEN
       SELECT SUM(COALESCE(A.SAL_QTDE, 0)), A.SAL_DATA INTO SALDOINI, DATA_SALDOINI
       FROM SALDO AS A
       WHERE A.PRO_CODIGO = PRODUTO
       AND   A.SAL_DATA <= (SELECT MAX(SAL_DATA) FROM SALDO 
                          WHERE PRO_CODIGO = A.PRO_CODIGO 
                          AND A.SAL_DATA <= DATAESTOQ)
       GROUP BY A.SAL_DATA
       ORDER BY A.SAL_DATA DESC LIMIT 1;
    ELSE
       SELECT SUM(COALESCE(A.SAL_QTDE, 0)), A.SAL_DATA INTO SALDOINI, DATA_SALDOINI
       FROM SALDO AS A
       WHERE A.PRO_CODIGO = PRODUTO
       AND   A.SET_CODIGO = SETOR
       AND   A.SAL_DATA <= (SELECT MAX(SAL_DATA) FROM SALDO 
                          WHERE PRO_CODIGO = A.PRO_CODIGO 
                          AND A.SAL_DATA <= DATAESTOQ
                          AND A.SET_CODIGO = SET_CODIGO)
      GROUP BY A.SAL_DATA
      ORDER BY A.SAL_DATA DESC LIMIT 1;      
    END IF;
    
    IF SALDOINI IS NULL THEN 
       SALDOINI := 0;
       IF SETOR = 0 THEN 
          SELECT MIN(MOV_DATA)-1 INTO DATA_SALDOINI
             FROM MOVIMENTO MOV, ITENS_MOVIMENTO IT
             WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
             AND   IT.PRO_CODIGO = PRODUTO;
       ELSE
          SELECT MIN(MOV_DATA)-1 INTO DATA_SALDOINI
             FROM MOVIMENTO MOV, ITENS_MOVIMENTO IT
             WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
             AND   IT.PRO_CODIGO = PRODUTO
             AND   MOV.SET_ENTRADA = SETOR;
       END IF;          
    END IF;

    IF DATA_SALDOINI IS NULL THEN
       SELECT TO_DATE('27/10/2006', 'DD/MM/YYYY') INTO DATA_SALDOINI;
    END IF;
    
 -- CALCULAR AS ENTRADAS

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
       AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_ENTRADA = SETOR
       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
       AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;
    
    
 -- CALCULAR AS SAIDAS
    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE       
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_SAIDA = SETOR
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;
    
    SALDOFINAL := SALDOINI + ENTRADAS - SAIDAS;
      
       
    RETURN SALDOFINAL;
END; $_$;


--
-- TOC entry 1142 (class 1255 OID 17240831)
-- Name: calcula_estoque3(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_estoque3(bigint, bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    produto       integer := 0;
    setor         integer := 0;
    dataestoq     date;
    data_saldoini date;

BEGIN

    SETOR := $2;
    PRODUTO := $1;
    DATAESTOQ := $3;

 -- PEGA SALDO INICIAL

    SELECT sal_data, sal_qtde INTO DATA_SALDOINI, SALDOINI
      FROM saldo
     WHERE pro_codigo = PRODUTO
       AND set_codigo = SETOR
       AND sal_data  <= DATAESTOQ
     ORDER BY sal_data DESC LIMIT 1;

    if SALDOINI      is null then SALDOINI := 0; end if;  
    if DATA_SALDOINI is null then DATA_SALDOINI := '01-01-2006'; end if;

 -- CALCULAR AS ENTRADAS

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
       AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_ENTRADA = SETOR
       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
       AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;
     RAISE NOTICE 'ENTRADAS=(%), SETOR=(%), DATA_SALDOINI=(%), DATAESTOQ=(%)', ENTRADAS, SETOR, DATA_SALDOINI, DATAESTOQ;    
 -- CALCULAR AS SAIDAS

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE       
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_SAIDA = SETOR
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA > DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;

    RAISE NOTICE 'SALDOINI = (%), ENTRADAS = (%), SAIDAS = (%)', SALDOINI, ENTRADAS, SAIDAS;    
    SALDOFINAL := SALDOINI + ENTRADAS - SAIDAS;

    if saldofinal is null then saldofinal:=0;
    end if;  
       
    RETURN SALDOFINAL;
END; $_$;


--
-- TOC entry 1153 (class 1255 OID 17240832)
-- Name: calcula_estoque4(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_estoque4(bigint, bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    PRODUTO       alias for $1;
    SETOR         alias for $2;
    DATAESTOQ     alias for $3;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    data_saldoini date;

BEGIN

-- calcula o saldo inicial do individuo (produto)   
    --DATA_SALDOINI := '01-01-2006';
    SELECT MIN(MOV_DATA) INTO DATA_SALDOINI
    FROM MOVIMENTO, ITENS_MOVIMENTO
    WHERE MOVIMENTO.MOV_CODIGO = ITENS_MOVIMENTO.MOV_CODIGO
    AND   PRO_CODIGO = PRODUTO
    AND   SET_ENTRADA = SETOR;

 -- CALCULAR AS ENTRADAS

    RAISE NOTICE 'Setor: %', SETOR;
    RAISE NOTICE 'Dataini: %', DATA_SALDOINI; 

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'E')
       --AND   IT.ITE_CONSOLIDADO = 'S'
       AND   IT.PRO_CODIGO = PRODUTO
       AND   MOV_DATA >= DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE
	       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
	       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
	       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
	       AND   MOV.SET_ENTRADA = SETOR
	       AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
	       --AND   IT.ITE_CONSOLIDADO = 'S'
	       AND   IT.PRO_CODIGO = PRODUTO
	       AND   MOV_DATA >= DATA_SALDOINI
	       AND   MOV_DATA <= DATAESTOQ;
    END IF;
    
 -- CALCULAR AS SAIDAS

    IF SETOR = 0 THEN 
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   (MOV_TIPO = 'S')
       AND   IT.PRO_CODIGO = PRODUTO    
       --AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA >= DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    ELSE       
       SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
       FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
       WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
       AND   MOV.SET_SAIDA = SETOR
       AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
       AND   IT.PRO_CODIGO = PRODUTO    
       --AND   IT.ITE_CONSOLIDADO = 'S'    
       AND   MOV_DATA >= DATA_SALDOINI
       AND   MOV_DATA <= DATAESTOQ;
    END IF;
    
    SALDOFINAL := ENTRADAS - SAIDAS;
    RAISE NOTICE 'Entradas: %', ENTRADAS;
    RAISE NOTICE 'Saidas: %', SAIDAS;
    RAISE NOTICE 'SaldoFinal: %', SALDOFINAL	;

    if saldofinal is null then saldofinal:=0;
    end if;  
    
    if saldofinal < 0 then saldofinal:=0;
    end if;  
       
    RETURN SALDOFINAL;
END; $_$;


--
-- TOC entry 1154 (class 1255 OID 17240833)
-- Name: calcula_estoque_lote(bigint, bigint, date, character varying); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_estoque_lote(bigint, bigint, date, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    produto       integer := 0;
    setor         integer := 0;
    dataestoq     date;
    data_saldoini date;
    LOTE          varchar(20);

BEGIN


    SETOR := $2;
    PRODUTO := $1;
    DATAESTOQ := $3;
    lote := $4;
    
-- calcula o saldo inicial do individuo (produto)    
    SELECT MIN(MOV_DATA) INTO DATA_SALDOINI
    FROM MOVIMENTO, ITENS_MOVIMENTO
    WHERE MOVIMENTO.MOV_CODIGO = ITENS_MOVIMENTO.MOV_CODIGO
    AND   PRO_CODIGO = PRODUTO
    AND   SET_ENTRADA = SETOR;

    
    SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
    FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
    WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
    AND   MOV.SET_ENTRADA = SETOR
    AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
    AND   IT.ITE_CONSOLIDADO = 'S'
    AND   IT.PRO_CODIGO = PRODUTO
    AND   MOV_DATA >= DATA_SALDOINI -- (por Renato) coloquei o >= ao invÃ©s de >
    AND   MOV_DATA <= DATAESTOQ
    AND   ITE_LOTE = LOTE;

    
    
 -- CALCULAR AS SAIDAS
    SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
    FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
    WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
    AND   MOV.SET_SAIDA = SETOR
    AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
    AND   IT.PRO_CODIGO = PRODUTO    
    AND   IT.ITE_CONSOLIDADO = 'S'    
    AND   MOV_DATA >= DATA_SALDOINI -- (por Renato) coloquei o >= ao invÃ©s de >

    AND   MOV_DATA <= DATAESTOQ
    AND   ITE_LOTE = LOTE;
   
    
    SALDOFINAL := ENTRADAS - SAIDAS;
      
       
    RETURN SALDOFINAL;
END; $_$;


--
-- TOC entry 1155 (class 1255 OID 17240834)
-- Name: calcula_estoque_lote_validade(bigint, bigint, date, character varying, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_estoque_lote_validade(bigint, bigint, date, character varying, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;    
    entradas      numeric := 0;        
    saidas        numeric := 0;        
    produto       integer := 0;
    setor         integer := 0;
    dataestoq     date;
    data_saldoini date;
    LOTE          varchar(20);
    validade      date;

BEGIN
    SETOR := $2;
    PRODUTO := $1;
    DATAESTOQ := $3;
    lote := $4;
    validade := $5;
    
-- calcula o saldo inicial do individuo (produto)    
    SELECT MIN(MOV_DATA) INTO DATA_SALDOINI
    FROM MOVIMENTO, ITENS_MOVIMENTO
    WHERE MOVIMENTO.MOV_CODIGO = ITENS_MOVIMENTO.MOV_CODIGO
    AND   PRO_CODIGO = PRODUTO
    AND   SET_ENTRADA = SETOR;

    
    SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO ENTRADAS
    FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
    WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
    AND   MOV.SET_ENTRADA = SETOR
    AND   (MOV_TIPO = 'E' OR MOV_TIPO = 'T')
    AND   IT.ITE_CONSOLIDADO = 'S'
    AND   IT.PRO_CODIGO = PRODUTO
    AND   MOV_DATA >= DATA_SALDOINI -- (por Renato) coloquei o >= ao invÃ©s de >
    AND   MOV_DATA <= DATAESTOQ
    AND   ITE_LOTE = LOTE
    AND   ITE_VALIDADE = VALIDADE;

    
    
 -- CALCULAR AS SAIDAS
    SELECT COALESCE(SUM(ITE_QUANTIDADE),0) INTO SAIDAS
    FROM MOVIMENTO AS MOV, ITENS_MOVIMENTO AS IT
    WHERE MOV.MOV_CODIGO = IT.MOV_CODIGO
    AND   MOV.SET_SAIDA = SETOR
    AND   (MOV_TIPO = 'S' OR MOV_TIPO = 'T')
    AND   IT.PRO_CODIGO = PRODUTO    
    AND   IT.ITE_CONSOLIDADO = 'S'    
    AND   MOV_DATA >= DATA_SALDOINI -- (por Renato) coloquei o >= ao invÃ©s de >

    AND   MOV_DATA <= DATAESTOQ
    AND   ITE_LOTE = LOTE
    AND   ITE_VALIDADE = VALIDADE;
   
    
    SALDOFINAL := ENTRADAS - SAIDAS;
      
       
    RETURN SALDOFINAL;
END; $_$;


--
-- TOC entry 1156 (class 1255 OID 17240835)
-- Name: calcula_idade(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_idade(bigint) RETURNS bigint
    LANGUAGE sql
    AS $_$select cast(trunc((date(now()) - usu_datanasc)/365.5) as int8)
 from usuario
 where usu_codigo = $1$_$;


--
-- TOC entry 1157 (class 1255 OID 17240836)
-- Name: calcula_preco(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_preco(bigint, bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row RECORD;
    PRODUTO       alias for $1;
    SETOR         alias for $2;
    DATAPRECO     alias for $3;
    sld_dta_ini   date;
    sld_qtd_ini   numeric := 0;
    sld_custo     numeric := 0;
    precomedio    numeric := 0;
    estoque       numeric := 0;
    divisao       numeric := 0;
    conta         integer := 0;

BEGIN

    SELECT sal_data, sal_qtde, sal_custo INTO sld_dta_ini, sld_qtd_ini, sld_custo
      FROM saldo
     WHERE pro_codigo = PRODUTO
       AND set_codigo = SETOR
       AND sal_custo  > 0
     ORDER BY sal_data DESC LIMIT 1;

    estoque    := sld_qtd_ini;
    precomedio := sld_custo;

    FOR row IN SELECT * 
                 FROM v_movimentacao
                WHERE mov_data   > sld_dta_ini - 1
                  AND pro_codigo = produto
                  AND codsetor   = setor
                ORDER BY mov_data, mov_tipo
       LOOP

       IF row.mov_tipo = 'E' THEN
          IF row.sinal = '+' THEN
             divisao := estoque + row.ite_quantidade;
          ELSE
             divisao := estoque - row.ite_quantidade;
          END IF;
          precomedio := ((estoque * precomedio) + (row.ite_quantidade * row.ite_vlrunit)) / divisao;
       END IF;
       IF row.sinal = '+' THEN
          estoque := estoque + row.ite_quantidade;
       ELSE
          estoque := estoque - row.ite_quantidade;
       END IF;

       SELECT COUNT(*) INTO CONTA
         FROM PRECOMEDIO
        WHERE PRO_CODIGO = row.pro_codigo
          AND PRM_DATA   = row.mov_data
          AND SET_CODIGO = row.codsetor;

       IF CONTA = 0 THEN
          INSERT INTO PRECOMEDIO (PRO_CODIGO, SET_CODIGO, PRM_DATA, PRM_CUSTO)
                                VALUES (row.pro_codigo, row.codsetor, row.mov_data, precomedio);
       ELSE
          UPDATE PRECOMEDIO
             SET prm_custo  = precomedio
           WHERE PRO_CODIGO = row.pro_codigo
             AND PRM_DATA   = row.mov_data
             AND SET_CODIGO = row.codsetor;
       END IF;
    END LOOP;

    IF (precomedio = 0  OR precomedio is null) THEN precomedio := sld_custo;
    END IF;  

    RETURN PRECOMEDIO;
END; $_$;


--
-- TOC entry 1158 (class 1255 OID 17240837)
-- Name: calcula_precoteste(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION calcula_precoteste(bigint, bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    row     RECORD;
    PRODUTO       alias for $1;
    SETOR         alias for $2;
    DATAPRECO     alias for $3;
    sld_dta_ini   date;
    sld_qtd_ini   numeric := 0;
    sld_custo     numeric := 0;
    precomedio    numeric := 0;
    estoque       numeric := 0;
    divisao       numeric := 0;
    conta         integer := 0;

BEGIN

    SELECT sal_data, sal_qtde, sal_custo INTO sld_dta_ini, sld_qtd_ini, sld_custo
      FROM saldo
     WHERE pro_codigo = PRODUTO
       AND set_codigo = SETOR
       AND sal_custo  > 0
       AND sal_data   < DATAPRECO
     ORDER BY sal_data DESC LIMIT 1;

    estoque    := sld_qtd_ini;
    precomedio := sld_custo;

    FOR row IN SELECT * 
                 FROM v_movimentacao
                WHERE mov_data   > sld_dta_ini - 1
                  AND pro_codigo = produto
                  AND codsetor   = setor
                ORDER BY mov_data, mov_tipo
       LOOP

       IF row.mov_tipo = 'E' THEN
          IF row.sinal = '+' THEN
             divisao := estoque + row.ite_quantidade;
          ELSE
             divisao := estoque - row.ite_quantidade;
          END IF;
          precomedio := ((estoque * precomedio) + (row.ite_quantidade * row.ite_vlrunit)) / divisao;
       END IF;
       IF row.sinal = '+' THEN
          estoque := estoque + row.ite_quantidade;

          SELECT COUNT(*) INTO CONTA
            FROM PRECOMEDIO
           WHERE PRO_CODIGO = row.pro_codigo
             AND PRM_DATA   = row.mov_data
             AND SET_CODIGO = row.codsetor;

          IF CONTA = 0 THEN
             INSERT INTO PRECOMEDIO (PRO_CODIGO, SET_CODIGO, PRM_DATA, PRM_CUSTO)
                                   VALUES (row.pro_codigo, row.codsetor, row.mov_data, precomedio);
          ELSE
             UPDATE PRECOMEDIO
                SET prm_custo  = precomedio
              WHERE PRO_CODIGO = row.pro_codigo
                AND PRM_DATA   = row.mov_data
                AND SET_CODIGO = row.codsetor;
          END IF;
       ELSE
          estoque := estoque - row.ite_quantidade;
       END IF;
    END LOOP;

    IF (precomedio = 0  OR precomedio is null) THEN precomedio := sld_custo;
    END IF;  

    RETURN PRECOMEDIO;
END; $_$;


--
-- TOC entry 1160 (class 1255 OID 17240838)
-- Name: carga_agendamento(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION carga_agendamento() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
     row          Record;
     varCount     numeric := 0;
     varInclui    integer := 0;
     varNaoInclui Integer := 0;
BEGIN
   FOR row IN select * from APUCARANA.AGENDAMENTO2006   
       	     WHERE APUCARANA.AGENDAMENTO2006.age_data < '30-10-2006' LOOP
       select count(age_codigo) into varCount from agendamento where age_codigo = row.age_codigo;
       if varCount = 0 then 
	  INSERT INTO AGENDAMENTO (age_codigo, age_data, med_codigo, age_hora, usu_codigo, age_tipo, age_atendido, age_paciente, uni_codigo, age_item, age_status, esp_codigo, age_valor_proc, agt_codigo)
          values (row.age_codigo, row.age_data, row.med_codigo, row.age_hora, row.usu_codigo, row.age_tipo, row.age_atendido, row.age_paciente, row.uni_codigo,  
	           row.age_item, row.age_status, row.esp_codigo, row.age_valor_proc, row.agt_codigo)
          ;
   varInclui    := varInclui    + 1; 
       end if;
   END LOOP;
  RETURN varInclui;
END;
$$;


--
-- TOC entry 1161 (class 1255 OID 17240839)
-- Name: carga_usuario(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION carga_usuario() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
     row          Record;
     varCount     numeric := 0;
     varInclui    integer := 0;
     varNaoInclui Integer := 0;

BEGIN
   FOR row IN select * from apucarana.usuario_novo   LOOP
       select count(usu_codigo) into varCount from usuario where usu_codigo = row.usu_codigo;
       if varCount = 0 then
          insert into usuario   ( usu_codigo , usu_nome,  fam_codigo,  usu_observacao, usu_sexo,  usu_datanasc,
					cid_codigo_nasc, usu_dt_entrada_pais,ecd_codigo,usu_sit_familiar,usu_ocupacao,
					usu_pis_pasep,usu_cpf,usu_cartao_p_sus,usu_cartao_sus,usu_tipo_certidao,
					usu_cert_cartorio,usu_cert_livro,usu_cert_lv_fls,usu_cert_termo,usu_cert_emissao,
					usu_rg,usu_rg_compl,uf_codigo_rg,usu_rg_emissor,usu_rg_dt_emissao,usu_ctps,
					usu_ctps_serie,uf_codigo_ctps,usu_ctps_dt_emissao,usu_tit_eleitor,usu_tit_eleitor_zona,
					usu_tit_eleitor_secao,usu_mae,usu_pai,usu_cisvir,usu_end_rua,usu_end_nr,
					usu_end_compl,usu_end_bairro,usu_end_cep,usu_end_cidade,usu_cidade_nasc,
					usu_fone,usu_celular,usu_same,usu_prontuario,uni_origem,uni_unidade
				      ) 
		       ( select usu_codigo , usu_nome,  fam_codigo,  usu_observacao, usu_sexo,  usu_datanasc,
				cid_codigo_nasc, usu_dt_entrada_pais,ecd_codigo,usu_sit_familiar,usu_ocupacao,
				usu_pis_pasep,usu_cpf,usu_cartao_p_sus,usu_cartao_sus,usu_tipo_certidao,
				usu_cert_cartorio,usu_cert_livro,usu_cert_lv_fls,usu_cert_termo,usu_cert_emissao,
				usu_rg,usu_rg_compl,uf_codigo_rg,usu_rg_emissor,usu_rg_dt_emissao,usu_ctps,
				usu_ctps_serie,uf_codigo_ctps,usu_ctps_dt_emissao,usu_tit_eleitor,usu_tit_eleitor_zona,
				usu_tit_eleitor_secao,usu_mae,usu_pai,usu_cisvir,usu_end_rua,usu_end_nr,
				usu_end_compl,usu_end_bairro,usu_end_cep,usu_end_cidade,usu_cidade_nasc,
				usu_fone,usu_celular,usu_same,usu_prontuario,uni_origem,uni_unidade
		           from apucarana.usuario_novo where usu_codigo = row.usu_codigo
                       );
          varInclui    := varInclui    + 1;
       else
          update usuario                
			set     usu_observacao = row.usu_observacao,
				usu_cartao_sus = row.usu_cartao_sus,
				usu_cisvir = row.usu_cisvir,
				usu_end_rua = row.usu_end_rua,
				usu_end_nr  = row.usu_end_nr,
				usu_end_compl = row.usu_end_compl,
				usu_end_bairro = row.usu_end_bairro,
				usu_end_cep = row.usu_end_cep,
				usu_end_cidade = row.usu_end_cidade,
				usu_cidade_nasc = row.usu_cidade_nasc,
				usu_fone = row.usu_fone,
				usu_celular = row.usu_celular,
				usu_same = row.usu_same,
				usu_prontuario = row.usu_prontuario,
				uni_origem = row.uni_origem,
				uni_unidade = row.uni_unidade
          where  usu_codigo = row.usu_codigo;
         varNaoInclui := varNaoInclui + 1;
       end if;
   END LOOP;
  RETURN varInclui;
END;
$$;


--
-- TOC entry 1162 (class 1255 OID 17240840)
-- Name: consolidapath(bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION consolidapath(bigint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$ 
DECLARE
    row   RECORD;
    SETOR          integer;
    MostraResult   varchar;
    TotAlter       integer:=0;
    SldNoDia       numeric:=0;
    SldHoje        numeric:=0;
    DataConsolida  date;

BEGIN
    SETOR := $1;
    DataConsolida := $2;
    
    FOR row IN SELECT * 
                 FROM movimento, itens_movimento 
                WHERE movimento.mov_codigo = itens_movimento.mov_codigo
                  AND mov_tipo        = 'S'
                  AND set_saida       = SETOR
                  AND ite_consolidado = 'N'
                  AND mov_data        = DataConsolida
                ORDER BY movimento.mov_codigo, itens_movimento.ite_codigo
      LOOP
       select calcula_estoque(row.pro_codigo,row.set_saida,row.mov_data) into  SldNoDia;
       select calcula_estoque(row.pro_codigo,row.set_saida,DATE(NOW()))  into  SldHoje;
       RAISE NOTICE 'ite_codigo=(%), SldNoDia=(%), SldHoje=(%), Saida=(%)',row.ite_codigo, SldNoDia, SldHoje, row.ite_quantidade;
       IF (SldNoDia >= row.ite_quantidade) and (SldHoje >= row.ite_quantidade)
          THEN
              update itens_movimento set ite_consolidado = 'S' where ite_codigo = row.ite_codigo;
              TotAlter= TotAlter + 1;
              select calcula_estoque(row.pro_codigo,row.set_saida,row.mov_data) into  SldNoDia;
              RAISE NOTICE 'FIZ--> Prod=(%),QtdMov=(%),SaldoNoDia=(%)', row.pro_codigo, row.ite_quantidade, SldNoDia;
       END IF;
    END LOOP;
    return TotAlter;
END;
$_$;


--
-- TOC entry 1163 (class 1255 OID 17240841)
-- Name: converte_horarios_agenda_profissional(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION converte_horarios_agenda_profissional() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
	rec RECORD;
	rec2 RECORD;
	condi_age_codigo_dia INTEGER;
	coni_codigo_dia INTEGER;
BEGIN
	FOR rec IN 
		-- Percorrendo os dias de convênio da tabela convenio_dias_semana e migrando os dados para a convenio_dias_semana_agendamento
		SELECT DISTINCT 
			condi.condi_dia AS condi_age_dia, 
			condi.coni_codigo AS coni_codigo,
			coni.coni_cota_dia AS condi_age_cota_dia,
			coni.coni_encaixe AS condi_age_encaixe,
			coni.coni_intervalo AS condi_age_intervalo
		FROM 
			convenio_dias_semana AS condi
		INNER JOIN 
			convenio_horarios AS convh ON condi.coni_codigo=convh.coni_codigo
		INNER JOIN
			convenio_itens AS coni ON condi.coni_codigo=coni.coni_codigo
		INNER JOIN
			convenio AS conv ON coni.conv_codigo=conv.conv_codigo
	LOOP
		-- Inserindo os novos dias de convênio
		INSERT INTO convenio_dias_semana_agendamento
						(condi_age_dia,
						 coni_codigo,
						 condi_age_cota_dia,
						 condi_age_encaixe,
						 condi_age_intervalo)
					VALUES
						(rec.condi_age_dia,
						 rec.coni_codigo,
						 rec.condi_age_cota_dia,
						 rec.condi_age_encaixe,
						 rec.condi_age_intervalo);
		 -- Pegando o código do último registro inserido para realizar os vinculos com os horários
		 SELECT condi_age_codigo INTO condi_age_codigo_dia FROM convenio_dias_semana_agendamento ORDER BY condi_age_codigo DESC LIMIT 1; 
		 SELECT coni_codigo INTO coni_codigo_dia FROM convenio_dias_semana_agendamento ORDER BY condi_age_codigo DESC LIMIT 1; 
		 -- Listando os horários antigos e inserindo os mesmos mas já vinculando com os dias de agendamento
		 FOR rec2 IN 
			SELECT 
				hora_codigo,
				hora_inicial,
				hora_final
			FROM
				convenio_horarios
			WHERE
				coni_codigo = coni_codigo_dia AND
				condi_age_codigo IS NULL
		LOOP
			-- Inserindo os horários vinculado ao dia de atendimento
			INSERT INTO convenio_horarios
							(hora_inicial,
							 hora_final,
							 coni_codigo,
							 condi_age_codigo)
						VALUES
							(rec2.hora_inicial,
							 rec2.hora_final,
							 coni_codigo_dia,
							 condi_age_codigo_dia);
		END LOOP;
	END LOOP;
END
$$;


--
-- TOC entry 1164 (class 1255 OID 17240842)
-- Name: converte_instituicoes_unidade(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION converte_instituicoes_unidade() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
	rec RECORD;
	cod INTEGER;	-- codigo da ultima ocorrencia
	
BEGIN
	
	FOR rec IN
		SELECT *
		  FROM instituicoes
		 ORDER BY cod_ins
	LOOP	
		INSERT INTO unidade (uni_desc,
				     uni_endereco,
				     uni_responsavel,
				     uni_tipo,
				     uni_numero,
				     uni_cep,
				     uni_codigo_ibge,
				     cod_ins)
		              VALUES(rec.nome,
				     rec.logradouro || ', ' || rec.bairro,
				     rec.responsavel,
				     'U',
				     rec.numero,
				     rec.cep,
				     (select cid_codigo_ibge from cidade where cid_codigo = rec.cid_codigo),
				     rec.cod_ins);
		              
	END LOOP;
	drop table instituicoes;
END
$$;


--
-- TOC entry 1165 (class 1255 OID 17240843)
-- Name: converte_procedimentos_odonto(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION converte_procedimentos_odonto() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
	rec RECORD;
	rec2 RECORD;
	cod INTEGER;	-- codigo da ultima ocorrencia
	next_odo_trat INTEGER;
	cod_ate INTEGER;
	next_odo_pcon INTEGER;
	codigo_od INTEGER;
	
BEGIN
	
	FOR rec IN
		SELECT distinct age_codigo,
		       od_data,
		       od_datafinal
		  FROM odonto
		 ORDER BY age_codigo
	LOOP	

		SELECT ate_codigo INTO cod_ate FROM atendimento WHERE age_codigo = rec.age_codigo;
		SELECT od_codigo INTO codigo_od FROM odonto WHERE age_codigo = rec.age_codigo LIMIT 1;
		next_odo_trat = (SELECT nextval('odonto_tratamento_odo_trat_codigo_seq') as odo);
		IF cod_ate IS NOT NULL THEN
			INSERT INTO odonto_tratamento (odo_trat_codigo,
							   odo_trat_dtinicial,
							   odo_trat_dtfinal,
							   ate_codigo_origem,
							   odo_trat_status)
							   VALUES (next_odo_trat,
							   rec.od_data,
							   rec.od_datafinal,
							   cod_ate,
							   'F');
							   
			next_odo_pcon = (SELECT nextval('odonto_procedimentos_controle_odo_pcon_codigo_seq') as odo);
				INSERT INTO odonto_procedimentos_controle (odo_pcon_codigo,
								   odo_trat_codigo,
								   ate_codigo)
								VALUES(next_odo_pcon,
									   next_odo_trat,
									   cod_ate);
			FOR rec2 IN
			  SELECT od_codigo,
					 od_hist_data,
					 dente_num,
					 dente_face,
					 dente_situacao,
					 dente_anotacao,
					 od_finalizado
				FROM odonto_historico
			   WHERE od_codigo = codigo_od
			   --ORDER BY age_codigo
			LOOP
			  IF rec2.dente_situacao <> '4' THEN 
				  INSERT INTO odonto_procedimentos_realizados (odo_pcon_codigo,
										   proc_codigo,
										   odo_preal_dentenum,
										   odo_preal_denteface,
										   odo_preal_denteanot,
										   odo_preal_dtcadastro)
									VALUES (next_odo_pcon,
										(CASE WHEN rec2.dente_situacao = '1' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010023')
											  WHEN rec2.dente_situacao = '2' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010023')
											  WHEN rec2.dente_situacao = '3' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010023')
											  WHEN rec2.dente_situacao = '5' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0414020120')
											  WHEN rec2.dente_situacao = '6' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0414020120')
											  WHEN rec2.dente_situacao = '7' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0101020066')
											  WHEN rec2.dente_situacao = '8' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0101020066')
											  WHEN rec2.dente_situacao = '9' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010015')
											  WHEN rec2.dente_situacao = '10' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010015')
											  WHEN rec2.dente_situacao = '11' THEN (select proc_codigo from procedimento where proc_codigo_sus = '0307010015')
										  END ),
										  rec2.dente_num,
										  REPLACE(rec2.dente_face, ';', ''),
										  rec2.dente_anotacao,
										  rec2.od_hist_data);

			  END IF;
			END LOOP;
		END IF;
	END LOOP;
END
$$;


--
-- TOC entry 1166 (class 1255 OID 17240844)
-- Name: difference(text, text); Type: FUNCTION; Schema: social; Owner: -
--
/*
CREATE OR REPLACE FUNCTION difference(text, text) RETURNS integer
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'difference';


--
-- TOC entry 1167 (class 1255 OID 17240845)
-- Name: dmetaphone(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION dmetaphone(text) RETURNS text
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'dmetaphone';


--
-- TOC entry 1168 (class 1255 OID 17240846)
-- Name: dmetaphone_alt(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION dmetaphone_alt(text) RETURNS text
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'dmetaphone_alt';
*/

--
-- TOC entry 1216 (class 1255 OID 21644174)
-- Name: esus_atendimento_individual(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION esus_atendimento_individual() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
	linha RECORD;
	eai_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM esus_atendimento_individual WHERE ate_codigo = OLD.ate_codigo;
		RETURN OLD;
	ELSE
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				age.tat_codigo AS eai_tipo_atendimento,
				tbl.co_local_atend,
				usr.cnes_cod_cns AS eai_profissional_cns,
				esp.cod_cbo AS eai_cbo_codigo_2002,
				uni.uni_cnes AS eai_cnes,
				ate.ate_data AS eai_dtatendimento,
				uni.uni_codigo_ibge AS eai_codigo_ibge_mun,
				usu.usu_cartao_sus AS eai_num_cartao_sus,
				usu.usu_datanasc AS eai_dtnascimento,
				usu.usu_prontuario AS eai_numprontuario, 
				usu.usu_sexo
			FROM 
				atendimento AS ate
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
			INNER JOIN
				rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo=rlai.ate_codigo
			INNER JOIN 
				rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo=rlaic.ate_codigo
			WHERE 
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validação de sexo
			IF (linha.usu_sexo='M') THEN 
				eai_sexo = '0 L';
			ELSE
				eai_sexo = '1 L';
			END IF;
			-- Realiza a inserção dos da ficha de procedimento do E-SUS
			INSERT INTO esus_atendimento_individual(
				ate_codigo,
				co_local_atend,
				eai_profissional_cns,
				eai_cbo_codigo_2002,
				eai_cnes,
				eai_dtatendimento,
				eai_codigo_ibge_mun,
				eai_dtnascimento,
				eai_num_cartao_sus,
				eai_numprontuario,
				eai_tipo_atendimento,
				eai_sexo,
				eai_tipo_dado_serializado
			) VALUES (
				linha.ate_codigo,
				linha.co_local_atend,
				linha.eai_profissional_cns,
				linha.eai_cbo_codigo_2002,
				linha.eai_cnes,
				linha.eai_dtatendimento,
				linha.eai_codigo_ibge_mun,
				linha.eai_dtnascimento,
				linha.eai_num_cartao_sus,
				linha.eai_numprontuario,
				linha.eai_tipo_atendimento,
				eai_sexo,
				'4 L'
			);
			RETURN NEW;
			RAISE NOTICE 'Registro inserido com sucesso''.';
		END LOOP;
	END IF;	
	RETURN NULL;
END;
$$;


--
-- TOC entry 1214 (class 1255 OID 21644095)
-- Name: esus_atividade_coletiva(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION esus_atividade_coletiva() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
linha RECORD;
BEGIN
	FOR linha IN
		SELECT
			tb_fav.co_cds_ficha_ativ_col, 
			tb_fav.dt_ativ_col AS eav_dt_atividade,
			tb_fav.qt_participante_programado AS eav_num_participantes_prog,
			tb_fav.qt_participante_ativ AS eav_num_participantes,
			tb_fav.ds_local_ativ AS eav_local_atividade,
			tb_fav.hr_inicio AS eav_hora_inicio,
			tb_fav.hr_fim AS eav_hora_fim,
			usr.cnes_cod_cns AS eav_responsavel_cns,
			uni.uni_cnes AS eav_uni_cnes,
			tb_fav.cod_equipe_ine AS eav_responsavel_ine,
			tb_fav.cod_cnes_unidade AS eav_responsavel_cnes,
			tb_fav.qt_avaliacao_alterada AS eav_num_aval_alteradas,
			tb_fav.tp_cds_ativ_col AS eav_atividade_tipo,
			uni.uni_codigo_ibge AS eav_codigo_ibge,
			tb_fav.co_inep_escola AS eav_inep
		FROM 
			tb_cds_ficha_ativ_col AS tb_fav
		INNER JOIN
			usuarios AS usr ON tb_fav.usr_codigo=usr.usr_codigo
		INNER JOIN
			unidade AS uni ON tb_fav.uni_codigo=uni.uni_codigo
		WHERE 
			tb_fav.co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col	LOOP

		IF (TG_OP='INSERT') THEN
			IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN				
				INSERT INTO esus_atividade_coletiva(
					co_cds_ficha_ativ_col,
					eav_dt_atividade,
					eav_num_participantes_prog,
					eav_num_participantes,
					eav_local_atividade,
					eav_hora_inicio,
					eav_hora_fim,
					eav_responsavel_cns,
					eav_responsavel_cnes,
					eav_responsavel_ine,
					eav_num_aval_alteradas,
					eav_atividade_tipo,
					eav_codigo_ibge,
					eav_inep,
					eav_uni_cnes
				) VALUES (
					linha.co_cds_ficha_ativ_col,
					linha.eav_dt_atividade,
					linha.eav_num_participantes_prog,
					linha.eav_num_participantes,
					linha.eav_local_atividade,
					linha.eav_hora_inicio,
					linha.eav_hora_fim,
					linha.eav_responsavel_cns,
					linha.eav_responsavel_cnes,
					linha.eav_responsavel_ine,
					linha.eav_num_aval_alteradas,
					linha.eav_atividade_tipo,
					linha.eav_codigo_ibge,
					linha.eav_inep,
					linha.eav_uni_cnes
				);
				RETURN NEW;
			END IF;
		ELSE 
			IF linha.co_cds_ficha_ativ_col IS NOT NULL THEN				
				UPDATE esus_atividade_coletiva 
					SET	co_cds_ficha_ativ_col = linha.co_cds_ficha_ativ_col,
						eav_dt_atividade = linha.eav_dt_atividade,
						eav_num_participantes_prog = linha.eav_num_participantes_prog,
						eav_num_participantes = linha.eav_num_participantes,
						eav_local_atividade = linha.eav_local_atividade,
						eav_hora_inicio = linha.eav_hora_inicio,
						eav_hora_fim = linha.eav_hora_fim,
						eav_responsavel_cns = linha.eav_responsavel_cns,
						eav_responsavel_cnes  = linha.eav_responsavel_cnes,
						eav_responsavel_ine  = linha.eav_responsavel_ine,
						eav_num_aval_alteradas = linha.eav_num_aval_alteradas,
						eav_atividade_tipo = linha.eav_atividade_tipo,
						eav_codigo_ibge = linha.eav_codigo_ibge,
						eav_inep = linha.eav_inep,
						eav_uni_cnes = linha.eav_uni_cnes
				WHERE 
					co_cds_ficha_ativ_col=NEW.co_cds_ficha_ativ_col;
				RETURN NEW;
			END IF;
		END IF;
	END LOOP;
RETURN NULL;
END;
$$;


--
-- TOC entry 1220 (class 1255 OID 21644192)
-- Name: esus_cadastro_individual(); Type: FUNCTION; Schema: social; Owner: -
--


CREATE OR REPLACE FUNCTION social.esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE 
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN 
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';				 
	ELSE
		FOR linha IN 
			SELECT 
				usu.usu_codigo, 
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM 
				usuario AS usu
			INNER JOIN 
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
			INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
			LEFT JOIN 
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo 
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN
													
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua,
						uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						NOW(),
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua,
						(select uuid_ficha 
						 from esus_cadastro_individual 
						 where usu_codigo = linha.usu_codigo
						 order by eci_codigo asc 
						 limit 1));	
								
						RAISE NOTICE 'UPDATE''.';
					 
				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
						(usu_codigo,
						eci_usr_cnes,
						eci_usr_profissional_cns,
						eci_usr_codigo_ibge,
						eci_usr_dtatendimento,
						eci_usu_codigo_ibge,
						eci_usu_dtnascimento,
						eci_usu_nacionalidade,
						eci_usu_nome,
						eci_usu_mae,
						eci_usu_raca,
						eci_usu_sexo,
						eci_usu_escola,
						eci_usu_deficiencia,
						eci_usu_cns,
						eci_tipo_dado_serializado,
						eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
						linha.eci_cnes,
						linha.eci_usr_cns,
						linha.eci_usr_codigo_ibge,
						NOW(),
						linha.eci_usu_codigo_ibge,
						linha.eci_usu_dtnascimento,
						eci_nacionalidade,
						linha.eci_usu_nome,
						linha.eci_usu_mae,
						eci_raca,
						eci_sexo,
						linha.eci_usu_escola,
						linha.eci_usu_deficiencia,
						linha.eci_usu_cns,
						'2 L',
						linha.eci_usu_sit_rua);
				END IF;				
			END LOOP;
		RAISE NOTICE 'INSERT''.';				 
	END IF;
	RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

--
-- TOC entry 1211 (class 1255 OID 21643911)
-- Name: esus_ficha_procedimentos(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION esus_ficha_procedimentos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
	-- Dados do Atendimento
	linha_ate RECORD;
	-- Dados da Pré-Consulta
	linha_pc RECORD;
	efp_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		--RAISE NOTICE '1111111111''.',OLD.pat_codigo;
		DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
		RETURN OLD;
	ELSE
		IF ((SELECT usr_tipo_medico FROM usuarios WHERE usr_codigo = NEW.usr_codigo) <> 'D') THEN
		-- Valida se o procedimento está vindo do Atendimento ou da Pré-Consulta
			IF (NEW.ate_codigo IS NOT NULL) THEN
			FOR linha_ate IN
				SELECT 
					ate.age_codigo,
					pat.pat_codigo,
					pat.proc_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS efp_profissional_cns,
					esp.cod_cbo AS efp_cbo_codigo_2002,
					uni.uni_cnes AS efp_cnes,
					tbe.nu_ine AS efp_ine,
					ate.ate_data AS efp_dtatendimento,
					uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
					usu.usu_cartao_sus AS efp_num_cartao_sus,
					usu.usu_datanasc AS efp_dtnascimento,
					usu.usu_prontuario AS efp_numprontuario, 
					usu.usu_sexo
				FROM 
					procedimento_atendimento AS pat 
				INNER JOIN 
					atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
				INNER JOIN 
					agendamento AS age ON ate.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON ate.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON ate.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
				INNER JOIN 
					tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
				WHERE 
					pat.pat_codigo = NEW.pat_codigo LOOP
					
				IF (linha_ate.age_codigo IS NOT NULL AND linha_ate.proc_codigo IS NOT NULL AND linha_ate.co_local_atend IS NOT NULL AND linha_ate.efp_profissional_cns IS NOT NULL AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL AND linha_ate.efp_cnes IS NOT NULL AND linha_ate.efp_codigo_ibge_mun IS NOT NULL AND linha_ate.efp_dtnascimento IS NOT NULL) THEN			
					-- Validação de sexo
					IF (linha_ate.usu_sexo='M') THEN 
						efp_sexo = '0 L';
					ELSE
						efp_sexo = '1 L';
					END IF;
					-- Realiza a inserção dos da ficha de procedimento do E-SUS
					INSERT INTO esus_ficha_procedimento(
						age_codigo,
						pat_codigo,
						proc_codigo,
						co_local_atend,
						efp_profissional_cns,
						efp_cbo_codigo_2002,
						efp_cnes,
						efp_ine,
						efp_dtatendimento,
						efp_codigo_ibge_mun,
						efp_num_cartao_sus,
						efp_dtnascimento,
						efp_numprontuario,
						efp_sexo,
						efp_tipo_dado_serializado,
						efp_dtcadastro
					) VALUES (
						linha_ate.age_codigo,
						linha_ate.pat_codigo,
						linha_ate.proc_codigo,
						linha_ate.co_local_atend,
						linha_ate.efp_profissional_cns,
						linha_ate.efp_cbo_codigo_2002,
						linha_ate.efp_cnes,
						linha_ate.efp_ine,
						linha_ate.efp_dtatendimento,
						linha_ate.efp_codigo_ibge_mun,
						linha_ate.efp_num_cartao_sus,
						linha_ate.efp_dtnascimento,
						linha_ate.efp_numprontuario,
						efp_sexo,
						'7 L',
						'NOW()'
					);
					RETURN NEW;
					RAISE NOTICE 'Registro inserido com sucesso''.';
				END IF;	
			END LOOP;
		END IF;
			IF (NEW.pc_codigo IS NOT NULL) THEN

		
			--RAISE NOTICE '1111111111''.';
			FOR linha_pc IN
				SELECT 
					pc.age_codigo,
					pat.pat_codigo,
					pat.proc_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS efp_profissional_cns,
					esp.cod_cbo AS efp_cbo_codigo_2002,
					uni.uni_cnes AS efp_cnes,
					tbe.nu_ine AS efp_ine,
					pc.pc_data AS efp_dtatendimento,
					uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
					usu.usu_cartao_sus AS efp_num_cartao_sus,
					usu.usu_datanasc AS efp_dtnascimento,
					usu.usu_prontuario AS efp_numprontuario, 
					usu.usu_sexo
				FROM 
					procedimento_atendimento AS pat 
				INNER JOIN 
					pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
				INNER JOIN 
					agendamento AS age ON pc.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON age.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON age.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
				INNER JOIN 
					tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
				WHERE 
					pat.pat_codigo = NEW.pat_codigo LOOP
				
				IF (linha_pc.age_codigo IS NOT NULL AND linha_pc.proc_codigo IS NOT NULL AND linha_pc.co_local_atend IS NOT NULL AND linha_pc.efp_profissional_cns IS NOT NULL AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL AND linha_pc.efp_cnes IS NOT NULL AND linha_pc.efp_codigo_ibge_mun IS NOT NULL AND linha_pc.efp_dtnascimento IS NOT NULL) THEN
					-- Validação de sexo
					IF (linha_pc.usu_sexo='M') THEN 
						efp_sexo = '0 L';
					ELSE
						efp_sexo = '1 L';
					END IF;
					-- Realiza a inserção dos da ficha de procedimento do E-SUS
					INSERT INTO esus_ficha_procedimento(
						age_codigo,
						pat_codigo,
						proc_codigo,
						co_local_atend,
						efp_profissional_cns,
						efp_cbo_codigo_2002,
						efp_cnes,
						efp_ine,
						efp_dtatendimento,
						efp_codigo_ibge_mun,
						efp_num_cartao_sus,
						efp_dtnascimento,
						efp_sexo,
						efp_tipo_dado_serializado,
						efp_numprontuario,
						efp_dtcadastro
					) VALUES (
						linha_pc.age_codigo,
						linha_pc.pat_codigo,
						linha_pc.proc_codigo,
						linha_pc.co_local_atend,
						linha_pc.efp_profissional_cns,
						linha_pc.efp_cbo_codigo_2002,
						linha_pc.efp_cnes,
						linha_pc.efp_ine,
						linha_pc.efp_dtatendimento,
						linha_pc.efp_codigo_ibge_mun,
						linha_pc.efp_num_cartao_sus,
						linha_pc.efp_dtnascimento,
						efp_sexo,
						'7 L',
						linha_pc.efp_numprontuario,
						'NOW()'
					);
					RETURN NEW;
					RAISE NOTICE 'Registro inserido com sucesso''.';
				END IF;
			END LOOP;
		END IF;

		END IF;
	END IF;	
	RETURN NULL;
END;
$$;


--
-- TOC entry 1217 (class 1255 OID 21644154)
-- Name: esus_odonto(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION esus_odonto() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
	linha RECORD;
	eo_sexo character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM esus_odonto WHERE eo_codigo = OLD.eo_codigo;
		RETURN OLD;
	ELSE
		FOR linha IN
			SELECT DISTINCT
				odpc.odo_pcon_codigo,
				tbl.co_local_atend,
				usr.cnes_cod_cns AS eo_profissional_cns,
				esp.cod_cbo AS eo_cbo_codigo_2002,
				uni.uni_cnes AS eo_cnes,
				ate.ate_data AS eo_dtatendimento,
				uni.uni_codigo_ibge AS eo_codigo_ibge_mun,
				usu.usu_datanasc AS eo_dtnascimento,
				usu.usu_cartao_sus AS eo_num_cartao_sus,	
				usu.usu_prontuario AS eo_numprontuario,
				age.tat_codigo AS eo_tipo_atendimento,
				age.tp_cod AS eo_tipo_consulta,					
				usu.usu_sexo					
			FROM 
				odonto_procedimentos_controle AS odpc 
			INNER JOIN 
				atendimento AS ate ON odpc.ate_codigo=ate.ate_codigo
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
			WHERE 
				odpc.odo_pcon_codigo = NEW.odo_pcon_codigo LOOP
			-- Validação de sexo
			IF (linha.usu_sexo='M') THEN 
				eo_sexo = '0 L';
			ELSE
				eo_sexo = '1 L';
			END IF;
			-- Realiza a inserção dos da ficha de procedimento do E-SUS
			INSERT INTO esus_odonto(
				odo_pcon_codigo,
				co_local_atend,
				eo_profissional_cns,
				eo_cbo_codigo_2002,
				eo_cnes,
				eo_dtatendimento,
				eo_codigo_ibge_mun,
				eo_dtnascimento,
				eo_num_cartao_sus,
				eo_numprontuario,
				eo_tipo_atendimento,
				eo_tipo_consulta,
				eo_sexo,
				eo_tipo_dado_serializado
			) VALUES (
				linha.odo_pcon_codigo,
				linha.co_local_atend,
				linha.eo_profissional_cns,
				linha.eo_cbo_codigo_2002,
				linha.eo_cnes,
				linha.eo_dtatendimento,
				linha.eo_codigo_ibge_mun,
				linha.eo_dtnascimento,
				linha.eo_num_cartao_sus,
				linha.eo_numprontuario,
				linha.eo_tipo_atendimento,
				linha.eo_tipo_consulta,
				eo_sexo,
				'5 L'
			);
			RETURN NEW;
			RAISE NOTICE 'Registro inserido com sucesso''.';
		END LOOP;
	END IF;	
	RETURN NULL;
END;
$$;


--
-- TOC entry 1213 (class 1255 OID 21644080)
-- Name: esus_visita_domiciliar(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION esus_visita_domiciliar() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	linha RECORD;
	esv_sexo character varying(20);
	esv_desfecho character varying(20);
BEGIN 
	IF (TG_OP='INSERT') THEN
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				ate.ate_data,
				usr.cnes_cod_cns AS esv_profissional_cns,
				esp.cod_cbo AS esv_cbo_codigo_2002,
				uni.uni_cnes AS esv_cnes,
				uni.uni_codigo_ibge AS esv_codigo_ibge_mun,
				usu.usu_cartao_sus AS esv_usu_cns,
				usu.usu_datanasc AS esv_usu_datanasc,
				usu.usu_prontuario AS esv_num_prontuario, 
				usu.usu_sexo AS usu_sexo,
				tbvd.co_cds_visita_dom_desfecho AS desfecho,
				tbvd.co_seq_cds_visita_domiciliar AS co_cds_visita_domiciliar
			FROM 
				atendimento AS ate 
			INNER JOIN 
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN 
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN 
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN 
				tb_cds_visita_domiciliar AS tbvd ON ate.ate_codigo=tbvd.ate_codigo
			INNER JOIN 
				tb_cds_visita_dom_desfecho AS tbvdd ON tbvd.co_cds_visita_dom_desfecho=tbvdd.co_cds_visita_dom_desfecho
			WHERE 
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validação Sexo
			IF (linha.usu_sexo='M') THEN esv_sexo = '0 L'; ELSE esv_sexo = '1 L'; END IF; 
			-- Validação Desfecho
			IF (linha.desfecho='1') THEN esv_desfecho = '1 L'; END IF;
			IF (linha.desfecho='2') THEN esv_desfecho = '2 L'; END IF;
			IF (linha.desfecho='3') THEN esv_desfecho = '3 L'; END IF;
			-- Valida Inserção
			IF (linha.ate_codigo IS NOT NULL) THEN
				INSERT INTO esus_visita_domiciliar(
					ate_codigo,
					esv_profissional_cns,
					esv_cbo_codigo_2002,
					esv_cnes,
					esv_num_prontuario,
					esv_usu_cns,
					esv_usu_datanasc,
					esv_usu_sexo,
					esv_desfecho,
					co_cds_visita_domiciliar,
					esv_dtatendimento,
					esv_codigo_ibge_mun
				) VALUES (
					linha.ate_codigo,
					linha.esv_profissional_cns,
					linha.esv_cbo_codigo_2002,
					linha.esv_cnes,
					linha.esv_num_prontuario,
					linha.esv_usu_cns,
					linha.esv_usu_datanasc,
					esv_sexo,
					esv_desfecho,
					linha.co_cds_visita_domiciliar,
					linha.ate_data,
					linha.esv_codigo_ibge_mun
				);
				RETURN NEW;
			END IF;
		END LOOP;
	ELSE 
	
	END IF;
	RETURN NULL;
END;
$$;


--
-- TOC entry 1169 (class 1255 OID 17240847)
-- Name: exame_dt_valida(bigint, date, bigint, bigint, character); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION exame_dt_valida(usu bigint, dt date, proc bigint, med bigint, tipo character) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
	total INT8 := 0;
	totalpaciente INT8 := 0;	
	valor NUMERIC := 0;
        valorproc NUMERIC := 0;
        totalproc NUMERIC := 0;
        valortotal NUMERIC := 0;        
	tem_vaga BOOL := false;
	intervalo INT4 := 0;
	dt_aux DATE;
        period DATE;
        codigogem INT8 := 0;
        tipoagend CHAR(1) := 'Q';

BEGIN

        --variavel que guarda o tipo de agendamento do laboratorio
        SELECT med_tipoagendamento INTO tipoagend
        FROM medico
        WHERE med_codigo= med;

	-- // verifica se jah possui um exame desse tipo para esse cliente
	SELECT COUNT(*) INTO total 
	FROM agendamento_exame_lista 
	WHERE usu_codigo = usu AND agexl_data = dt AND proc_codigo = proc
	AND med_codigo = med AND agexl_status NOT IN ('T');
	
	if ( total > 0 ) then
		return 1;
	end if;
	
	if (med = '2165') then
  	    -- // verifica se a data passada eh valida
	    SELECT COUNT(*) INTO total 
	    FROM grade_exame 
	    WHERE graex_data = dt AND proc_codigo = proc AND med_codigo = med;
   	    if ( total = 0 ) then
		return 3;
	    end if;
	end if;
	
	if (med != '2165') then
  	    -- // verifica se a data passada eh valida
	    SELECT COUNT(*) INTO total 
	    FROM grade_exame 
	    WHERE graex_data = dt AND med_codigo = med;
   	    if ( total = 0 ) then
		return 3;
	    end if;
	end if;
	
	
	-- // conta o total dos agendamentos deste procedimento
	SELECT COUNT(*) INTO total
	FROM agendamento_exame_lista 
	WHERE agexl_data = dt AND proc_codigo = proc AND med_codigo = med 
	AND agexl_status NOT IN ('T');

	-- // conta o total de pessoas que apresentam este procedimento
	SELECT COUNT(DISTINCT USU_CODIGO) INTO totalpaciente
	FROM agendamento_exame_lista 
	WHERE agexl_data = dt 
        AND proc_codigo = proc 
        AND med_codigo = med ;



        if( med != '2165' ) then
		SELECT gex_periodo as GEM_periodo,vlr_mensal as gem_valor,gex_codigo as gem_codigo into period, valortotal, codigogem
		FROM grade_exame_mensal 
		WHERE med_codigo = med
		AND dt between gex_periodo and gex_periodo+29;

                SELECT COALESCE(SUM(PRECO_PROCEDIMENTO(PROC_CODIGO)),0) INTO totalproc
                FROM AGENDAMENTO_EXAME_LISTA
                WHERE dt between period and period+29;

                SELECT COALESCE(SUM(PRECO_PROCEDIMENTO(proc)),0) INTO valorproc;

		SELECT ((vlr_mensal - totalproc+valorproc) <= valortotal) INTO tem_vaga 
                FROM grade_exame_mensal
		WHERE gex_codigo = codigogem;

		RAISE NOTICE 'tem_vaga = %', tem_vaga;

		if ( NOT tem_vaga ) then
			return 2;
		end if;
        end if;

	-- // por quantidade de procedimentos
	if ( med = '2165' ) then
		SELECT (total + 1 <= graex_qtde) INTO tem_vaga from grade_exame
			WHERE proc_codigo = proc AND med_codigo = med 
			AND graex_data = dt;
			
		if ( NOT tem_vaga ) then
			return 2;
		end if;
        end if;

        if ( TRIM(tipoagend) = 'P' ) then
		SELECT (totalpaciente + 1 <= graex_qtde) INTO tem_vaga from grade_exame
			WHERE med_codigo = med 
			AND graex_data = dt;
			
		if ( NOT tem_vaga ) then
			return 2;
		end if;
        end if;
		
	return 0;

END;
$$;


--
-- TOC entry 7517 (class 0 OID 0)
-- Dependencies: 1169
-- Name: FUNCTION exame_dt_valida(usu bigint, dt date, proc bigint, med bigint, tipo character); Type: COMMENT; Schema: social; Owner: -
--

COMMENT ON FUNCTION exame_dt_valida(usu bigint, dt date, proc bigint, med bigint, tipo character) IS 'Autor: Dilee
Data: 01/12/2009
Funcao usadas para a validacao do agendamento de exames
return int (tipo do erro) 
 - 0 : OK
 - 1 : O Procedimento já foi cadastrado para este paciente nesta data !
 - 2 : Não há mais vagas para esta data !
 - 3 : A Data escolhida não pode ser reservada
 - 4 : O procedimento possui intervalo minimo nao respeitado entre dois agendamentos';


--
-- TOC entry 1170 (class 1255 OID 17240848)
-- Name: exame_qtde_vagas(date, bigint, bigint, character); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION exame_qtde_vagas(dt date, proc bigint, med bigint, tipo character) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
	resto numeric := 0;
	teste1 INT8 := 0;
	valor NUMERIC := 0;
	total INT8 := 0;
	qtde INT8 := 0;	
	vagas INT8 := 0;		
	totalpaciente INT8 := 0;	
        valorproc NUMERIC := 0;
        totalproc NUMERIC := 0;
        valortotal NUMERIC := 0; 
        vlr_mensal NUMERIC := 0;         
	tem_vaga BOOL := false;
	intervalo INT4 := 0;
	dt_aux DATE;
        period DATE;
        codigogem INT8 := 0;
        tipoagend CHAR(1) := 'Q';

BEGIN

        --variavel que guarda o tipo de agendamento do laboratorio
        SELECT med_tipoagendamento INTO tipoagend
        FROM medico
        WHERE med_codigo= med;

	if (tipoagend = 'Q') then
  	    -- // verifica se a data passada eh valida
	    SELECT COUNT(*) INTO total 
	    FROM grade_exame 
	    WHERE graex_data = dt AND proc_codigo = proc AND med_codigo = med;
   	    if ( total = 0 ) then
		return 0;
	    end if;
	end if;
	
	if (tipoagend = 'V' or tipoagend = 'D' or tipoagend = 'P') then
  	    -- // verifica se a data passada eh valida
	    SELECT COUNT(*) INTO total 
	    FROM grade_exame 
	    WHERE graex_data = dt AND med_codigo = med;
   	    if ( total = 0 ) then
		return 0;
	    end if;
	end if;
	
	
	-- // conta o total dos agendamentos deste procedimento
	SELECT COUNT(*) INTO total
	FROM agendamento_exame_lista 
	WHERE agexl_data = dt AND proc_codigo = proc AND med_codigo = med 
	AND agexl_status NOT IN ('T');

	-- // conta o total de pessoas que apresentam este procedimento
	SELECT COUNT(DISTINCT USU_CODIGO) INTO totalpaciente
	FROM agendamento_exame_lista 
	WHERE agexl_data = dt 
        AND med_codigo = med 
	AND agexl_status NOT IN ('T');

        -- // por valor
	if( med != '2165' ) then
 		SELECT gex_periodo as GEM_periodo,vlr_mensal,gex_codigo as gem_codigo into period, valortotal, codigogem
		FROM grade_exame_mensal 
		WHERE med_codigo = med
		AND dt between gex_periodo and gex_periodo+29;

                SELECT COALESCE(SUM(PRECO_PROCEDIMENTO(PROC_CODIGO)),0) INTO totalproc
                FROM AGENDAMENTO_EXAME_LISTA
                WHERE dt between period and period+29;

                SELECT COALESCE(SUM(PRECO_PROCEDIMENTO(proc)),0) INTO valorproc;

		SELECT ((vlr_mensal - totalproc+valorproc) <= valortotal) INTO tem_vaga 
                FROM grade_exame_mensal
		WHERE gex_codigo = codigogem;

		RAISE NOTICE 'tem_vaga = %', tem_vaga;

		if ( NOT tem_vaga ) then
			return 0;
		end if;
                resto = (totalproc+valorproc - vlr_mensal);
        end if;

	-- // por quantidade de procedimentos
	if ( med = '2165' ) then
                qtde = total;
		SELECT (total <= graex_qtde), (graex_qtde) INTO tem_vaga, vagas from grade_exame
			WHERE proc_codigo = proc AND med_codigo = med 
			AND graex_data = dt;
			
		if ( NOT tem_vaga ) then
			return 0;
		end if;
                resto = vagas - qtde;
        end if;

        if ( TRIM(tipoagend) = 'P' ) then
		SELECT (totalpaciente <= graex_qtde), (graex_qtde) INTO tem_vaga, vagas from grade_exame
			WHERE med_codigo = med 
			AND graex_data = dt;	
		if ( NOT tem_vaga ) then
			return 0;
		end if;
                resto = vagas - (totalpaciente);
        end if;
		
	RETURN resto;
END;
$$;


--
-- TOC entry 7518 (class 0 OID 0)
-- Dependencies: 1170
-- Name: FUNCTION exame_qtde_vagas(dt date, proc bigint, med bigint, tipo character); Type: COMMENT; Schema: social; Owner: -
--

COMMENT ON FUNCTION exame_qtde_vagas(dt date, proc bigint, med bigint, tipo character) IS 'Calcula a quantidade de vagas disponíveis para um exame !';


--
-- TOC entry 1171 (class 1255 OID 17240849)
-- Name: exame_qtde_vagas_agt(date, bigint, bigint, character, bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION exame_qtde_vagas_agt(dt date, proc bigint, med bigint, tipo character, agt bigint) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
	total INT8 := 0;
	resto INT8 := 0;
	teste1 INT8 := 0;
	valor NUMERIC := 0;
BEGIN

	-- conta total de agendamentos
	SELECT COUNT(*) INTO total FROM agendamento_exame_lista 
		WHERE agexl_data = dt AND proc_codigo = proc AND med_codigo = med 
		AND agexl_status NOT IN ('T');

	-- quantidade...
	IF TRIM(tipo) = 'Q' THEN

		SELECT (graex_qtde - total) INTO resto from grade_exame
			WHERE proc_codigo = proc AND med_codigo = med AND agt_codigo = agt
			AND graex_data = dt;
	-- valor
	ELSIF TRIM(tipo) = 'V' THEN
		
		SELECT proc_valor INTO valor FROM procedimento WHERE proc_codigo = proc;
		
		RAISE NOTICE 'VALOR DO PROC = %', valor;
		BEGIN
			SELECT FLOOR((graex_valor - valor * total) / valor) INTO resto FROM grade_exame
				WHERE proc_codigo = proc AND med_codigo = med AND agt_codigo = agt
				AND graex_data = dt;
		EXCEPTION WHEN division_by_zero THEN
			resto := 0;
		END;
	END IF;

	RETURN resto;
END;
$$;


--
-- TOC entry 7519 (class 0 OID 0)
-- Dependencies: 1171
-- Name: FUNCTION exame_qtde_vagas_agt(dt date, proc bigint, med bigint, tipo character, agt bigint); Type: COMMENT; Schema: social; Owner: -
--

COMMENT ON FUNCTION exame_qtde_vagas_agt(dt date, proc bigint, med bigint, tipo character, agt bigint) IS 'Autor: Dudu
Data: 05/04/2007
Calcula a quantidade de vagas disponíveis para um exame !';


--
-- TOC entry 1172 (class 1255 OID 17240850)
-- Name: faixa_etaria(date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION faixa_etaria(dt date) RETURNS integer
    LANGUAGE plpgsql
    AS $$

declare
	resp int := -1;
begin

	if dt is null then return resp; end if;

	SELECT INTO resp

	(CASE WHEN EXTRACT(YEAR FROM age(now(), dt)) <= 1 THEN 0
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 1 AND EXTRACT(YEAR FROM age(now(),dt)) <= 5 THEN 1
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 5 AND EXTRACT(YEAR FROM age(now(),dt)) <= 12 THEN 5
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 12 AND EXTRACT(YEAR FROM age(now(),dt)) <= 19 THEN 12
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 19 AND EXTRACT(YEAR FROM age(now(),dt)) <= 25 THEN 19
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 25 AND EXTRACT(YEAR FROM age(now(),dt)) <= 49 THEN 25
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 49 AND EXTRACT(YEAR FROM age(now(),dt)) <= 65 THEN 49
	WHEN EXTRACT(YEAR FROM age(now(),dt)) > 65 THEN 65 END);

	return resp;
end;
$$;


--
-- TOC entry 1173 (class 1255 OID 17240851)
-- Name: faixa_etaria_str(date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION faixa_etaria_str(dt date) RETURNS character varying
    LANGUAGE plpgsql
    AS $$

declare
	resp int := -1;
begin
	SELECT faixa_etaria( dt ) INTO resp;

	if resp = 0 THEN return '0 a 1 ano'; end if;
	if resp = 1 THEN return '1 a 5 anos'; end if;
	if resp = 5 THEN return '5 a 12 anos'; end if;
	if resp = 12 THEN return '12 a 19 anos'; end if;
	if resp = 19 THEN return '19 a 25 anos'; end if;
	if resp = 25 THEN return '25 a 49 anos'; end if;
	if resp = 49 THEN return '49 a 65 anos'; end if;
	if resp = 65 THEN return 'Acima de 65 anos'; end if;

	return 'SEM IDADE';
end;
$$;


--
-- TOC entry 1229 (class 1255 OID 85503390)
-- Name: gerar_codbarras(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION gerar_codbarras(value bigint) RETURNS bigint
    LANGUAGE plpgsql IMMUTABLE STRICT
    AS $$
DECLARE
l1 int;
l2 int;
r1 int;
r2 int;
i int:=0;
BEGIN
 l1:= (VALUE >> 16) & 65535;
 r1:= VALUE & 65535;
 WHILE i < 3 LOOP
   l2 := r1;
   r2 := l1 # ((((1366.0 * r1 + 150889) % 714025) / 714025.0) * 32767)::int;
   l1 := l2;
   r1 := r2;
   i := i + 1;
 END LOOP;
 RETURN ((l1::bigint << 16) + r1);
END;
$$;


--
-- TOC entry 1209 (class 1255 OID 17240852)
-- Name: get_cod_grupo(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION get_cod_grupo(bigint) RETURNS bigint
    LANGUAGE sql
    AS $_$select gru_codigo from produto where pro_codigo = $1;$_$;


--
-- TOC entry 1174 (class 1255 OID 17240853)
-- Name: get_medico(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION get_medico(bigint) RETURNS character varying
    LANGUAGE sql
    AS $_$select med_nome from medico where med_codigo = $1;$_$;


--
-- TOC entry 1210 (class 1255 OID 17240854)
-- Name: get_nome_grupo(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION get_nome_grupo(bigint) RETURNS character varying
    LANGUAGE sql
    AS $_$select gru_nome from grupo, produto where produto.gru_codigo = grupo.gru_codigo and produto.pro_codigo = $1;$_$;


--
-- TOC entry 1175 (class 1255 OID 17240855)
-- Name: get_produto(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION get_produto(bigint) RETURNS character varying
    LANGUAGE sql
    AS $_$select pro_nome from produto where pro_codigo = $1;$_$;


--
-- TOC entry 1176 (class 1255 OID 17240856)
-- Name: get_setor(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION get_setor(bigint) RETURNS character varying
    LANGUAGE sql
    AS $_$select set_nome from setor where set_codigo = $1;$_$;


--
-- TOC entry 1177 (class 1255 OID 17240857)
-- Name: get_vlr_proced_espec(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION get_vlr_proced_espec(bigint) RETURNS numeric
    LANGUAGE sql
    AS $_$SELECT PROC_VALOR_CUSTO FROM PROCEDIMENTO, ESPECIALIDADE
WHERE PROCEDIMENTO.PROC_CODIGO = ESPECIALIDADE.PROC_CODIGO
AND   ESPECIALIDADE.ESP_CODIGO = $1$_$;


--
-- TOC entry 1228 (class 1255 OID 82187230)
-- Name: historico_data_hora_agendamento(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION historico_data_hora_agendamento() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

IF (TG_OP = 'INSERT') THEN
INSERT INTO historico_data_hora(age_codigo,hdh_agendamento_cadastro) VALUES(NEW.age_codigo,NOW());
IF (NEW.age_atendido = 'S') THEN
UPDATE historico_data_hora SET hdh_agendamento_recepcionado=NOW() WHERE age_codigo=NEW.age_codigo;
END IF;
IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
				UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
END IF;	
ELSIF (TG_OP = 'UPDATE') THEN
IF ((OLD.age_atendido = 'N' AND NEW.age_atendido = 'S') OR (OLD.age_atendido = 'N' AND NEW.age_atendido = 'A') OR (OLD.age_atendido = 'S' AND NEW.age_atendido = 'A') OR (OLD.age_atendido is null AND NEW.age_atendido = 'A')) THEN
UPDATE historico_data_hora SET hdh_agendamento_recepcionado=NOW() WHERE age_codigo=NEW.age_codigo;
	
END IF;
IF (NEW.age_atendido = 'P') THEN
IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
				UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
END IF;
END IF;
END IF;

RETURN NEW;

END
$$;


--
-- TOC entry 1224 (class 1255 OID 82187234)
-- Name: historico_data_hora_atendimento(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION historico_data_hora_atendimento() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

	IF (TG_OP = 'INSERT') THEN
		UPDATE historico_data_hora SET hdh_atendimento_inicio=NOW() WHERE age_codigo=NEW.age_codigo;
		IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
			UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
		END IF;
        ELSIF (TG_OP = 'UPDATE') THEN
		IF (OLD.ate_horafinal is null AND NEW.ate_horafinal is not null AND NEW.ate_horafinal <> '') THEN
			UPDATE historico_data_hora SET hdh_atendimento_fim=NOW() WHERE age_codigo=NEW.age_codigo;
			IF (SELECT TRUE FROM historico_data_hora WHERE hdh_preconsulta_inicio is not null AND hdh_preconsulta_fim IS NULL AND age_codigo=NEW.age_codigo) THEN		
				UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo;
			END IF;	
		END IF;
	END IF;
				
	RETURN NEW;

END
$$;


--
-- TOC entry 1227 (class 1255 OID 82187232)
-- Name: historico_data_hora_pre_consulta(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION historico_data_hora_pre_consulta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

IF (TG_OP = 'INSERT') THEN
UPDATE historico_data_hora SET hdh_preconsulta_inicio=NOW() WHERE age_codigo=NEW.age_codigo;
ELSIF (TG_OP = 'UPDATE') THEN
UPDATE historico_data_hora SET hdh_preconsulta_fim=NOW() WHERE age_codigo=NEW.age_codigo AND hdh_preconsulta_fim IS NULL;
END IF;

RETURN NEW;

END
$$;


--
-- TOC entry 1159 (class 1255 OID 17240858)
-- Name: inventario_precomedio(bigint, bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION inventario_precomedio(bigint, bigint) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$ 
DECLARE
    row   RECORD;
    Cod_Invent_Ini integer;
    Cod_Invent_Fim integer;
    MostraResult   varchar;
    TotAlter       integer:=0;
    Aux            numeric:=0;

BEGIN
    Cod_Invent_Ini := $1;
    Cod_Invent_Fim := $2;
    
FOR row IN Select * From movimento 
            Where mov_tipo = 'E' AND inv_codigo between Cod_Invent_Ini and Cod_Invent_Fim
        LOOP
            RAISE NOTICE '--> Mov=(%)', row.mov_codigo;
            update itens_movimento 
               set ite_vlrunit= verifica_preco(pro_codigo,99405,row.mov_data)
             where mov_codigo=row.mov_codigo;
            TotAlter = TotAlter + 1;
        END LOOP;
    return TotAlter;
END;
$_$;


--
-- TOC entry 1225 (class 1255 OID 17240859)
-- Name: itxtobap(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION itxtobap() RETURNS trigger
    LANGUAGE plpgsql
    AS $$DECLARE
  linha RECORD;
  bpaCodigo bigint;
  ciCodigo bigint;  
BEGIN
	FOR linha IN SELECT a.usu_codigo,
			       ai.med_codigo_coleta,
			       ci.proc_codigo,
			       p.proc_bpa_tipo,
			       p.proc_nome,
			       'P' as itx_urgente,
			       c.col_data_coleta,
			       ai.usr_codigo,
			       c.esp_codigo
			  FROM coleta c
			  join agenda_itens ai
			    on ai.agei_codigo = c.agei_codigo
			  join agenda a 
			    on a.age_codigo = ai.age_codigo
			  join convenio_itens ci
			    on ci.coni_codigo = ai.coni_codigo
			  join procedimento p
			    on p.proc_codigo = ci.proc_codigo
			 WHERE c.col_codigo=NEW.col_codigo LOOP	
		 SELECT ci.ci_codigo FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
				
						-- Buscar se já foi feito um BPA
									
					SELECT bpa_codigo 
					  FROM bpa
					 WHERE bpa_origem = 'coleta'
					   AND bpa_origem_codigo = NEW.col_codigo
					  INTO bpaCodigo;
					  
						IF FOUND THEN					
							-- Atualiza BPA
							UPDATE bpa
							   SET med_codigo  = linha.med_codigo_coleta,
							       usr_codigo  = linha.usr_codigo,
								   usu_codigo  = linha.usu_codigo,
								   bpa_data    = linha.col_data_coleta,
								   proc_codigo = linha.proc_codigo,
								   ci_codigo = ciCodigo,
								   bpa_tipo = linha.proc_bpa_tipo
							 WHERE bpa_codigo = bpaCodigo;
							 RAISE NOTICE 'Um registro na tabela ''bpa'' foi atualizado devido uma alteração na tabela ''coleta''.';
						ELSE						
							-- Se não houver,  cria	   
							INSERT INTO BPA (med_codigo,
								 usr_codigo,
								 usu_codigo,
								 bpa_data,
								 proc_codigo,
								 ci_codigo,
								 bpa_tipo,
							  -- bpa_cd10_codigo, -- NULL
								 bpa_origem,
								 bpa_origem_codigo,
								 esp_codigo)
							VALUES (linha.med_codigo_coleta,
								 linha.usr_codigo,
								 linha.usu_codigo,
								 linha.col_data_coleta,
								 linha.proc_codigo,
								 ciCodigo,
								 linha.proc_bpa_tipo,
							  -- NEW.cd10_codigo,
								 'coleta',
								 NEW.col_codigo,
								 linha.esp_codigo);
							RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma alteração na tabela ''coleta''.';				 
					END IF; -- status
				END LOOP;
	RETURN NEW;

END
$$;


--
-- TOC entry 1179 (class 1255 OID 17240860)
-- Name: itxtobpadel(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION itxtobpadel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		
	BEGIN

		DELETE FROM bpa WHERE bpa_origem='coleta' AND bpa_origem_codigo=OLD.col_codigo;
		RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma exclusão na tabela ''coleta''.';
		RETURN OLD;
		
	END
	$$;


--
-- TOC entry 1180 (class 1255 OID 17240861)
-- Name: laboratorio_calcula_custo_agt(bigint, date, smallint, bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION laboratorio_calcula_custo_agt(med bigint, data_ini date, periodo smallint, agt bigint) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
	row RECORD;
	row_proc RECORD;
	r NUMERIC(9,2) := 0;
	valor NUMERIC(9,2) := 0;
	periodo_ini DATE;

BEGIN
	-- calcula o periodo que a data se encontra
	SELECT MAX(gem_periodo) INTO periodo_ini FROM grade_exame_mensal_manut 
		WHERE med_codigo = med AND agt_codigo = agt AND gem_periodo <= data_ini;

	RAISE NOTICE 'periodo=(%)',periodo_ini;

	-- percorre todas as ocorrencias em grade_exame deste med_codigo neste periodo
	FOR row IN 
	SELECT ge.graex_data, ge.graex_valor, ge.graex_qtde, p.proc_codigo, p.med_codigo
	FROM grade_exame AS ge
	INNER JOIN laboratorio_procedimento AS p ON ( p.proc_codigo = ge.proc_codigo AND p.med_codigo = ge.med_codigo )
	WHERE ge.med_codigo = med AND agt_codigo = agt AND graex_data BETWEEN periodo_ini AND periodo_ini + periodo LOOP

		-- fetching o procedimento
		SELECT proc_tipo, COALESCE(proc_valor,0) AS proc_valor INTO row_proc FROM laboratorio_procedimento 
		NATURAL JOIN procedimento
		WHERE proc_codigo = row.proc_codigo AND med_codigo = med;
		
		RAISE NOTICE 'row.proc_codigo=(%), valor=(%),tipo=(%), data=(%)',
			row.proc_codigo, row_proc.proc_valor, row_proc.proc_tipo,row.graex_data;	
	
		IF UPPER(TRIM(row_proc.proc_tipo)) = 'Q' THEN
			--RAISE NOTICE 'if tipo = quantidade, proc=(%), qtde=(%)', row.proc_codigo, row.graex_qtde;
			r := r + row.graex_qtde * row_proc.proc_valor;
		ELSE
			--RAISE NOTICE 'if tipo = valor, proc=(%), qtde=(%)', row.proc_codigo, row.graex_qtde;
			r := r + row.graex_valor;
		END IF;
		
	END LOOP;

	return r;

END;
$$;


--
-- TOC entry 7522 (class 0 OID 0)
-- Dependencies: 1180
-- Name: FUNCTION laboratorio_calcula_custo_agt(med bigint, data_ini date, periodo smallint, agt bigint); Type: COMMENT; Schema: social; Owner: -
--

COMMENT ON FUNCTION laboratorio_calcula_custo_agt(med bigint, data_ini date, periodo smallint, agt bigint) IS 'Autor: Dudu
Data: 04/04/2007
Descricao: Calcula todo o custo de um laboratorio num determinado periodo.
Ele busca o periodo aproximado, onde a data_ini se encontra, e se soma toda a grade (tanto para tipo Q ou V)';


--
-- TOC entry 1181 (class 1255 OID 17240862)
-- Name: levenshtein(text, text); Type: FUNCTION; Schema: social; Owner: -
--
/*
CREATE OR REPLACE FUNCTION levenshtein(text, text) RETURNS integer
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'levenshtein';


--
-- TOC entry 1182 (class 1255 OID 17240863)
-- Name: levenshtein(text, text, integer, integer, integer); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION levenshtein(text, text, integer, integer, integer) RETURNS integer
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'levenshtein_with_costs';
*/

--
-- TOC entry 1133 (class 1255 OID 25395715)
-- Name: limpa_cns(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION limpa_cns(stexto text) RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	stextonovo text;
BEGIN
	stextonovo := translate(stexto,'.','');
	RETURN stextonovo;
END;
$$;


--
-- TOC entry 1193 (class 1255 OID 21643885)
-- Name: limpa_cpf(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION limpa_cpf(stexto text) RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
  stextonovo TEXT;
BEGIN
  stextonovo := translate(stexto, '-','');       
  stextonovo := translate(stextonovo, '.','');
  RETURN stextonovo;
END;
$$;


--
-- TOC entry 1183 (class 1255 OID 17240864)
-- Name: limpa_logon(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION limpa_logon() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	DELETE FROM logon WHERE id_login = NEW.id_login;
	RETURN NEW;
END
$$;


--
-- TOC entry 1184 (class 1255 OID 17240865)
-- Name: limpa_permissoes(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION limpa_permissoes() RETURNS void
    LANGUAGE plpgsql
    AS $$

DECLARE
	rec RECORD;
	cod INTEGER;	-- codigo da ultima ocorrencia
	st TEXT;

BEGIN


	PERFORM backup_tabela( 'usuarios_permissoes' );

	-- verifica quais ocorrencias tem mais de 2 registros
	FOR rec IN
		SELECT usr_codigo, perm_codigo --, COUNT(perm_codigo)
		FROM usuarios_permissoes
		GROUP BY usr_codigo, perm_codigo
		HAVING COUNT(perm_codigo) >= 2
	LOOP
				
		-- seleciona a ultima ocorrencia deste registro, e apaga as anteriores
		SELECT INTO cod MAX(perus_codigo) 
			FROM usuarios_permissoes 
			WHERE usr_codigo = rec.usr_codigo AND perm_codigo = rec.perm_codigo;
		
		st := 'DELETE FROM usuarios_permissoes ' ||
			'WHERE usr_codigo = ' || rec.usr_codigo ||
			' AND perm_codigo = ' || rec.perm_codigo ||
			' AND perus_codigo <> ' || cod;
		
		--RAISE NOTICE 'sql: %', st;

		EXECUTE st;


	END LOOP;
END
$$;


--
-- TOC entry 1185 (class 1255 OID 17240866)
-- Name: limpa_programas(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION limpa_programas() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
	-- codigos repetidos
	cods INT[] := ARRAY[ [45,142], [138,140], [144,152], [33,102], [24,122] ] ;
	-- tamanho
	cods_t INT := 4;

	i INT := 1;
	rec RECORD;

	p1 RECORD;
	p2 RECORD;

	/* TESTES

	SELECT perm_programa, COUNT(perm_programa)
	FROM permissoes AS sp
	GROUP BY perm_programa
	HAVING COUNT(perm_programa) >= 2
	ORDER BY 2 DESC;

	SELECT * FROM permissoes WHERE perm_codigo in (45,142,138,140,144,152,33,102,24,122);
	*/


BEGIN
	WHILE ( i <= cods_t ) LOOP

		RAISE NOTICE '(EXTERNO) PROCURANDO por ( %, % )', cods[i][1], cods[i][2];

		-- VERIFICANDO QUAIS USUARIOS POSSUEM ESTAS PERMISSOES...
		FOR rec IN 
			SELECT DISTINCT usr_codigo 
			FROM usuarios_permissoes WHERE perm_codigo IN ( cods[i][1], cods[i][2] )
		LOOP

		
			SELECT INTO p1 * FROM usuarios_permissoes 
				WHERE perm_codigo = cods[i][1] AND usr_codigo = rec.usr_codigo;

			SELECT INTO p2 * FROM usuarios_permissoes 
				WHERE perm_codigo = cods[i][2] AND usr_codigo = rec.usr_codigo;


			RAISE NOTICE 'usuario [ % ] com permissoes ( %, % ), pks ( %, % )', 
				rec.usr_codigo, cods[i][1], cods[i][2], p1.perus_codigo, p2.perus_codigo;

			-- fazendo o merge --
			
			-- quando o p2 for nulo, e o p1 nao for nulo,"copiar" para p1
			-- AMBOS NUNCA SERAO NULOS, POIS ENTRARAM NO LOOP, NEH MESMO ?

			IF( p2.perus_codigo IS NULL AND p1.perus_codigo IS NOT NULL ) THEN

				RAISE NOTICE 'atualizando p1 ( % ) para prog ( % )', p1.perus_codigo, cods[i][2];
				UPDATE usuarios_permissoes  SET perm_codigo = cods[i][2]
					WHERE perus_codigo = p1.perus_codigo;
				
			END IF;

			-- o 'p1' soh vai morrer quando ambos existirem 
			-- (vamos pegar a ocorrencia mais recente)
			IF( p1.perus_codigo IS NOT NULL AND p2.perus_codigo IS NOT NULL ) THEN
				RAISE NOTICE 'apagando o p1 ( % )', p1.perus_codigo;
				DELETE FROM usuarios_permissoes WHERE perus_codigo = p1.perus_codigo;
			END IF;
		
		END LOOP;

		i := i + 1;

	END LOOP;


	PERFORM backup_tabela( 'permissoes' );

	RAISE NOTICE 'apagando as permissoes duplicadas { %, %, %, %, % } !', cods[1][1], cods[2][1], cods[3][1], cods[4][1], cods[5][1];
	
	DELETE FROM permissoes WHERE perm_codigo IN ( cods[1][1], cods[2][1], cods[3][1], cods[4][1], cods[5][1] );
	-- CRIANDO CONTRAINT !
	--ALTER TABLE permissoes ADD CONSTRAINT saude_usuarios_permissoes_cte_uniq UNIQUE( perm_programa );
END
$$;


--
-- TOC entry 1186 (class 1255 OID 17240867)
-- Name: metaphone(text, integer); Type: FUNCTION; Schema: social; Owner: -
--
/*
CREATE OR REPLACE FUNCTION metaphone(text, integer) RETURNS text
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'metaphone';
*/

--
-- TOC entry 1215 (class 1255 OID 21644135)
-- Name: migra_bairro_para_logradouro(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION migra_bairro_para_logradouro() RETURNS numeric
    LANGUAGE plpgsql
    AS $$ 
DECLARE
    row   RECORD;
    linhas bigint;
BEGIN

    linhas = 0; 
    FOR row IN 
          SELECT * FROM domicilio
           
       LOOP
	       update rua set bai_codigo = row.bai_codigo where rua_codigo = row.rua_codigo;
		linhas = linhas + 1;
    END LOOP;
    return linhas;
END;
$$;


--
-- TOC entry 1187 (class 1255 OID 17240868)
-- Name: migra_schema(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION migra_schema() RETURNS void
    LANGUAGE plpgsql
    AS $$
	declare
		r RECORD;
		sql TEXT;
	begin
		for r in select * from information_schema.tables where table_schema in ('acaosocial', 'common', 'public', 'guiche') order by table_schema, table_name 
		loop
			sql = 'alter table ' || r.table_schema || '.' || r.table_name || ' set schema saude ';
			execute sql;
		end loop;
	end
$$;


--
-- TOC entry 1188 (class 1255 OID 17240869)
-- Name: migra_sequences_common(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION migra_sequences_common() RETURNS void
    LANGUAGE plpgsql
    AS $$
	declare
		r RECORD;
		sql TEXT;
	begin
		for r in select column_default,
				table_name, 
				table_schema, 
				column_name,'nextval(('''||
				substring(column_default from 18 for position('::text' in column_default) - 19) || '''::text)::regclass)'  as novo
			   from information_schema.columns 
			  where column_default like '%common%' 

		loop
			sql ='ALTER TABLE ' || r.table_name || ' ALTER COLUMN ' || r.column_name || ' SET DEFAULT ' || r.novo;
			execute sql;
		end loop;
	end
$$;


--
-- TOC entry 1178 (class 1255 OID 17240870)
-- Name: migra_sequences_saude(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION migra_sequences_saude() RETURNS void
    LANGUAGE plpgsql
    AS $$
	declare
		r RECORD;
		sql TEXT;
	begin
		for r in select column_default,
				table_name, 
				table_schema, 
				column_name,'nextval(('''||
				substring(column_default from 17 for position('::text' in column_default) - 18) || '''::text)::regclass)'  as novo
			   from information_schema.columns 
			  where column_default like '%saude%' 

		loop
			sql ='ALTER TABLE ' || r.table_name || ' ALTER COLUMN ' || r.column_name || ' SET DEFAULT ' || r.novo;
			execute sql;
		end loop;
	end
$$;


--
-- TOC entry 1189 (class 1255 OID 74775747)
-- Name: movimentodatainsercao(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION movimentodatainsercao() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    
BEGIN

	NEW.mov_data_insercao = NOW();
				
	RETURN NEW;

END
$$;


--
-- TOC entry 1223 (class 1255 OID 17240871)
-- Name: operacoesiitensmovimentohorus(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION operacoesiitensmovimentohorus() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
linha RECORD;
tpxml character(1);
ite_validade date;
ite_vlrunit character varying(20);
ite_lote character varying(20);
tpmov character varying(20);
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM horus_dados WHERE hor_dad_origem = 'itensmovimento' AND hor_dad_origem_codigo = OLD.ite_codigo;
		RETURN OLD;	
	ELSE
		FOR linha IN
			SELECT 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				mov.set_entrada,
				mov.set_saida,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				count(ite.ite_codigo) AS num_registros,
				uni.uni_cnes
			FROM 
				itens_movimento AS ite
			INNER JOIN
				movimento AS mov ON ite.mov_codigo=mov.mov_codigo 
			INNER JOIN 
				produto AS pro ON ite.pro_codigo=pro.pro_codigo
			INNER JOIN 
				setor AS set ON mov.set_entrada=set.set_codigo OR mov.set_saida=set.set_codigo
			INNER JOIN 
				unidade AS uni ON set.uni_codigo=uni.uni_codigo
			WHERE 
				pro.pro_horus IS NOT NULL AND
				mov.mov_tipo IS NOT NULL AND
				mov.mov_saida IS NOT NULL AND
				pro.pro_codigo IS NOT NULL AND
				ite.ite_quantidade IS NOT NULL AND
				uni.uni_cnes IS NOT NULL AND
				ite.ite_codigo = NEW.ite_codigo 
			GROUP BY 
				mov.mov_data,
				mov.mov_tipo, 
				mov.mov_saida,
				mov.mov_entrada,
				mov.set_entrada,
				mov.set_saida,
				pro.pro_codigo,
				pro.pro_horus,
				ite.ite_vlrunit,
				ite.ite_validade,
				ite.ite_lote,
				ite.ite_quantidade,
				ite.ite_codigo,
				uni.uni_cnes LOOP

				RAISE NOTICE 'ite_vlrunit: %.', NEW.ite_vlrunit;
					
				IF (linha.num_registros > 0) THEN
					-- Validando Campo Lote
					IF (linha.ite_lote IS NULL) THEN
						ite_lote = '0';
					ELSE
						ite_lote = linha.ite_lote;
					END IF;
					-- Validando Valor do Item
					IF (linha.ite_vlrunit IS NULL) THEN
						ite_vlrunit = '0.0000';
					ELSE
						ite_vlrunit = linha.ite_vlrunit;
					END IF;
					-- Validando item da validade
					IF (linha.ite_validade IS NULL) THEN 
						ite_validade = (SELECT((DATE_PART('DAY', CURRENT_DATE)||'/'||DATE_PART('MONTH', CURRENT_DATE)||'/'||DATE_PART('YEAR', CURRENT_DATE))::DATE + interval '3 year')::DATE);
					ELSE
						ite_validade = linha.ite_validade;
					END IF;
					-- Valida tipo de XML(tpxml)
					IF (linha.mov_tipo <> 'T') THEN
						IF (linha.mov_tipo = 'S' AND linha.mov_saida = 'D') THEN 
							tpxml = 'D';
							tpmov = 'D'; 
						END IF;
						IF (linha.mov_tipo = 'S' AND linha.mov_saida <> 'D' ) THEN 
							tpxml = linha.mov_tipo;
							tpmov = linha.mov_saida; 
						END IF;
						IF (linha.mov_tipo = 'E') THEN 
							tpxml = linha.mov_tipo;
							tpmov = linha.mov_entrada; 
						END IF;
						-- Insert 
						IF (TG_OP = 'INSERT') THEN
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										(tpxml,'F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0',tpmov,NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
							RETURN NEW;
						END IF;
					ELSE 
						-- Insert 
						IF (TG_OP = 'INSERT') THEN
						
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										('E','F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0','E-AE',NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
										
							INSERT 	INTO horus_dados 
										(hor_dad_tpxml, hor_dad_status_envio, hor_dad_counidadecnes, hor_dad_nuproduto, hor_dad_tpproduto, hor_dad_vlitem, hor_dad_dtvalidade, hor_dad_nulote, hor_dad_qtd, hor_dad_nucnspaciente, hor_dad_tpmovimentacao, hor_dad_dtcadastro, hor_dad_origem, hor_dad_origem_codigo,hor_dad_dtrecebimentoprod)
									VALUES
										('S','F',linha.uni_cnes,linha.pro_horus,'B',ite_vlrunit,ite_validade,ite_lote,linha.ite_quantidade,'0','S-AE',NOW(),'itensmovimento',linha.ite_codigo,linha.mov_data);
							RETURN NEW;
						END IF;
					END IF;
					-- Update
					IF (TG_OP = 'UPDATE') THEN
						UPDATE horus_dados 
						   SET hor_dad_tpxml = tpxml, 
							   hor_dad_counidadecnes = linha.uni_cnes, 
							   hor_dad_nuproduto = linha.pro_horus, 
							   hor_dad_tpproduto = 'B', 
							   hor_dad_vlitem = linha.ite_vlrunit, 
							   hor_dad_dtvalidade = ite_validade, 
							   hor_dad_nulote = ite_lote, 
							   hor_dad_qtd = linha.ite_quantidade, 
							   hor_dad_nucnspaciente = '0', 
							   hor_dad_tpmovimentacao = tpmov, 
							   hor_dad_dtcadastro = NOW(), 
							   hor_dad_origem = 'itensmovimento', 
							   hor_dad_origem_codigo = linha.ite_codigo
						WHERE
							   hor_dad_origem = 'itensmovimento' AND 
							   hor_dad_origem_codigo = NEW.ite_codigo;
						RETURN NEW;	
					END IF;
				END IF;
		END LOOP;
	END IF;
	RETURN NULL;
END;
$$;


--
-- TOC entry 1194 (class 1255 OID 17240872)
-- Name: operacoesodontobpa(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION operacoesodontobpa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
linha RECORD;
ciCodigo bigint;  
BEGIN
	IF (TG_OP = 'DELETE') THEN
		DELETE FROM bpa WHERE bpa_origem = 'odontograma' AND bpa_origem_codigo = OLD.odo_preal_codigo;
		RETURN OLD;
		-- Procedimento e BPA excluido com sucesso
	ELSE 
		FOR linha IN	
		SELECT 
			odpr.odo_preal_codigo,
			odpr.odo_preal_dtcadastro,
			proc.proc_codigo,
			proc.proc_bpa_tipo,
			ate.uni_codigo,
			ate.med_codigo,
			ate.usu_codigo,
			age.esp_codigo
		FROM 
			odonto_procedimentos_realizados AS odpr
		INNER JOIN 
			procedimento AS proc ON odpr.proc_codigo = proc.proc_codigo
		INNER JOIN 
			odonto_procedimentos_controle AS odpc ON odpr.odo_pcon_codigo = odpc.odo_pcon_codigo
		INNER JOIN
			atendimento AS ate ON odpc.ate_codigo = ate.ate_codigo
		INNER JOIN agendamento AS age
					ON age.age_codigo = ate.age_codigo
		WHERE 
			odpr.odo_preal_codigo = NEW.odo_preal_codigo  LOOP
			-- Operação de Insert
			
			SELECT ci.ci_cod FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
			
			IF (TG_OP = 'INSERT') THEN
				INSERT 	INTO bpa
							(bpa_data, uni_codigo,usr_codigo,usu_codigo,proc_codigo,ci_codigo,bpa_tipo,bpa_origem,bpa_origem_codigo,bpa_ativo,bpa_data_alt,esp_codigo)
						VALUES
							(linha.odo_preal_dtcadastro,linha.uni_codigo,linha.med_codigo,linha.usu_codigo,linha.proc_codigo,ciCodigo,linha.proc_bpa_tipo,'odontograma',linha.odo_preal_codigo,'t',linha.odo_preal_dtcadastro,linha.esp_codigo);
				RETURN NEW;
				-- Procedimento e BPA inserido com sucesso!
			END IF;
			-- Operação de Update
			IF (TG_OP = 'UPDATE') THEN
				UPDATE bpa
					SET 
						uni_codigo = linha.uni_codigo,
						usr_codigo = linha.med_codigo,
						usu_codigo = linha.usu_codigo,
						proc_codigo = linha.proc_codigo,
						ci_codigo = ciCodigo,
						bpa_tipo = linha.proc_bpa_tipo,
						bpa_origem = 'odontograma',
						bpa_origem_codigo = linha.odo_preal_codigo,
						bpa_ativo = 't',
						bpa_data_alt = linha.odo_preal_dtcadastro,
						esp_codigo = linha.esp_codigo
					WHERE
						bpa_origem = 'odontograma' AND
						bpa_origem_codigo = linha.odo_preal_codigo;
				RETURN NEW;
				-- Procedimento e BPA atualizado com sucesso!
			END IF;
		END LOOP;
	END IF;
END
$$;


--
-- TOC entry 1221 (class 1255 OID 17240873)
-- Name: pattobpa(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION pattobpa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  linha RECORD;
  ciCodigo bigint;  
    
BEGIN

	FOR linha IN SELECT ate.usu_codigo,
					    ate.ate_data, 
					    ate.med_codigo,
					    ate.uni_codigo,
					    ate.ate_acidentetrab,
					    proc.proc_bpa_tipo,
					    age.esp_codigo
				   FROM procedimento_atendimento AS pat
				   JOIN atendimento AS ate
				     ON ate.ate_codigo=pat.ate_codigo
				   JOIN procedimento AS proc
				     ON proc.proc_codigo=pat.proc_codigo
				  JOIN agendamento age
				     ON age.age_codigo=ate.age_codigo
				  WHERE pat_codigo=NEW.pat_codigo LOOP
				
						-- verificar acidente de trabalho
						SELECT ci.ci_cod FROM ci WHERE ci_descricao='Eletivo' AND ci_ativo='S' INTO ciCodigo;
					
						IF (TG_OP = 'INSERT') THEN
						
							INSERT INTO BPA (uni_codigo,
											 usr_codigo,
											 usu_codigo,
											 bpa_data,
											 proc_codigo,
											 ci_codigo,
											 bpa_tipo,
											 bpa_cd10_codigo,
											 bpa_origem,
											 bpa_origem_codigo,
											 esp_codigo)
									 VALUES (linha.uni_codigo,
											 linha.med_codigo,
											 linha.usu_codigo,
											 linha.ate_data,
											 NEW.proc_codigo,
											 ciCodigo,
											 linha.proc_bpa_tipo,
											 NEW.cd10_codigo,
											 'procedimento_atendimento',
											 NEW.pat_codigo,
											 linha.esp_codigo);	
						END IF;
						IF (TG_OP = 'UPDATE') THEN
							UPDATE bpa SET uni_codigo = linha.uni_codigo,
								 usr_codigo = linha.med_codigo,
								 usu_codigo = linha.usu_codigo,
								 bpa_data = linha.ate_data,
								 proc_codigo =NEW.proc_codigo ,
								 ci_codigo = ciCodigo,
								 bpa_tipo = linha.proc_bpa_tipo,
								 bpa_cd10_codigo = COALESCE(NEW.cd10_codigo,NULL),
								 bpa_origem = 'procedimento_atendimento',
								 bpa_origem_codigo = NEW.pat_codigo,
								 esp_codigo = linha.esp_codigo
							   WHERE bpa_origem_codigo=NEW.pat_codigo;

						END IF;
					
					END LOOP;
						
						
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi gerado devido uma inserção na tabela ''procedimento_atendimento''.';
				
	RETURN NEW;

END
$$;


--
-- TOC entry 1190 (class 1255 OID 17240874)
-- Name: pattobpadel(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION pattobpadel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    
BEGIN

	DELETE FROM bpa WHERE bpa_origem='procedimento_atendimento' AND bpa_origem_codigo=OLD.pat_codigo;
	RAISE NOTICE 'Um registro na tabela ''bpa'' foi deletado devido uma exclusão na tabela ''procedimento_atendimento''.';
	RETURN OLD;

END
$$;


--
-- TOC entry 1191 (class 1255 OID 17240875)
-- Name: persisteestoque(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION persisteestoque() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	vmov_tipo	character(1);
	vset_entrada	bigint;
	vset_saida	bigint;
	vsal_codigo	bigint;
	vpro_codigo	bigint;
	vset_codigo	bigint;
	vsal_data	date;
	vsal_qtde	integer;
	vsal_dose	integer;
	vpro_custo	numeric(9,4);
	vsal_lote	character varying(20);
	vsal_validade	date;
	vnova_qtde	integer;
	vqtde		integer;
	
BEGIN
	vqtde := trunc(NEW.ite_quantidade);
	RAISE NOTICE 'Mov_codigo: %.', NEW.mov_codigo;
	RAISE NOTICE 'Pro_codigo: %.', NEW.pro_codigo;
	RAISE NOTICE 'Ite_lote: %.', NEW.ite_lote;
	RAISE NOTICE 'Ite_validade: %.', NEW.ite_validade;
	RAISE NOTICE 'Ite_quantidade: %', vqtde;
	--descobrir o tipo de movimento para definir se vai somar ou subtrair
	SELECT mov_tipo,
	       set_entrada,
	       set_saida
	  INTO vmov_tipo,
	       vset_entrada,
	       vset_saida
	  FROM movimento 
	 WHERE mov_codigo = NEW.mov_codigo;

	RAISE NOTICE 'mov_tipo: %', vmov_tipo;
	RAISE NOTICE 'set_entrada: %', vset_entrada;
	RAISE NOTICE 'set_saida: %', vset_saida;

	--se mov_tipo for (S)aída ou (T)ransferência
	IF vmov_tipo <> 'E' THEN
		vsal_qtde := 0;
		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = NEW.pro_codigo
		   AND sal_lote = NEW.ite_lote
		   AND sal_validade = NEW.ite_validade; 

		RAISE NOTICE 'vsal_qtde: %', vsal_qtde;

		--calcular novo saldo
		vnova_qtde := vsal_qtde - vqtde;
		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;

		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = NEW.pro_codigo
		   AND sal_lote = NEW.ite_lote
		   AND sal_validade = NEW.ite_validade; 
		   
	END IF;
	--se mov_tipo for (E)ntrada ou (T)ransferência
	IF vmov_tipo <> 'S' THEN
		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = NEW.pro_codigo
		   AND sal_lote = NEW.ite_lote
		   AND sal_validade = NEW.ite_validade;

		--calcular novo saldo
		IF FOUND THEN
			RAISE NOTICE 'SAL_QTDE: %', vsal_qtde;
			RAISE NOTICE 'vQtde: %', vqtde;
			vnova_qtde := vsal_qtde + vqtde;
			RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
			RAISE NOTICE 'new.pro_codigo: %', NEW.pro_codigo;
			RAISE NOTICE 'new.ite_lote: %', NEW.ite_lote;
			RAISE NOTICE 'new.ite_validade: %', NEW.ite_validade;
			--atualizar o estoque na tabela saldo
			UPDATE saldo 
			   SET sal_qtde = vnova_qtde,
			       sal_data = CURRENT_DATE
			 WHERE set_codigo = vset_entrada
			   AND pro_codigo = NEW.pro_codigo
			   AND sal_lote = NEW.ite_lote
			   AND sal_validade = NEW.ite_validade;
		ELSE
			RAISE NOTICE 'SAL_QTDE: %', vsal_qtde;
			RAISE NOTICE 'vQtde: %', vqtde;
			vnova_qtde := vsal_qtde + vqtde;
			RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
			RAISE NOTICE 'new.pro_codigo: %', NEW.pro_codigo;
			RAISE NOTICE 'new.ite_lote: %', NEW.ite_lote;
			RAISE NOTICE 'new.ite_validade: %', NEW.ite_validade;
			RAISE NOTICE 'new.ite_dose: %', NEW.ite_dose;
			RAISE NOTICE 'vset_entrada: %', vset_entrada;
			SELECT pro_custo 
			  INTO vpro_custo
			  FROM produto 
			 WHERE pro_codigo = NEW.pro_codigo;
			 
			IF NEW.ite_dose IS NULL THEN
				vsal_dose = 1;
			ELSE
				vsal_dose = NEW.ite_dose;
			END IF;
			
			--insere o estoque na tabela saldo
			INSERT INTO saldo
			       (pro_codigo,
			       set_codigo,
			       sal_data,
			       sal_qtde,
			       sal_custo,
			       sal_lote,
			       sal_validade,
				   sal_dose_lote)
			VALUES (NEW.pro_codigo,
				vset_entrada,
				CURRENT_DATE,
				vqtde,
				vpro_custo,
				NEW.ite_lote,
				NEW.ite_validade,
				vsal_dose);
		END IF;
	END IF;

	RETURN NEW;
END
$$;


--
-- TOC entry 1192 (class 1255 OID 17240876)
-- Name: persisteestoquedel(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION persisteestoquedel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	vmov_tipo	character(1);
	vset_entrada	bigint;
	vset_saida	bigint;
	vsal_codigo	bigint;
	vpro_codigo	bigint;
	vset_codigo	bigint;
	vsal_data	date;
	vsal_qtde	integer;
	vpro_custo	numeric(9,4);
	vsal_lote	character varying(20);
	vsal_validade	date;
	vnova_qtde	integer;
	vqtde		integer;
BEGIN
	vqtde := trunc(OLD.ite_quantidade);
	RAISE NOTICE 'Mov_codigo: %.', OLD.mov_codigo;
	RAISE NOTICE 'Pro_codigo: %.', OLD.pro_codigo;
	RAISE NOTICE 'Ite_lote: %.', OLD.ite_lote;
	RAISE NOTICE 'Ite_validade: %.', OLD.ite_validade;
	RAISE NOTICE 'Ite_quantidade: %', vqtde;
	--descobrir o tipo de movimento para definir se vai somar ou subtrair
	SELECT mov_tipo,
	       set_entrada,
	       set_saida
	  INTO vmov_tipo,
	       vset_entrada,
	       vset_saida
	  FROM movimento 
	 WHERE mov_codigo = OLD.mov_codigo;

	RAISE NOTICE 'mov_tipo: %', vmov_tipo;
	RAISE NOTICE 'set_entrada: %', vset_entrada;
	RAISE NOTICE 'set_saida: %', vset_saida;

	--se mov_tipo for (S)aída ou (T)ransferência
	IF vmov_tipo <> 'E' THEN
		vsal_qtde := 0;
		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade; 

		RAISE NOTICE 'vsal_qtde: %', vsal_qtde;

		--calcular novo saldo
		vnova_qtde := vsal_qtde + vqtde;
		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;

		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade; 
		   
	END IF;
	--se mov_tipo for (E)ntrada ou (T)ransferência
	IF vmov_tipo <> 'S' THEN
		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

		vnova_qtde := vsal_qtde - vqtde;
		--calcular novo saldo
		RAISE NOTICE 'SAL_QTDE: %', vsal_qtde;
		RAISE NOTICE 'vQtde: %', vqtde;
		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'new.pro_codigo: %', OLD.pro_codigo;
		RAISE NOTICE 'new.ite_lote: %', OLD.ite_lote;
		RAISE NOTICE 'new.ite_validade: %', OLD.ite_validade;
		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

	END IF;

	RETURN OLD;
END
$$;


--
-- TOC entry 1195 (class 1255 OID 17240877)
-- Name: persisteestoqueupdate(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION persisteestoqueupdate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	vmov_tipo	character(1);
	vset_entrada	bigint;
	vset_saida	bigint;
	vsal_codigo	bigint;
	vpro_codigo	bigint;
	vset_codigo	bigint;
	vsal_data	date;
	vsal_qtde	integer;
	vpro_custo	numeric(9,4);
	vsal_lote	character varying(20);
	vsal_validade	date;
	vnova_qtde	integer;
	vqtdeold	integer;
	vqtdenew	integer;
BEGIN
	vqtdeold := trunc(OLD.ite_quantidade);
	vqtdenew := trunc(NEW.ite_quantidade);

	RAISE NOTICE 'Mov_codigo: %.', OLD.mov_codigo;
	RAISE NOTICE 'Pro_codigo: %.', OLD.pro_codigo;
	RAISE NOTICE 'Ite_lote: %.', NEW.ite_lote;
	RAISE NOTICE 'Ite_validade: %.', NEW.ite_validade;
	RAISE NOTICE 'Ite_quantidadeOLD: %', vqtdeold;
	RAISE NOTICE 'Ite_quantidadeNEW: %', vqtdenew;

	--descobrir o tipo de movimento para definir se vai somar ou subtrair
	SELECT mov_tipo,
	       set_entrada,
	       set_saida
	  INTO vmov_tipo,
	       vset_entrada,
	       vset_saida
	  FROM movimento 
	 WHERE mov_codigo = OLD.mov_codigo;

	RAISE NOTICE 'mov_tipo: %', vmov_tipo;
	RAISE NOTICE 'set_entrada: %', vset_entrada;
	RAISE NOTICE 'set_saida: %', vset_saida;

	--vsal_qtde := 0;
	
	RAISE NOTICE 'vsal_qtde: %', vsal_qtde;
	
	--se mov_tipo for (S)aída ou (T)ransferência
	IF vmov_tipo <> 'E' THEN

		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

		IF NOT FOUND THEN
			vsal_qtde = 0;
		END IF;

		--calcular novo saldo
		vnova_qtde := vsal_qtde - vqtdenew + vqtdeold;

		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'vQtdenew: %', vqtdenew;
		RAISE NOTICE 'vQtdeold: %', vqtdeold;
		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'new.pro_codigo: %', OLD.pro_codigo;
		RAISE NOTICE 'new.ite_lote: %', OLD.ite_lote;
		RAISE NOTICE 'new.ite_validade: %', OLD.ite_validade;
		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE,
		       sal_lote = NEW.ite_lote,
		       sal_validade = NEW.ite_validade
		 WHERE set_codigo = vset_saida
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade; 
		   
	END IF;
	--se mov_tipo for (E)ntrada ou (T)ransferência
	IF vmov_tipo <> 'S' THEN

		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo 
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

		IF NOT FOUND THEN
			vsal_qtde = 0;
		END IF;

		--calcular novo saldo
		vnova_qtde := vsal_qtde - vqtdeold + vqtdenew;

		--atualizar o estoque na tabela saldo
		UPDATE saldo 
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE,
		       sal_lote = NEW.ite_lote,
		       sal_validade = NEW.ite_validade
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

	END IF;
	
	RETURN NEW;
END
$$;


--
-- TOC entry 1196 (class 1255 OID 17240878)
-- Name: poe_precomedio(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION poe_precomedio() RETURNS numeric
    LANGUAGE plpgsql
    AS $$ 
DECLARE
    row   RECORD;
    TotAlter       integer:=0;

BEGIN
    
    FOR row IN SELECT * 
                 FROM produto_setor
                ORDER BY pro_codigo, set_codigo
      LOOP
       update precomedio set prm_custo=verifica_preco(row.pro_codigo,row.set_codigo,prm_data) 
              where pro_codigo=row.pro_codigo and set_codigo=row.set_codigo ;
       TotAlter= TotAlter + 1;
       RAISE NOTICE 'FIZ--> Prod=(%)', row.pro_codigo;
    END LOOP;
    return TotAlter;
END;
$$;


--
-- TOC entry 1197 (class 1255 OID 17240879)
-- Name: poe_precomedio(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION poe_precomedio(bigint) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$ 
DECLARE
    row   RECORD;
    TotAlter       integer:=0;
    SETOR          integer;

BEGIN

    SETOR := $1;
    
    FOR row IN SELECT * 
                 FROM produto_setor
                ORDER BY pro_codigo, set_codigo
      LOOP
       update precomedio set prm_custo=verifica_preco(row.pro_codigo,row.set_codigo,prm_data) 
              where pro_codigo=row.pro_codigo and set_codigo=row.set_codigo ;
       TotAlter= TotAlter + 1;
       RAISE NOTICE 'FIZ--> Prod=(%)', row.pro_codigo;
    END LOOP;
    return TotAlter;
END;
$_$;


--
-- TOC entry 1198 (class 1255 OID 17240880)
-- Name: preco_procedimento(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION preco_procedimento(bigint) RETURNS numeric
    LANGUAGE sql
    AS $_$select proc_valor from procedimento
  where proc_codigo = $1$_$;


--
-- TOC entry 1199 (class 1255 OID 17240881)
-- Name: procedimento_vagas_manutencao_agt(bigint, bigint, date, bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION procedimento_vagas_manutencao_agt(med bigint, proc bigint, data date, agt bigint) RETURNS bigint
    LANGUAGE plpgsql
    AS $$
DECLARE
	row RECORD;
	row_proc RECORD;
	r INT8 := 0;
	valor NUMERIC(9,2) := 0;
	periodo_ini DATE;

BEGIN
	-- fetching o procedimento
	SELECT proc_tipo, COALESCE(proc_valor,0) AS proc_valor INTO row_proc
	FROM laboratorio_procedimento AS lp
	INNER JOIN procedimento AS p ON p.proc_codigo = lp.proc_codigo
	WHERE lp.proc_codigo = proc AND lp.med_codigo = med;

	IF UPPER(TRIM(row_proc.proc_tipo)) = 'Q' THEN
		SELECT graex_qtde INTO r FROM grade_exame 
		WHERE proc_codigo = proc AND med_codigo = med AND graex_data = data AND agt_codigo = agt;
	ELSE
		RAISE NOTICE 'valor do proc=(%)', row_proc.proc_valor;
		SELECT FLOOR(graex_valor / row_proc.proc_valor) INTO r FROM grade_exame 
		WHERE proc_codigo = proc AND med_codigo = med AND graex_data = data AND agt_codigo = agt;

	END IF;

	return COALESCE(r,0);

END;
$$;


--
-- TOC entry 7523 (class 0 OID 0)
-- Dependencies: 1199
-- Name: FUNCTION procedimento_vagas_manutencao_agt(med bigint, proc bigint, data date, agt bigint); Type: COMMENT; Schema: social; Owner: -
--

COMMENT ON FUNCTION procedimento_vagas_manutencao_agt(med bigint, proc bigint, data date, agt bigint) IS 'Autor: Dudu
Data: 05/04/2007
Descricao: Exibe as vagas "reservadas" na grade_exame... 
NAO CALCULA AS VAGAS USADAS OU RESTANTES, APENAS EXIBE AS INDICAS NA GRADE !';


--
-- TOC entry 1200 (class 1255 OID 17240882)
-- Name: qtde_dispensado(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION qtde_dispensado(bigint) RETURNS numeric
    LANGUAGE sql
    AS $_$select coalesce(sum(ireq_quantidade),0) from itens_requisicao
  where ireq_consolidado = 'D' and pro_codigo = $1$_$;


--
-- TOC entry 1201 (class 1255 OID 17240883)
-- Name: remove_caracter_acento(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION remove_caracter_acento(stexto text) RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
  stextonovo TEXT;
BEGIN
  stextonovo := translate(stexto, 'Á','');       
  stextonovo := translate(stextonovo, 'É','');   
  stextonovo := translate(stextonovo, 'Í','');   
  stextonovo := translate(stextonovo, 'Ó','');   
  stextonovo := translate(stextonovo, 'Ú','');   
  stextonovo := translate(stextonovo, 'Ã','');   
  stextonovo := translate(stextonovo, 'Õ','');   
  stextonovo := translate(stextonovo, 'Â','');   
  stextonovo := translate(stextonovo, 'Ê','');   
  stextonovo := translate(stextonovo, 'Î','');  
  stextonovo := translate(stextonovo, 'Ô','');  
  stextonovo := translate(stextonovo, 'Û','');  
  stextonovo := translate(stextonovo, 'Ä','');  
  stextonovo := translate(stextonovo, 'Ë','');  
  stextonovo := translate(stextonovo, 'Ï','');  
  stextonovo := translate(stextonovo, 'Ö','');  
  stextonovo := translate(stextonovo, 'Ü','');  
  stextonovo := translate(stextonovo, 'Ç','');  
  stextonovo := translate(stextonovo, 'á','');  
  stextonovo := translate(stextonovo, 'é','');  
  stextonovo := translate(stextonovo, 'í','');  
  stextonovo := translate(stextonovo, 'ó','');  
  stextonovo := translate(stextonovo, 'ú','');  
  stextonovo := translate(stextonovo, 'à','');  
  stextonovo := translate(stextonovo, 'è','');  
  stextonovo := translate(stextonovo, 'ì','');  
  stextonovo := translate(stextonovo, 'ò','');  
  stextonovo := translate(stextonovo, 'ù','');  
  stextonovo := translate(stextonovo, 'ã','');  
  stextonovo := translate(stextonovo, 'õ','');  
  stextonovo := translate(stextonovo, 'â','');  
  stextonovo := translate(stextonovo, 'ê',''); 
  stextonovo := translate(stextonovo, 'î',''); 
  stextonovo := translate(stextonovo, 'ô',''); 
  stextonovo := translate(stextonovo, 'ô',''); 
  stextonovo := translate(stextonovo, 'ä',''); 
  stextonovo := translate(stextonovo, 'ë',''); 
  stextonovo := translate(stextonovo, 'ï',''); 
  stextonovo := translate(stextonovo, 'ö',''); 
  stextonovo := translate(stextonovo, 'ü',''); 
  stextonovo := translate(stextonovo, 'ç','');
  RETURN stextonovo;
END;
$$;


--
-- TOC entry 1202 (class 1255 OID 17240884)
-- Name: retira_acentos(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION retira_acentos(text) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE a varchar;
BEGIN
  SELECT translate($1,
	 text 'ÁÉÍÓÚÀÈÌÒÙÃÕÂÊÎÔÛÄËÏÖÜÇáéíóúàèìòùãõâêîôôäëïöüç',
	 text 'AEIOUAEIOUAOAEIOUAEIOUCaeiouaeiouaoaeiooaeiouc') INTO a;
  RETURN a;
END;
$_$;


--
-- TOC entry 1218 (class 1255 OID 29493156)
-- Name: retira_acentuacao(text); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION retira_acentuacao(p_texto text) RETURNS text
    LANGUAGE sql
    AS $_$  
  SELECT translate($1,  
					'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈÊìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ',  
					'aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY'   
				   );  
  $_$;


--
-- TOC entry 1203 (class 1255 OID 17240885)
-- Name: retorna_usuario(bigint); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION retorna_usuario(bigint) RETURNS character varying
    LANGUAGE sql
    AS $_$select usr_login from usuarios where usr_codigo = $1;$_$;


--
-- TOC entry 1204 (class 1255 OID 17240886)
-- Name: soundex(text); Type: FUNCTION; Schema: social; Owner: -
--
/*
CREATE OR REPLACE FUNCTION soundex(text) RETURNS text
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'soundex';

*/
--
-- TOC entry 1205 (class 1255 OID 17240887)
-- Name: temp_cidade(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION temp_cidade() RETURNS void
    LANGUAGE plpgsql
    AS $$

declare
linha record;

begin
  for linha in
    select usu_codigo, usu_end_cidade,cid_nome,cid_codigo_ibge
      from usuario 
      inner join cidade on 
      trim(to_ascii(upper(usuario.usu_end_cidade))) = trim(to_ascii(upper(cidade.cid_nome)))
      --where usu_end_cidade = 'ANAHY'
      --limit 50
  loop

    update usuario 
      set muni_cd_cod_ibge_resid = linha.cid_codigo_ibge
      where usu_codigo = linha.usu_codigo;
    --raise notice 'update usuario 
    --set muni_cd_cod_ibge_resid = %
    --where usu_codigo = %', linha.cid_codigo_ibge, linha.usu_codigo;

  end loop;

 -- uso:
 -- SELECT temp_cidade()

end;
$$;


--
-- TOC entry 1206 (class 1255 OID 17240888)
-- Name: temp_usu_uni(); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION temp_usu_uni() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  linha RECORD;
  uni INT8 := 0;
BEGIN

  FOR linha IN
  SELECT usu_codigo, uni_unidade FROM usuario
  LOOP

    SELECT uni_codigo INTO uni 
    FROM unidade 
    WHERE TO_ASCII( UPPER( TRIM(uni_desc) ) ) = TO_ASCII( UPPER( TRIM( linha.uni_unidade ) ) );
	--OR uni_codigo = linha.uni_unidade 
        --LIMIT 150;

   IF uni IS NULL THEN
     uni := 0;
   END IF;

    --RAISE NOTICE 'usu_codigo = (%), uni_unidade = (%), uni = (%)', linha.usu_codigo, linha.uni_unidade, uni;
    RAISE NOTICE 'UPDATE usuario SET uni_unidade_cod = % WHERE usu_codigo = %', uni, linha.usu_codigo;

    UPDATE usuario SET uni_unidade_cod = uni WHERE usu_codigo = linha.usu_codigo;


  END LOOP;
  

END;
$$;


--
-- TOC entry 1207 (class 1255 OID 17240889)
-- Name: text_soundex(text); Type: FUNCTION; Schema: social; Owner: -
--
/*
CREATE OR REPLACE FUNCTION text_soundex(text) RETURNS text
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/fuzzystrmatch', 'soundex';
*/

--
-- TOC entry 1212 (class 1255 OID 17240890)
-- Name: verifica_preco(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION verifica_preco(produto bigint, setor bigint, dataestoq date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    --row RECORD; pra q isso ???

    setorentrada  integer := 0;
    saldoini      numeric := 0;
    --saldofinal    numeric := 0; hmmmm ???
    --entradas      numeric := 0; uatarreu ???
    --saidas        numeric := 0; hein ???
    sld_custo     numeric := 0;
    sld_dta_ini   date;
    data_saldoini date;

BEGIN

    -- foi p/ os parametros
    --SETOR := $2;
    --PRODUTO := $1;
    --DATAESTOQ := $3;

--verifica o preco do produto
    IF SETOR = 0 THEN
       SELECT SET_CODIGO_ENTRADA INTO SETORENTRADA FROM CONF_ESTOQUE;    
       
       SELECT COALESCE(PRM_CUSTO,0) INTO SALDOINI 
       FROM   PRECOMEDIO
       WHERE  PRO_CODIGO = PRODUTO
       AND    SET_CODIGO = SETORENTRADA
       AND    PRM_DATA  <= DATAESTOQ
       ORDER BY PRM_DATA DESC LIMIT 1;
   
    ELSE
       SELECT COALESCE(PRM_CUSTO,0) INTO SALDOINI 
       FROM   PRECOMEDIO
       WHERE  PRO_CODIGO = PRODUTO
       AND    SET_CODIGO = SETOR
       AND    PRM_DATA <= DATAESTOQ
       ORDER BY PRM_DATA DESC LIMIT 1;
    END IF;

    IF SALDOINI IS NULL THEN
       SELECT SET_CODIGO_ENTRADA INTO SETORENTRADA FROM CONF_ESTOQUE;        
       IF SETOR = 0 THEN
          SELECT MAX(COALESCE(A.SAL_CUSTO,0)), SAL_DATA INTO SALDOINI, DATA_SALDOINI
          FROM SALDO AS A
          WHERE A.PRO_CODIGO = PRODUTO
          AND   A.SAL_DATA <= (SELECT MAX(SAL_DATA) FROM SALDO 
                               WHERE PRO_CODIGO = A.PRO_CODIGO 
                               AND A.SET_CODIGO = SET_CODIGO
                               AND A.SAL_DATA <= DATAESTOQ)
          AND   A.SET_CODIGO = SETORENTRADA                     
          GROUP BY A.SAL_DATA
          ORDER BY A.SAL_DATA DESC LIMIT 1;
       ELSE
          SELECT COALESCE(A.SAL_CUSTO, 0),  A.SAL_DATA INTO SALDOINI, DATA_SALDOINI
          FROM SALDO AS A
          WHERE A.PRO_CODIGO = PRODUTO
          AND   A.SET_CODIGO = SETOR
          AND   A.SAL_DATA <= (SELECT MAX(SAL_DATA) FROM SALDO 
                               WHERE PRO_CODIGO = A.PRO_CODIGO 
                               AND A.SAL_DATA <= DATAESTOQ
                               AND A.SET_CODIGO = SET_CODIGO)
          GROUP BY A.SAL_CUSTO, A.SAL_DATA
          ORDER BY A.SAL_DATA DESC LIMIT 1;      
       END IF;
    END IF;

    if SALDOINI = 0 then
       SELECT sal_data, sal_custo INTO sld_dta_ini, sld_custo
         FROM saldo
        WHERE pro_codigo = PRODUTO
          AND set_codigo = SETOR
          AND sal_data  <= DATAESTOQ
        ORDER BY sal_data DESC LIMIT 1;

       SALDOINI=sld_custo;
    end if;


    -- gambiarra gosmenta
    -- vide OS #0421
    -- tenta axar algum valor para o 'preco' no desespero !
    if( saldoini is null or saldoini = 0 ) then

	SELECT i.ite_vlrunit INTO saldoini
	FROM itens_movimento AS i
	INNER JOIN movimento AS m ON m.mov_codigo = i.mov_codigo
	WHERE i.pro_codigo = PRODUTO AND m.set_entrada = SETOR AND mov_tipo = 'E' 
	ORDER BY mov_data DESC limit 1;

    end if;

    RETURN SALDOINI;

END; $_$;


--
-- TOC entry 1208 (class 1255 OID 17240891)
-- Name: verifica_preco2(bigint, bigint, date); Type: FUNCTION; Schema: social; Owner: -
--

CREATE OR REPLACE FUNCTION verifica_preco2(produto bigint, setor bigint, dataestoq date) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
    row RECORD;
    setorentrada  integer := 0;
    saldoini      numeric := 0;
    saldofinal    numeric := 0;
    entradas      numeric := 0;
    saidas        numeric := 0;
    sld_custo     numeric := 0;
    sld_dta_ini   date;
    data_saldoini date;

BEGIN


	--verifica o preco do produto
    IF SETOR = 0 THEN
       SELECT SET_CODIGO_ENTRADA INTO SETORENTRADA FROM CONF_ESTOQUE;    
       
       SELECT COALESCE(PRM_CUSTO,0) INTO SALDOINI 
       FROM   PRECOMEDIO
       WHERE  PRO_CODIGO = PRODUTO
       AND    SET_CODIGO = SETORENTRADA
       AND    PRM_DATA  <= DATAESTOQ
       ORDER BY PRM_DATA DESC LIMIT 1;
   
    ELSE
       SELECT COALESCE(PRM_CUSTO,0) INTO SALDOINI 
       FROM   PRECOMEDIO
       WHERE  PRO_CODIGO = PRODUTO
       AND    SET_CODIGO = SETOR
       AND    PRM_DATA <= DATAESTOQ
       ORDER BY PRM_DATA DESC LIMIT 1;
    END IF;

    IF SALDOINI IS NULL THEN
       SELECT SET_CODIGO_ENTRADA INTO SETORENTRADA FROM CONF_ESTOQUE;        
       IF SETOR = 0 THEN
          SELECT MAX(COALESCE(A.SAL_CUSTO,0)), SAL_DATA INTO SALDOINI, DATA_SALDOINI
          FROM SALDO AS A
          WHERE A.PRO_CODIGO = PRODUTO
          AND   A.SAL_DATA <= (SELECT MAX(SAL_DATA) FROM SALDO 
                               WHERE PRO_CODIGO = A.PRO_CODIGO 
                               AND A.SET_CODIGO = SET_CODIGO
                               AND A.SAL_DATA <= DATAESTOQ)
          AND   A.SET_CODIGO = SETORENTRADA                     
          GROUP BY A.SAL_DATA
          ORDER BY A.SAL_DATA DESC LIMIT 1;
       ELSE
          SELECT COALESCE(A.SAL_CUSTO, 0),  A.SAL_DATA INTO SALDOINI, DATA_SALDOINI
          FROM SALDO AS A
          WHERE A.PRO_CODIGO = PRODUTO
          AND   A.SET_CODIGO = SETOR
          AND   A.SAL_DATA <= (SELECT MAX(SAL_DATA) FROM SALDO 
                               WHERE PRO_CODIGO = A.PRO_CODIGO 
                               AND A.SAL_DATA <= DATAESTOQ
                               AND A.SET_CODIGO = SET_CODIGO)
          GROUP BY A.SAL_CUSTO, A.SAL_DATA
          ORDER BY A.SAL_DATA DESC LIMIT 1;      
       END IF;
    END IF;

    if SALDOINI = 0 then
       SELECT sal_data, sal_custo INTO sld_dta_ini, sld_custo
         FROM saldo
        WHERE pro_codigo = PRODUTO
          AND set_codigo = SETOR
          AND sal_data  <= DATAESTOQ
        ORDER BY sal_data DESC LIMIT 1;

       SALDOINI := sld_custo;
    end if;

    RETURN SALDOINI;
END; $$;



CREATE OR REPLACE FUNCTION social.src_esus_cadastro_domiciliar()
  RETURNS trigger AS
$BODY$
DECLARE 
BEGIN 
	UPDATE tb_cds_domicilio_resposta SET uuid_ficha = null, co_data_atendimento = current_date WHERE co_cds_cad_domiciliar=NEW.dom_codigo;
	RETURN NEW;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE OR REPLACE FUNCTION social.replaceinvalidcharacters(
    schemaname character varying,
    tablename character varying)
  RETURNS integer AS
$BODY$
             DECLARE columnName character varying;
           BEGIN
             RAISE NOTICE 'Execute replaceInvalidCharacters for (%,%)', tableName,schemaName;
             FOR columnName IN SELECT column_name
              FROM information_schema.columns
              WHERE table_schema = schemaName
              AND table_name   =  tableName
              AND data_type = 'character varying'
             LOOP
               RAISE NOTICE 'update column %', columnName;
               EXECUTE 'UPDATE '|| schemaName || '.'||tableName|| ' SET '|| columnName ||
                 ' = regexp_replace('||columnName||',E''\\x81|\x8D|\x8F|\x90|\x9D|\x8D'','''') WHERE '|| columnName || ' ~ E''\x81|\x8D|\x8F|\x90|\x9D''';
             END LOOP;
             RETURN 1; 
           END;
           $BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
  
DROP TRIGGER IF EXISTS atualiza_esus_atendimento_individual ON rl_cds_atend_individual_condut;
CREATE TRIGGER atualiza_esus_atendimento_individual AFTER INSERT OR DELETE OR UPDATE ON rl_cds_atend_individual_condut FOR EACH ROW EXECUTE PROCEDURE esus_atendimento_individual();

DROP TRIGGER IF EXISTS atualiza_esus_atividade_coletiva ON tb_cds_ficha_ativ_col;
CREATE TRIGGER atualiza_esus_atividade_coletiva AFTER INSERT OR DELETE OR UPDATE ON tb_cds_ficha_ativ_col FOR EACH ROW EXECUTE PROCEDURE esus_atividade_coletiva();

DROP TRIGGER IF EXISTS atualiza_esus_cadastro_individual ON usuario;
CREATE TRIGGER atualiza_esus_cadastro_individual AFTER INSERT OR DELETE OR UPDATE ON usuario FOR EACH ROW EXECUTE PROCEDURE esus_cadastro_individual();

DROP TRIGGER IF EXISTS atualiza_esus_ficha_procedimentos ON procedimento_atendimento;
CREATE TRIGGER atualiza_esus_ficha_procedimentos AFTER INSERT OR DELETE OR UPDATE ON procedimento_atendimento FOR EACH ROW EXECUTE PROCEDURE esus_ficha_procedimentos();

DROP TRIGGER IF EXISTS atualiza_esus_odonto ON odonto_procedimentos_controle;
CREATE TRIGGER atualiza_esus_odonto AFTER INSERT OR UPDATE ON odonto_procedimentos_controle FOR EACH ROW EXECUTE PROCEDURE esus_odonto();

DROP TRIGGER IF EXISTS atualiza_esus_visita_domiciliar ON tb_cds_visita_domiciliar;
CREATE TRIGGER atualiza_esus_visita_domiciliar AFTER INSERT OR UPDATE ON tb_cds_visita_domiciliar FOR EACH ROW EXECUTE PROCEDURE esus_visita_domiciliar();

DROP TRIGGER IF EXISTS atualizaestoque ON itens_movimento;
CREATE TRIGGER atualizaestoque AFTER INSERT ON itens_movimento FOR EACH ROW EXECUTE PROCEDURE persisteestoque();

DROP TRIGGER IF EXISTS atualizaestoquedel ON itens_movimento;
CREATE TRIGGER atualizaestoquedel AFTER DELETE ON itens_movimento FOR EACH ROW EXECUTE PROCEDURE persisteestoquedel();

DROP TRIGGER IF EXISTS atualizaestoqueupdate ON itens_movimento;
CREATE TRIGGER atualizaestoqueupdate AFTER UPDATE ON itens_movimento FOR EACH ROW EXECUTE PROCEDURE persisteestoqueupdate();

DROP TRIGGER IF EXISTS atualizahorus ON itens_movimento;
CREATE TRIGGER atualizahorus AFTER INSERT OR DELETE OR UPDATE ON itens_movimento FOR EACH ROW EXECUTE PROCEDURE operacoesiitensmovimentohorus();

DROP TRIGGER IF EXISTS atualizaodontobpa ON odonto_procedimentos_realizados;
CREATE TRIGGER atualizaodontobpa AFTER INSERT OR DELETE OR UPDATE ON odonto_procedimentos_realizados FOR EACH ROW EXECUTE PROCEDURE operacoesodontobpa();

DROP TRIGGER IF EXISTS bpa ON procedimento_atendimento;
CREATE TRIGGER bpa AFTER INSERT ON procedimento_atendimento FOR EACH ROW EXECUTE PROCEDURE pattobpa();

DROP TRIGGER IF EXISTS bpa ON itensdoexame;
CREATE TRIGGER bpa AFTER UPDATE ON itensdoexame FOR EACH ROW EXECUTE PROCEDURE itxtobap();

DROP TRIGGER IF EXISTS bpa ON atendimento;
CREATE TRIGGER bpa AFTER INSERT ON atendimento FOR EACH ROW EXECUTE PROCEDURE atetobpa();

DROP TRIGGER IF EXISTS bpa ON coleta;
CREATE TRIGGER bpa AFTER INSERT OR UPDATE ON coleta FOR EACH ROW EXECUTE PROCEDURE itxtobap();

DROP TRIGGER IF EXISTS bpadel ON procedimento_atendimento;
CREATE TRIGGER bpadel AFTER DELETE ON procedimento_atendimento FOR EACH ROW EXECUTE PROCEDURE pattobpadel();

DROP TRIGGER IF EXISTS bpadel ON itensdoexame;
CREATE TRIGGER bpadel AFTER DELETE ON itensdoexame FOR EACH ROW EXECUTE PROCEDURE itxtobpadel();

DROP TRIGGER IF EXISTS bpadel ON atendimento;
CREATE TRIGGER bpadel AFTER DELETE ON atendimento FOR EACH ROW EXECUTE PROCEDURE atetobpadel();

DROP TRIGGER IF EXISTS bpadel ON coleta;
CREATE TRIGGER bpadel AFTER DELETE ON coleta FOR EACH ROW EXECUTE PROCEDURE itxtobpadel();

DROP TRIGGER IF EXISTS historico_data_hora_agendamento ON agendamento;
CREATE TRIGGER historico_data_hora_agendamento AFTER INSERT OR UPDATE ON agendamento FOR EACH ROW EXECUTE PROCEDURE historico_data_hora_agendamento();

DROP TRIGGER IF EXISTS historico_data_hora_atendimento ON atendimento;
CREATE TRIGGER historico_data_hora_atendimento AFTER INSERT OR UPDATE ON atendimento FOR EACH ROW EXECUTE PROCEDURE historico_data_hora_atendimento();

DROP TRIGGER IF EXISTS historico_data_hora_pre_consulta ON pre_consulta;
CREATE TRIGGER historico_data_hora_pre_consulta AFTER INSERT OR UPDATE ON pre_consulta FOR EACH ROW EXECUTE PROCEDURE historico_data_hora_pre_consulta();

DROP TRIGGER IF EXISTS logon_before ON logon;
CREATE TRIGGER logon_before BEFORE INSERT ON logon FOR EACH ROW EXECUTE PROCEDURE limpa_logon();

DROP TRIGGER IF EXISTS movimento ON movimento;
CREATE TRIGGER movimento BEFORE INSERT ON movimento FOR EACH ROW EXECUTE PROCEDURE movimentodatainsercao();

DROP TRIGGER IF EXISTS esus_cadastro_domiciliar ON social.domicilio;
CREATE TRIGGER esus_cadastro_domiciliar AFTER UPDATE ON social.domicilio FOR EACH ROW EXECUTE PROCEDURE social.src_esus_cadastro_domiciliar();
  

