SET search_path = social;
/***************
** OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
--UPDATE social.schema_version SET version='107', script='V107__3.140.139.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.142.141' WHERE conf_chave='VERSAO_SAUDE';
UPDATE tb_cds_visita_dom_motivo SET no_cds_visita_dom_motivo = upper(no_cds_visita_dom_motivo);
DROP TABLE tb_cid;

CREATE TABLE tb_cid
(
  no_cid character varying(100) NOT NULL,
  tp_agravo character(1) NOT NULL,
  tp_sexo character(1) NOT NULL,
  tp_estadio character(1),
  vl_campos_irradiados integer,
  co_cid character varying(4)
)
WITH (
  OIDS=FALSE
);

CREATE OR REPLACE function esus_visita_domiciliar() returns trigger
LANGUAGE plpgsql
AS $$
DECLARE
	linha RECORD;
	esv_sexo character varying(20);
	esv_desfecho character varying(20);
BEGIN
	IF (TG_OP='INSERT') THEN
	  DELETE FROM esus_visita_domiciliar WHERE ate_codigo = NEW.ate_codigo;
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				ate.ate_data,
				usr.cnes_cod_cns AS esv_profissional_cns,
				esp.cod_cbo AS esv_cbo_codigo_2002,
				uni.uni_cnes AS esv_cnes,
				uni.uni_codigo_ibge AS esv_codigo_ibge_mun,
				usu.usu_cartao_sus AS esv_usu_cns,
				usu.usu_datanasc AS esv_usu_datanasc,
				usu.usu_prontuario AS esv_num_prontuario,
				usu.usu_sexo AS usu_sexo,
				tbvd.co_cds_visita_dom_desfecho AS desfecho,
				tbvd.co_seq_cds_visita_domiciliar AS co_cds_visita_domiciliar
			FROM
				atendimento AS ate
			INNER JOIN
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN
				tb_cds_visita_domiciliar AS tbvd ON ate.ate_codigo=tbvd.ate_codigo
			INNER JOIN
				tb_cds_visita_dom_desfecho AS tbvdd ON tbvd.co_cds_visita_dom_desfecho=tbvdd.co_cds_visita_dom_desfecho
			WHERE
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validação Sexo
			IF (linha.usu_sexo='M') THEN esv_sexo = '0 L'; ELSE esv_sexo = '1 L'; END IF;
			-- Validação Desfecho
			IF (linha.desfecho='1') THEN esv_desfecho = '1 L'; END IF;
			IF (linha.desfecho='2') THEN esv_desfecho = '2 L'; END IF;
			IF (linha.desfecho='3') THEN esv_desfecho = '3 L'; END IF;
			-- Valida Inserção
			IF (linha.ate_codigo IS NOT NULL) THEN
				INSERT INTO esus_visita_domiciliar(
					ate_codigo,
					esv_profissional_cns,
					esv_cbo_codigo_2002,
					esv_cnes,
					esv_num_prontuario,
					esv_usu_cns,
					esv_usu_datanasc,
					esv_usu_sexo,
					esv_desfecho,
					co_cds_visita_domiciliar,
					esv_dtatendimento,
					esv_codigo_ibge_mun
				) VALUES (
					linha.ate_codigo,
					linha.esv_profissional_cns,
					linha.esv_cbo_codigo_2002,
					linha.esv_cnes,
					linha.esv_num_prontuario,
					linha.esv_usu_cns,
					linha.esv_usu_datanasc,
					esv_sexo,
					esv_desfecho,
					linha.co_cds_visita_domiciliar,
					linha.ate_data,
					linha.esv_codigo_ibge_mun
				);
				RETURN NEW;
			END IF;
		END LOOP;
	ELSE
		FOR linha IN
		SELECT DISTINCT
			ate.ate_codigo,
			ate.ate_data,
			usr.cnes_cod_cns AS esv_profissional_cns,
			esp.cod_cbo AS esv_cbo_codigo_2002,
			uni.uni_cnes AS esv_cnes,
			uni.uni_codigo_ibge AS esv_codigo_ibge_mun,
			usu.usu_cartao_sus AS esv_usu_cns,
			usu.usu_datanasc AS esv_usu_datanasc,
			usu.usu_prontuario AS esv_num_prontuario,
			usu.usu_sexo AS usu_sexo,
			tbvd.co_cds_visita_dom_desfecho AS desfecho,
			tbvd.co_seq_cds_visita_domiciliar AS co_cds_visita_domiciliar
		FROM
			atendimento AS ate
			INNER JOIN
			agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN
			especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN
			usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
			usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
			unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN
			tb_cds_visita_domiciliar AS tbvd ON ate.ate_codigo=tbvd.ate_codigo
			INNER JOIN
			tb_cds_visita_dom_desfecho AS tbvdd ON tbvd.co_cds_visita_dom_desfecho=tbvdd.co_cds_visita_dom_desfecho
		WHERE
			ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validação Sexo
			IF (linha.usu_sexo='M') THEN esv_sexo = '0 L'; ELSE esv_sexo = '1 L'; END IF;
			-- Validação Desfecho
			IF (linha.desfecho='1') THEN esv_desfecho = '1 L'; END IF;
			IF (linha.desfecho='2') THEN esv_desfecho = '2 L'; END IF;
			IF (linha.desfecho='3') THEN esv_desfecho = '3 L'; END IF;
			-- Valida Inserção
			IF (linha.ate_codigo IS NOT NULL) THEN
				UPDATE esus_visita_domiciliar
					SET
						esv_profissional_cns = linha.esv_profissional_cns,
						esv_cbo_codigo_2002	= linha.esv_cbo_codigo_2002,
						esv_cnes = linha.esv_cnes,
						esv_num_prontuario = linha.esv_num_prontuario,
						esv_usu_cns	= linha.esv_usu_cns,
						esv_usu_datanasc = linha.esv_usu_datanasc,
						esv_usu_sexo = esv_sexo,
						esv_desfecho = esv_desfecho,
						esv_dtatendimento = linha.ate_data,
						esv_codigo_ibge_mun = linha.esv_codigo_ibge_mun,
						uuid_ficha = null
					WHERE ate_codigo = linha.ate_codigo
					  AND co_cds_visita_domiciliar = linha.co_cds_visita_domiciliar;
				RETURN NEW;
			END IF;
		END LOOP;
	END IF;
	RETURN NULL;
END;
$$;


