INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('PRODUO DIARIA','zf/relatorio/producao-diaria','zf/relatorio/producao-diaria');


INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Cadastro de Veiculo','zf/transporte/veiculo','zf/transporte/veiculo');

CREATE TABLE veiculo_situacao
(
   veis_codigo bigserial, 
   veis_descricao character varying, 
   CONSTRAINT pk_veis_codigo PRIMARY KEY (veis_codigo)
) 
WITH (
  OIDS = FALSE
)
;
INSERT INTO veiculo_situacao(veis_descricao)VALUES('Em uso');


CREATE TABLE veiculo_especie
(
   veie_codigo bigserial, 
   veie_descricao character varying(100), 
   CONSTRAINT pk_veiculo_especie PRIMARY KEY (veie_codigo)
) 
WITH (
  OIDS = FALSE
)
;

INSERT INTO veiculo_especie(veie_descricao)VALUES('Automvel');



CREATE TABLE veiculo_tipo_transporte
(
   veit_codigo bigserial, 
   veit_descricao character varying, 
   CONSTRAINT pk_veiculo_tipo PRIMARY KEY (veit_codigo)
) 
WITH (
  OIDS = FALSE
)
;

INSERT INTO veiculo_tipo_transporte(veit_descricao)VALUES('Passageiros');


CREATE TABLE veiculo_combustivel
(
   veic_codigo bigserial, 
   veic_descricao character varying(150), 
   CONSTRAINT pk_combustivel PRIMARY KEY (veic_codigo)
) 
WITH (
  OIDS = FALSE
)
;

INSERT INTO veiculo_combustivel(veic_descricao)VALUES('Gasolina');
INSERT INTO veiculo_combustivel(veic_descricao)VALUES('lcool');
INSERT INTO veiculo_combustivel(veic_descricao)VALUES('Disel');


CREATE TABLE veiculo
(
   vei_codigo bigserial, 
   vei_data_aquisicao date, 
   vei_descricao character varying(150), 
   vei_placa character(8), 
   vei_chassi character varying(150), 
   vei_renavan character varying(150), 
   vei_placa_patrimonial integer, 
   for_codigo bigint, 
   vei_nota_fiscal character varying(50), 
   vei_ano integer, 
   vei_ano_modelo integer, 
   vei_cor character(15), 
   vei_capacidade integer, 
   vei_cnh_minima character varying(2), 
   vei_qtde_tanque integer, 
   vei_media integer, 
   veis_codigo bigint, 
   veie_codigo integer, 
   veit_codigo integer, 
   veic_codigo integer, 
   CONSTRAINT "PK_veiculo" PRIMARY KEY (vei_codigo), 
   CONSTRAINT pk_fornecedor_veiculo FOREIGN KEY (for_codigo) REFERENCES fornecedor (for_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT "FK_veiculo_Situacao" FOREIGN KEY (veis_codigo) REFERENCES veiculo_situacao (veis_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_veiculo_especie FOREIGN KEY (veie_codigo) REFERENCES veiculo_especie (veie_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_veiculo_combustivel FOREIGN KEY (veic_codigo) REFERENCES veiculo_combustivel (veic_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_veiculo_tipo_transporte FOREIGN KEY (veit_codigo) REFERENCES veiculo_tipo_transporte (veit_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;
INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Transporte Viagem','zf/transporte/viagem','zf/transporte/viagem');



CREATE TABLE viagem
(
   via_codigo bigserial, 
   vei_codigo bigint, 
   usr_codigo bigint, 
   via_local character varying(50), 
   via_hora character(5), 
   via_motivo text, 
   CONSTRAINT pk_viagem PRIMARY KEY (via_codigo), 
   CONSTRAINT pk_usuarios FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_veiculo FOREIGN KEY (vei_codigo) REFERENCES veiculo (vei_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;
ALTER TABLE viagem ADD COLUMN usr_codigo_cadastro bigint NOT NULL;
ALTER TABLE viagem ADD COLUMN via_data date NOT NULL;



INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Agendar paciente para TFD','zf/transporte/viagem-usuario','zf/transporte/viagem-usuario');

ALTER TABLE veiculo ADD COLUMN vei_tipo_veiculo character(1) NOT NULL;
COMMENT ON COLUMN veiculo.vei_tipo_veiculo IS 'F = FLUVIAL
T = TERRESTRE
A = AEREO';
CREATE TABLE viagem_usuario
(
   viausu_codigo bigserial NOT NULL, 
   usu_codigo bigint NOT NULL, 
   viausu_despesas character(10), 
   cid_codigo_origem bigint NOT NULL, 
   cid_codigo_destino bigint NOT NULL, 
   viausu_km integer, 
   usr_codigo_cadastro bigint, 
   CONSTRAINT pk_viagem_usuario PRIMARY KEY (viausu_codigo), 
   CONSTRAINT fk_viagem_usuario FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_cidade_de_origem FOREIGN KEY (cid_codigo_origem) REFERENCES cidade (cid_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_cid_codigo_destino FOREIGN KEY (cid_codigo_destino) REFERENCES cidade (cid_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;
ALTER TABLE viagem_usuario ADD COLUMN viausu_alimentacao boolean NOT NULL;
ALTER TABLE viagem_usuario ADD COLUMN viausu_pernoite boolean NOT NULL;
ALTER TABLE viagem_usuario ADD COLUMN via_codigo bigint NOT NULL;
ALTER TABLE viagem_usuario ADD CONSTRAINT viagem_usuario_codigo_quem_cadastrou FOREIGN KEY (usr_codigo_cadastro) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE viagem_usuario ADD CONSTRAINT fk_codigo_da_viagem_do_usuario FOREIGN KEY (via_codigo) REFERENCES viagem (via_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


CREATE TABLE usuario_acompanhante
(
   acom_codigo bigserial NOT NULL, 
   viausu_codigo bigint NOT NULL, 
   usu_codigo bigint NOT NULL, 
   CONSTRAINT pk_acompanhante PRIMARY KEY (acom_codigo), 
   CONSTRAINT fk_viagem_usuario FOREIGN KEY (viausu_codigo) REFERENCES viagem_usuario (viausu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_acompanhante_usuario FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;

CREATE TABLE viagem_procedimento_usuario
(
   viaproc_codigo bigserial, 
   viausu_codigo bigint, 
   proc_codigo bigint, 
   CONSTRAINT pk_procedimento_viagem PRIMARY KEY (viaproc_codigo), 
   CONSTRAINT fk_viagem_usuario FOREIGN KEY (viausu_codigo) REFERENCES viagem_usuario (viausu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_procedimentos_viagem FOREIGN KEY (proc_codigo) REFERENCES procedimento (proc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH (
  OIDS = FALSE
)
;


COMMENT ON COLUMN agendamento.age_atendido IS 'S - Recepcionado
A - Atendido
N - Agendado
T - Transferido
F - Faltoso
E - Em atendimento
I - Atendimento Incluso
M - Falta Mdica';

UPDATE agendamento SET age_atendido = 'M' WHERE age_falta_medico = 'S';
ALTER TABLE agendamento DROP COLUMN age_falta_medico;


INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Acompanhante do tfd','usuario-acompanhante','usuario-acompanhante');


INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Relatorio de viagem por motorista','/zf/relatorio/transporte','/zf/relatorio/transporte');


ALTER TABLE procedimento DROP COLUMN proc_dtcompetencia;
ALTER TABLE procedimento ADD COLUMN proc_dtcompetencia character varying(6);
ALTER TABLE rl_procedimento_cid DROP COLUMN dt_competencia;
ALTER TABLE rl_procedimento_cid ADD COLUMN dt_competencia character varying(6);

INSERT INTO permissoes (perm_descricao,perm_programa,perm_objeto) VALUES ('Modulo transporte','zf/transporte/index','zf/transporte/index');




