SET search_path = social;
/***************
** OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
--UPDATE social.schema_version SET version='110', script='V110__3.143.142.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.143.142' WHERE conf_chave='VERSAO_SAUDE';

CREATE OR REPLACE function esus_visita_domiciliar() returns trigger
LANGUAGE plpgsql
AS $$
DECLARE
	linha RECORD;
	esv_sexo character varying(20);
	esv_desfecho character varying(20);
BEGIN
	IF (TG_OP='INSERT') THEN
    DELETE FROM esus_visita_domiciliar WHERE ate_codigo = NEW.ate_codigo;
		FOR linha IN
			SELECT DISTINCT
				ate.ate_codigo,
				ate.ate_data,
				usr.cnes_cod_cns AS esv_profissional_cns,
				esp.cod_cbo AS esv_cbo_codigo_2002,
				uni.uni_cnes AS esv_cnes,
				uni.uni_codigo_ibge AS esv_codigo_ibge_mun,
				usu.usu_cartao_sus AS esv_usu_cns,
				usu.usu_datanasc AS esv_usu_datanasc,
				usu.usu_prontuario AS esv_num_prontuario,
				usu.usu_sexo AS usu_sexo,
				tbvd.co_cds_visita_dom_desfecho AS desfecho,
				tbvd.co_seq_cds_visita_domiciliar AS co_cds_visita_domiciliar
			FROM
				atendimento AS ate
			INNER JOIN
				agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN
				especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN
				usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
				usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
				unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN
				tb_cds_visita_domiciliar AS tbvd ON ate.ate_codigo=tbvd.ate_codigo
			INNER JOIN
				tb_cds_visita_dom_desfecho AS tbvdd ON tbvd.co_cds_visita_dom_desfecho=tbvdd.co_cds_visita_dom_desfecho
			WHERE
				ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validação Sexo
			IF (linha.usu_sexo='M') THEN esv_sexo = '0 L'; ELSE esv_sexo = '1 L'; END IF;
			-- Validação Desfecho
			IF (linha.desfecho='1') THEN esv_desfecho = '1 L'; END IF;
			IF (linha.desfecho='2') THEN esv_desfecho = '2 L'; END IF;
			IF (linha.desfecho='3') THEN esv_desfecho = '3 L'; END IF;
			-- Valida Inserção
			IF (linha.ate_codigo IS NOT NULL) THEN
				INSERT INTO esus_visita_domiciliar(
					ate_codigo,
					esv_profissional_cns,
					esv_cbo_codigo_2002,
					esv_cnes,
					esv_num_prontuario,
					esv_usu_cns,
					esv_usu_datanasc,
					esv_usu_sexo,
					esv_desfecho,
					co_cds_visita_domiciliar,
					esv_dtatendimento,
					esv_codigo_ibge_mun
				) VALUES (
					linha.ate_codigo,
					linha.esv_profissional_cns,
					linha.esv_cbo_codigo_2002,
					linha.esv_cnes,
					linha.esv_num_prontuario,
					linha.esv_usu_cns,
					linha.esv_usu_datanasc,
					esv_sexo,
					esv_desfecho,
					linha.co_cds_visita_domiciliar,
					linha.ate_data,
					linha.esv_codigo_ibge_mun
				);
				RETURN NEW;
			END IF;
		END LOOP;
	ELSE
		FOR linha IN
		SELECT DISTINCT
			ate.ate_codigo,
			ate.ate_data,
			usr.cnes_cod_cns AS esv_profissional_cns,
			esp.cod_cbo AS esv_cbo_codigo_2002,
			uni.uni_cnes AS esv_cnes,
			uni.uni_codigo_ibge AS esv_codigo_ibge_mun,
			usu.usu_cartao_sus AS esv_usu_cns,
			usu.usu_datanasc AS esv_usu_datanasc,
			usu.usu_prontuario AS esv_num_prontuario,
			usu.usu_sexo AS usu_sexo,
			tbvd.co_cds_visita_dom_desfecho AS desfecho,
			tbvd.co_seq_cds_visita_domiciliar AS co_cds_visita_domiciliar
		FROM
			atendimento AS ate
			INNER JOIN
			agendamento AS age ON ate.age_codigo=age.age_codigo
			INNER JOIN
			especialidade AS esp ON age.esp_codigo=esp.esp_codigo
			INNER JOIN
			usuarios AS usr ON ate.med_codigo=usr.usr_codigo
			INNER JOIN
			usuario AS usu ON ate.usu_codigo=usu.usu_codigo
			INNER JOIN
			unidade AS uni ON ate.uni_codigo=uni.uni_codigo
			INNER JOIN
			tb_cds_visita_domiciliar AS tbvd ON ate.ate_codigo=tbvd.ate_codigo
			INNER JOIN
			tb_cds_visita_dom_desfecho AS tbvdd ON tbvd.co_cds_visita_dom_desfecho=tbvdd.co_cds_visita_dom_desfecho
		WHERE
			ate.ate_codigo = NEW.ate_codigo LOOP
			-- Validação Sexo
			IF (linha.usu_sexo='M') THEN esv_sexo = '0 L'; ELSE esv_sexo = '1 L'; END IF;
			-- Validação Desfecho
			IF (linha.desfecho='1') THEN esv_desfecho = '1 L'; END IF;
			IF (linha.desfecho='2') THEN esv_desfecho = '2 L'; END IF;
			IF (linha.desfecho='3') THEN esv_desfecho = '3 L'; END IF;
			-- Valida Inserção
			IF (linha.ate_codigo IS NOT NULL) THEN
				UPDATE esus_visita_domiciliar
					SET
						esv_profissional_cns = linha.esv_profissional_cns,
						esv_cbo_codigo_2002	= linha.esv_cbo_codigo_2002,
						esv_cnes = linha.esv_cnes,
						esv_num_prontuario = linha.esv_num_prontuario,
						esv_usu_cns	= linha.esv_usu_cns,
						esv_usu_datanasc = linha.esv_usu_datanasc,
						esv_usu_sexo = esv_sexo,
						esv_desfecho = esv_desfecho,
						esv_dtatendimento = linha.ate_data,
						esv_codigo_ibge_mun = linha.esv_codigo_ibge_mun,
						uuid_ficha = null
					WHERE ate_codigo = linha.ate_codigo
					  AND co_cds_visita_domiciliar = linha.co_cds_visita_domiciliar;
				RETURN NEW;
			END IF;
		END LOOP;
	END IF;
	RETURN NULL;
END;
$$;


ALTER TABLE procedimento DROP COLUMN IF EXISTS proc_cor_hexa;
ALTER TABLE procedimento ADD COLUMN proc_cor_hexa CHARACTER VARYING(7);

ALTER TABLE usuario ADD COLUMN usu_origem_prontuario BOOLEAN DEFAULT false;

CREATE OR REPLACE FUNCTION social.esus_cadastro_individual()
	RETURNS trigger AS
$BODY$
DECLARE
	usu_codigo_conf bigint;
	eci_sexo character(20);
	eci_raca character(20);
	eci_nacionalidade character(20);
	eci_exportado integer;
	linha RECORD;
BEGIN
	IF (TG_OP='DELETE') THEN
		DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
		RAISE NOTICE 'DELETE''.';
	ELSE
		IF (NEW.usu_origem_prontuario=false) THEN
			FOR linha IN
			SELECT
				usu.usu_codigo,
				uni.uni_cnes AS eci_cnes,
				usr.cnes_cod_cns AS eci_usr_cns,
				uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
				usu.usu_data_cad AS eci_dtatendimento,
				cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
				usu.usu_datanasc AS eci_usu_dtnascimento,
				usu.cd_nacionalidade AS eci_usu_nacionalidade,
				usu.usu_nome AS eci_usu_nome,
				usu.usu_mae AS eci_usu_mae,
				usu.rac_codigo AS eci_usu_raca,
				usu.usu_sexo AS eci_usu_sexo,
				usu.usu_freq_escolar AS eci_usu_escola,
				usu.usu_deficiencia AS eci_usu_deficiencia,
				usu.usu_sit_rua AS eci_usu_sit_rua,
				usu.usu_cartao_sus AS eci_usu_cns
			FROM
				usuario AS usu
				INNER JOIN
				usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
				INNER JOIN
				unidade AS uni ON usu.uni_codigo=uni.uni_codigo
				LEFT JOIN
				cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo
			WHERE
				usu.usu_codigo = NEW.usu_codigo LOOP
				-- Validação de sexo
				IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
				-- Validação nacionalidade
				IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
				IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
				IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
				-- Validação Raça
				IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
				IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
				IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
				IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
				IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
				IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
				SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
				IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN

					INSERT INTO esus_cadastro_individual
					(usu_codigo,
					 eci_usr_cnes,
					 eci_usr_profissional_cns,
					 eci_usr_codigo_ibge,
					 eci_usr_dtatendimento,
					 eci_usu_codigo_ibge,
					 eci_usu_dtnascimento,
					 eci_usu_nacionalidade,
					 eci_usu_nome,
					 eci_usu_mae,
					 eci_usu_raca,
					 eci_usu_sexo,
					 eci_usu_escola,
					 eci_usu_deficiencia,
					 eci_usu_cns,
					 eci_tipo_dado_serializado,
					 eci_usu_sit_rua,
					 uuid_ficha_ori)
					VALUES
						(linha.usu_codigo,
							linha.eci_cnes,
							linha.eci_usr_cns,
							linha.eci_usr_codigo_ibge,
							NOW(),
							linha.eci_usu_codigo_ibge,
							linha.eci_usu_dtnascimento,
							eci_nacionalidade,
							linha.eci_usu_nome,
							linha.eci_usu_mae,
							eci_raca,
						 eci_sexo,
						 linha.eci_usu_escola,
						 linha.eci_usu_deficiencia,
						 linha.eci_usu_cns,
						 '2 L',
						 linha.eci_usu_sit_rua,
						 (select uuid_ficha
							from esus_cadastro_individual
							where usu_codigo = linha.usu_codigo
							order by eci_codigo asc
							limit 1));

					RAISE NOTICE 'UPDATE''.';

				ELSE
					-- INSERÇÃO
					INSERT INTO esus_cadastro_individual
					(usu_codigo,
					 eci_usr_cnes,
					 eci_usr_profissional_cns,
					 eci_usr_codigo_ibge,
					 eci_usr_dtatendimento,
					 eci_usu_codigo_ibge,
					 eci_usu_dtnascimento,
					 eci_usu_nacionalidade,
					 eci_usu_nome,
					 eci_usu_mae,
					 eci_usu_raca,
					 eci_usu_sexo,
					 eci_usu_escola,
					 eci_usu_deficiencia,
					 eci_usu_cns,
					 eci_tipo_dado_serializado,
					 eci_usu_sit_rua)
					VALUES
						(linha.usu_codigo,
							linha.eci_cnes,
							linha.eci_usr_cns,
							linha.eci_usr_codigo_ibge,
							NOW(),
							linha.eci_usu_codigo_ibge,
							linha.eci_usu_dtnascimento,
							eci_nacionalidade,
							linha.eci_usu_nome,
							linha.eci_usu_mae,
							eci_raca,
						 eci_sexo,
						 linha.eci_usu_escola,
						 linha.eci_usu_deficiencia,
						 linha.eci_usu_cns,
						 '2 L',
						 linha.eci_usu_sit_rua);
				END IF;
			END LOOP;
		END IF;
		RAISE NOTICE 'INSERT''.';
	END IF;
	RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;


ALTER TABLE unidade ADD COLUMN uni_cnes_importador_ignorar BOOLEAN DEFAULT false;

UPDATE unidade SET uni_cnes_importacao=false;

UPDATE medico SET med_cnes_importacao=false;
