SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='112', script='V112__3.145.144.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.145.144' WHERE conf_chave='VERSAO_SAUDE';

--Ativação do sistema
DROP TABLE IF EXISTS social.registro;

CREATE TABLE social.registro
(
  reg_nome character varying(260) NOT NULL,
  reg_sistema_codigo character varying(3) NOT NULL,
  reg_modulo character varying(60) NOT NULL,
  reg_validade date NOT NULL,
  reg_codigo character varying(10),
  reg_senha character varying(100),
  reg_hash character(512) NOT NULL,
  CONSTRAINT registro_pkey PRIMARY KEY (reg_sistema_codigo, reg_hash)
);

INSERT INTO config(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_string,cac_codigo) VALUES ('CHAVE_ATIVACAO','Chave de Ativação',FALSE,1,'',6);

--Desativar usuário
UPDATE usuarios SET usr_ativo='N',usr_mestre=null,usr_senha='f176ff241fdf2b4cd17f3cf8c0c3a435' WHERE usr_nome='DILEE PACHECO';

--Odontograma
ALTER TABLE odonto_procedimentos ALTER COLUMN proc_codigo DROP NOT NULL;
ALTER TABLE odonto_procedimentos ALTER COLUMN odo_proc_marcacao TYPE character varying(60);
ALTER TABLE odonto_procedimentos ALTER COLUMN odo_proc_sextante TYPE character varying(60);
ALTER TABLE odonto_tratamento ADD COLUMN odo_anotacao CHARACTER VARYING(5000);
ALTER TABLE odonto_tratamento ADD COLUMN odo_trat_dtinicial_tratamento TIMESTAMP;
ALTER TABLE odonto_tratamento ADD COLUMN odo_trat_dtfinal_exame TIMESTAMP;

--Adiciona coluna mostra_saldo_estoque as configurações de setor
ALTER TABLE setor ADD mostra_saldo_estoque CHAR DEFAULT 'N' NOT NULL;



/***************
* MODULO SOCIAL * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE social.config SET conf_valor_string='3.66.64' WHERE conf_chave='VERSAO_SOCIAL';

CREATE OR REPLACE FUNCTION atualiza_bai_codigo_rua_nulo()
  RETURNS VOID AS
$BODY$
DECLARE
  dados RECORD;
BEGIN
  FOR dados IN
  SELECT
    rua.rua_codigo       AS codRua,
    domicilio.bai_codigo AS domicilio_bairro
  FROM rua
    LEFT JOIN domicilio ON rua.rua_codigo = domicilio.rua_codigo
  WHERE rua.bai_codigo IS NULL
  LOOP
    UPDATE rua
    SET bai_codigo = dados.domicilio_bairro
    WHERE rua_codigo = dados.codRua;
  END LOOP;
END;
$BODY$
LANGUAGE plpgsql VOLATILE COST 100;
SELECT atualiza_bai_codigo_rua_nulo();

ALTER TABLE domicilio DROP COLUMN bai_codigo;

INSERT INTO acesso (ace_descricao, ace_pai, ace_caminho, ace_modulo)
VALUES ('Bairro', 6, 'zf/domicilio/bairro', 13);

INSERT INTO acesso (ace_descricao, ace_pai, ace_caminho, ace_modulo)
VALUES ('Logradouro', 6, 'zf/domicilio/logradouro', 13);
