SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='115', script='V115__3.148.147.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.148.147.3' WHERE conf_chave='VERSAO_SAUDE';

--Tempo de sessao para sistemas social e saude, para utilizar seguir instruçoes para setar a sessao no php.ini
INSERT INTO config(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_int,cac_codigo) VALUES ('TEMPO_SESSAO_SAUDE','Tempo de Sessão Saúde',false,3,30,6);
INSERT INTO config(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_int,cac_codigo) VALUES ('TEMPO_SESSAO_SOCIAL','Tempo de Sessão Social',false,3,30,6);

--Alteracao entrada estoque, tabela intermediaria
ALTER TABLE itens_movimento_aux ADD COLUMN ite_aux_dose_lote integer NOT NULL DEFAULT 1;
ALTER TABLE itens_movimento_aux ADD COLUMN ite_aux_duracao integer;
ALTER TABLE itens_movimento_aux ADD COLUMN ite_aux_custo_medio numeric;
ALTER TABLE itens_movimento_aux ADD COLUMN fab_codigo integer;
ALTER TABLE itens_movimento_aux ADD COLUMN ite_aux_cod_receita integer;
ALTER TABLE itens_movimento_aux ADD COLUMN ite_aux_codbarras character varying(255) DEFAULT ' '::character varying;

--dropa constraint pq nao sera usado movimento_aux
ALTER TABLE itens_movimento_aux DROP CONSTRAINT fk_movimento_aux;

--Nova opção para Alta do paciente
INSERT INTO internacao_alta (alt_codigo, alt_descricao) VALUES ((SELECT nextval(pg_get_serial_sequence('internacao_alta', 'alt_codigo'))), 'Internação Externa');
CREATE TABLE agendamento_transferencia_profissional (
  atp_codigo INTEGER NOT NULL PRIMARY KEY,
  atp_id_profissional_origem  INTEGER,
  atp_id_profissional_destino INTEGER,
  atp_motivo_transferencia    VARCHAR(1000),
  age_codigo                  INTEGER   NOT NULL,
  data_hora                   TIMESTAMP NOT NULL,
  tipo_transferencia          CHAR
);
COMMENT ON COLUMN agendamento_transferencia_profissional.tipo_transferencia IS '"T" - TRANSFERIDO "L" - LIBERADO';
ALTER TABLE agendamento ALTER COLUMN age_status TYPE CHAR(2) USING age_status::CHAR(2);
ALTER TABLE agendamento ADD COLUMN usr_cod_status integer;
ALTER TABLE agendamento ADD COLUMN datahora_status timestamp without time zone;
COMMENT ON COLUMN social.agendamento.age_status IS 'R  - RECEPCIONADO
RP - RECEPCIONADO COM PRÉ-CONSULTA
E  - EM ATENDIMENTO
EM - EM ATENDIMENTO MÉDICO
P  - PRÉ-CONSULTA
PF - PRÉ CONSULTA FINALIZADA
A  - ATENDIMENTO
AF - ATENDIMENTO FINALIZADO';


--Update na tabela atendimento campo esp_codigo pegando da tabela agendamento
ALTER TABLE atendimento ADD COLUMN esp_codigo integer;
CREATE OR REPLACE FUNCTION atualiza_med_codigo_atendimento()
  RETURNS VOID AS
$BODY$
DECLARE
  dados RECORD;
BEGIN
  FOR dados IN
    SELECT
      age_codigo,
      med_codigo,
      esp_codigo
    FROM agendamento
    WHERE esp_codigo IS NOT NULL
    AND med_codigo is NOT NULL
  LOOP
    UPDATE atendimento
    SET esp_codigo = dados.esp_codigo
    WHERE age_codigo = dados.age_codigo
    AND med_codigo = dados.med_codigo;
  END LOOP;
END;
$BODY$
LANGUAGE plpgsql VOLATILE COST 100;

CREATE OR REPLACE FUNCTION social.limpa_logon()
  RETURNS trigger AS
$BODY$
BEGIN
  DELETE FROM logon WHERE id_login = NEW.id_login AND uni_codigo=NEW.uni_codigo;
  RETURN NEW;
END
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;


/***************
* MODULO SOCIAL * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE social.config SET conf_valor_string='3.68.66.1' WHERE conf_chave='VERSAO_SOCIAL';


