SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='116', script='V116__3.149.148.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.149.148' WHERE conf_chave='VERSAO_SAUDE';

CREATE OR REPLACE FUNCTION social.limpa_logon()
  RETURNS trigger AS
$BODY$
BEGIN
  DELETE FROM logon WHERE id_login = NEW.id_login AND uni_codigo=NEW.uni_codigo;
  RETURN NEW;
END
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;


DROP TABLE chamada;
CREATE TABLE chamada
(
cha_codigo BIGSERIAL NOT NULL
CONSTRAINT chamada_pkey1
PRIMARY KEY,
cha_usu_prontuario VARCHAR(15) NOT NULL,
cha_paciente VARCHAR(255) NOT NULL,
cha_profissional VARCHAR(255) NOT NULL,
cha_setor VARCHAR(255) NOT NULL,
cha_status CHAR,
cha_data_hora TIMESTAMP,
age_codigo INTEGER
CONSTRAINT chamada_age_codigo_fkey
REFERENCES agendamento,
uni_codigo INTEGER,
cha_chamar BOOLEAN DEFAULT FALSE
);
COMMENT ON COLUMN chamada.cha_status IS 'C - CompareceunF - Faltou';
COMMENT ON COLUMN chamada.uni_codigo IS 'codigo unidade';

CREATE OR REPLACE FUNCTION adiciona_colunas_atendimento()
  RETURNS void AS
$BODY$
DECLARE var_column_exists VARCHAR(32);
BEGIN
  SELECT A.ATTNAME INTO VAR_COLUMN_EXISTS FROM PG_ATTRIBUTE A, PG_CLASS C
  WHERE A.ATTRELID = C.OID AND A.ATTNAME = 'vd_peso' AND C.RELNAME = 'atendimento';

  IF var_column_exists IS NULL THEN
    ALTER TABLE atendimento ADD COLUMN  vd_peso numeric(9,3);
  END IF;

  SELECT A.ATTNAME INTO VAR_COLUMN_EXISTS FROM PG_ATTRIBUTE A, PG_CLASS C
  WHERE A.ATTRELID = C.OID AND A.ATTNAME = 'vd_altura' AND C.RELNAME = 'atendimento';

  IF var_column_exists IS NULL THEN
    ALTER TABLE atendimento ADD COLUMN  vd_altura numeric(9,1);
  END IF;
END;
$BODY$
LANGUAGE plpgsql;

SELECT adiciona_colunas_atendimento();
DROP FUNCTION adiciona_colunas_atendimento();

