CREATE TABLE upload_arquivo
(
   upa_codigo bigserial, 
   usu_codigo bigserial, 
   ate_codigo bigint, 
   usr_codigo bigint, 
   upa_data time with time zone, 
   upa_arquivo oid, 
   upa_arquivo_nome character varying(160)
) 
WITH (
  OIDS = FALSE
)
;
ALTER TABLE upload_arquivo ADD PRIMARY KEY (upa_codigo);
ALTER TABLE upload_arquivo ADD FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE upload_arquivo ADD CONSTRAINT ate_codigo FOREIGN KEY (ate_codigo) REFERENCES atendimento (ate_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE upload_arquivo ADD FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE upload_arquivo RENAME upa_codigo  TO upl_codigo;
ALTER TABLE upload_arquivo RENAME upa_data  TO upl_data;
ALTER TABLE upload_arquivo RENAME upa_arquivo  TO upl_arquivo;
ALTER TABLE upload_arquivo RENAME upa_arquivo_nome  TO upl_arquivo_nome;
ALTER TABLE upload_arquivo DROP COLUMN upl_data;
ALTER TABLE upload_arquivo ADD COLUMN upl_data timestamp with time zone;

insert into config(conf_chave,conf_label,conf_readonly,conf_tipo,conf_valor_bool) Values ('ENCAMINHAMENTO_RAIOX','Encaminhamento Laboratorio SUS','f',2,'f');
ALTER TABLE requisicao_exames ADD COLUMN req_encaminhamento boolean;

ALTER TABLE upload_arquivo ADD COLUMN proc_codigo bigint;
ALTER TABLE upload_arquivo ADD FOREIGN KEY (proc_codigo) REFERENCES procedimento (proc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE upload_arquivo ADD COLUMN req_codigo bigint;
ALTER TABLE upload_arquivo ADD FOREIGN KEY (req_codigo) REFERENCES requisicao_exames (req_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;



ALTER TABLE upload_arquivo DROP COLUMN usu_codigo;
ALTER TABLE upload_arquivo DROP COLUMN ate_codigo;
ALTER TABLE upload_arquivo DROP COLUMN proc_codigo;

ALTER TABLE requisicao_exames
   ALTER COLUMN ate_codigo DROP NOT NULL;

ALTER TABLE requisicao_exames ADD COLUMN med_codigo_solicitante bigint;
ALTER TABLE requisicao_exames ADD COLUMN usr_codigo_solicitante bigint;
ALTER TABLE requisicao_exames ADD FOREIGN KEY (ate_codigo) REFERENCES atendimento (ate_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE requisicao_exames ADD FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE requisicao_exames ADD FOREIGN KEY (proc_codigo) REFERENCES procedimento (proc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE requisicao_exames ADD FOREIGN KEY (med_codigo_solicitante) REFERENCES medico (med_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;
ALTER TABLE requisicao_exames ADD FOREIGN KEY (usr_codigo_solicitante) REFERENCES usuarios (usr_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE upload_arquivo DROP COLUMN upl_data;
ALTER TABLE upload_arquivo ADD COLUMN upl_data timestamp with time zone;


UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.42.41' WHERE conf_chave='VERSAO_SAUDE';

UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_COMUM';
UPDATE config SET conf_valor_string='3.23.13' WHERE conf_chave='VERSAO_COMUM';



