SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='124', script='V124__3.157.156.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.157.156' WHERE conf_chave='VERSAO_SAUDE';


/*************************************************************************************************
209935 - Criação de tabelas e scripts de inserção da ficha Marcadores de Consumo Alimentar
*************************************************************************************************/

----------------------------------------------- FRONT-END ---------------------------------------

CREATE TABLE tb_qst_ficha
(
  co_seq_qst_ficha serial NOT NULL,
  co_qst_ficha int,
  no_qst_ficha character varying(80),
  CONSTRAINT co_seq_qst_ficha_pk PRIMARY KEY (co_seq_qst_ficha)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE tb_qst_questao
(
  co_seq_qst_questao serial NOT NULL,
  co_qst_ficha int,
  co_qst_questao int,
  no_qst_questao character varying(255),
  no_qst_identificador character varying(100),
  CONSTRAINT co_seq_qst_questao_pk PRIMARY KEY (co_seq_qst_questao)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE tb_qst_resposta
(
  co_seq_qst_resposta serial NOT NULL,
  co_qst_resposta int,
  no_qst_resposta character varying(80),
  no_qst_identificador character varying(100),
  CONSTRAINT co_seq_qst_resposta_pk PRIMARY KEY (co_seq_qst_resposta)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE tb_qst_questao_resposta
(
  co_seq_qst_questao_resposta serial NOT NULL,
  co_qst_questao int,
  co_qst_resposta int,
  CONSTRAINT co_seq_qst_questao_resposta_pk PRIMARY KEY (co_seq_qst_questao_resposta)
)
WITH (
  OIDS=FALSE
);

INSERT INTO tb_qst_ficha (
  co_qst_ficha, 
  no_qst_ficha)
VALUES (
  1,
  'CONSUMO ALIMENTAR');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  1,
  'A criança ontem tomou leite do peito?',
  'A_CRIANCA_ONTEM_TOMOU_LEITE_DO_PEITO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  3,
  'Mingau',
  'MINGAU');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  4,
  'Água/chá',
  'AGUA_CHA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  5,
  'Leite de vaca',
  'LEITE_VACA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  6,
  'Fórmula infantil',
  'FORMULA_INFANTIL');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  7,
  'Suco de fruta',
  'SUCO_FRUTA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  8,
  'Fruta',
  'FRUTA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  9,
  'Comida de sal(de panela, papa ou sopa)',
  'COMIDA_DE_SAL');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  10,
  'Outros alimentos/bebidas',
  'OUTROS_ALIMENTOS_BEBIDAS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  11,
  'Você tem costume de realizar as refeições assistindo à tv,mexendo no computador e/ou celular?',
  'VOCE_TEM_COSTUME_DE_REALIZAR_AS_REFEICOES_ASSISTINDO_TV_MEXENDO_NO_COMPUTADOR_E_OU_CELULAR');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  12,
  'Quais refeições você faz ao longo do dia?',
  'QUAIS_REFEICOES_VOCE_FAZ_AO_LONGO_DO_DIA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  14,
  'Feijão',
  'FEIJAO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  15,
  'Frutas frescas(não considerar suco de frutas)',
  'FRUTAS_FRESCAS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  16,
  'Verduras e/ou legumes(não considerar batata, mandioca, aipim, macaxeira, cará e inhame)',
  'VERDURAS_E_OU_LEGUMES');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  17,
  'Hamburguer e/ou embutidos(presunto, mortadela, salame, linguiça, salsicha)',
  'HAMBURGUER_E_OU_EMBUTIDOS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  18,
  'Bebidas adoçadas(refrigerantes, suco de caixinha, suco em pó, água de coco de caixinha, xaropes de guaraná/groselha, suco de fruta com adição de açúcar)',
  'BEBIDAS_ADOCADAS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  19,
  'Macarrão instantâneo, salgadinhos de pacote ou biscoitos salgados',
  'MACARRAO_INSTANTANEO_SALGADINHOS_BISCOITOS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  20,
  'Biscoito recheado, doces  ou guloseimas(balas, pirulitos, chicletes, caramelo, gelatina)',
  'BISCOITO_RECHEADO_DOCES_OU_GULOSEIMAS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  21,
  'A criança ontem tomou leite do peito?',
  'A_CRIANCA_ONTEM_TOMOU_LEITE_PEITO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  22,
  'Ontem, a criança comeu fruta inteira, em pedaço ou amassada?',
  'ONTEM_A_CRIANCA_COMEU_FRUTA_INTEIRA_PEDACO_AMASSADO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  23,
  'Se sim, quantas vezes?',
  'SE_SIM_QUANTAS_VEZES');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  24,
  'Ontem a criança comeu comida de sal(de panela, papa ou sopa)?',
  'ONTEM_A_CRIANCA_COMEU_COMIDA_DE_SAL');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  25,
  'Se sim, quantas vezes?',
  'SE_COMEU_COMIDA_DE_SAL_QUANTAS_VEZES');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  26,
  'Se sim, essa comida foi oferecida:',
  'SE_SIM_ESSA_COMIDA_FOI_OFERECIDA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  28,
  'Outro leite que não o leite de peito',
  'OUTRO_LEITE_QUE_NAO_LEITE_DO_PEITO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  29,
  'Mingau com leite',
  'MINGAU_COM_LEITE');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  30,
  'Iogurte',
  'IOGURTE');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  31,
  'Legumes(não considerar os utilizados como temperos, nem batata, mandioca/aipim/macaxeira, cará e inhame)',
  'LEGUMES');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  32,
  'Vegetal ou fruta de cor alaranjada(abóbora ou jerimum, cenoura, mamão, manga) ou folhas verdes-escuras(couve, caruru, beldroega, bertalha, espinafre, mostarda)',
  'VEGETAL_OU_FRUTAS_COR_ALARANJADA_OU_FOLHAS_ESCURAS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  33,
  'Verdura de folha(alface, acelga, repolho)',
  'VERDURA_DE_FOLHA');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  34,
  'Carne(boi, frango, peixe, porco, miúdos, outras) ou ovo',
  'CARNE');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  35,
  'Fígado',
  'FIGADO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  36,
  'Feijão',
  'FEIJAO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  37,
  'Arroz, batata, inhame, aipim/macaxeira/mandioca, farinha ou macarrão(sem ser instantâneo)',
  'ARROZ_BATATA_INHAME_MANDIOCA_FARINHA_MACARRAO');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  38,
  'Hambúrguer e/ou embutidos(presunto, mortadela, salame, linguiça, salsicha)',
  'HAMBURGUER_E_OU_EMBUTIDOS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  39,
  'Bebidas adoçadas(refrigerante, suco de caixinha, suco em pó, água de coco de caixinha, xaropes de guaraná/groselha, suco de fruta com adição de açúcar)',
  'BEBIDAS_ADOCADAS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  40,
  'Macarrão instantâneo, salgadinhos de pacote ou biscoitos salgados',
  'MACARRAO_INSTANTANEO_SALGADINHOS_BISCOITOS');

INSERT INTO tb_qst_questao (
  co_qst_ficha,
  co_qst_questao,
  no_qst_questao,
  no_qst_identificador)
VALUES (
  1,
  41,
  'Biscoito recheado, doces ou guloseimas(balas, pirulitos, chiclete, caramelo, gelatina)',
  'BISCOITO_RECHEADO_DOCES_OU_GULOSEIMAS');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  1,
  'Sim',
  'SIM');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  2,
  'Não',
  'NAO');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  3,
  'Não sabe',
  'NAO_SABE');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  4,
  '1 vezes',
  'UMA_VEZ');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  5,
  '2 vezes',
  'DUAS_VEZES');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  6,
  '3 vezes ou mais',
  'TRES_VEZES_OU_MAIS');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  7,
  'Em pedaços',
  'EM_PEDACOS');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  8,
  'Amassada',
  'AMASSADA');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  9,
  'Passada na peneira',
  'PASSADA_NA_PENEIRA');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  10,
  'Liquidificada',
  'LIQUIDIFICADA');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  11,
  'Só o caldo',
  'SO_O_CALDO');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  12,
  'Café da manhã',
  'CAFE_DA_MANHA');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  13,
  'Lanche da manhã',
  'LANCHE_DA_MANHA');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  14,
  'Almoço',
  'ALMOCO');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  15,
  'Lanche da tarde',
  'LANCHE_DA_TARDE');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  16,
  'Jantar',
  'JANTAR');

INSERT INTO tb_qst_resposta (
  co_qst_resposta,
  no_qst_resposta,
  no_qst_identificador)
VALUES (
  17,
  'Ceia',
  'CEIA');

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  1,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  1,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  1,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  3,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  3,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  3,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  4,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  4,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  4,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  5,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  5,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  5,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  6,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  6,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  6,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  7,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  7,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  7,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  8,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  8,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  8,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  9,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  9,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  9,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  10,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  10,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  10,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  11,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  11,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  11,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  12,
  12);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  12,
  13);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  12,
  14);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  12,
  15);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  12,
  16);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  12,
  17);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  14,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  14,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  14,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  15,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  15,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  15,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  16,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  16,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  16,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  17,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  17,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  17,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  18,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  18,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  18,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  19,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  19,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  19,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  20,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  20,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  20,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  21,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  21,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  21,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  22,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  22,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  22,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  23,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  23,
  4);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  23,
  5);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  23,
  6);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  24,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  24,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  24,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  25,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  25,
  4);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  25,
  5);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  25,
  6);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  26,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  26,
  7);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  26,
  8);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  26,
  9);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  26,
  10);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  26,
  11);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  28,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  28,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  28,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  29,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  29,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  29,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  30,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  30,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  30,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  31,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  31,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  31,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  32,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  32,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  32,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  33,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  33,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  33,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  34,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  34,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  34,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  35,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  35,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  35,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  36,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  36,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  36,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  37,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  37,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  37,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  38,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  38,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  38,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  39,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  39,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  39,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  40,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  40,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  40,
  3);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  41,
  1);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  41,
  2);

INSERT INTO tb_qst_questao_resposta (
  co_qst_questao,
  co_qst_resposta)
VALUES (
  41,
  3);

  ---------------------------------------------- BACK END -------------------------------------------

CREATE TABLE tb_cds_consumo_alimentar
(
  co_seq_cds_consumo_alimentar bigserial NOT NULL,
  ate_codigo int,
  CONSTRAINT co_seq_cds_consumo_alimentar_pk PRIMARY KEY (co_seq_cds_consumo_alimentar)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE tb_cds_consumo_alimentar_resposta
(
  co_seq_cds_con_ali_resp bigserial NOT NULL,
  co_cds_consumo_alimentar int,
  co_qst_questao int,
  co_qst_resposta int,
  CONSTRAINT co_seq_cds_con_ali_resp_pk PRIMARY KEY (co_seq_cds_con_ali_resp)
  --- uma constraint pra cada coluna
)
WITH (
  OIDS=FALSE
);

----------------------------------------------- ESUS ----------------------------------------------------------

CREATE TABLE esus_consumo_alimentar
(
  eca_codigo bigserial NOT NULL,
  co_cds_consumo_alimentar bigint NOT NULL,
  eca_profissional_cns character varying(20) NOT NULL,
  eca_cbo character varying(20) NOT NULL,
  eca_cnes character varying(20) NOT NULL,
  eca_ine character varying(20),
  eca_dt_atividade character varying(20) NOT NULL,
  eca_codigo_ibge character varying(20) NOT NULL,
  eca_cidadao_cns character varying(20) NOT NULL,
  eca_cidadao_nome character varying(70) NOT NULL,
  eca_cidadao_dt_nasc character varying(20) NOT NULL,
  eca_cidadao_sexo character varying(20) NOT NULL,
  eca_local_atendimento character varying(20) NOT NULL,
  uuid_ficha character varying(60),
  CONSTRAINT eca_codigo_pk PRIMARY KEY (eca_codigo),
  CONSTRAINT eca_codigo_fk FOREIGN KEY (co_cds_consumo_alimentar)
      REFERENCES tb_cds_consumo_alimentar (co_seq_cds_consumo_alimentar) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

  CREATE OR REPLACE FUNCTION esus_consumo_alimentar()
  RETURNS trigger AS
$BODY$
DECLARE
linha RECORD;
BEGIN
  FOR linha IN
    SELECT
      csa.co_seq_cds_consumo_alimentar AS co_cds_consumo_alimentar,
        usr.cnes_cod_cns AS eca_profissional_cns,
      esp.cod_cbo AS eca_cbo,
      uni.uni_cnes AS eca_cnes,
      tbe.nu_ine AS eca_ine,
      ate.ate_data AS eca_dt_atividade,
      uni.uni_codigo_ibge AS eca_codigo_ibge,
      usu.usu_cartao_sus AS eca_cidadao_cns,
      usu.usu_nome AS eca_cidadao_nome,
      usu.usu_datanasc AS eca_cidadao_dt_nasc,
      case when usu.usu_sexo = 'M' then '0'
      when usu.usu_sexo = 'F' then '1'
      else '4'
      end AS eca_cidadao_sexo,
      tla.co_local_atend AS eca_local_atendimento
    FROM tb_cds_consumo_alimentar csa
      INNER JOIN atendimento ate ON ate.ate_codigo = csa.ate_codigo
      INNER JOIN usuarios usr ON usr.usr_codigo = ate.med_codigo
      INNER JOIN medico_especialidade as me ON me.med_codigo = ate.med_codigo and
        me.uni_codigo = ate.uni_codigo
      INNER JOIN especialidade as esp ON esp.esp_codigo = me.esp_codigo
      INNER JOIN unidade uni ON uni.uni_codigo = ate.uni_codigo
      INNER JOIN usuario usu ON ate.usu_codigo = usu.usu_codigo
      LEFT JOIN usuarios_equipe use ON usr.usr_codigo = use.usr_codigo
      LEFT JOIN tb_equipe tbe ON use.co_equipe = tbe.co_seq_equipe
      INNER JOIN tb_local_atend tla ON tla.co_local_atend = ate.co_local_atend
    WHERE 
      csa.co_seq_cds_consumo_alimentar=NEW.co_seq_cds_consumo_alimentar LOOP

    IF (TG_OP='INSERT') THEN
      IF linha.co_cds_consumo_alimentar IS NOT NULL THEN        
        INSERT INTO esus_consumo_alimentar(
          co_cds_consumo_alimentar,
          eca_profissional_cns,
          eca_cbo,
                eca_cnes,
                eca_ine,
                eca_dt_atividade,
                eca_codigo_ibge,
                eca_cidadao_cns,
                eca_cidadao_nome,
                eca_cidadao_dt_nasc,
                eca_cidadao_sexo,
                eca_local_atendimento
        ) VALUES (
          linha.co_cds_consumo_alimentar,
          linha.eca_profissional_cns,
          linha.eca_cbo,
                linha.eca_cnes,
                linha.eca_ine,
                linha.eca_dt_atividade,
                linha.eca_codigo_ibge,
                linha.eca_cidadao_cns,
                linha.eca_cidadao_nome,
                linha.eca_cidadao_dt_nasc,
                linha.eca_cidadao_sexo,
                linha.eca_local_atendimento
        );
        RETURN NEW;
      END IF;
    ELSE 
      IF linha.co_cds_consumo_alimentar IS NOT NULL THEN        
        UPDATE esus_consumo_alimentar 
          SET co_cds_consumo_alimentar = linha.co_cds_consumo_alimentar, 
            eca_profissional_cns = linha.eca_profissional_cns, 
            eca_cbo = linha.eca_cbo,
            eca_cnes = linha.eca_cnes,
            eca_ine = linha.eca_ine,
            eca_dt_atividade = linha.eca_dt_atividade,
            eca_codigo_ibge = linha.eca_codigo_ibge,
            eca_cidadao_cns = linha.eca_cidadao_cns,
            eca_cidadao_nome = linha.eca_cidadao_nome,
            eca_cidadao_dt_nasc = linha.eca_cidadao_dt_nasc,
            eca_cidadao_sexo = linha.eca_cidadao_sexo,
            eca_local_atendimento = linha.eca_local_atendimento
        WHERE 
          co_cds_consumo_alimentar=NEW.co_seq_cds_consumo_alimentar;
        RETURN NEW;
      END IF;
    END IF;
  END LOOP;
RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE TRIGGER atualiza_esus_consumo_alimentar
  AFTER INSERT OR UPDATE 
  ON tb_cds_consumo_alimentar
  FOR EACH ROW
  EXECUTE PROCEDURE esus_consumo_alimentar();


/*************************************************************************************************
209935 - Fim
*************************************************************************************************/

/*************************************************************************************************
210044 - Criação de scripts de inserção na tabela "acessos_ficha_esus" para controle de acesso da 
         ficha Marcadores de Consumo Alimentar
*************************************************************************************************/

INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251605', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515305', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223505', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223565', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223530', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223545', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223550', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223555', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223560', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223405', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223415', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223430', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223445', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223425', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223650', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223605', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223810', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225105', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225110', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225120', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225125', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225142', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225130', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225135', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225140', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225155', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225160', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225165', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225170', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225180', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225250', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225185', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225195', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225103', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225255', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225109', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225350', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225112', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225118', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225265', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225121', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225270', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225275', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225124', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225127', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225133', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('2231F9', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225136', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225139', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225154', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('225285', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('226305', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251545', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223710', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('239415', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('234410', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('2241E1', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251550', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251555', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251510', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251540', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251505', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('251530', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('239425', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223905', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223204', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223208', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223280', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223284', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223212', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223216', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223220', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223224', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223228', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223276', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223288', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223232', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223236', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223240', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223244', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223248', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223252', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223256', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223260', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223264', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223268', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223272', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('223293', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322415', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322430', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322405', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322425', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('352210', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515105', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515140', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515130', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515125', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515120', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('515310', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322230', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322250', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322205', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322245', 'ca');
INSERT INTO acessos_ficha_esus(afe_cbo, afe_ficha)
    VALUES ('322210', 'ca');

/*************************************************************************************************
210044 - Fim
*************************************************************************************************/

/*************************************************************************************************
165132 - Adicionado coluna "asam_status" na tabela "as_atendimento_motivo" para ativar e inativar
		 o motivo do atendimento. 
		 Inserido novo registro na tabela "acesso" para acesso da nova tela de Motivos.
*************************************************************************************************/

ALTER TABLE as_atendimento_motivo
ADD asam_status boolean DEFAULT true;

INSERT INTO acesso(
            ace_descricao, 
            ace_pai, 
            ace_caminho, 
            ace_modulo)
    VALUES (
            'Motivos', 
            6, 
            'zf/default/motivo', 
            13);

/*************************************************************************************************
165132 - Fim
*************************************************************************************************/

/*************************************************************************************************
164489 - Criação da tabela associativa "as_atendimento_basicocras_motivo", inserção de valores já
         existentes nela e drop da coluna na tabela "as_atendimento_basicocras".
*************************************************************************************************/

CREATE TABLE as_atendimento_basicocras_motivo
(
  asabm_codigo bigserial NOT NULL,
  asab_codigo int NOT NULL,
  asam_codigo int NOT NULL,
  CONSTRAINT pk_asabm_codigo PRIMARY KEY (asabm_codigo),
  CONSTRAINT fk_asab_codigo FOREIGN KEY (asab_codigo)
      REFERENCES as_atendimento_basicocras (asab_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_asam_codigo FOREIGN KEY (asam_codigo)
      REFERENCES as_atendimento_motivo (asam_codigo) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);

INSERT INTO as_atendimento_basicocras_motivo (asab_codigo, asam_codigo)
SELECT asab.asab_codigo, asab.asam_codigo
  FROM as_atendimento_basicocras asab
WHERE asab.asam_codigo is not null;

ALTER TABLE as_atendimento_basicocras
DROP COLUMN asam_codigo;

/*************************************************************************************************
164489 - Fim
*************************************************************************************************/


/*************************************************************************************************
#0 - Alteração de labels da tela de configuração, para indicar a unidade de tempo do parâmetro
*************************************************************************************************/

UPDATE config SET conf_label = 'Tempo de Sessão Saúde (Minutos)' WHERE conf_chave = 'TEMPO_SESSAO_SAUDE';
UPDATE config SET conf_label = 'Tempo de Sessão Social (Minutos)' WHERE conf_chave = 'TEMPO_SESSAO_SOCIAL';
UPDATE config SET conf_label = 'Tempo máximo de espera para atendimento médico (Horas)' WHERE conf_chave = 'TEMPO_ESPERA';

/*************************************************************************************************
#0 - Fim
*************************************************************************************************/
