SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='125', script='V125__3.158.157.sql',installed_on=NOW();

/***************
* MODULO SAUDE * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.158.157' WHERE conf_chave='VERSAO_SAUDE';

/******************************************************************************************************
214393 - Implementar campo CATMAT Horus
******************************************************************************************************/
-- Altera tipo da coluna de VARCHAR para CHAR(14)
ALTER TABLE produto ALTER COLUMN pro_horus TYPE char(14);
/******************************************************************************************************
214393 - Fim
******************************************************************************************************/

/******************************************************************************************************
217936 - Erro ao importar arquivo xml cnes
******************************************************************************************************/
ALTER TABLE medico ALTER COLUMN med_end_telefone SET DATA TYPE character varying(40);
/******************************************************************************************************
217936 - Fim
******************************************************************************************************/

/***************
* MODULO SOCIAL * 
****************/

--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
UPDATE social.config SET conf_valor_string='3.75.73' WHERE conf_chave='VERSAO_SOCIAL';
/******************************************************************************************************
155923 - Relatório de atendimentos básico
******************************************************************************************************/
INSERT INTO social.acesso
			(ace_descricao,
			 ace_pai,
			 ace_caminho,
			 ace_modulo,
			 ace_imagem,
			 ace_item_menu,
			 ace_ordem)
	VALUES 	('Atendimento Básico',
		   	(SELECT ace_codigo
		   	   FROM social.acesso
		   	  WHERE ace_descricao = 'Relatórios'),
		   	 'zf/relatorio/atendimento-basico/form-atendimento-basico',
		   	 13,
		   	 NULL,
		   	 NULL,
		   	 NULL);

/******************************************************************************************************
155923 - Fim
******************************************************************************************************/

/******************************************************************************************************
211897 - Drop e modificação das triggers (atualiza_esus_odonto e atualiza_esus_atendimento_individual) 
		 e functions (esus_odonto, esus_atendimento_individual) para não ser possivel salvar nas 
		 tabelas do esus quando o tipo da unidade for 'H'.
******************************************************************************************************/

DROP TRIGGER atualiza_esus_odonto ON social.odonto_procedimentos_controle;

DROP FUNCTION social.esus_odonto();

-- FUNCTION: social.esus_odonto()

-- DROP FUNCTION social.esus_odonto();

CREATE FUNCTION social.esus_odonto()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE
AS $BODY$

DECLARE 
	linha RECORD;
	eo_sexo character varying(20);
	ret integer;
BEGIN
	SELECT 
	INTO ret apc.ate_codigo
	from odonto_procedimentos_controle apc
	join atendimento ate on ate.ate_codigo = apc.ate_codigo
	join unidade uni on uni.uni_codigo = ate.uni_codigo
	where apc.ate_codigo = new.ate_codigo
	and uni.uni_tipo <> 'H';

	IF ret IS NOT NULL THEN
		IF (TG_OP = 'DELETE') THEN
			DELETE FROM esus_odonto WHERE eo_codigo = OLD.eo_codigo;
			RETURN OLD;
		ELSE
			FOR linha IN
				SELECT DISTINCT
					odpc.odo_pcon_codigo,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS eo_profissional_cns,
					esp.cod_cbo AS eo_cbo_codigo_2002,
					uni.uni_cnes AS eo_cnes,
					ate.ate_data AS eo_dtatendimento,
					uni.uni_codigo_ibge AS eo_codigo_ibge_mun,
					usu.usu_datanasc AS eo_dtnascimento,
					usu.usu_cartao_sus AS eo_num_cartao_sus,	
					usu.usu_prontuario AS eo_numprontuario,
					age.tat_codigo AS eo_tipo_atendimento,
					age.tp_cod AS eo_tipo_consulta,					
					usu.usu_sexo					
				FROM 
					odonto_procedimentos_controle AS odpc 
				INNER JOIN 
					atendimento AS ate ON odpc.ate_codigo=ate.ate_codigo
				INNER JOIN 
					agendamento AS age ON ate.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON ate.med_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON ate.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON ate.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
				WHERE 
					odpc.odo_pcon_codigo = NEW.odo_pcon_codigo LOOP
				-- Validação de sexo
				IF (linha.usu_sexo='M') THEN 
					eo_sexo = '0 L';
				ELSE
					eo_sexo = '1 L';
				END IF;
				-- Realiza a inserção dos da ficha de procedimento do E-SUS
				INSERT INTO esus_odonto(
					odo_pcon_codigo,
					co_local_atend,
					eo_profissional_cns,
					eo_cbo_codigo_2002,
					eo_cnes,
					eo_dtatendimento,
					eo_codigo_ibge_mun,
					eo_dtnascimento,
					eo_num_cartao_sus,
					eo_numprontuario,
					eo_tipo_atendimento,
					eo_tipo_consulta,
					eo_sexo,
					eo_tipo_dado_serializado
				) VALUES (
					linha.odo_pcon_codigo,
					linha.co_local_atend,
					linha.eo_profissional_cns,
					linha.eo_cbo_codigo_2002,
					linha.eo_cnes,
					linha.eo_dtatendimento,
					linha.eo_codigo_ibge_mun,
					linha.eo_dtnascimento,
					linha.eo_num_cartao_sus,
					linha.eo_numprontuario,
					linha.eo_tipo_atendimento,
					linha.eo_tipo_consulta,
					eo_sexo,
					'5 L'
				);
				RETURN NEW;
				RAISE NOTICE 'Registro inserido com sucesso''.';
			END LOOP;
		END IF;	
	END IF;
	RETURN NULL;
END;
$BODY$;
CREATE TRIGGER atualiza_esus_odonto
AFTER INSERT OR UPDATE 
ON social.odonto_procedimentos_controle
FOR EACH ROW
EXECUTE PROCEDURE social.esus_odonto();

DROP TRIGGER atualiza_esus_atendimento_individual ON social.rl_cds_atend_individual_condut;

DROP FUNCTION social.esus_atendimento_individual();

-- FUNCTION: social.esus_atendimento_individual()

-- DROP FUNCTION social.esus_atendimento_individual();

CREATE FUNCTION social.esus_atendimento_individual()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE
AS $BODY$

DECLARE 
	linha RECORD;
	eai_sexo character varying(20);
	ret integer;
BEGIN
	SELECT 
	INTO ret rai.ate_codigo
	from rl_cds_atend_individual_condut rai
	join atendimento ate on ate.ate_codigo = rai.ate_codigo
	join unidade uni on uni.uni_codigo = ate.uni_codigo
	where rai.ate_codigo = new.ate_codigo
	and uni.uni_tipo <> 'H'
	group by rai.ate_codigo;

	IF ret IS NOT NULL THEN
		IF (TG_OP = 'DELETE') THEN
			DELETE FROM esus_atendimento_individual WHERE ate_codigo = OLD.ate_codigo;
			RETURN OLD;
		ELSE
			FOR linha IN
				SELECT DISTINCT
					ate.ate_codigo,
					age.tat_codigo AS eai_tipo_atendimento,
					tbl.co_local_atend,
					usr.cnes_cod_cns AS eai_profissional_cns,
					esp.cod_cbo AS eai_cbo_codigo_2002,
					uni.uni_cnes AS eai_cnes,
					ate.ate_data AS eai_dtatendimento,
					uni.uni_codigo_ibge AS eai_codigo_ibge_mun,
					usu.usu_cartao_sus AS eai_num_cartao_sus,
					usu.usu_datanasc AS eai_dtnascimento,
					usu.usu_prontuario AS eai_numprontuario, 
					usu.usu_sexo
				FROM 
					atendimento AS ate
				INNER JOIN 
					agendamento AS age ON ate.age_codigo=age.age_codigo
				INNER JOIN 
					especialidade AS esp ON age.esp_codigo=esp.esp_codigo
				INNER JOIN 
					usuarios AS usr ON ate.med_codigo=usr.usr_codigo
				INNER JOIN
					usuario AS usu ON ate.usu_codigo=usu.usu_codigo
				INNER JOIN
					unidade AS uni ON ate.uni_codigo=uni.uni_codigo
				INNER JOIN 
					tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
				LEFT JOIN
					rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo=rlai.ate_codigo
				INNER JOIN 
					rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo=rlaic.ate_codigo
				WHERE 
					ate.ate_codigo = NEW.ate_codigo LOOP
				-- Validação de sexo
				IF (linha.usu_sexo='M') THEN 
					eai_sexo = '0 L';
				ELSE
					eai_sexo = '1 L';
				END IF;
				-- Realiza a inserção dos da ficha de procedimento do E-SUS
				INSERT INTO esus_atendimento_individual(
					ate_codigo,
					co_local_atend,
					eai_profissional_cns,
					eai_cbo_codigo_2002,
					eai_cnes,
					eai_dtatendimento,
					eai_codigo_ibge_mun,
					eai_dtnascimento,
					eai_num_cartao_sus,
					eai_numprontuario,
					eai_tipo_atendimento,
					eai_sexo,
					eai_tipo_dado_serializado
				) VALUES (
					linha.ate_codigo,
					linha.co_local_atend,
					linha.eai_profissional_cns,
					linha.eai_cbo_codigo_2002,
					linha.eai_cnes,
					linha.eai_dtatendimento,
					linha.eai_codigo_ibge_mun,
					linha.eai_dtnascimento,
					linha.eai_num_cartao_sus,
					linha.eai_numprontuario,
					linha.eai_tipo_atendimento,
					eai_sexo,
					'4 L'
				);
				RETURN NEW;
				RAISE NOTICE 'Registro inserido com sucesso''.';
			END LOOP;
		END IF;
	END IF;
	RETURN NULL;
END;

$BODY$;
CREATE TRIGGER atualiza_esus_atendimento_individual
AFTER INSERT OR DELETE OR UPDATE 
ON social.rl_cds_atend_individual_condut
FOR EACH ROW
EXECUTE PROCEDURE social.esus_atendimento_individual();

/******************************************************************************************************
211897 - Fim
******************************************************************************************************/

/******************************************************************************************************
213216 - Alterar senha no login e dentro do sistema
******************************************************************************************************/
INSERT INTO acesso (ace_descricao, ace_pai, ace_caminho, ace_modulo)
    VALUES (
      'Alterar Senha',
      (SELECT a.ace_codigo FROM acesso a WHERE a.ace_descricao = 'Usuários' LIMIT 1),
      'zf/usuarios/usuarios/altera-senha',
      13
    );
CREATE OR REPLACE FUNCTION adiciona_acesso_altera_senha()
  RETURNS VOID AS
$BODY$
DECLARE dados RECORD;
        acesso INT := (SELECT ace_codigo FROM acesso WHERE ace_descricao = 'Alterar Senha');
BEGIN
  FOR dados IN
  SELECT grac_codigo
  FROM grupo_acesso
  LOOP
    INSERT INTO grupo_acesso_permissoes (grac_codigo, ace_codigo)
    VALUES (dados.grac_codigo, acesso);
  END LOOP;
END;
$BODY$
LANGUAGE plpgsql VOLATILE COST 100;

SELECT adiciona_acesso_altera_senha();
DROP FUNCTION adiciona_acesso_altera_senha();

/******************************************************************************************************
211897 - Fim
******************************************************************************************************/

/******************************************************************************************************
104994 -  Relatório por Programa Social
******************************************************************************************************/
INSERT INTO social.acesso
			(ace_descricao,
			 ace_pai,
			 ace_caminho,
			 ace_modulo,
			 ace_imagem,
			 ace_item_menu,
			 ace_ordem)
	VALUES 	('Programas Sociais',
		   	(SELECT ace_codigo
		   	   FROM social.acesso
		   	  WHERE ace_descricao = 'Relatórios'),
		   	 'zf/relatorio/programas-sociais/form-programas-sociais',
		   	 13,
		   	 NULL,
		   	 NULL,
		   	 NULL);

/******************************************************************************************************
104994 - Fim
******************************************************************************************************/
/******************************************************************************************************
213127 - Relatório de Atividades por Profissional
******************************************************************************************************/
INSERT INTO social.acesso
(ace_descricao,
 ace_pai,
 ace_caminho,
 ace_modulo,
 ace_imagem,
 ace_item_menu,
 ace_ordem)
VALUES 	('Atividades por Profissional',
				 (SELECT ace_codigo
					FROM social.acesso
					WHERE ace_descricao = 'Relatórios'),
				 'zf/relatorio/atividade-coletiva-profissional/form-atividade-coletiva-profissional',
				 13,
				 NULL,
				 NULL,
				 NULL);

/******************************************************************************************************
213127 - Fim
******************************************************************************************************/

/******************************************************************************************************
216719 - Adequação das permissões de acesso as fichas do e-SUS por CBO
******************************************************************************************************/

--EXCLUI OS DADOS EXISTENTES
DELETE FROM acessos_ficha_esus;

--CADASTRO INDIVIDUAL
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322205', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322210', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322230', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322245', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322250', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322415', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322430', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515105', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515120', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515125', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515130', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515140', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515310', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('422110', 'ci');

--CADASTRO DOMICILIAR
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322205', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322210', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322230', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322245', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322250', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322415', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322430', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515105', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515120', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515125', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515130', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515140', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515310', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('422110', 'cd');

--ATENDIMENTO INDIVIDUAL
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223405', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223415', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223430', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223445', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223425', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223810', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225110', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225185', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225118', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225121', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251545', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223710', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2241E1', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251550', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251555', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251510', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251540', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251505', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251530', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223905', 'ai');

--ATENDIMENTO ODONTOLOGICO INDIVIDUAL
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223204', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223208', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223280', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223284', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223212', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223216', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223220', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223224', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223228', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223276', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223288', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223232', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223236', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223240', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223244', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223248', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223252', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223256', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223260', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223264', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223268', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223272', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223293', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322415', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322430', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'o');

--ATIVIDADE COLETIVA
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223405', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223415', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223430', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223445', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223425', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223810', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225110', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225185', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225118', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225121', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251545', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223710', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2241E1', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251550', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251555', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251510', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251540', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251505', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251530', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223905', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223204', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223208', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223280', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223284', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223212', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223216', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223220', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223224', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223228', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223276', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223288', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223232', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223236', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223240', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223244', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223248', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223252', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223256', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223260', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223264', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223268', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223272', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223293', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322415', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322430', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515105', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515140', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515130', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515125', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515120', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515310', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322230', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322250', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322205', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322245', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322210', 'ac');

--PROCEDIMENTOS
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223405', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223415', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223430', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223445', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223425', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223810', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225110', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225185', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225118', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225121', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251545', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223710', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2241E1', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251550', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251555', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251510', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251540', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251505', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251530', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223905', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322230', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322250', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322205', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322245', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322210', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('324205', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515105', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515140', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515130', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515125', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515120', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515310', 'p');

--VISITA DOMICILIAR
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515105', 'vd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515120', 'vd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515310', 'vd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515140', 'vd');

--CONSUMO ALIMENTAR
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223405', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223415', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223430', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223445', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223425', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223810', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225110', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225185', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225118', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225121', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251545', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223710', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2241E1', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251550', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251555', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251510', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251540', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251505', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251530', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223905', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223204', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223208', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223280', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223284', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223212', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223216', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223220', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223224', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223228', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223276', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223288', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223232', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223236', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223240', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223244', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223248', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223252', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223256', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223260', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223264', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223268', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223272', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223293', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322415', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322430', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515105', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515140', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515130', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515125', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515120', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515310', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322230', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322250', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322205', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322245', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322210', 'ca');

--AVALIACAO DE ELEGIBILIDADE
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F8', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231A2', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223510', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223660', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223655', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223630', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223635', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225115', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225150', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225210', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225225', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225230', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225203', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225260', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225320', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'ae');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'ae');

--ATENDIMENTO DOMICILIAR
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F8', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231A2', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223204', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223208', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223280', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223212', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223220', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223276', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223288', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223232', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223236', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223240', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223248', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223256', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223260', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223264', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223268', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223272', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223293', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223405', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223415', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223410', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223430', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223445', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223510', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223660', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223655', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223630', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223635', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223710', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223810', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223815', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223830', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223840', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223905', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225115', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225150', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225210', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225225', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225230', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225203', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225260', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225320', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251550', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251555', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251510', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251540', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251505', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251520', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251525', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251530', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322230', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322250', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322205', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322245', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322210', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ad');

--FICHA COMPLEMENTAR ZIKA
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2231F9', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223405', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223415', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223430', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223445', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223425', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223505', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223565', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223530', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223545', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223550', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223555', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223560', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223650', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223605', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223710', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223810', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223905', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('2241E1', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225105', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225110', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225120', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225125', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225142', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225130', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225135', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225140', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225155', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225160', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225165', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225170', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225180', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225185', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225195', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225103', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225109', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225112', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225118', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225121', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225124', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225127', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225133', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225136', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225139', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225154', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225250', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225255', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225265', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225270', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225275', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225285', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('225350', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251545', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251550', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251555', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251510', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251540', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251505', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251530', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('251605', 'zk');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'zk');

/******************************************************************************************************
216719 - Fim
******************************************************************************************************/

/******************************************************************************************************
0 - Limitar maxlenght do Tempo de Sessão Saúde e Tempo de Sessão Social nas configuração do sistema.
******************************************************************************************************/

ALTER TABLE social.config
 ADD COLUMN conf_maxlength integer;
	
UPDATE social.config 
   SET conf_maxlength = 3 
 WHERE conf_chave = 'TEMPO_SESSAO_SAUDE' 
	OR conf_chave = 'TEMPO_SESSAO_SOCIAL';

/******************************************************************************************************
0 - Fim
******************************************************************************************************/