SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='127', script='V127__3.160.159.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.160.159' WHERE conf_chave='VERSAO_SAUDE';

/******************************************************************************************************
112958 - Adicionar Tipos de Veiculo
******************************************************************************************************/

INSERT INTO social.veiculo_especie(veie_descricao)
    VALUES ('Caminhão');
INSERT INTO social.veiculo_especie(veie_descricao)
    VALUES ('Micro-ônibus');
INSERT INTO social.veiculo_especie(veie_descricao)
    VALUES ('Ônibus');

/******************************************************************************************************
112958 - Fim
******************************************************************************************************/


/******************************************************************************************************
0 - Corrige controllers pra funcionar no Sistemas Operacionais Case Sensitive
******************************************************************************************************/

UPDATE permissoes
    SET perm_programa='zf/relatorio/visita-domiciliar',
        perm_objeto='zf/relatorio/visita-domiciliar'
    WHERE perm_objeto='zf/relatorio/visitadomiciliar';

UPDATE permissoes SET perm_programa = replace(perm_programa, 'programasfederais', 'programas-federais'),
        perm_objeto = replace(perm_objeto, 'programasfederais', 'programas-federais');

/******************************************************************************************************
0 - Fim
******************************************************************************************************/


/******************************************************************************************************
220407 - Ficha de Procedimentos de Unidade Tipo Hospital(uni_tipo = 'H') não serão exportadas para o 
         E-sus e arrumado inner join para left join da tb_equipe.
******************************************************************************************************/

DROP TRIGGER atualiza_esus_ficha_procedimentos ON social.procedimento_atendimento;

DROP FUNCTION social.esus_ficha_procedimentos();

CREATE FUNCTION social.esus_ficha_procedimentos()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF 
AS $BODY$

DECLARE 
    -- Dados do Atendimento
    linha_ate RECORD;
    -- Dados da Pré-Consulta
    linha_pc RECORD;
    efp_sexo character varying(20);
    ret integer;
BEGIN
    SELECT 
    INTO ret pra.ate_codigo
    from procedimento_atendimento pra
    join atendimento ate on ate.ate_codigo = pra.ate_codigo
    join unidade uni on uni.uni_codigo = ate.uni_codigo
    where pra.ate_codigo = NEW.ate_codigo
    and uni.uni_tipo <> 'H'
    group by pra.ate_codigo;

    IF ret IS NOT NULL THEN
        IF (TG_OP = 'DELETE') THEN
            DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
            RETURN OLD;
        ELSE
            IF ((SELECT usr_tipo_medico FROM usuarios WHERE usr_codigo = NEW.usr_codigo) <> 'D') THEN
            -- Valida se o procedimento está vindo do Atendimento ou da Pré-Consulta
                IF (NEW.ate_codigo IS NOT NULL) THEN
                FOR linha_ate IN
                    SELECT 
                        ate.age_codigo,
                        pat.pat_codigo,
                        pat.proc_codigo,
                        tbl.co_local_atend,
                        usr.cnes_cod_cns AS efp_profissional_cns,
                        esp.cod_cbo AS efp_cbo_codigo_2002,
                        uni.uni_cnes AS efp_cnes,
                        tbe.nu_ine AS efp_ine,
                        ate.ate_data AS efp_dtatendimento,
                        uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
                        usu.usu_cartao_sus AS efp_num_cartao_sus,
                        usu.usu_datanasc AS efp_dtnascimento,
                        usu.usu_prontuario AS efp_numprontuario, 
                        usu.usu_sexo
                    FROM 
                        procedimento_atendimento AS pat 
                    INNER JOIN 
                        atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
                    INNER JOIN 
                        agendamento AS age ON ate.age_codigo=age.age_codigo
                    INNER JOIN 
                        especialidade AS esp ON age.esp_codigo=esp.esp_codigo
                    INNER JOIN 
                        usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
                    INNER JOIN
                        usuario AS usu ON ate.usu_codigo=usu.usu_codigo
                    INNER JOIN
                        unidade AS uni ON ate.uni_codigo=uni.uni_codigo
                    INNER JOIN 
                        tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
                    LEFT JOIN 
                        tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
                    WHERE 
                        pat.pat_codigo = NEW.pat_codigo LOOP
                        
                    IF (linha_ate.age_codigo IS NOT NULL AND linha_ate.proc_codigo IS NOT NULL AND linha_ate.co_local_atend IS NOT NULL AND linha_ate.efp_profissional_cns IS NOT NULL AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL AND linha_ate.efp_cnes IS NOT NULL AND linha_ate.efp_codigo_ibge_mun IS NOT NULL AND linha_ate.efp_dtnascimento IS NOT NULL) THEN          
                        -- Validação de sexo
                        IF (linha_ate.usu_sexo='M') THEN 
                            efp_sexo = '0 L';
                        ELSE
                            efp_sexo = '1 L';
                        END IF;
                        -- Realiza a inserção dos da ficha de procedimento do E-SUS
                        INSERT INTO esus_ficha_procedimento(
                            age_codigo,
                            pat_codigo,
                            proc_codigo,
                            co_local_atend,
                            efp_profissional_cns,
                            efp_cbo_codigo_2002,
                            efp_cnes,
                            efp_ine,
                            efp_dtatendimento,
                            efp_codigo_ibge_mun,
                            efp_num_cartao_sus,
                            efp_dtnascimento,
                            efp_numprontuario,
                            efp_sexo,
                            efp_tipo_dado_serializado,
                            efp_dtcadastro
                        ) VALUES (
                            linha_ate.age_codigo,
                            linha_ate.pat_codigo,
                            linha_ate.proc_codigo,
                            linha_ate.co_local_atend,
                            linha_ate.efp_profissional_cns,
                            linha_ate.efp_cbo_codigo_2002,
                            linha_ate.efp_cnes,
                            linha_ate.efp_ine,
                            linha_ate.efp_dtatendimento,
                            linha_ate.efp_codigo_ibge_mun,
                            linha_ate.efp_num_cartao_sus,
                            linha_ate.efp_dtnascimento,
                            linha_ate.efp_numprontuario,
                            efp_sexo,
                            '7 L',
                            'NOW()'
                        );
                        RETURN NEW;
                        RAISE NOTICE 'Registro inserido com sucesso''.';
                    END IF; 
                END LOOP;
            END IF;
                IF (NEW.pc_codigo IS NOT NULL) THEN
                FOR linha_pc IN
                    SELECT 
                        pc.age_codigo,
                        pat.pat_codigo,
                        pat.proc_codigo,
                        tbl.co_local_atend,
                        usr.cnes_cod_cns AS efp_profissional_cns,
                        esp.cod_cbo AS efp_cbo_codigo_2002,
                        uni.uni_cnes AS efp_cnes,
                        tbe.nu_ine AS efp_ine,
                        pc.pc_data AS efp_dtatendimento,
                        uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
                        usu.usu_cartao_sus AS efp_num_cartao_sus,
                        usu.usu_datanasc AS efp_dtnascimento,
                        usu.usu_prontuario AS efp_numprontuario, 
                        usu.usu_sexo
                    FROM 
                        procedimento_atendimento AS pat 
                    INNER JOIN 
                        pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
                    INNER JOIN 
                        agendamento AS age ON pc.age_codigo=age.age_codigo
                    INNER JOIN 
                        especialidade AS esp ON age.esp_codigo=esp.esp_codigo
                    INNER JOIN 
                        usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
                    INNER JOIN
                        usuario AS usu ON age.usu_codigo=usu.usu_codigo
                    INNER JOIN
                        unidade AS uni ON age.uni_codigo=uni.uni_codigo
                    INNER JOIN 
                        tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
                    LEFT JOIN 
                        tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
                    WHERE 
                        pat.pat_codigo = NEW.pat_codigo LOOP
                    
                    IF (linha_pc.age_codigo IS NOT NULL AND linha_pc.proc_codigo IS NOT NULL AND linha_pc.co_local_atend IS NOT NULL AND linha_pc.efp_profissional_cns IS NOT NULL AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL AND linha_pc.efp_cnes IS NOT NULL AND linha_pc.efp_codigo_ibge_mun IS NOT NULL AND linha_pc.efp_dtnascimento IS NOT NULL) THEN
                        -- Validação de sexo
                        IF (linha_pc.usu_sexo='M') THEN 
                            efp_sexo = '0 L';
                        ELSE
                            efp_sexo = '1 L';
                        END IF;
                        -- Realiza a inserção dos da ficha de procedimento do E-SUS
                        INSERT INTO esus_ficha_procedimento(
                            age_codigo,
                            pat_codigo,
                            proc_codigo,
                            co_local_atend,
                            efp_profissional_cns,
                            efp_cbo_codigo_2002,
                            efp_cnes,
                            efp_ine,
                            efp_dtatendimento,
                            efp_codigo_ibge_mun,
                            efp_num_cartao_sus,
                            efp_dtnascimento,
                            efp_sexo,
                            efp_tipo_dado_serializado,
                            efp_numprontuario,
                            efp_dtcadastro
                        ) VALUES (
                            linha_pc.age_codigo,
                            linha_pc.pat_codigo,
                            linha_pc.proc_codigo,
                            linha_pc.co_local_atend,
                            linha_pc.efp_profissional_cns,
                            linha_pc.efp_cbo_codigo_2002,
                            linha_pc.efp_cnes,
                            linha_pc.efp_ine,
                            linha_pc.efp_dtatendimento,
                            linha_pc.efp_codigo_ibge_mun,
                            linha_pc.efp_num_cartao_sus,
                            linha_pc.efp_dtnascimento,
                            efp_sexo,
                            '7 L',
                            linha_pc.efp_numprontuario,
                            'NOW()'
                        );
                        RETURN NEW;
                        RAISE NOTICE 'Registro inserido com sucesso''.';
                    END IF;
                END LOOP;
            END IF;
            END IF;
        END IF; 
    END IF;
    RETURN NULL;
END;

$BODY$;

CREATE TRIGGER atualiza_esus_ficha_procedimentos
    AFTER INSERT OR DELETE OR UPDATE 
    ON social.procedimento_atendimento
    FOR EACH ROW
    EXECUTE PROCEDURE social.esus_ficha_procedimentos();
    

/******************************************************************************************************
220407 - Fim
******************************************************************************************************/


/******************************************************************************************************
222840 - Adicionado coluna 'grau_risco' na tabela 'agendamento_externo'
******************************************************************************************************/

ALTER TABLE social.agendamento_externo
    ADD COLUMN grau_risco character varying(1);

/******************************************************************************************************
222840 - Fim
******************************************************************************************************/

/******************************************************************************************************
146459 - Valores de referência laboratório
******************************************************************************************************/

ALTER TABLE valoresdereferencia ADD COLUMN vlr_tp_faixa CHAR(1) NOT NULL DEFAULT 'M';

/******************************************************************************************************
146459 - Fim
******************************************************************************************************/

/******************************************************************************************************
224418 - Fichas com erro ao editar e excluir.
******************************************************************************************************/

DROP TRIGGER atualiza_esus_ficha_procedimentos ON social.procedimento_atendimento;

DROP FUNCTION social.esus_ficha_procedimentos();

CREATE FUNCTION social.esus_ficha_procedimentos()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF 
AS $BODY$

DECLARE 
    -- Dados do Atendimento
    linha_ate RECORD;
    -- Dados da Pré-Consulta
    linha_pc RECORD;
    efp_sexo character varying(20);
    ret integer;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
        RETURN OLD;
    ELSE
        SELECT 
        INTO ret pra.ate_codigo
        from procedimento_atendimento pra
        join atendimento ate on ate.ate_codigo = pra.ate_codigo
        join unidade uni on uni.uni_codigo = ate.uni_codigo
        where pra.ate_codigo = NEW.ate_codigo
        and uni.uni_tipo <> 'H'
        group by pra.ate_codigo;

        IF ret IS NULL THEN
            RETURN NULL;
        END IF;

        IF ((SELECT usr_tipo_medico FROM usuarios WHERE usr_codigo = NEW.usr_codigo) <> 'D') THEN
        -- Valida se o procedimento está vindo do Atendimento ou da Pré-Consulta
            IF (NEW.ate_codigo IS NOT NULL) THEN
                FOR linha_ate IN
                    SELECT 
                        ate.age_codigo,
                        pat.pat_codigo,
                        pat.proc_codigo,
                        tbl.co_local_atend,
                        usr.cnes_cod_cns AS efp_profissional_cns,
                        esp.cod_cbo AS efp_cbo_codigo_2002,
                        uni.uni_cnes AS efp_cnes,
                        tbe.nu_ine AS efp_ine,
                        ate.ate_data AS efp_dtatendimento,
                        uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
                        usu.usu_cartao_sus AS efp_num_cartao_sus,
                        usu.usu_datanasc AS efp_dtnascimento,
                        usu.usu_prontuario AS efp_numprontuario, 
                        usu.usu_sexo
                    FROM 
                        procedimento_atendimento AS pat 
                    INNER JOIN 
                        atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
                    INNER JOIN 
                        agendamento AS age ON ate.age_codigo=age.age_codigo
                    INNER JOIN 
                        especialidade AS esp ON age.esp_codigo=esp.esp_codigo
                    INNER JOIN 
                        usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
                    INNER JOIN
                        usuario AS usu ON ate.usu_codigo=usu.usu_codigo
                    INNER JOIN
                        unidade AS uni ON ate.uni_codigo=uni.uni_codigo
                    INNER JOIN 
                        tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
                    LEFT JOIN 
                        tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
                    WHERE 
                        pat.pat_codigo = NEW.pat_codigo LOOP
                        
                    IF (linha_ate.age_codigo IS NOT NULL AND linha_ate.proc_codigo IS NOT NULL AND linha_ate.co_local_atend IS NOT NULL AND linha_ate.efp_profissional_cns IS NOT NULL AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL AND linha_ate.efp_cnes IS NOT NULL AND linha_ate.efp_codigo_ibge_mun IS NOT NULL AND linha_ate.efp_dtnascimento IS NOT NULL) THEN          
                        -- Validação de sexo
                        IF (linha_ate.usu_sexo='M') THEN 
                            efp_sexo = '0 L';
                        ELSE
                            efp_sexo = '1 L';
                        END IF;
                        -- Realiza a inserção dos da ficha de procedimento do E-SUS
                        INSERT INTO esus_ficha_procedimento(
                            age_codigo,
                            pat_codigo,
                            proc_codigo,
                            co_local_atend,
                            efp_profissional_cns,
                            efp_cbo_codigo_2002,
                            efp_cnes,
                            efp_ine,
                            efp_dtatendimento,
                            efp_codigo_ibge_mun,
                            efp_num_cartao_sus,
                            efp_dtnascimento,
                            efp_numprontuario,
                            efp_sexo,
                            efp_tipo_dado_serializado,
                            efp_dtcadastro
                        ) VALUES (
                            linha_ate.age_codigo,
                            linha_ate.pat_codigo,
                            linha_ate.proc_codigo,
                            linha_ate.co_local_atend,
                            linha_ate.efp_profissional_cns,
                            linha_ate.efp_cbo_codigo_2002,
                            linha_ate.efp_cnes,
                            linha_ate.efp_ine,
                            linha_ate.efp_dtatendimento,
                            linha_ate.efp_codigo_ibge_mun,
                            linha_ate.efp_num_cartao_sus,
                            linha_ate.efp_dtnascimento,
                            linha_ate.efp_numprontuario,
                            efp_sexo,
                            '7 L',
                            'NOW()'
                        );
                        RETURN NEW;
                        RAISE NOTICE 'Registro inserido com sucesso''.';
                    END IF; 
                END LOOP;
            END IF;
            IF (NEW.pc_codigo IS NOT NULL) THEN
                FOR linha_pc IN
                    SELECT 
                        pc.age_codigo,
                        pat.pat_codigo,
                        pat.proc_codigo,
                        tbl.co_local_atend,
                        usr.cnes_cod_cns AS efp_profissional_cns,
                        esp.cod_cbo AS efp_cbo_codigo_2002,
                        uni.uni_cnes AS efp_cnes,
                        tbe.nu_ine AS efp_ine,
                        pc.pc_data AS efp_dtatendimento,
                        uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
                        usu.usu_cartao_sus AS efp_num_cartao_sus,
                        usu.usu_datanasc AS efp_dtnascimento,
                        usu.usu_prontuario AS efp_numprontuario, 
                        usu.usu_sexo
                    FROM 
                        procedimento_atendimento AS pat 
                    INNER JOIN 
                        pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
                    INNER JOIN 
                        agendamento AS age ON pc.age_codigo=age.age_codigo
                    INNER JOIN 
                        especialidade AS esp ON age.esp_codigo=esp.esp_codigo
                    INNER JOIN 
                        usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
                    INNER JOIN
                        usuario AS usu ON age.usu_codigo=usu.usu_codigo
                    INNER JOIN
                        unidade AS uni ON age.uni_codigo=uni.uni_codigo
                    INNER JOIN 
                        tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
                    LEFT JOIN 
                        tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
                    WHERE 
                        pat.pat_codigo = NEW.pat_codigo LOOP
                    
                    IF (linha_pc.age_codigo IS NOT NULL AND linha_pc.proc_codigo IS NOT NULL AND linha_pc.co_local_atend IS NOT NULL AND linha_pc.efp_profissional_cns IS NOT NULL AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL AND linha_pc.efp_cnes IS NOT NULL AND linha_pc.efp_codigo_ibge_mun IS NOT NULL AND linha_pc.efp_dtnascimento IS NOT NULL) THEN
                        -- Validação de sexo
                        IF (linha_pc.usu_sexo='M') THEN 
                            efp_sexo = '0 L';
                        ELSE
                            efp_sexo = '1 L';
                        END IF;
                        -- Realiza a inserção dos da ficha de procedimento do E-SUS
                        INSERT INTO esus_ficha_procedimento(
                            age_codigo,
                            pat_codigo,
                            proc_codigo,
                            co_local_atend,
                            efp_profissional_cns,
                            efp_cbo_codigo_2002,
                            efp_cnes,
                            efp_ine,
                            efp_dtatendimento,
                            efp_codigo_ibge_mun,
                            efp_num_cartao_sus,
                            efp_dtnascimento,
                            efp_sexo,
                            efp_tipo_dado_serializado,
                            efp_numprontuario,
                            efp_dtcadastro
                        ) VALUES (
                            linha_pc.age_codigo,
                            linha_pc.pat_codigo,
                            linha_pc.proc_codigo,
                            linha_pc.co_local_atend,
                            linha_pc.efp_profissional_cns,
                            linha_pc.efp_cbo_codigo_2002,
                            linha_pc.efp_cnes,
                            linha_pc.efp_ine,
                            linha_pc.efp_dtatendimento,
                            linha_pc.efp_codigo_ibge_mun,
                            linha_pc.efp_num_cartao_sus,
                            linha_pc.efp_dtnascimento,
                            efp_sexo,
                            '7 L',
                            linha_pc.efp_numprontuario,
                            'NOW()'
                        );
                        RETURN NEW;
                        RAISE NOTICE 'Registro inserido com sucesso''.';
                    END IF;
                END LOOP;
            END IF;
        END IF;
    END IF;
END;

$BODY$;

CREATE TRIGGER atualiza_esus_ficha_procedimentos
    AFTER INSERT OR DELETE OR UPDATE 
    ON social.procedimento_atendimento
    FOR EACH ROW
    EXECUTE PROCEDURE social.esus_ficha_procedimentos();

/*****************************************************************************************************/

DROP TRIGGER atualiza_esus_atendimento_individual ON social.rl_cds_atend_individual_condut;

DROP FUNCTION social.esus_atendimento_individual();

CREATE FUNCTION social.esus_atendimento_individual()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF 
AS $BODY$

DECLARE 
    linha RECORD;
    eai_sexo character varying(20);
    ret integer;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        DELETE FROM esus_atendimento_individual WHERE ate_codigo = OLD.ate_codigo;
        RETURN OLD;
    ELSE
        SELECT 
        INTO ret rai.ate_codigo
        from rl_cds_atend_individual_condut rai
        join atendimento ate on ate.ate_codigo = rai.ate_codigo
        join unidade uni on uni.uni_codigo = ate.uni_codigo
        where rai.ate_codigo = new.ate_codigo
        and uni.uni_tipo <> 'H'
        group by rai.ate_codigo;

        IF ret IS NULL THEN
            RETURN NULL;
        END IF;

        FOR linha IN
            SELECT DISTINCT
                ate.ate_codigo,
                age.tat_codigo AS eai_tipo_atendimento,
                tbl.co_local_atend,
                usr.cnes_cod_cns AS eai_profissional_cns,
                esp.cod_cbo AS eai_cbo_codigo_2002,
                uni.uni_cnes AS eai_cnes,
                ate.ate_data AS eai_dtatendimento,
                uni.uni_codigo_ibge AS eai_codigo_ibge_mun,
                usu.usu_cartao_sus AS eai_num_cartao_sus,
                usu.usu_datanasc AS eai_dtnascimento,
                usu.usu_prontuario AS eai_numprontuario, 
                usu.usu_sexo
            FROM 
                atendimento AS ate
            INNER JOIN 
                agendamento AS age ON ate.age_codigo=age.age_codigo
            INNER JOIN 
                especialidade AS esp ON age.esp_codigo=esp.esp_codigo
            INNER JOIN 
                usuarios AS usr ON ate.med_codigo=usr.usr_codigo
            INNER JOIN
                usuario AS usu ON ate.usu_codigo=usu.usu_codigo
            INNER JOIN
                unidade AS uni ON ate.uni_codigo=uni.uni_codigo
            INNER JOIN 
                tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
            LEFT JOIN
                rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo=rlai.ate_codigo
            INNER JOIN 
                rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo=rlaic.ate_codigo
            WHERE 
                ate.ate_codigo = NEW.ate_codigo LOOP
            -- Validação de sexo
            IF (linha.usu_sexo='M') THEN 
                eai_sexo = '0 L';
            ELSE
                eai_sexo = '1 L';
            END IF;
            -- Realiza a inserção dos da ficha de procedimento do E-SUS
            INSERT INTO esus_atendimento_individual(
                ate_codigo,
                co_local_atend,
                eai_profissional_cns,
                eai_cbo_codigo_2002,
                eai_cnes,
                eai_dtatendimento,
                eai_codigo_ibge_mun,
                eai_dtnascimento,
                eai_num_cartao_sus,
                eai_numprontuario,
                eai_tipo_atendimento,
                eai_sexo,
                eai_tipo_dado_serializado
            ) VALUES (
                linha.ate_codigo,
                linha.co_local_atend,
                linha.eai_profissional_cns,
                linha.eai_cbo_codigo_2002,
                linha.eai_cnes,
                linha.eai_dtatendimento,
                linha.eai_codigo_ibge_mun,
                linha.eai_dtnascimento,
                linha.eai_num_cartao_sus,
                linha.eai_numprontuario,
                linha.eai_tipo_atendimento,
                eai_sexo,
                '4 L'
            );
            RETURN NEW;
            RAISE NOTICE 'Registro inserido com sucesso''.';
        END LOOP;
    END IF;
END;

$BODY$;

CREATE TRIGGER atualiza_esus_atendimento_individual
AFTER INSERT OR DELETE OR UPDATE 
ON social.rl_cds_atend_individual_condut
FOR EACH ROW
EXECUTE PROCEDURE social.esus_atendimento_individual();

/*****************************************************************************************************/

DROP TRIGGER atualiza_esus_odonto ON social.odonto_procedimentos_controle;

DROP FUNCTION social.esus_odonto();

CREATE FUNCTION social.esus_odonto()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF 
AS $BODY$

DECLARE 
    linha RECORD;
    eo_sexo character varying(20);
    ret integer;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        DELETE FROM esus_odonto WHERE eo_codigo = OLD.eo_codigo;
        RETURN OLD;
    ELSE
        SELECT 
        INTO ret apc.ate_codigo
        from odonto_procedimentos_controle apc
        join atendimento ate on ate.ate_codigo = apc.ate_codigo
        join unidade uni on uni.uni_codigo = ate.uni_codigo
        where apc.ate_codigo = new.ate_codigo
        and uni.uni_tipo <> 'H';

        IF ret IS NULL THEN
            RETURN NULL;
        END IF;

        FOR linha IN
            SELECT DISTINCT
                odpc.odo_pcon_codigo,
                tbl.co_local_atend,
                usr.cnes_cod_cns AS eo_profissional_cns,
                esp.cod_cbo AS eo_cbo_codigo_2002,
                uni.uni_cnes AS eo_cnes,
                ate.ate_data AS eo_dtatendimento,
                uni.uni_codigo_ibge AS eo_codigo_ibge_mun,
                usu.usu_datanasc AS eo_dtnascimento,
                usu.usu_cartao_sus AS eo_num_cartao_sus,    
                usu.usu_prontuario AS eo_numprontuario,
                age.tat_codigo AS eo_tipo_atendimento,
                age.tp_cod AS eo_tipo_consulta,                 
                usu.usu_sexo                    
            FROM 
                odonto_procedimentos_controle AS odpc 
            INNER JOIN 
                atendimento AS ate ON odpc.ate_codigo=ate.ate_codigo
            INNER JOIN 
                agendamento AS age ON ate.age_codigo=age.age_codigo
            INNER JOIN 
                especialidade AS esp ON age.esp_codigo=esp.esp_codigo
            INNER JOIN 
                usuarios AS usr ON ate.med_codigo=usr.usr_codigo
            INNER JOIN
                usuario AS usu ON ate.usu_codigo=usu.usu_codigo
            INNER JOIN
                unidade AS uni ON ate.uni_codigo=uni.uni_codigo
            INNER JOIN 
                tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
            WHERE 
                odpc.odo_pcon_codigo = NEW.odo_pcon_codigo LOOP
            -- Validação de sexo
            IF (linha.usu_sexo='M') THEN 
                eo_sexo = '0 L';
            ELSE
                eo_sexo = '1 L';
            END IF;
            -- Realiza a inserção dos da ficha de procedimento do E-SUS
            INSERT INTO esus_odonto(
                odo_pcon_codigo,
                co_local_atend,
                eo_profissional_cns,
                eo_cbo_codigo_2002,
                eo_cnes,
                eo_dtatendimento,
                eo_codigo_ibge_mun,
                eo_dtnascimento,
                eo_num_cartao_sus,
                eo_numprontuario,
                eo_tipo_atendimento,
                eo_tipo_consulta,
                eo_sexo,
                eo_tipo_dado_serializado
            ) VALUES (
                linha.odo_pcon_codigo,
                linha.co_local_atend,
                linha.eo_profissional_cns,
                linha.eo_cbo_codigo_2002,
                linha.eo_cnes,
                linha.eo_dtatendimento,
                linha.eo_codigo_ibge_mun,
                linha.eo_dtnascimento,
                linha.eo_num_cartao_sus,
                linha.eo_numprontuario,
                linha.eo_tipo_atendimento,
                linha.eo_tipo_consulta,
                eo_sexo,
                '5 L'
            );
            RETURN NEW;
            RAISE NOTICE 'Registro inserido com sucesso''.';
        END LOOP;
    END IF; 
END;

$BODY$;

CREATE TRIGGER atualiza_esus_odonto
AFTER INSERT OR UPDATE 
ON social.odonto_procedimentos_controle
FOR EACH ROW
EXECUTE PROCEDURE social.esus_odonto();

/******************************************************************************************************
224418 - Fim
******************************************************************************************************/

/******************************************************************************************************
221333 - Realizar implementação da tela de inventário (back-end) - envio
******************************************************************************************************/

CREATE TABLE inventario_produto_tmp
(
    invp_codigo     SERIAL PRIMARY KEY NOT NULL,
    inv_codigo      BIGINT NOT NULL CONSTRAINT "$1" REFERENCES inventario,
    pro_codigo      BIGINT NOT NULL CONSTRAINT "$2" REFERENCES produto,
    usr_codigo      BIGINT,
    invp_datahora   TIMESTAMP,
    invp_ip         VARCHAR(15),
    invp_status     CHAR DEFAULT 'A' :: BPCHAR NOT NULL,
    invp_quantidade NUMERIC(20, 4),
    invp_lote       VARCHAR(80),
    invp_validade   DATE,
    invp_dose_atual INTEGER,
    invp_dose_lote  INTEGER
);

COMMENT ON COLUMN inventario_produto_tmp.invp_status IS 'A - Ativo E - Excluido T - Alteracao';

/******************************************************************************************************
221333 - Fim
******************************************************************************************************/