SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='128', script='V128__3.161.160.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE social.config SET conf_valor_string='3.161.160' WHERE conf_chave='VERSAO_SAUDE';
UPDATE social.config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';


/******************************************************************************************************
146459 - Valores de referência laboratório
******************************************************************************************************/
UPDATE valoresdereferencia SET vlr_sexo = 'A' WHERE vlr_sexo IS NULL;

/******************************************************************************************************
224714 - Realizar implementação da tela de inventário (back-end) - edição
******************************************************************************************************/
UPDATE domicilio
   SET usu_codigo_responsavel = null
 WHERE usu_codigo_responsavel NOT IN (SELECT usu_codigo FROM usuario);
ALTER TABLE domicilio ADD CONSTRAINT id_usuario_valido CHECK (usu_codigo_responsavel > 0);

DROP VIEW v_inventario;
ALTER TABLE social.inventario ALTER COLUMN inv_data TYPE timestamp USING inv_data :: timestamp;
ALTER TABLE social.inventario ALTER COLUMN inv_data_digitacao TYPE timestamp USING inv_data_digitacao :: timestamp;
CREATE VIEW v_inventario AS
  SELECT
    inventario.inv_codigo,
    cast(inventario.inv_data as date) as inv_data,
    inventario.set_codigo,
    inventario.gru_codigo,
    inventario.inv_responsavel,
    inventario.inv_equipe,
    inventario_produto.pro_codigo,
    inventario_produto.invp_quantidade,
    setor.set_nome,
    produto.pro_nome,
    grupo.gru_nome,
    calcula_estoque(inventario_produto.pro_codigo, inventario.set_codigo, cast(inventario.inv_data as date)) AS estoqueatual,
    inventario_produto.invp_status
  FROM inventario,
    inventario_produto,
    setor,
    grupo,
    produto
  WHERE (
    (inventario.inv_codigo = inventario_produto.inv_codigo)
    AND (inventario.set_codigo = setor.set_codigo) AND (inventario.gru_codigo = grupo.gru_codigo) AND
    (inventario_produto.pro_codigo = produto.pro_codigo) AND (inventario_produto.invp_status = 'A' :: bpchar));


/******************************************************************************************************
112096 - Relatório de pacientes por faixa etária x sexo
******************************************************************************************************/

INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto)
VALUES ('Relatório de Pacientes', 'zf/relatorio/paciente','zf/relatorio/paciente');

/******************************************************************************************************
112096 - Fim
******************************************************************************************************/

/******************************************************************************************************
226231 - Procedimentos não estão sendo salvos no prontuário
******************************************************************************************************/

CREATE OR REPLACE FUNCTION social.esus_ficha_procedimentos()
  RETURNS trigger
LANGUAGE 'plpgsql'
COST 100
VOLATILE LEAKPROOF
AS $BODY$

DECLARE
  -- Dados do Atendimento
  linha_ate RECORD;
  -- Dados da Pré-Consulta
  linha_pc RECORD;
  efp_sexo CHARACTER VARYING(20);
  ret INTEGER;
BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
    RETURN NULL;
  END IF;

  SELECT
    INTO ret pra.ate_codigo
  FROM procedimento_atendimento pra
    JOIN atendimento ate ON ate.ate_codigo = pra.ate_codigo
    JOIN unidade uni ON uni.uni_codigo = ate.uni_codigo
  WHERE pra.ate_codigo = NEW.ate_codigo
        AND uni.uni_tipo <> 'H'
  GROUP BY pra.ate_codigo;

  IF ret IS NULL THEN
    RETURN NULL;
  END IF;

  IF ((SELECT usr_tipo_medico FROM usuarios WHERE usr_codigo = NEW.usr_codigo) = 'D') THEN
    RETURN NULL;
  END IF;

  -- Valida se o procedimento está vindo do Atendimento ou da Pré-Consulta
  IF (NEW.ate_codigo IS NOT NULL) THEN
    FOR linha_ate IN
    SELECT
      ate.age_codigo,
      pat.pat_codigo,
      pat.proc_codigo,
      tbl.co_local_atend,
      usr.cnes_cod_cns AS efp_profissional_cns,
      esp.cod_cbo AS efp_cbo_codigo_2002,
      uni.uni_cnes AS efp_cnes,
      tbe.nu_ine AS efp_ine,
      ate.ate_data AS efp_dtatendimento,
      uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
      usu.usu_cartao_sus AS efp_num_cartao_sus,
      usu.usu_datanasc AS efp_dtnascimento,
      usu.usu_prontuario AS efp_numprontuario,
      usu.usu_sexo
    FROM
      procedimento_atendimento AS pat
      INNER JOIN
      atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
      INNER JOIN
      agendamento AS age ON ate.age_codigo=age.age_codigo
      INNER JOIN
      especialidade AS esp ON age.esp_codigo=esp.esp_codigo
      INNER JOIN
      usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
      INNER JOIN
      usuario AS usu ON ate.usu_codigo=usu.usu_codigo
      INNER JOIN
      unidade AS uni ON ate.uni_codigo=uni.uni_codigo
      INNER JOIN
      tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
      LEFT JOIN
      tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
    WHERE
      pat.pat_codigo = NEW.pat_codigo LOOP

      IF (linha_ate.age_codigo IS NOT NULL
          AND linha_ate.proc_codigo IS NOT NULL
          AND linha_ate.co_local_atend IS NOT NULL
          AND linha_ate.efp_profissional_cns IS NOT NULL
          AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL
          AND linha_ate.efp_cnes IS NOT NULL
          AND linha_ate.efp_codigo_ibge_mun IS NOT NULL
          AND linha_ate.efp_dtnascimento IS NOT NULL) THEN

        -- Validação de sexo
        IF (linha_ate.usu_sexo='M') THEN
          efp_sexo = '0 L';
        ELSE
          efp_sexo = '1 L';
        END IF;
        -- Realiza a inserção dos da ficha de procedimento do E-SUS
        INSERT INTO esus_ficha_procedimento(
          age_codigo,
          pat_codigo,
          proc_codigo,
          co_local_atend,
          efp_profissional_cns,
          efp_cbo_codigo_2002,
          efp_cnes,
          efp_ine,
          efp_dtatendimento,
          efp_codigo_ibge_mun,
          efp_num_cartao_sus,
          efp_dtnascimento,
          efp_numprontuario,
          efp_sexo,
          efp_tipo_dado_serializado,
          efp_dtcadastro
        ) VALUES (
          linha_ate.age_codigo,
          linha_ate.pat_codigo,
          linha_ate.proc_codigo,
          linha_ate.co_local_atend,
          linha_ate.efp_profissional_cns,
          linha_ate.efp_cbo_codigo_2002,
          linha_ate.efp_cnes,
          linha_ate.efp_ine,
          linha_ate.efp_dtatendimento,
          linha_ate.efp_codigo_ibge_mun,
          linha_ate.efp_num_cartao_sus,
          linha_ate.efp_dtnascimento,
          linha_ate.efp_numprontuario,
          efp_sexo,
          '7 L',
          'NOW()'
        );
        RAISE NOTICE 'Registro inserido com sucesso''.';
      END IF;
    END LOOP;
  END IF;
  IF (NEW.pc_codigo IS NOT NULL) THEN
    FOR linha_pc IN
    SELECT
      pc.age_codigo,
      pat.pat_codigo,
      pat.proc_codigo,
      tbl.co_local_atend,
      usr.cnes_cod_cns AS efp_profissional_cns,
      esp.cod_cbo AS efp_cbo_codigo_2002,
      uni.uni_cnes AS efp_cnes,
      tbe.nu_ine AS efp_ine,
      pc.pc_data AS efp_dtatendimento,
      uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
      usu.usu_cartao_sus AS efp_num_cartao_sus,
      usu.usu_datanasc AS efp_dtnascimento,
      usu.usu_prontuario AS efp_numprontuario,
      usu.usu_sexo
    FROM
      procedimento_atendimento AS pat
      INNER JOIN
      pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
      INNER JOIN
      agendamento AS age ON pc.age_codigo=age.age_codigo
      INNER JOIN
      especialidade AS esp ON age.esp_codigo=esp.esp_codigo
      INNER JOIN
      usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
      INNER JOIN
      usuario AS usu ON age.usu_codigo=usu.usu_codigo
      INNER JOIN
      unidade AS uni ON age.uni_codigo=uni.uni_codigo
      INNER JOIN
      tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
      LEFT JOIN
      tb_equipe AS tbe ON uni.uni_codigo=tbe.uni_codigo
    WHERE
      pat.pat_codigo = NEW.pat_codigo LOOP

      IF (linha_pc.age_codigo IS NOT NULL
          AND linha_pc.proc_codigo IS NOT NULL
          AND linha_pc.co_local_atend IS NOT NULL
          AND linha_pc.efp_profissional_cns IS NOT NULL
          AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL
          AND linha_pc.efp_cnes IS NOT NULL
          AND linha_pc.efp_codigo_ibge_mun IS NOT NULL
          AND linha_pc.efp_dtnascimento IS NOT NULL) THEN

        -- Validação de sexo
        IF (linha_pc.usu_sexo='M') THEN
          efp_sexo = '0 L';
        ELSE
          efp_sexo = '1 L';
        END IF;
        -- Realiza a inserção dos da ficha de procedimento do E-SUS
        INSERT INTO esus_ficha_procedimento(
          age_codigo,
          pat_codigo,
          proc_codigo,
          co_local_atend,
          efp_profissional_cns,
          efp_cbo_codigo_2002,
          efp_cnes,
          efp_ine,
          efp_dtatendimento,
          efp_codigo_ibge_mun,
          efp_num_cartao_sus,
          efp_dtnascimento,
          efp_sexo,
          efp_tipo_dado_serializado,
          efp_numprontuario,
          efp_dtcadastro
        ) VALUES (
          linha_pc.age_codigo,
          linha_pc.pat_codigo,
          linha_pc.proc_codigo,
          linha_pc.co_local_atend,
          linha_pc.efp_profissional_cns,
          linha_pc.efp_cbo_codigo_2002,
          linha_pc.efp_cnes,
          linha_pc.efp_ine,
          linha_pc.efp_dtatendimento,
          linha_pc.efp_codigo_ibge_mun,
          linha_pc.efp_num_cartao_sus,
          linha_pc.efp_dtnascimento,
          efp_sexo,
          '7 L',
          linha_pc.efp_numprontuario,
          'NOW()'
        );
        RAISE NOTICE 'Registro inserido com sucesso''.';
      END IF;
    END LOOP;
  END IF;
  RETURN NULL;
END;
$BODY$;

/******************************************************************************************************
226231 - Fim
******************************************************************************************************/

/***************
* MODULO SOCIAL *
****************/
--Atualiza Versao
UPDATE social.config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SOCIAL';
--UPDATE social.config SET conf_valor_string='3.76.74' WHERE conf_chave='VERSAO_SOCIAL';


