SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='130', script='V130__3.163.162.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.163.162' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/* 220738 - Implementação do WebService do HORUS nas telas de movimento*/
/* Altera a tabela produto*/
ALTER TABLE produto ADD pro_horus_tipo char NULL;
COMMENT ON COLUMN produto.pro_horus_tipo IS 'B - (Básico) Produtos dos Anexos I e IV da RENAME conforme regra de financiamento da Portaria 1555/2013. 
E - (Especializado) Produtos do Anexo III conforme regra de financiamento da Portaria 1554/2013. 
S - (Específico) Produtos dos Anexos II e IV com financiamento federal. 
O - (RENAME) Produtos da RENAME financiados somente com recursos próprios do ente. 
 ';
 
 /* Cria a tabela de protocolos do Horus */
 DROP TABLE IF EXISTS horus_protocolo;
 CREATE TABLE horus_protocolo
(
    hp_codigo SERIAL PRIMARY KEY NOT NULL,
    hp_registro INT,
    hp_registro_origem INT,
    hp_tipo_registro CHAR,
    hp_nu_protocolo VARCHAR(255),
    hp_data TIMESTAMP
);
COMMENT ON COLUMN horus_protocolo.hp_tipo_registro IS 'E - Entrada
S - Saída
D - Dispensação
// Adicionar mais tipos
';
COMMENT ON TABLE horus_protocolo IS 'Protocolos de retorno das funções Horus';

/* Cria a tabela de erros do Horus */
 DROP TABLE IF EXISTS horus_erros;
CREATE TABLE horus_erros
(
    he_id SERIAL PRIMARY KEY NOT NULL,
    he_codigo varchar(10),
    he_mensagem VARCHAR(500),
    he_campo VARCHAR(100),
    he_valor VARCHAR(150),
    he_datatime TIMESTAMP
);

ALTER TABLE social.setor ADD set_tipo_estab CHAR NULL;
COMMENT ON COLUMN social.setor.set_tipo_estab IS 'A - ALMOXARIFADO_CENTRAL
R - ALMOXARIFADO_REGIONAL
F - FARMACIA_UNIDADE';
/* 220738 - Fim ******************************/

/******************************************************************************************************
228331 - Estratificação de risco do paciente
******************************************************************************************************/
ALTER TABLE usuario ADD COLUMN risco_gestacao character(1);
ALTER TABLE usuario ADD COLUMN risco_hipertensao character(1);
ALTER TABLE usuario ADD COLUMN risco_diabetes character(1);
ALTER TABLE usuario ADD COLUMN risco_idoso character(1);
ALTER TABLE usuario ADD COLUMN risco_crianca character(1);
ALTER TABLE usuario ADD COLUMN risco_odonto character(1);
ALTER TABLE usuario ADD COLUMN risco_psico character(1);

COMMENT ON COLUMN usuario.risco_gestacao IS 'A - Alto, M - Médio (Intermediário), B - Baixo (Habitual)';
COMMENT ON COLUMN usuario.risco_hipertensao IS 'A - Alto, M - Médio (Moderado), B - Baixo';
COMMENT ON COLUMN usuario.risco_diabetes IS 'A - Alto (Ruim), M - Médio (Regular), B - Baixo (Bom)';
COMMENT ON COLUMN usuario.risco_idoso IS 'A - Alto (Frágil), M - Médio (Risco de fragilização), B - Baixo (Robusto)';
COMMENT ON COLUMN usuario.risco_crianca IS 'A - Alto, M - Médio (Intermediário), B - Baixo (Habitual)';
COMMENT ON COLUMN usuario.risco_odonto IS 'A - Alto, M - Médio, B - Baixo';
COMMENT ON COLUMN usuario.risco_psico IS 'A - Alto, M - Médio, B - Baixo';

/******************************************************************************************************
228331 - Fim
******************************************************************************************************/


/******************************************************************************************************
228333 - Estratificação de risco familiar
******************************************************************************************************/
ALTER TABLE domicilio ADD COLUMN estrat_risco_familiar character(1);

COMMENT ON COLUMN domicilio.estrat_risco_familiar IS 'A - Alto, M - Médio, B - Baixo';

/******************************************************************************************************
228333 - Fim
******************************************************************************************************/


/***************
* MODULO SOCIAL *
****************/
/******************************************************************************************************
109344 - Relatório de Perfil Populacional por bairro
******************************************************************************************************/
INSERT INTO social.acesso
(ace_descricao,
 ace_pai,
 ace_caminho,
 ace_modulo,
 ace_imagem,
 ace_item_menu,
 ace_ordem)
VALUES  ('Perfil Populacional por Bairro',
                 (SELECT ace_codigo
                    FROM social.acesso
                    WHERE ace_descricao = 'Relatórios'),
                 'zf/relatorio/bairros/form-bairros',
                 13,
                 NULL,
                 NULL,
                 NULL);

/******************************************************************************************************
109344 - Fim
******************************************************************************************************/

/******************************************************************************************************
213201 - Inclusão de Micro Área e outros campos na Ficha de Cadastro individual 
******************************************************************************************************/

INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (73, 'pt_BR', 'Orientação sexual informada pelo cidadão', NULL, 1, 2);
INSERT INTO tb_pergunta (co_seq_pergunta, ds_local, ds_pergunta, co_pergunta_pai, co_contexto_pergunta, tp_pergunta) VALUES (74, 'pt_BR', 'Identidade de gênero informada pelo cidadão', NULL, 1, 2);

INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (147, 56, 'pt_BR', 'Servidor público / Militar', 'SERVIDOR_PUBLICO_MILITAR');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (152, 65, 'pt_BR', 'Mineral', 'MINERAL');

INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (148, 73, 'pt_BR', 'Heterossexual', 'HETEROSSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (153, 73, 'pt_BR', 'Homossexual (gay / lésbica)', 'HOMOSSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (154, 73, 'pt_BR', 'Bissexual', 'BISSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (155, 73, 'pt_BR', 'Outro', 'OUTRO');

INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (149, 74, 'pt_BR', 'Homem transsexual', 'HOMEM_TRANSSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (150, 74, 'pt_BR', 'Mulher transsexual', 'MULHER_TRANSSEXUAL');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (156, 74, 'pt_BR', 'Travesti', 'TRAVESTI');
INSERT INTO tb_pergunta_detalhe (co_pergunta_detalhe, co_pergunta, ds_local, ds_pergunta_detalhe, no_identificador) VALUES (151, 74, 'pt_BR', 'Outro', 'OUTRO');

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usu_mudanca_territorio;
ALTER TABLE social.usuario
    ADD COLUMN usu_mudanca_territorio character varying DEFAULT 'f'; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usu_numero_do;
ALTER TABLE social.usuario
    ADD COLUMN usu_numero_do integer; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usr_cadastro_codigo;
ALTER TABLE social.usuario
    ADD COLUMN usr_cadastro_codigo integer; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS uni_cadastro_codigo;
ALTER TABLE social.usuario
    ADD COLUMN uni_cadastro_codigo integer; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usr_esp_codigo;
ALTER TABLE social.usuario
    ADD COLUMN usr_esp_codigo integer; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usr_equipe_codigo;
ALTER TABLE social.usuario
    ADD COLUMN usr_equipe_codigo integer; 
    
ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usu_microarea;
ALTER TABLE social.usuario
    ADD COLUMN usu_microarea integer; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usu_maternidade_ref;
ALTER TABLE social.usuario
    ADD COLUMN usu_maternidade_ref character varying; 

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usu_microarea_fa;
ALTER TABLE social.usuario
    ADD COLUMN usu_microarea_fa character varying DEFAULT 'f';

ALTER TABLE social.usuario
    DROP COLUMN IF EXISTS usu_recusa;
ALTER TABLE social.usuario
    ADD COLUMN usu_recusa character varying DEFAULT 'f';

CREATE TABLE IF NOT EXISTS usuario_info_sociodemo
(
  co_seq_usuario_info_sociodemo serial NOT NULL,
  usu_codigo integer,
  uis_parentesco_resp integer,
  uis_curso_mais_elevado integer,
  uis_mercado_trabalho integer,
  uis_freq_cuidador_trad character varying,
  uis_grupo_comunitario character varying,
  uis_povo_comunidade_trad character varying,
  uis_povo_comunidade_trad_nome character varying,
  uis_orientacao_sexual character varying,
  uis_orientacao_sexual_nome character varying,
  uis_identidade_genero character varying,
  uis_identidade_genero_nome character varying,
  uis_peso integer,
  uis_fumante character varying,
  uis_alcool character varying,
  uis_drogas character varying,
  uis_avc_derrame character varying,
  uis_infarto character varying,
  uis_doenca_cardiaca character varying,
  uis_problema_rins character varying,
  uis_doenca_respiratoria character varying,
  uis_hanseniase character varying,
  uis_tuberculose character varying,
  uis_cancer character varying,
  uis_internacao_dose_meses character varying,
  uis_internacao_dose_meses_causa character varying,
  uis_problema_saude_mental character varying,
  uis_acamado character varying,
  uis_domiciliado character varying,
  uis_plantas_medicinais character varying,
  uis_plantas_medicinais_nome character varying,
  uis_praticas_integrat_complem character varying,
  uis_condicao_saude1 character varying,
  uis_condicao_saude2 character varying,
  uis_condicao_saude3 character varying,
  uis_situacao_rua_tempo character varying,
  uis_recebe_beneficio character varying,
  uis_referencia_familiar character varying,
  uis_vezes_alimenta_dia character varying,
  uis_acompanhado_intituicao character varying,
  uis_acompanhado_intituicao_nome character varying,
  uis_vista_familiar_frequencia character varying,
  uis_vista_familiar_grau character varying,
  uis_acesso_higiene_pessoal character varying,
  CONSTRAINT co_seq_usuario_info_sociodemo_pk PRIMARY KEY (co_seq_usuario_info_sociodemo)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE IF NOT EXISTS usuario_crianca_responsavel
(
  co_seq_usuario_crianca_responsavel serial NOT NULL,
  usu_codigo integer,
  co_pergunta_detalhe int,
  CONSTRAINT co_seq_usuario_crianca_responsavel_pk PRIMARY KEY (co_seq_usuario_crianca_responsavel)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE IF NOT EXISTS usuario_doenca_cardiaca
(
  co_seq_usuario_doenca_cardiaca serial NOT NULL,
  usu_codigo integer,
  co_pergunta_detalhe int,
  CONSTRAINT co_seq_usuario_doenca_cardiaca_pk PRIMARY KEY (co_seq_usuario_doenca_cardiaca)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE IF NOT EXISTS usuario_doenca_rins
(
  co_seq_usuario_doenca_rins serial NOT NULL,
  usu_codigo integer,
  co_pergunta_detalhe int,
  CONSTRAINT co_seq_usuario_doenca_rins_pk PRIMARY KEY (co_seq_usuario_doenca_rins)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE IF NOT EXISTS usuario_doenca_pulmonar
(
  co_seq_usuario_doenca_pulmonar serial NOT NULL,
  usu_codigo integer,
  co_pergunta_detalhe int,
  CONSTRAINT co_seq_usuario_doenca_pulmonar_pk PRIMARY KEY (co_seq_usuario_doenca_pulmonar)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE IF NOT EXISTS usuario_origem_alimentacao
(
  co_seq_usuario_origem_alimentacao serial NOT NULL,
  usu_codigo integer,
  co_pergunta_detalhe int,
  CONSTRAINT co_seq_usuario_origem_alimentacao_pk PRIMARY KEY (co_seq_usuario_origem_alimentacao)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE IF NOT EXISTS usuario_higiene
(
  co_seq_usuario_higiene serial NOT NULL,
  usu_codigo integer,
  co_pergunta_detalhe int,
  CONSTRAINT co_seq_usuario_higiene_pk PRIMARY KEY (co_seq_usuario_higiene)
)
WITH (
  OIDS=FALSE
);

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_parentesco_resp;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_parentesco_resp integer; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_ocupacao;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_ocupacao character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_curso_mais_elevado;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_curso_mais_elevado integer; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_mercado_trabalho;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_mercado_trabalho integer; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_freq_cuidador_trad;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_freq_cuidador_trad character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_grupo_comunitario;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_grupo_comunitario character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_povo_comunidade_trad;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_povo_comunidade_trad character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_povo_comunidade_trad_nome;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_povo_comunidade_trad_nome character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_orientacao_sexual;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_orientacao_sexual character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_orientacao_sexual_nome;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_orientacao_sexual_nome character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_identidade_genero;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_identidade_genero character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_identidade_genero_nome;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_identidade_genero_nome character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_peso;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_peso integer; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_fumante;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_fumante character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_alcool;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_alcool character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_drogas;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_drogas character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_avc_derrame;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_avc_derrame character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_infarto;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_infarto character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_doenca_cardiaca;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_doenca_cardiaca character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_problema_rins;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_problema_rins character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_doenca_respiratoria;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_doenca_respiratoria character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_hanseniase;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_hanseniase character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_tuberculose;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_tuberculose character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_cancer;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_cancer character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_internacao_dose_meses;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_internacao_dose_meses character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_internacao_dose_meses_causa;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_internacao_dose_meses_causa character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_problema_saude_mental;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_problema_saude_mental character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_acamado;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_acamado character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_domiciliado;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_domiciliado character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_plantas_medicinais;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_plantas_medicinais character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_plantas_medicinais_nome;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_plantas_medicinais_nome character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_praticas_integrat_complem;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_praticas_integrat_complem character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_condicao_saude1;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_condicao_saude1 character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_condicao_saude2;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_condicao_saude2 character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_condicao_saude3;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_condicao_saude3 character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_situacao_rua_tempo;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_situacao_rua_tempo character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_recebe_beneficio;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_recebe_beneficio character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_referencia_familiar;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_referencia_familiar character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_vezes_alimenta_dia;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_vezes_alimenta_dia character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_acompanhado_intituicao;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_acompanhado_intituicao character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_acompanhado_intituicao_nome;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_acompanhado_intituicao_nome character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_vista_familiar_frequencia;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_vista_familiar_frequencia character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_vista_familiar_grau;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_vista_familiar_grau character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_acesso_higiene_pessoal;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_acesso_higiene_pessoal character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usr_cbo;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usr_cbo character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usr_ine;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usr_ine character varying; 

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_microarea;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_microarea character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_microarea_fa;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_microarea_fa character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_maternidade_ref;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_maternidade_ref character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_mudanca_territorio;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_mudanca_territorio character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_numero_do;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_numero_do character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_pai;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_pai character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_pis_pasep;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_pis_pasep character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_email;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_email character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_celular;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_celular character varying;

ALTER TABLE social.esus_cadastro_individual
    DROP COLUMN IF EXISTS eci_usu_st_responsavel_familiar;
ALTER TABLE social.esus_cadastro_individual
    ADD COLUMN eci_usu_st_responsavel_familiar character varying;

ALTER TABLE esus_cadastro_individual ALTER COLUMN eci_usu_escola DROP NOT NULL;

ALTER TABLE esus_cadastro_individual ALTER COLUMN eci_usu_sit_rua DROP NOT NULL;

ALTER TABLE esus_cadastro_individual ALTER COLUMN eci_usu_deficiencia DROP NOT NULL;

DROP TRIGGER IF EXISTS atualiza_esus_cadastro_individual ON social.usuario;

DROP TRIGGER IF EXISTS atualiza_esus_cadastro_individual ON social.usuario_info_sociodemo;

DROP FUNCTION social.esus_cadastro_individual();

CREATE FUNCTION social.esus_cadastro_individual()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
AS $BODY$

DECLARE
  usu_codigo_conf bigint;
  eci_sexo character(20);
  eci_raca character(20);
  eci_st_responsavel_familiar character(1);
  eci_nacionalidade character(20);
  eci_exportado integer;
  origem_prontuario boolean;
  linha RECORD;
BEGIN
  IF (TG_OP='DELETE') THEN
    DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
    RAISE NOTICE 'DELETE''.';
  ELSE

    select usu_origem_prontuario into origem_prontuario from usuario where usu_codigo = NEW.usu_codigo;

    IF (origem_prontuario=false) THEN
      FOR linha IN
      SELECT
        usu.usu_codigo,
        uni.uni_cnes AS eci_cnes,
        usu.usu_st_responsavel_familiar AS eci_usu_st_responsavel_familiar,
        usr.cnes_cod_cns AS eci_usr_cns,
        uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
        usu.usu_data_cad AS eci_usr_dtatendimento,
        cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
        usu.usu_datanasc AS eci_usu_dtnascimento,
        usu.cd_nacionalidade AS eci_usu_nacionalidade,
        usu.usu_nome AS eci_usu_nome,
        usu.usu_nome_social AS eci_usu_nome_social,
        usu.usu_mae AS eci_usu_mae,
        usu.usu_pai AS eci_usu_pai,
        usu.rac_codigo AS eci_usu_raca,
        usu.usu_sexo AS eci_usu_sexo,
        usu.usu_pis_pasep AS eci_usu_pis_pasep, 
        usu.usu_email AS eci_usu_email, 
        usu.usu_celular AS eci_usu_celular,
        usu.usu_freq_escolar AS eci_usu_escola,
        usu.usu_deficiencia AS eci_usu_deficiencia,
        usu.usu_sit_rua AS eci_usu_sit_rua,
        usu.usu_cartao_sus AS eci_usu_cns,
        esp.cod_cbo AS eci_usr_cbo,
        eqp.nu_ine AS eci_usr_ine,
        mca.mic_descricao AS eci_usu_microarea,
        usu.usu_microarea_fa AS eci_usu_microarea_fa,
        usu.usu_maternidade_ref AS eci_usu_maternidade_ref,
        usu.usu_mudanca_territorio AS eci_usu_mudanca_territorio,
        usu.usu_numero_do AS eci_usu_numero_do,
        uis.uis_parentesco_resp AS eci_usu_parentesco_resp,
        usu.usu_cbo_r AS eci_usu_ocupacao,
        uis.uis_curso_mais_elevado AS eci_usu_curso_mais_elevado,
        uis.uis_mercado_trabalho AS eci_usu_mercado_trabalho,
        uis.uis_freq_cuidador_trad AS eci_usu_freq_cuidador_trad,
        uis.uis_grupo_comunitario AS eci_usu_grupo_comunitario,
        uis.uis_povo_comunidade_trad AS eci_usu_povo_comunidade_trad,
        uis.uis_povo_comunidade_trad_nome AS eci_usu_povo_comunidade_trad_nome,
        uis.uis_orientacao_sexual AS eci_usu_orientacao_sexual,
        uis.uis_orientacao_sexual_nome AS eci_usu_orientacao_sexual_nome,
        uis.uis_identidade_genero AS eci_usu_identidade_genero,
        uis.uis_identidade_genero_nome AS eci_usu_identidade_genero_nome,
        uis.uis_peso AS eci_usu_peso,
        uis.uis_fumante AS eci_usu_fumante,
        uis.uis_alcool AS eci_usu_alcool,
        uis.uis_drogas AS eci_usu_drogas,
        uis.uis_avc_derrame AS eci_usu_avc_derrame,
        uis.uis_infarto AS eci_usu_infarto,
        uis.uis_doenca_cardiaca AS eci_usu_doenca_cardiaca,
        uis.uis_problema_rins AS eci_usu_problema_rins,
        uis.uis_doenca_respiratoria AS eci_usu_doenca_respiratoria,
        uis.uis_hanseniase AS eci_usu_hanseniase,
        uis.uis_tuberculose AS eci_usu_tuberculose,
        uis.uis_cancer AS eci_usu_cancer,
        uis.uis_internacao_dose_meses AS eci_usu_internacao_dose_meses,
        uis.uis_internacao_dose_meses_causa AS eci_usu_internacao_dose_meses_causa,
        uis.uis_problema_saude_mental AS eci_usu_problema_saude_mental,
        uis.uis_acamado AS eci_usu_acamado,
        uis.uis_domiciliado AS eci_usu_domiciliado,
        uis.uis_plantas_medicinais AS eci_usu_plantas_medicinais,
        uis.uis_plantas_medicinais_nome AS eci_usu_plantas_medicinais_nome,
        uis.uis_praticas_integrat_complem AS eci_usu_praticas_integrat_complem,
        uis.uis_condicao_saude1 AS eci_usu_condicao_saude1,
        uis.uis_condicao_saude2 AS eci_usu_condicao_saude2,
        uis.uis_condicao_saude3 AS eci_usu_condicao_saude3,
        uis.uis_situacao_rua_tempo AS eci_usu_situacao_rua_tempo,
        uis.uis_recebe_beneficio AS eci_usu_recebe_beneficio,
        uis.uis_referencia_familiar AS eci_usu_referencia_familiar,
        uis.uis_vezes_alimenta_dia AS eci_usu_vezes_alimenta_dia,
        uis.uis_acompanhado_intituicao AS eci_usu_acompanhado_intituicao,
        uis.uis_acompanhado_intituicao_nome AS eci_usu_acompanhado_intituicao_nome,
        uis.uis_vista_familiar_frequencia AS eci_usu_vista_familiar_frequencia,
        uis.uis_vista_familiar_grau AS eci_usu_vista_familiar_grau,
        uis.uis_acesso_higiene_pessoal AS eci_usu_acesso_higiene_pessoal
      FROM
        usuario AS usu
        INNER JOIN
        usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
        INNER JOIN
        unidade AS uni ON usu.uni_codigo=uni.uni_codigo
        LEFT JOIN
        cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo
        INNER JOIN
        especialidade esp ON usu.usr_esp_codigo=esp.esp_codigo
        INNER JOIN
        tb_equipe eqp ON usu.usr_equipe_codigo=eqp.co_seq_equipe
        LEFT JOIN
        microarea mca ON usu.usu_microarea=mca.mic_codigo
        LEFT JOIN
        usuario_info_sociodemo uis ON usu.usu_codigo=uis.usu_codigo
      WHERE
        usu.usu_codigo = NEW.usu_codigo LOOP
        -- Validação de sexo
        IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
        -- Validação nacionalidade
        IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
        IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
        IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
        -- Validação Raça
        IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
        IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
        IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
        IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
        IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
        IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
        -- Valida situação responsavel
        IF (linha.eci_usu_st_responsavel_familiar='N') THEN eci_st_responsavel_familiar = 'f'; END IF;
        IF (linha.eci_usu_st_responsavel_familiar='S') THEN eci_st_responsavel_familiar = 't'; END IF;
        SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
        IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN

          INSERT INTO esus_cadastro_individual
          (usu_codigo,
           eci_usr_cnes,
           eci_usu_st_responsavel_familiar,
           eci_usr_profissional_cns,
           eci_usr_codigo_ibge,
           eci_usr_dtatendimento,
           eci_usu_codigo_ibge,
           eci_usu_dtnascimento,
           eci_usu_nacionalidade,
           eci_usu_nome,
           eci_usu_nome_social,
           eci_usu_mae,
           eci_usu_pai,
           eci_usu_raca,
           eci_usu_sexo,
           eci_usu_pis_pasep, 
           eci_usu_email, 
           eci_usu_celular,
           eci_usu_escola,
           eci_usu_deficiencia,
           eci_usu_cns,
           eci_tipo_dado_serializado,
           eci_usu_sit_rua,
           uuid_ficha_ori,
           eci_usr_cbo,
           eci_usr_ine,
           eci_usu_microarea,
           eci_usu_microarea_fa,
           eci_usu_maternidade_ref,
           eci_usu_mudanca_territorio,
           eci_usu_numero_do,
           eci_usu_parentesco_resp,
           eci_usu_ocupacao,
           eci_usu_curso_mais_elevado,
           eci_usu_mercado_trabalho,
           eci_usu_freq_cuidador_trad,
           eci_usu_grupo_comunitario,
           eci_usu_povo_comunidade_trad,
           eci_usu_povo_comunidade_trad_nome,
           eci_usu_orientacao_sexual,
           eci_usu_orientacao_sexual_nome,
           eci_usu_identidade_genero,
           eci_usu_identidade_genero_nome,
           eci_usu_peso,
           eci_usu_fumante,
           eci_usu_alcool,
           eci_usu_drogas,
           eci_usu_avc_derrame,
           eci_usu_infarto,
           eci_usu_doenca_cardiaca,
           eci_usu_problema_rins,
           eci_usu_doenca_respiratoria,
           eci_usu_hanseniase,
           eci_usu_tuberculose,
           eci_usu_cancer,
           eci_usu_internacao_dose_meses,
           eci_usu_internacao_dose_meses_causa,
           eci_usu_problema_saude_mental,
           eci_usu_acamado,
           eci_usu_domiciliado,
           eci_usu_plantas_medicinais,
           eci_usu_plantas_medicinais_nome,
           eci_usu_praticas_integrat_complem,
           eci_usu_condicao_saude1,
           eci_usu_condicao_saude2,
           eci_usu_condicao_saude3,
           eci_usu_situacao_rua_tempo,
           eci_usu_recebe_beneficio,
           eci_usu_referencia_familiar,
           eci_usu_vezes_alimenta_dia,
           eci_usu_acompanhado_intituicao,
           eci_usu_acompanhado_intituicao_nome,
           eci_usu_vista_familiar_frequencia,
           eci_usu_vista_familiar_grau,
           eci_usu_acesso_higiene_pessoal)
          VALUES
             (linha.usu_codigo,
              linha.eci_cnes,
              eci_st_responsavel_familiar,
              linha.eci_usr_cns,
              linha.eci_usr_codigo_ibge,
              linha.eci_usr_dtatendimento,
              linha.eci_usu_codigo_ibge,
              linha.eci_usu_dtnascimento,
              eci_nacionalidade,
              linha.eci_usu_nome,
              linha.eci_usu_nome_social,
              linha.eci_usu_mae,
              linha.eci_usu_pai,
              eci_raca,
              eci_sexo,
              linha.eci_usu_pis_pasep, 
              linha.eci_usu_email, 
              linha.eci_usu_celular,
              linha.eci_usu_escola,
              linha.eci_usu_deficiencia,
              linha.eci_usu_cns,
              '2 L',
              linha.eci_usu_sit_rua,
              (select uuid_ficha from esus_cadastro_individual  where usu_codigo = linha.usu_codigo order by eci_codigo asc limit 1),
              linha.eci_usr_cbo,
              linha.eci_usr_ine,
              linha.eci_usu_microarea,
              linha.eci_usu_microarea_fa,
              linha.eci_usu_maternidade_ref,
              linha.eci_usu_mudanca_territorio,
              linha.eci_usu_numero_do,
              linha.eci_usu_parentesco_resp,
              linha.eci_usu_ocupacao,
              linha.eci_usu_curso_mais_elevado,
              linha.eci_usu_mercado_trabalho,
              linha.eci_usu_freq_cuidador_trad,
              linha.eci_usu_grupo_comunitario,
              linha.eci_usu_povo_comunidade_trad,
              linha.eci_usu_povo_comunidade_trad_nome,
              linha.eci_usu_orientacao_sexual,
              linha.eci_usu_orientacao_sexual_nome,
              linha.eci_usu_identidade_genero,
              linha.eci_usu_identidade_genero_nome,
              linha.eci_usu_peso,
              linha.eci_usu_fumante,
              linha.eci_usu_alcool,
              linha.eci_usu_drogas,
              linha.eci_usu_avc_derrame,
              linha.eci_usu_infarto,
              linha.eci_usu_doenca_cardiaca,
              linha.eci_usu_problema_rins,
              linha.eci_usu_doenca_respiratoria,
              linha.eci_usu_hanseniase,
              linha.eci_usu_tuberculose,
              linha.eci_usu_cancer,
              linha.eci_usu_internacao_dose_meses,
              linha.eci_usu_internacao_dose_meses_causa,
              linha.eci_usu_problema_saude_mental,
              linha.eci_usu_acamado,
              linha.eci_usu_domiciliado,
              linha.eci_usu_plantas_medicinais,
              linha.eci_usu_plantas_medicinais_nome,
              linha.eci_usu_praticas_integrat_complem,
              linha.eci_usu_condicao_saude1,
              linha.eci_usu_condicao_saude2,
              linha.eci_usu_condicao_saude3,
              linha.eci_usu_situacao_rua_tempo,
              linha.eci_usu_recebe_beneficio,
              linha.eci_usu_referencia_familiar,
              linha.eci_usu_vezes_alimenta_dia,
              linha.eci_usu_acompanhado_intituicao,
              linha.eci_usu_acompanhado_intituicao_nome,
              linha.eci_usu_vista_familiar_frequencia,
              linha.eci_usu_vista_familiar_grau,
              linha.eci_usu_acesso_higiene_pessoal);

          RAISE NOTICE 'UPDATE''.';

        ELSE
          -- INSERÇÃO
          INSERT INTO esus_cadastro_individual
          (usu_codigo,
           eci_usr_cnes,
           eci_usu_st_responsavel_familiar,
           eci_usr_profissional_cns,
           eci_usr_codigo_ibge,
           eci_usr_dtatendimento,
           eci_usu_codigo_ibge,
           eci_usu_dtnascimento,
           eci_usu_nacionalidade,
           eci_usu_nome,
           eci_usu_nome_social,
           eci_usu_mae,
           eci_usu_pai,
           eci_usu_raca,
           eci_usu_sexo,
           eci_usu_pis_pasep, 
           eci_usu_email, 
           eci_usu_celular,
           eci_usu_escola,
           eci_usu_deficiencia,
           eci_usu_cns,
           eci_tipo_dado_serializado,
           eci_usu_sit_rua,
           eci_usr_cbo,
           eci_usr_ine,
           eci_usu_microarea,
           eci_usu_microarea_fa,
           eci_usu_maternidade_ref,
           eci_usu_mudanca_territorio,
           eci_usu_numero_do,
           eci_usu_parentesco_resp,
           eci_usu_ocupacao,
           eci_usu_curso_mais_elevado,
           eci_usu_mercado_trabalho,
           eci_usu_freq_cuidador_trad,
           eci_usu_grupo_comunitario,
           eci_usu_povo_comunidade_trad,
           eci_usu_povo_comunidade_trad_nome,
           eci_usu_orientacao_sexual,
           eci_usu_orientacao_sexual_nome,
           eci_usu_identidade_genero,
           eci_usu_identidade_genero_nome,
           eci_usu_peso,
           eci_usu_fumante,
           eci_usu_alcool,
           eci_usu_drogas,
           eci_usu_avc_derrame,
           eci_usu_infarto,
           eci_usu_doenca_cardiaca,
           eci_usu_problema_rins,
           eci_usu_doenca_respiratoria,
           eci_usu_hanseniase,
           eci_usu_tuberculose,
           eci_usu_cancer,
           eci_usu_internacao_dose_meses,
           eci_usu_internacao_dose_meses_causa,
           eci_usu_problema_saude_mental,
           eci_usu_acamado,
           eci_usu_domiciliado,
           eci_usu_plantas_medicinais,
           eci_usu_plantas_medicinais_nome,
           eci_usu_praticas_integrat_complem,
           eci_usu_condicao_saude1,
           eci_usu_condicao_saude2,
           eci_usu_condicao_saude3,
           eci_usu_situacao_rua_tempo,
           eci_usu_recebe_beneficio,
           eci_usu_referencia_familiar,
           eci_usu_vezes_alimenta_dia,
           eci_usu_acompanhado_intituicao,
           eci_usu_acompanhado_intituicao_nome,
           eci_usu_vista_familiar_frequencia,
           eci_usu_vista_familiar_grau,
           eci_usu_acesso_higiene_pessoal)
          VALUES
            (linha.usu_codigo,
             linha.eci_cnes,
             eci_st_responsavel_familiar,
             linha.eci_usr_cns,
             linha.eci_usr_codigo_ibge,
             linha.eci_usr_dtatendimento,
             linha.eci_usu_codigo_ibge,
             linha.eci_usu_dtnascimento,
             eci_nacionalidade,
             linha.eci_usu_nome,
             linha.eci_usu_nome_social,
             linha.eci_usu_mae,
             linha.eci_usu_pai,
             eci_raca,
             eci_sexo,
             linha.eci_usu_pis_pasep, 
             linha.eci_usu_email, 
             linha.eci_usu_celular,
             linha.eci_usu_escola,
             linha.eci_usu_deficiencia,
             linha.eci_usu_cns,
             '2 L',
             linha.eci_usu_sit_rua,
             linha.eci_usr_cbo,
             linha.eci_usr_ine,
             linha.eci_usu_microarea,
             linha.eci_usu_microarea_fa,
             linha.eci_usu_maternidade_ref,
             linha.eci_usu_mudanca_territorio,
             linha.eci_usu_numero_do,
             linha.eci_usu_parentesco_resp,
             linha.eci_usu_ocupacao,
             linha.eci_usu_curso_mais_elevado,
             linha.eci_usu_mercado_trabalho,
             linha.eci_usu_freq_cuidador_trad,
             linha.eci_usu_grupo_comunitario,
             linha.eci_usu_povo_comunidade_trad,
             linha.eci_usu_povo_comunidade_trad_nome,
             linha.eci_usu_orientacao_sexual,
             linha.eci_usu_orientacao_sexual_nome,
             linha.eci_usu_identidade_genero,
             linha.eci_usu_identidade_genero_nome,
             linha.eci_usu_peso,
             linha.eci_usu_fumante,
             linha.eci_usu_alcool,
             linha.eci_usu_drogas,
             linha.eci_usu_avc_derrame,
             linha.eci_usu_infarto,
             linha.eci_usu_doenca_cardiaca,
             linha.eci_usu_problema_rins,
             linha.eci_usu_doenca_respiratoria,
             linha.eci_usu_hanseniase,
             linha.eci_usu_tuberculose,
             linha.eci_usu_cancer,
             linha.eci_usu_internacao_dose_meses,
             linha.eci_usu_internacao_dose_meses_causa,
             linha.eci_usu_problema_saude_mental,
             linha.eci_usu_acamado,
             linha.eci_usu_domiciliado,
             linha.eci_usu_plantas_medicinais,
             linha.eci_usu_plantas_medicinais_nome,
             linha.eci_usu_praticas_integrat_complem,
             linha.eci_usu_condicao_saude1,
             linha.eci_usu_condicao_saude2,
             linha.eci_usu_condicao_saude3,
             linha.eci_usu_situacao_rua_tempo,
             linha.eci_usu_recebe_beneficio,
             linha.eci_usu_referencia_familiar,
             linha.eci_usu_vezes_alimenta_dia,
             linha.eci_usu_acompanhado_intituicao,
             linha.eci_usu_acompanhado_intituicao_nome,
             linha.eci_usu_vista_familiar_frequencia,
             linha.eci_usu_vista_familiar_grau,
             linha.eci_usu_acesso_higiene_pessoal);
        END IF;
      END LOOP;
    END IF;
    RAISE NOTICE 'INSERT''.';
  END IF;
  RETURN NULL;
END;

$BODY$;

CREATE TRIGGER atualiza_esus_cadastro_individual
    AFTER INSERT OR DELETE OR UPDATE 
    ON social.usuario_info_sociodemo
    FOR EACH ROW
    EXECUTE PROCEDURE social.esus_cadastro_individual();

UPDATE usuario SET usr_cadastro_codigo = usr_codigo WHERE usr_codigo IS NOT NULL AND usr_cadastro_codigo IS NULL;
UPDATE usuario SET uni_cadastro_codigo = uni_codigo WHERE uni_codigo IS NOT NULL AND uni_cadastro_codigo IS NULL;
UPDATE usuario SET usr_codigo = NULL, uni_codigo = NULL WHERE usr_equipe_codigo IS NULL;

/******************************************************************************************************
213201 - Fim
******************************************************************************************************/