SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='132', script='V132__3.165.164.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.165.164' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/******************************************************************************************************
233829 - Campo INE não carrega informação correta
******************************************************************************************************/

DROP TRIGGER atualiza_esus_ficha_procedimentos ON social.procedimento_atendimento;

DROP FUNCTION social.esus_ficha_procedimentos();

CREATE FUNCTION social.esus_ficha_procedimentos()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
AS $BODY$

DECLARE
  -- Dados do Atendimento
  linha_ate RECORD;
  -- Dados da Pré-Consulta
  linha_pc RECORD;
  efp_sexo CHARACTER VARYING(20);
  ret INTEGER;
BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM esus_ficha_procedimento WHERE pat_codigo = OLD.pat_codigo;
    RETURN NULL;
  END IF;

  SELECT
    INTO ret pra.ate_codigo
  FROM procedimento_atendimento pra
    JOIN atendimento ate ON ate.ate_codigo = pra.ate_codigo
    JOIN unidade uni ON uni.uni_codigo = ate.uni_codigo
  WHERE pra.ate_codigo = NEW.ate_codigo
        AND uni.uni_tipo <> 'H'
  GROUP BY pra.ate_codigo;

  IF ret IS NULL THEN
    RETURN NULL;
  END IF;

  IF ((SELECT usr_tipo_medico FROM usuarios WHERE usr_codigo = NEW.usr_codigo) = 'D') THEN
    RETURN NULL;
  END IF;

  -- Valida se o procedimento está vindo do Atendimento ou da Pré-Consulta
  IF (NEW.ate_codigo IS NOT NULL) THEN
    FOR linha_ate IN
    SELECT
      ate.age_codigo,
      pat.pat_codigo,
      pat.proc_codigo,
      tbl.co_local_atend,
      usr.cnes_cod_cns AS efp_profissional_cns,
      esp.cod_cbo AS efp_cbo_codigo_2002,
      uni.uni_cnes AS efp_cnes,
      tbe.nu_ine AS efp_ine,
      ate.ate_data AS efp_dtatendimento,
      uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
      usu.usu_cartao_sus AS efp_num_cartao_sus,
      usu.usu_datanasc AS efp_dtnascimento,
      usu.usu_prontuario AS efp_numprontuario,
      usu.usu_sexo
    FROM
      procedimento_atendimento AS pat
      INNER JOIN
      atendimento AS ate ON pat.ate_codigo=ate.ate_codigo
      INNER JOIN
      agendamento AS age ON ate.age_codigo=age.age_codigo
      INNER JOIN
      especialidade AS esp ON age.esp_codigo=esp.esp_codigo
      INNER JOIN
      usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
      INNER JOIN
      usuario AS usu ON ate.usu_codigo=usu.usu_codigo
      INNER JOIN
      unidade AS uni ON ate.uni_codigo=uni.uni_codigo
      INNER JOIN
      tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
      LEFT JOIN 
      usuarios_equipe AS umd ON umd.usr_codigo = usr.usr_codigo 
      LEFT JOIN 
      tb_equipe AS tbe ON tbe.co_seq_equipe = umd.co_equipe 
    WHERE
      pat.pat_codigo = NEW.pat_codigo LOOP

      IF (linha_ate.age_codigo IS NOT NULL
          AND linha_ate.proc_codigo IS NOT NULL
          AND linha_ate.co_local_atend IS NOT NULL
          AND linha_ate.efp_profissional_cns IS NOT NULL
          AND linha_ate.efp_cbo_codigo_2002 IS NOT NULL
          AND linha_ate.efp_cnes IS NOT NULL
          AND linha_ate.efp_codigo_ibge_mun IS NOT NULL
          AND linha_ate.efp_dtnascimento IS NOT NULL) THEN

        -- Validação de sexo
        IF (linha_ate.usu_sexo='M') THEN
          efp_sexo = '0 L';
        ELSE
          efp_sexo = '1 L';
        END IF;
        -- Realiza a inserção dos da ficha de procedimento do E-SUS
        INSERT INTO esus_ficha_procedimento(
          age_codigo,
          pat_codigo,
          proc_codigo,
          co_local_atend,
          efp_profissional_cns,
          efp_cbo_codigo_2002,
          efp_cnes,
          efp_ine,
          efp_dtatendimento,
          efp_codigo_ibge_mun,
          efp_num_cartao_sus,
          efp_dtnascimento,
          efp_numprontuario,
          efp_sexo,
          efp_tipo_dado_serializado,
          efp_dtcadastro
        ) VALUES (
          linha_ate.age_codigo,
          linha_ate.pat_codigo,
          linha_ate.proc_codigo,
          linha_ate.co_local_atend,
          linha_ate.efp_profissional_cns,
          linha_ate.efp_cbo_codigo_2002,
          linha_ate.efp_cnes,
          linha_ate.efp_ine,
          linha_ate.efp_dtatendimento,
          linha_ate.efp_codigo_ibge_mun,
          linha_ate.efp_num_cartao_sus,
          linha_ate.efp_dtnascimento,
          linha_ate.efp_numprontuario,
          efp_sexo,
          '7 L',
          'NOW()'
        );
        RAISE NOTICE 'Registro inserido com sucesso''.';
      END IF;
    END LOOP;
  END IF;
  IF (NEW.pc_codigo IS NOT NULL) THEN
    FOR linha_pc IN
    SELECT
      pc.age_codigo,
      pat.pat_codigo,
      pat.proc_codigo,
      tbl.co_local_atend,
      usr.cnes_cod_cns AS efp_profissional_cns,
      esp.cod_cbo AS efp_cbo_codigo_2002,
      uni.uni_cnes AS efp_cnes,
      tbe.nu_ine AS efp_ine,
      pc.pc_data AS efp_dtatendimento,
      uni.uni_codigo_ibge AS efp_codigo_ibge_mun,
      usu.usu_cartao_sus AS efp_num_cartao_sus,
      usu.usu_datanasc AS efp_dtnascimento,
      usu.usu_prontuario AS efp_numprontuario,
      usu.usu_sexo
    FROM
      procedimento_atendimento AS pat
      INNER JOIN
      pre_consulta AS pc ON pat.pc_codigo=pc.pc_codigo
      INNER JOIN
      agendamento AS age ON pc.age_codigo=age.age_codigo
      INNER JOIN
      especialidade AS esp ON age.esp_codigo=esp.esp_codigo
      INNER JOIN
      usuarios AS usr ON pat.usr_codigo=usr.usr_codigo
      INNER JOIN
      usuario AS usu ON age.usu_codigo=usu.usu_codigo
      INNER JOIN
      unidade AS uni ON age.uni_codigo=uni.uni_codigo
      INNER JOIN
      tb_local_atend AS tbl ON pc.co_local_atend=tbl.co_local_atend
      LEFT JOIN 
      usuarios_equipe AS umd ON umd.usr_codigo = usr.usr_codigo 
      LEFT JOIN 
      tb_equipe AS tbe ON tbe.co_seq_equipe = umd.co_equipe 
    WHERE
      pat.pat_codigo = NEW.pat_codigo LOOP

      IF (linha_pc.age_codigo IS NOT NULL
          AND linha_pc.proc_codigo IS NOT NULL
          AND linha_pc.co_local_atend IS NOT NULL
          AND linha_pc.efp_profissional_cns IS NOT NULL
          AND linha_pc.efp_cbo_codigo_2002 IS NOT NULL
          AND linha_pc.efp_cnes IS NOT NULL
          AND linha_pc.efp_codigo_ibge_mun IS NOT NULL
          AND linha_pc.efp_dtnascimento IS NOT NULL) THEN

        -- Validação de sexo
        IF (linha_pc.usu_sexo='M') THEN
          efp_sexo = '0 L';
        ELSE
          efp_sexo = '1 L';
        END IF;
        -- Realiza a inserção dos da ficha de procedimento do E-SUS
        INSERT INTO esus_ficha_procedimento(
          age_codigo,
          pat_codigo,
          proc_codigo,
          co_local_atend,
          efp_profissional_cns,
          efp_cbo_codigo_2002,
          efp_cnes,
          efp_ine,
          efp_dtatendimento,
          efp_codigo_ibge_mun,
          efp_num_cartao_sus,
          efp_dtnascimento,
          efp_sexo,
          efp_tipo_dado_serializado,
          efp_numprontuario,
          efp_dtcadastro
        ) VALUES (
          linha_pc.age_codigo,
          linha_pc.pat_codigo,
          linha_pc.proc_codigo,
          linha_pc.co_local_atend,
          linha_pc.efp_profissional_cns,
          linha_pc.efp_cbo_codigo_2002,
          linha_pc.efp_cnes,
          linha_pc.efp_ine,
          linha_pc.efp_dtatendimento,
          linha_pc.efp_codigo_ibge_mun,
          linha_pc.efp_num_cartao_sus,
          linha_pc.efp_dtnascimento,
          efp_sexo,
          '7 L',
          linha_pc.efp_numprontuario,
          'NOW()'
        );
        RAISE NOTICE 'Registro inserido com sucesso''.';
      END IF;
    END LOOP;
  END IF;
  RETURN NULL;
END;

$BODY$;

CREATE TRIGGER atualiza_esus_ficha_procedimentos
    AFTER INSERT OR DELETE OR UPDATE 
    ON social.procedimento_atendimento
    FOR EACH ROW
    EXECUTE PROCEDURE social.esus_ficha_procedimentos();
    
/******************************************************************************************************
233829 - Fim
******************************************************************************************************/

/******************************************************************************************************
234459 - Erro em exportação de conduta para o atendimento individual
******************************************************************************************************/

ALTER TABLE social.atendimento
    DROP COLUMN IF EXISTS usr_equipe_codigo;
ALTER TABLE social.atendimento
    ADD COLUMN usr_equipe_codigo integer; 

/******************************************************************************************************
234459 - Fim
******************************************************************************************************/

/******************************************************************************************************
234454 - Validações no campo INE na fichas de atendimento odontológico
******************************************************************************************************/

ALTER TABLE social.esus_odonto
    DROP COLUMN IF EXISTS eo_ine;
ALTER TABLE social.esus_odonto
    ADD COLUMN eo_ine character varying; 

DROP TRIGGER atualiza_esus_odonto ON social.odonto_procedimentos_controle;

DROP FUNCTION social.esus_odonto();

CREATE FUNCTION social.esus_odonto()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
AS $BODY$

DECLARE 
    linha RECORD;
    eo_sexo character varying(20);
    ret integer;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        DELETE FROM esus_odonto WHERE eo_codigo = OLD.eo_codigo;
        RETURN OLD;
    ELSE
        SELECT 
        INTO ret apc.ate_codigo
        from odonto_procedimentos_controle apc
        join atendimento ate on ate.ate_codigo = apc.ate_codigo
        join unidade uni on uni.uni_codigo = ate.uni_codigo
        where apc.ate_codigo = new.ate_codigo
        and uni.uni_tipo <> 'H';

        IF ret IS NULL THEN
            RETURN NULL;
        END IF;

        FOR linha IN
            SELECT DISTINCT
                odpc.odo_pcon_codigo,
                tbl.co_local_atend,
                usr.cnes_cod_cns AS eo_profissional_cns,
                esp.cod_cbo AS eo_cbo_codigo_2002,
                uni.uni_cnes AS eo_cnes,
                ate.ate_data AS eo_dtatendimento,
                uni.uni_codigo_ibge AS eo_codigo_ibge_mun,
                usu.usu_datanasc AS eo_dtnascimento,
                usu.usu_cartao_sus AS eo_num_cartao_sus,    
                usu.usu_prontuario AS eo_numprontuario,
                age.tat_codigo AS eo_tipo_atendimento,
                age.tp_cod AS eo_tipo_consulta,                 
                usu.usu_sexo,
                teq.nu_ine AS eo_ine
            FROM 
                odonto_procedimentos_controle AS odpc 
            INNER JOIN 
                atendimento AS ate ON odpc.ate_codigo=ate.ate_codigo
            INNER JOIN 
                agendamento AS age ON ate.age_codigo=age.age_codigo
            INNER JOIN 
                especialidade AS esp ON age.esp_codigo=esp.esp_codigo
            INNER JOIN 
                usuarios AS usr ON ate.med_codigo=usr.usr_codigo
            INNER JOIN
                usuario AS usu ON ate.usu_codigo=usu.usu_codigo
            INNER JOIN
                unidade AS uni ON ate.uni_codigo=uni.uni_codigo
            INNER JOIN 
                tb_local_atend AS tbl ON ate.co_local_atend=tbl.co_local_atend
            LEFT JOIN 
                tb_equipe teq ON teq.co_seq_equipe = ate.usr_equipe_codigo
            WHERE 
                odpc.odo_pcon_codigo = NEW.odo_pcon_codigo LOOP
            -- Validação de sexo
            IF (linha.usu_sexo='M') THEN 
                eo_sexo = '0 L';
            ELSE
                eo_sexo = '1 L';
            END IF;
            -- Realiza a inserção dos da ficha de procedimento do E-SUS
            INSERT INTO esus_odonto(
                odo_pcon_codigo,
                co_local_atend,
                eo_profissional_cns,
                eo_cbo_codigo_2002,
                eo_cnes,
                eo_dtatendimento,
                eo_codigo_ibge_mun,
                eo_dtnascimento,
                eo_num_cartao_sus,
                eo_numprontuario,
                eo_tipo_atendimento,
                eo_tipo_consulta,
                eo_sexo,
                eo_ine,
                eo_tipo_dado_serializado
            ) VALUES (
                linha.odo_pcon_codigo,
                linha.co_local_atend,
                linha.eo_profissional_cns,
                linha.eo_cbo_codigo_2002,
                linha.eo_cnes,
                linha.eo_dtatendimento,
                linha.eo_codigo_ibge_mun,
                linha.eo_dtnascimento,
                linha.eo_num_cartao_sus,
                linha.eo_numprontuario,
                linha.eo_tipo_atendimento,
                linha.eo_tipo_consulta,
                eo_sexo,
                linha.eo_ine,
                '5 L'
            );
            RETURN NEW;
            RAISE NOTICE 'Registro inserido com sucesso''.';
        END LOOP;
    END IF; 
END;

$BODY$;

CREATE TRIGGER atualiza_esus_odonto
    AFTER INSERT OR UPDATE 
    ON social.odonto_procedimentos_controle
    FOR EACH ROW
    EXECUTE PROCEDURE social.esus_odonto();

/******************************************************************************************************
234454 - Fim
******************************************************************************************************/