SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='135', script='V135__3.168.167.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.168.167' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/* 235054 - Adicionar funcionalidades na ficha de cadastro domiciliar */

CREATE TABLE IF NOT EXISTS instituicao_permanencia
(
    ipe_codigo serial NOT NULL, 
    dom_codigo bigint NOT NULL,
    ipe_nome character varying(100),
    ipe_st_outros character varying(1),
    ipe_resp_nome character varying(70),
    ipe_resp_cns character varying(15),
    ipe_resp_cargo character varying(100),
    ipe_resp_telefone character varying(20),
    CONSTRAINT ipe_codigo_pk PRIMARY KEY (ipe_codigo)
)
WITH (
    OIDS = FALSE
);
    
/* 235054 - Fim */


/* 235059 - Opção de encaixe por turnos */
ALTER TABLE convenio_horarios
DROP COLUMN IF EXISTS conh_intervalo;
ALTER TABLE convenio_horarios
ADD COLUMN conh_intervalo numeric;

ALTER TABLE convenio_horarios
DROP COLUMN IF EXISTS conh_encaixe;
ALTER TABLE convenio_horarios
ADD COLUMN conh_encaixe smallint;

ALTER TABLE convenio_horarios
DROP COLUMN IF EXISTS conh_cota_mes;
ALTER TABLE convenio_horarios
ADD COLUMN conh_cota_mes integer;

ALTER TABLE convenio_horarios
DROP COLUMN IF EXISTS conh_cota_dia;
ALTER TABLE convenio_horarios
ADD COLUMN conh_cota_dia integer;

/* 235059 - Fim */

/* 240826 - Inclusão de campo data do pedido e reformulação da tela de agendamento externo */
ALTER TABLE agendamento_externo
DROP COLUMN IF EXISTS agee_data_pedido;
ALTER TABLE agendamento_externo
ADD COLUMN agee_data_pedido date;
/* 240826 - Fim */

/*189308 - Implementar tela de criação e parametrização da lista de espera*/

INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto)
VALUES ('Criação e Parametrização Fila de Espera', 'zf/filaespera/fila','zf/filaespera/fila');

INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto)
VALUES ('Fila de Espera Unificada', 'zf/filaespera/fila-unificada','zf/filaespera/fila-unificada');

INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto)
VALUES ('Fila de Espera - Solicitações', 'zf/filaespera/filas-usuario','zf/filaespera/filas-usuario');

CREATE TABLE filas_tipoordenacao(
	fior_codigo SERIAL,
	fior_nome CHARACTER VARYING(60),
	fior_prioridade CHAR(1),
	fior_ordem_prioridade INTEGER,
	fior_tipoatendimento CHAR(1),
	fior_ordem_tipoatendimento INTEGER,
	CONSTRAINT pk_filas_tipoordenacao PRIMARY KEY (fior_codigo)
);

COMMENT ON COLUMN filas_tipoordenacao.fior_prioridade IS 'S - Sim, N - Não';
COMMENT ON COLUMN filas_tipoordenacao.fior_tipoatendimento IS 'S - Sim, N - Não';
COMMENT ON COLUMN filas_tipoordenacao.fior_ordem_prioridade IS 'Ordem de precedência no momento da ordenação. Pode ser 1 ou 2';
COMMENT ON COLUMN filas_tipoordenacao.fior_ordem_tipoatendimento IS 'Ordem de precedência no momento da ordenação. Pode ser 1 ou 2';

CREATE TABLE filas_prioridades(
	fipr_codigo SERIAL,
	fipr_nome CHARACTER VARYING(60) NOT NULL,
	fipr_peso INTEGER NOT NULL,
	CONSTRAINT pk_filas_prioridades PRIMARY KEY (fipr_codigo)
);

COMMENT ON COLUMN filas_prioridades.fipr_peso IS 'Peso numérico para ordenação ASCENDENTE da fila';

CREATE TABLE filas_tipoatendimentos(
	fiti_codigo SERIAL,
	fiti_nome CHARACTER VARYING(60) NOT NULL,
	fiti_peso INTEGER NOT NULL,
	CONSTRAINT pk_filas_tipoatendimentos PRIMARY KEY (fiti_codigo)
);

COMMENT ON COLUMN filas_tipoatendimentos.fiti_peso IS 'Peso numérico para ordenação ASCENDENTE da fila';

CREATE TABLE filas (
	fila_codigo SERIAL,
	fila_nome CHARACTER VARYING(60) NOT NULL,
	fila_descricao TEXT,
	fila_tipo CHAR(1) NOT NULL,
	fior_codigo INTEGER NOT NULL,
	fila_regulacao CHAR(1) NOT NULL,
	fila_consulta_publica CHAR(1) NOT NULL,
	fila_status CHAR(1) NOT NULL DEFAULT 'A',
	CONSTRAINT pk_filas PRIMARY KEY (fila_codigo),
	CONSTRAINT fk_filas_tipoordenacao FOREIGN KEY (fior_codigo) REFERENCES filas_tipoordenacao (fior_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);

COMMENT ON COLUMN filas.fila_tipo IS 'I - Agendamento Interno, E - Agendamento Externo, P - Procedimentos, U - Unificada';
COMMENT ON COLUMN filas.fior_codigo IS 'Tipo de Ordenação';
COMMENT ON COLUMN filas.fila_regulacao IS 'S - Sim, N - Não';
COMMENT ON COLUMN filas.fila_consulta_publica IS 'S - Sim, N - Não';
COMMENT ON COLUMN filas.fila_status IS 'A - Ativo, I - Inativo';


CREATE TABLE filas_reguladores(
	fire_codigo SERIAL,
	fila_codigo INTEGER NOT NULL,
	usr_codigo INTEGER NOT NULL,
	fire_regulador CHAR(1) DEFAULT 'N',
	CONSTRAINT pk_filas_reguladores PRIMARY KEY (fire_codigo),
	CONSTRAINT fk_filas FOREIGN KEY (fila_codigo) REFERENCES filas (fila_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_usuarios FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);

COMMENT ON COLUMN filas_reguladores.fire_regulador IS 'S - Sim, N - Não';


CREATE TABLE filas_usuario(
	fiusu_codigo SERIAL,
	fila_codigo INTEGER NOT NULL,
	uni_codigo INTEGER,
	usr_codigo INTEGER,
	med_codigo INTEGER,
	fipr_codigo INTEGER,
	fiti_codigo INTEGER,
	fiusu_data_entrada TIMESTAMP WITHOUT TIME ZONE,
	fiusu_motivo_solicitacao TEXT,
	fiusu_data_saida TIMESTAMP WITHOUT TIME ZONE,
	fiusu_motivo_saida TEXT,
	fiusu_data_pedido DATE,
	usu_codigo INTEGER NOT NULL,
	fiusu_status CHAR(2),
	fiusu_ordem INTEGER,
	esp_codigo INTEGER,
	
	CONSTRAINT pk_filas_usuario PRIMARY KEY (fiusu_codigo),
	CONSTRAINT fk_filas FOREIGN KEY (fila_codigo) REFERENCES filas (fila_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_unidade FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_usuarios FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_medico FOREIGN KEY (med_codigo) REFERENCES medico (med_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_filas_prioridades FOREIGN KEY (fipr_codigo) REFERENCES filas_prioridades (fipr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_filas_tipoatendimentos FOREIGN KEY (fiti_codigo) REFERENCES filas_tipoatendimentos (fiti_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_usuario FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_especialidade FOREIGN KEY (esp_codigo) REFERENCES especialidade (esp_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
	
);

COMMENT ON COLUMN filas_usuario.uni_codigo IS 'Unidade solicitante';
COMMENT ON COLUMN filas_usuario.usr_codigo IS 'Médico solicitante (Interno)';
COMMENT ON COLUMN filas_usuario.med_codigo IS 'Médico solicitante (Externo)';
COMMENT ON COLUMN filas_usuario.fipr_codigo IS 'Prioridade da solicitação';
COMMENT ON COLUMN filas_usuario.fiti_codigo IS 'Tipo de atendimento da solicitação';
COMMENT ON COLUMN filas_usuario.fiusu_status IS 'AR - Aguardando regulador, ES - Em espera, SA - Solicitação agendada, AT - Atendimento Realizado, SR - Solicitação retornada, CA - Cancelado';
COMMENT ON COLUMN filas_usuario.esp_codigo IS 'Especialidade que será levada para o agendamento';



CREATE TABLE filas_historicos(
	fihi_codigo SERIAL NOT NULL,
	fiusu_codigo INTEGER,
	fila_codigo INTEGER,
	uni_codigo INTEGER,
	usr_codigo INTEGER,
	med_codigo INTEGER,
	fipr_codigo INTEGER,
	fiti_codigo INTEGER,
	fihi_data_entrada TIMESTAMP WITHOUT TIME ZONE,
	fihi_motivo_solicitacao TEXT,
	fihi_data_saida TIMESTAMP WITHOUT TIME ZONE,
	fihi_motivo_saida TEXT,
	fihi_data_pedido DATE,
	usu_codigo INTEGER,
	fihi_status CHAR(2),
	fihi_ordem INTEGER,
	esp_codigo INTEGER,
	fihi_usr_historico INTEGER,
	fihi_datahora_historico TIMESTAMP WITHOUT TIME ZONE,
	fihi_ordem_historico INTEGER,
	CONSTRAINT pk_filas_historicos PRIMARY KEY (fihi_codigo),
	CONSTRAINT fk_filas FOREIGN KEY (fila_codigo) REFERENCES filas (fila_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_unidade FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_usuarios FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_medico FOREIGN KEY (med_codigo) REFERENCES medico (med_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_filas_prioridades FOREIGN KEY (fipr_codigo) REFERENCES filas_prioridades (fipr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_filas_tipoatendimentos FOREIGN KEY (fiti_codigo) REFERENCES filas_tipoatendimentos (fiti_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_usuario FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_especialidade FOREIGN KEY (esp_codigo) REFERENCES especialidade (esp_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);

COMMENT ON COLUMN filas_historicos.fihi_usr_historico IS 'Usuário que inseriu/alterou o registro';
COMMENT ON COLUMN filas_historicos.fihi_datahora_historico IS 'Data/Hora em que o registro foi inserido/alterado';
COMMENT ON COLUMN filas_historicos.fihi_ordem_historico IS 'Ordem de alteração do registro';

INSERT INTO filas_tipoatendimentos (fiti_nome, fiti_peso) VALUES ('URGENCIA', 1);
INSERT INTO filas_tipoatendimentos (fiti_nome, fiti_peso) VALUES ('RETORNO', 2);
INSERT INTO filas_tipoatendimentos (fiti_nome, fiti_peso) VALUES ('ELETIVO', 3);

INSERT INTO filas_prioridades (fipr_nome, fipr_peso) VALUES ('ALTA',1);
INSERT INTO filas_prioridades (fipr_nome, fipr_peso) VALUES ('MÉDIA',2);
INSERT INTO filas_prioridades (fipr_nome, fipr_peso) VALUES ('BAIXA',3);

INSERT INTO filas_tipoordenacao(fior_prioridade, fior_ordem_prioridade, fior_tipoatendimento, fior_ordem_tipoatendimento, fior_nome)
   VALUES ('S', 1, 'S', 2, 'PRIORIDADE > TIPO DE ATENDIMENTO > DATA DE ENTRADA');
INSERT INTO filas_tipoordenacao(fior_prioridade, fior_ordem_prioridade, fior_tipoatendimento, fior_ordem_tipoatendimento, fior_nome)
   VALUES ('S', 2, 'S', 1, 'TIPO DE ATENDIMENTO > PRIORIDADE > DATA DE ENTRADA');

/*189308 - Fim*/

/*242601 - Implementar adição de mais de um procedimento na lista de espera*/
CREATE TABLE filas_usuario_procedimento (
	fiproc_codigo serial,
	fiusu_codigo INTEGER NOT NULL,
	proc_codigo INTEGER NOT NULL,
	CONSTRAINT pk_filas_usuario_procedimento PRIMARY KEY (fiproc_codigo),
	CONSTRAINT fk_filas_usuario FOREIGN KEY (fiusu_codigo) REFERENCES filas_usuario (fiusu_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
	CONSTRAINT fk_procedimento FOREIGN KEY (proc_codigo) REFERENCES procedimento (proc_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);
COMMENT ON COLUMN filas_usuario_procedimento.fiusu_codigo IS 'Solicitacão da Fila de Espera';
COMMENT ON COLUMN filas_usuario_procedimento.proc_codigo IS 'Procedimento que será levado para o agendamento';
/*242601 - Fim*/

/* 237655 - Implementação na fila de espera para realização do agendamento de exames/procedimentos*/
ALTER TABLE agenda ADD COLUMN fiusu_codigo INTEGER;
ALTER TABLE agendamento_exame ADD COLUMN fiusu_codigo INTEGER;
/*237655 - Fim */
/* 237651 - Implementação na fila de espera para realização do agendamento externo*/
ALTER TABLE agendamento_externo ADD COLUMN fiusu_codigo INTEGER;
/*237651 - Fim */

/* 237645 - Implementação na fila de espera para realização do agendamento interno*/
ALTER TABLE agendamento ADD COLUMN fiusu_codigo INTEGER;
/*237645 - Fim */

/* 241239 - Erro ao realizar entrada de produtos enviados com Hórus - Tranferência*/
ALTER TABLE horus_protocolo ALTER COLUMN hp_tipo_registro TYPE char(2) USING hp_tipo_registro::char(2);
COMMENT ON COLUMN horus_protocolo.hp_tipo_registro IS 'E - Entrada
S - Saída
D - Dispensação
X - Exclusão
R - Retificação
TS - Transferência Saida
TE - Transferência Entrada
--Adicionar mais tipos conforme for necessário';
/*241239 - Fim */


/* 242657 - Recusa de cadastro domiciliar não exporta - Pergunta padrão para casos de recusa de cadastro */
INSERT INTO tb_pergunta(co_seq_pergunta, ds_local, ds_pergunta, co_contexto_pergunta, tp_pergunta) VALUES (9999, 'pt_BR', 'Pergunta provisória para casos de recusa de cadastro', 2, 1);
/*242657 - Fim */




