SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='137', script='V137__3.170.171.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.170.169' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';


/******************************************************************************************************
243122 - Criar parâmetro para controle da quantidade de solicitações na fila aparecem para agendamento
******************************************************************************************************/

INSERT INTO config (conf_chave, conf_label, conf_valor_string, conf_valor_int, conf_tipo, cac_codigo, conf_readonly)
     VALUES ('QTD_FILA_AGENDAMENTO', 'Quantidade de agendamentos liberados na fila de espera', NULL, 1, 3, 6, FALSE);
   
/******************************************************************************************************
243122 - Fim
******************************************************************************************************/


/******************************************************************************************************
203594 - Implementação de tela para lançamento de pré-natal e puerpério
******************************************************************************************************/

CREATE TABLE IF NOT EXISTS usuario_dados
(
  usd_codigo BIGSERIAL NOT NULL,
  usu_codigo INTEGER NOT NULL,
  cirurgias CHARACTER VARYING,
  internacoes CHARACTER VARYING,
  observacoes CHARACTER VARYING,
  gestas_previas INTEGER,
  cesareas INTEGER,
  abortos INTEGER,
  nascidos_vivos INTEGER,
  rn2500 INTEGER,
  rn4500 INTEGER,
  partos INTEGER,
  vivem INTEGER,
  mortos_1sem INTEGER,
  mortos_d1sem INTEGER,
  partos_vaginais INTEGER,
  partos_domiciliares INTEGER,
  nascidos_mortos INTEGER,
  desfecho CHAR(1),
  vacinacao_em_dia CHAR(1),
  CONSTRAINT pk_usuario_dados PRIMARY KEY (usd_codigo),
  CONSTRAINT fk_usuario_dados_usuario FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo)
);

COMMENT ON COLUMN usuario_dados.rn2500 IS 'RN < 2500g';
COMMENT ON COLUMN usuario_dados.rn4500 IS 'RN > 4500g';
COMMENT ON COLUMN usuario_dados.mortos_1sem IS 'Mortos - 1ª semana';
COMMENT ON COLUMN usuario_dados.mortos_d1sem IS 'Mortos - depois 1ª semana';
COMMENT ON COLUMN usuario_dados.desfecho IS 'S - Sim, N - Não';
COMMENT ON COLUMN usuario_dados.vacinacao_em_dia IS 't - Sim, f - Não';

CREATE TABLE IF NOT EXISTS atendimento_prenatal
(
  atp_codigo BIGSERIAL NOT NULL,
  ate_codigo INTEGER NOT NULL,
  tipo_gravidez CHARACTER(1),
  tipo_consulta INTEGER NOT NULL,
  numero_gestacao INTEGER NOT NULL,
  gravidez_planejada CHARACTER(1),
  edema INTEGER,
  altura_uterina INTEGER,
  batimento_cardiaco INTEGER,
  movimentacao_fetal CHAR(1),
  dum DATE,
  idade_gestacional INTEGER,
  CONSTRAINT pk_atendimento_prenatal PRIMARY KEY (atp_codigo),
  CONSTRAINT fk_atendimento_prenatal_atendimento FOREIGN KEY (ate_codigo) REFERENCES atendimento (ate_codigo)
);

COMMENT ON COLUMN atendimento_prenatal.tipo_consulta IS '1 - Pré-natal, 2 - Puerpero';
COMMENT ON COLUMN atendimento_prenatal.tipo_gravidez IS 'U - Única, D - Dupla/Gemelar, T - Tripla ou mais, I - Ignorada';
COMMENT ON COLUMN atendimento_prenatal.gravidez_planejada IS 't - Sim, f - Não';
COMMENT ON COLUMN atendimento_prenatal.edema IS '1 - (-), 2 - (+), 3 - (++), 4 - (+++)';
COMMENT ON COLUMN atendimento_prenatal.movimentacao_fetal IS 'S - Sim, N - Não';

ALTER TABLE pre_consulta ADD COLUMN pc_momento_coleta INTEGER;

COMMENT ON COLUMN pre_consulta.pc_momento_coleta IS '1 - Jejum, 2 - Pós-prandial, 3 - Pré-prandial, 4 - Não especificado';
   
/******************************************************************************************************
203594 - Fim
******************************************************************************************************/

/* 244103 - Opção de encaixe por turnos na tela de manutenção e exceção de agendamento*/
ALTER TABLE grade_periodo ADD COLUMN grade_cota INTEGER;
ALTER TABLE grade_periodo ADD COLUMN grade_encaixe INTEGER;
ALTER TABLE grade_periodo ADD COLUMN grade_intervalo NUMERIC;
/*244103 - Fim */

/* 165018 - Novos campos ficha de atendimento individual*/
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_rac_saude INTEGER;
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_perimetro_cefalico DOUBLE PRECISION;
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_vacinacao_em_dia CHAR(1);
ALTER TABLE esus_atendimento_individual ADD COLUMN  eai_aleitamento_materno INTEGER;
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_peso NUMERIC(9,3);
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_altura NUMERIC(9,1);
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_ate_dom_mod INTEGER;
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_gravidez_planejada CHAR(1);
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_dum TIMESTAMP WITHOUT TIME ZONE;
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_gestas_previas INTEGER;
ALTER TABLE esus_atendimento_individual ADD COLUMN eai_partos INTEGER;

ALTER TABLE usuario ADD COLUMN usu_ate_dom_mod INTEGER;
COMMENT ON COLUMN usuario.usu_ate_dom_mod IS '1 - AD1, 2 - AD2, 3 - AD3';
ALTER TABLE atendimento ADD COLUMN ate_rac_saude INTEGER;
COMMENT ON COLUMN atendimento.ate_rac_saude IS '1 - Medicina Tradicional, 2 - Antroposofia Aplicada à Saúde, 3 - Homeopatia, 4 - Fitoterapia, 5 - Ayurveda, 6 - Outra';
ALTER TABLE atendimento ADD COLUMN ate_perimetro_cefalico DOUBLE PRECISION;
ALTER TABLE atendimento ADD COLUMN vacinacao_em_dia CHAR(1);
COMMENT ON COLUMN atendimento.vacinacao_em_dia IS 't - Sim, f - Não';
ALTER TABLE atendimento ADD COLUMN aleitamento_materno INTEGER;
COMMENT ON COLUMN atendimento.aleitamento_materno IS '1 - Exclusivo, 2 - Predominante, 3 - Complementado, 4 - Inexistente';
ALTER TABLE atendimento ALTER COLUMN ate_peso TYPE NUMERIC(9,3);
ALTER TABLE atendimento ALTER COLUMN ate_altura TYPE NUMERIC(9,1);

DROP TRIGGER IF EXISTS atualiza_esus_atendimento_individual ON rl_cds_atend_individual_condut;

DROP FUNCTION IF EXISTS esus_atendimento_individual();

-- FUNCTION: social.esus_atendimento_individual()

-- DROP FUNCTION social.esus_atendimento_individual();


DROP FUNCTION IF EXISTS esus_atendimento_individual();
CREATE FUNCTION esus_atendimento_individual()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE
AS $BODY$

DECLARE
  linha    RECORD;
  eai_sexo character varying(20);
  ret      integer;
BEGIN
  IF (TG_OP = 'DELETE')
  THEN
    DELETE FROM esus_atendimento_individual
    WHERE ate_codigo = OLD.ate_codigo;
    RETURN OLD;
  ELSE
    SELECT
      INTO ret rai.ate_codigo
    from rl_cds_atend_individual_condut rai
      join atendimento ate on ate.ate_codigo = rai.ate_codigo
      join unidade uni on uni.uni_codigo = ate.uni_codigo
    where rai.ate_codigo = new.ate_codigo
          and uni.uni_tipo <> 'H'
    group by rai.ate_codigo;

    IF ret IS NULL
    THEN
      RETURN NULL;
    END IF;

    FOR linha IN
    SELECT DISTINCT
      ate.ate_codigo,
      ate.ate_rac_saude AS eai_rac_saude,
      ate.ate_perimetro_cefalico AS eai_perimetro_cefalico,
      ate.vacinacao_em_dia AS eai_vacinacao_em_dia,
      ate.aleitamento_materno AS eai_aleitamento_materno,
      ate.ate_peso AS eai_peso,
      ate.ate_altura AS eai_altura,
      age.tat_codigo           AS eai_tipo_atendimento,
      tbl.co_local_atend,
      usr.cnes_cod_cns         AS eai_profissional_cns,
      esp.cod_cbo              AS eai_cbo_codigo_2002,
      uni.uni_cnes             AS eai_cnes,
      ate.ate_data             AS eai_dtatendimento,
      uni.uni_codigo_ibge      AS eai_codigo_ibge_mun,
      usu.usu_cartao_sus       AS eai_num_cartao_sus,
      usu.usu_datanasc         AS eai_dtnascimento,
      usu.usu_prontuario       AS eai_numprontuario,
      usu.usu_sexo,
      usu.usu_ate_dom_mod      AS eai_ate_dom_mod,
      atepn.gravidez_planejada AS eai_gravidez_planejada,
      atepn.dum                AS eai_dum,
    usudados.gestas_previas  AS eai_gestas_previas,
      usudados.partos      AS eai_partos
    FROM
      atendimento AS ate
      INNER JOIN
      agendamento AS age ON ate.age_codigo = age.age_codigo
      INNER JOIN
      especialidade AS esp ON age.esp_codigo = esp.esp_codigo
      INNER JOIN
      usuarios AS usr ON ate.med_codigo = usr.usr_codigo
      INNER JOIN
      usuario AS usu ON ate.usu_codigo = usu.usu_codigo
      INNER JOIN
      unidade AS uni ON ate.uni_codigo = uni.uni_codigo
      INNER JOIN
      tb_local_atend AS tbl ON ate.co_local_atend = tbl.co_local_atend
      LEFT JOIN
      rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo = rlai.ate_codigo
      INNER JOIN
      rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo = rlaic.ate_codigo
      LEFT JOIN
      atendimento_prenatal AS atepn ON ate.ate_codigo = atepn.ate_codigo
    LEFT JOIN 
      usuario_dados as usudados ON ate.usu_codigo = usudados.usu_codigo
    WHERE
      ate.ate_codigo = NEW.ate_codigo LOOP
      -- Validação de sexo
      IF (linha.usu_sexo = 'M')
      THEN
        eai_sexo = '0 L';
      ELSE
        eai_sexo = '1 L';
      END IF;
      -- Realiza a inserção dos da ficha de procedimento do E-SUS
      INSERT INTO esus_atendimento_individual (
        ate_codigo,
        eai_rac_saude,
        eai_perimetro_cefalico,
        eai_vacinacao_em_dia,
        eai_aleitamento_materno,
        eai_peso,
        eai_altura,
        eai_ate_dom_mod,
        eai_gravidez_planejada,
        eai_dum,
    eai_gestas_previas,
    eai_partos,
        co_local_atend,
        eai_profissional_cns,
        eai_cbo_codigo_2002,
        eai_cnes,
        eai_dtatendimento,
        eai_codigo_ibge_mun,
        eai_dtnascimento,
        eai_num_cartao_sus,
        eai_numprontuario,
        eai_tipo_atendimento,
        eai_sexo,
        eai_tipo_dado_serializado

      ) VALUES (
        linha.ate_codigo,
        linha.eai_rac_saude,
        linha.eai_perimetro_cefalico,
        linha.eai_vacinacao_em_dia,
        linha.eai_aleitamento_materno,
        linha.eai_peso,
        linha.eai_altura,
        linha.eai_ate_dom_mod,
        linha.eai_gravidez_planejada,
        linha.eai_dum,
    linha.eai_gestas_previas,
    linha.eai_partos,
        linha.co_local_atend,
        linha.eai_profissional_cns,
        linha.eai_cbo_codigo_2002,
        linha.eai_cnes,
        linha.eai_dtatendimento,
        linha.eai_codigo_ibge_mun,
        linha.eai_dtnascimento,
        linha.eai_num_cartao_sus,
        linha.eai_numprontuario,
        linha.eai_tipo_atendimento,
        eai_sexo,
        '4 L'
      );
      RETURN NEW;
      RAISE NOTICE 'Registro inserido com sucesso''.';
    END LOOP;
  END IF;
END;

$BODY$;
CREATE TRIGGER atualiza_esus_atendimento_individual
AFTER INSERT OR DELETE OR UPDATE ON rl_cds_atend_individual_condut FOR EACH ROW
EXECUTE PROCEDURE esus_atendimento_individual();
/* 165018 - Fim */
/*247957 - Erro ao salvar 9º digito do numero de telefone domiciliar*/
DROP VIEW IF EXISTS bt_usuarios CASCADE ;
DROP VIEW IF EXISTS bt_inconsistencia_domicilio CASCADE ;
DROP VIEW IF EXISTS bt_domicilios CASCADE ;
ALTER TABLE domicilio ALTER COLUMN dom_telefone TYPE character varying(15);
/*247957 - Fim*/
