SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='138', script='V138__3.171.170.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.171.170' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';


/* 246144 - Aumentar a quantidade de caracteres da tela de cadastro de orientações */
ALTER TABLE orientacoes_exames ALTER COLUMN ori_exa_orientacoes TYPE character varying(150);
/* 246144 - Fim*/

/* 247489 - Implementação da Plataforma para Relatórios em Java. */
INSERT INTO permissoes (perm_descricao, perm_programa, perm_objeto) VALUES ('RELATÓRIOS DE AGENDAMENTO', 'zf/relatorio/agendamento', 'zf/relatorio/agendamento');
/* 247489 - Fim*/

/* 244356 - Não está sendo executado o cálculo de custo médio em saídas*/
ALTER TABLE itens_movimento DROP COLUMN IF EXISTS protocolo_horus;
ALTER TABLE itens_movimento ADD COLUMN protocolo_horus VARCHAR(50);
ALTER TABLE horus_erros ALTER COLUMN he_codigo TYPE varchar(50) USING he_codigo::varchar(50);
/*244356 - Fim */

/* 252767 - Problemas pré-natal*/
-- Function: esus_atendimento_individual()

-- DROP FUNCTION esus_atendimento_individual();

CREATE OR REPLACE FUNCTION esus_atendimento_individual()
  RETURNS trigger AS
$BODY$

DECLARE
  linha    RECORD;
  eai_sexo character varying(20);
  ret      integer;
  registro RECORD;
BEGIN
  IF (TG_OP = 'DELETE')
  THEN
    DELETE FROM esus_atendimento_individual
    WHERE ate_codigo = OLD.ate_codigo;
    RETURN OLD;
  ELSE
    --Busca para ver se a ficha já existe
    SELECT INTO registro eai_codigo FROM esus_atendimento_individual WHERE ate_codigo = NEW.ate_codigo;
    IF(registro IS NOT NULL)
    THEN
      DELETE FROM esus_atendimento_individual
      WHERE ate_codigo = NEW.ate_codigo;
    END IF;

    SELECT
      INTO ret rai.ate_codigo
    FROM rl_cds_atend_individual_condut rai
      JOIN atendimento ate on ate.ate_codigo = rai.ate_codigo
      JOIN unidade uni on uni.uni_codigo = ate.uni_codigo
    WHERE rai.ate_codigo = new.ate_codigo
          AND uni.uni_tipo <> 'H'
    GROUP BY rai.ate_codigo;

    IF ret IS NULL
    THEN
      RETURN NULL;
    END IF;

    FOR linha IN
    SELECT DISTINCT
      ate.ate_codigo,
      ate.ate_rac_saude AS eai_rac_saude,
      ate.ate_perimetro_cefalico AS eai_perimetro_cefalico,
      usudados.vacinacao_em_dia AS eai_vacinacao_em_dia,
      ate.aleitamento_materno AS eai_aleitamento_materno,
      ate.ate_peso AS eai_peso,
      ate.ate_altura AS eai_altura,
      age.tat_codigo           AS eai_tipo_atendimento,
      tbl.co_local_atend,
      usr.cnes_cod_cns         AS eai_profissional_cns,
      esp.cod_cbo              AS eai_cbo_codigo_2002,
      uni.uni_cnes             AS eai_cnes,
      ate.ate_data             AS eai_dtatendimento,
      uni.uni_codigo_ibge      AS eai_codigo_ibge_mun,
      usu.usu_cartao_sus       AS eai_num_cartao_sus,
      usu.usu_datanasc         AS eai_dtnascimento,
      usu.usu_prontuario       AS eai_numprontuario,
      usu.usu_sexo,
      usu.usu_ate_dom_mod      AS eai_ate_dom_mod,
      atepn.gravidez_planejada AS eai_gravidez_planejada,
      atepn.dum                AS eai_dum,
      usudados.gestas_previas  AS eai_gestas_previas,
      usudados.partos		   AS eai_partos
    FROM
      atendimento AS ate
      INNER JOIN
      agendamento AS age ON ate.age_codigo = age.age_codigo
      INNER JOIN
      especialidade AS esp ON age.esp_codigo = esp.esp_codigo
      INNER JOIN
      usuarios AS usr ON ate.med_codigo = usr.usr_codigo
      INNER JOIN
      usuario AS usu ON ate.usu_codigo = usu.usu_codigo
      INNER JOIN
      unidade AS uni ON ate.uni_codigo = uni.uni_codigo
      INNER JOIN
      tb_local_atend AS tbl ON ate.co_local_atend = tbl.co_local_atend
      LEFT JOIN
      rl_cds_atend_individual_ciap AS rlai ON ate.ate_codigo = rlai.ate_codigo
      INNER JOIN
      rl_cds_atend_individual_condut AS rlaic ON ate.ate_codigo = rlaic.ate_codigo
      LEFT JOIN
      atendimento_prenatal AS atepn ON ate.ate_codigo = atepn.ate_codigo
      LEFT JOIN
      usuario_dados as usudados ON ate.usu_codigo = usudados.usu_codigo
    WHERE
      ate.ate_codigo = NEW.ate_codigo LOOP
      -- Validação de sexo
      IF (linha.usu_sexo = 'M')
      THEN
        eai_sexo = '0 L';
      ELSE
        eai_sexo = '1 L';
      END IF;

        -- Realiza a inserção dos da ficha de procedimento do E-SUS
        INSERT INTO esus_atendimento_individual (
          ate_codigo,
          eai_rac_saude,
          eai_perimetro_cefalico,
          eai_vacinacao_em_dia,
          eai_aleitamento_materno,
          eai_peso,
          eai_altura,
          eai_ate_dom_mod,
          eai_gravidez_planejada,
          eai_dum,
          eai_gestas_previas,
          eai_partos,
          co_local_atend,
          eai_profissional_cns,
          eai_cbo_codigo_2002,
          eai_cnes,
          eai_dtatendimento,
          eai_codigo_ibge_mun,
          eai_dtnascimento,
          eai_num_cartao_sus,
          eai_numprontuario,
          eai_tipo_atendimento,
          eai_sexo,
          eai_tipo_dado_serializado

        ) VALUES (
          linha.ate_codigo,
          linha.eai_rac_saude,
          linha.eai_perimetro_cefalico,
          linha.eai_vacinacao_em_dia,
          linha.eai_aleitamento_materno,
          linha.eai_peso,
          linha.eai_altura,
          linha.eai_ate_dom_mod,
          linha.eai_gravidez_planejada,
          linha.eai_dum,
          linha.eai_gestas_previas,
          linha.eai_partos,
          linha.co_local_atend,
          linha.eai_profissional_cns,
          linha.eai_cbo_codigo_2002,
          linha.eai_cnes,
          linha.eai_dtatendimento,
          linha.eai_codigo_ibge_mun,
          linha.eai_dtnascimento,
          linha.eai_num_cartao_sus,
          linha.eai_numprontuario,
          linha.eai_tipo_atendimento,
          eai_sexo,
          '4 L'
        );
        RETURN NEW;
        RAISE NOTICE 'Registro inserido com sucesso''.';

    END LOOP;
  END IF;
END;

$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;

CREATE TRIGGER atualiza_esus_atendimento_individual
  AFTER INSERT OR UPDATE OR DELETE
  ON atendimento_prenatal
  FOR EACH ROW
  EXECUTE PROCEDURE esus_atendimento_individual();

/* 252767 - Fim*/
