SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='139', script='V139__3.172.171.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.172.171' WHERE conf_chave='VERSAO_SAUDE';
UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';


/*250453 - Inclusão do Campo Data do Parto*/
ALTER TABLE atendimento_prenatal DROP COLUMN IF EXISTS data_ultimo_parto;
ALTER TABLE atendimento_prenatal  ADD COLUMN data_ultimo_parto DATE;
/*250453 - Fim*/


/*251858 - Criação de data provável do parto no banco de dados.*/
ALTER TABLE atendimento_prenatal DROP COLUMN IF EXISTS data_provavel_parto;
ALTER TABLE atendimento_prenatal  ADD COLUMN data_provavel_parto DATE;
/*251858 - Fim*/


/* 249121 - Implementação de campos novos na ficha de procedimentos*/
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ACUPUNTURA COM INSERÇÃO DE AGULHAS','ABPG001','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE VITAMINA A','ABPG002','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('CATETERISMO VESICAL DE ALÍVIO','ABPG003','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('CAUTERIZAÇÃO QUÍMICA DE PEQUENAS LESÕES','ABPG004','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('CIRURGIA DE UNHA - CANTOPLASTIA','ABPG005','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('CUIDADO DE ESTOMAS','ABPG006','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('CURATIVO ESPECIAL','ABPG007','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('DRENAGEM DE ABSCESSO','ABPG008','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ELETROCARDIOGRAMA','ABEX004','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('COLETA DE CITOPATOLÓGICO DE COLO UTERINO','ABPG010','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('EXAME DE FUNDO DE OLHO - FUNDOSCOPIA','ABPG013','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('EXAME DO PÉ DIABÉTICO','ABPG011','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('EXÉRESE - BIÓPSIA - PUNÇÃO DE TUMORES SUPERFICIAIS DE PELE','ABPG012','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('INFILTRAÇÃO EM CAVIDADE SINOVIAL','ABPG014','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('REMOÇÃO DE CORPO ESTRANHO DA CAVIDADE AUDITIVA E NASAL','ABPG015','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('REMOÇÃO DE CORPO ESTRANHO SUBCUTÂNEO','ABPG016','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('RETIRADA DE CERUME','ABPG017','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('RETIRADA DE PONTOS DE CIRURGIAS','ABPG018','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('SUTURA SIMPLES','ABPG019','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TAMPONAMENTO DE EPISTAXE','ABPG021','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TESTE DO OLHINHO - TRV','ABEX022','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TRIAGEM OFTALMOLÓGICA','ABPG020','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TESTE RÁPIDO DE GRAVIDEZ','ABPG022','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TESTE RÁPIDO PARA DOSAGEM DE PROTEINÚRIA','ABPG040','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TESTE RÁPIDO PARA HIV','ABPG024','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TESTE RÁPIDO PARA HEPATITE C','ABPG025','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('TESTE RÁPIDO PARA SÍFILIS','ABPG026','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE MEDICAMENTOS VIA ORAL','ABPG027','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE MEDICAMENTOS VIA INTRAMUSCULAR','ABPG028','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE MEDICAMENTOS VIA ENDOVENOSA','ABPG029','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE MEDICAMENTOS VIA INALAÇÃO - NEBULIZAÇÃO','ABPG030','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE MEDICAMENTOS VIA TÓPICA','ABPG031','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE PENICILINA PARA TRATAMENTO DE SÍFILIS','ABPG032','I');
INSERT INTO procedimento (proc_nome, proc_codigo_sus, proc_ativo) VALUES ('ADMINISTRAÇÃO DE MEDICAMENTOS VIA SUBCUTÂNEA - SC','ABPG041','I'); 
/* 249121 - Fim*/

/*251117 - Exclusão manual de especialidade */
ALTER TABLE medico_especialidade DROP COLUMN IF EXISTS mes_data;
ALTER TABLE medico_especialidade ADD COLUMN mes_data DATE;
/*251117 - Fim*/

/*249126 - Implementação de campos novos na ficha de Atividade Coletiva */
ALTER TABLE tb_cds_ficha_ativ_col ADD pse_educacao boolean NULL;
ALTER TABLE tb_cds_ficha_ativ_col ADD pse_saude boolean NULL;
/*249126 - Fim*/

/*257403 - Implementar opção de utilização do Hórus na tela de centro estocador*/
ALTER TABLE setor ADD set_usa_horus char DEFAULT 'N' NULL;
COMMENT ON COLUMN setor.set_usa_horus IS 'S - Sim 
N - Não';
/*257403 - Fim*/

/*256648 - Obrigatoriedade de preenchimento do CNPJ para o fabricante */
ALTER TABLE fabricante ADD COLUMN fab_internacional BOOLEAN;
/*256648 - Fim*/

/*256808 - Erro em edição de movimentação de saída */
CREATE OR REPLACE FUNCTION persisteestoqueupdate()
  RETURNS trigger AS
$BODY$
DECLARE
	vmov_tipo	character(1);
	vset_entrada	bigint;
	vset_saida	bigint;
	vsal_codigo	bigint;
	vpro_codigo	bigint;
	vset_codigo	bigint;
	vsal_data	date;
	vsal_qtde	integer;
	vsal_qtde_old	integer;
	vsal_qtde_new	integer;
	vpro_custo	numeric(9,4);
	vsal_lote	character varying(20);
	vsal_validade	date;
	vnova_qtde	integer;
	vnova_qtde_old	integer;
	vnova_qtde_new	integer;
	vqtdeold	integer;
	vqtdenew	integer;
BEGIN
	vqtdeold := trunc(OLD.ite_quantidade);
	vqtdenew := trunc(NEW.ite_quantidade);

	RAISE NOTICE 'Mov_codigo: %.', OLD.mov_codigo;
	RAISE NOTICE 'Pro_codigo: %.', OLD.pro_codigo;
	RAISE NOTICE 'Ite_lote: %.', NEW.ite_lote;
	RAISE NOTICE 'Ite_validade: %.', NEW.ite_validade;
	RAISE NOTICE 'Ite_quantidadeOLD: %', vqtdeold;
	RAISE NOTICE 'Ite_quantidadeNEW: %', vqtdenew;

	--descobrir o tipo de movimento para definir se vai somar ou subtrair
	SELECT mov_tipo,
	       set_entrada,
	       set_saida
	  INTO vmov_tipo,
	       vset_entrada,
	       vset_saida
	  FROM movimento
	 WHERE mov_codigo = OLD.mov_codigo;

	RAISE NOTICE 'mov_tipo: %', vmov_tipo;
	RAISE NOTICE 'set_entrada: %', vset_entrada;
	RAISE NOTICE 'set_saida: %', vset_saida;

	--vsal_qtde := 0;

	RAISE NOTICE 'vsal_qtde: %', vsal_qtde;

	--se mov_tipo for (S)aída ou (T)ransferência
	IF vmov_tipo <> 'E' THEN
		IF NEW.ite_lote <> OLD.ite_lote THEN

			--calcular o estoque atual do old
			SELECT trunc(sal_qtde)
			  INTO vsal_qtde_old
			  FROM saldo
			 WHERE set_codigo = vset_saida
			   AND pro_codigo = OLD.pro_codigo
			   AND sal_lote = OLD.ite_lote
			   AND sal_validade = OLD.ite_validade;

			IF NOT FOUND THEN
				vsal_qtde_old = 0;
			END IF;

			--calcular novo saldo do old
			vnova_qtde_old := vsal_qtde_old + vqtdeold;

			--atualizar o estoque do lote antigo na tabela saldo
			UPDATE saldo
			   SET sal_qtde = vnova_qtde_old,
			       sal_data = CURRENT_DATE
			 WHERE set_codigo = vset_saida
			   AND pro_codigo = OLD.pro_codigo
			   AND sal_lote = OLD.ite_lote
			   AND sal_validade = OLD.ite_validade;


			   --calcular o estoque atual do new
			SELECT trunc(sal_qtde)
			  INTO vsal_qtde_new
			  FROM saldo
			 WHERE set_codigo = vset_saida
			   AND pro_codigo = NEW.pro_codigo
			   AND sal_lote = NEW.ite_lote
			   AND sal_validade = NEW.ite_validade;

			IF NOT FOUND THEN
				vsal_qtde_new = 0;
			END IF;

			--calcular novo saldo do new
			vnova_qtde_new := vsal_qtde_new - vqtdenew;

			--atualizar o estoque do lote antigo na tabela saldo
			UPDATE saldo
			   SET sal_qtde = vnova_qtde_new,
			       sal_data = CURRENT_DATE
			 WHERE set_codigo = vset_saida
			   AND pro_codigo = NEW.pro_codigo
			   AND sal_lote = NEW.ite_lote
			   AND sal_validade = NEW.ite_validade;
		ELSE
			--calcular o estoque atual
			SELECT trunc(sal_qtde)
			  INTO vsal_qtde_old
			  FROM saldo
			 WHERE set_codigo = vset_saida
			   AND pro_codigo = NEW.pro_codigo
			   AND sal_lote = NEW.ite_lote
			   AND sal_validade = NEW.ite_validade;

			IF NOT FOUND THEN
				vsal_qtde_old = 0;
			END IF;

			--calcular novo saldo
			vnova_qtde_new := vsal_qtde_old - vqtdenew + vqtdeold;

			--atualizar o estoque do lote antigo na tabela saldo
			UPDATE saldo
			   SET sal_qtde = vnova_qtde_new,
			       sal_data = CURRENT_DATE
			 WHERE set_codigo = vset_saida
			   AND pro_codigo = NEW.pro_codigo
			   AND sal_lote = NEW.ite_lote
			   AND sal_validade = NEW.ite_validade;
		END IF;

		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'vQtdenew: %', vqtdenew;
		RAISE NOTICE 'vQtdeold: %', vqtdeold;
		RAISE NOTICE 'vnova_qtde: %', vnova_qtde;
		RAISE NOTICE 'new.pro_codigo: %', OLD.pro_codigo;
		RAISE NOTICE 'new.ite_lote: %', OLD.ite_lote;
		RAISE NOTICE 'new.ite_validade: %', OLD.ite_validade;

	END IF;
	--se mov_tipo for (E)ntrada ou (T)ransferência
	IF vmov_tipo <> 'S' THEN

		--calcular o estoque atual
		SELECT trunc(sal_qtde)
		  INTO vsal_qtde
		  FROM saldo
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

		IF NOT FOUND THEN
			vsal_qtde = 0;
		END IF;

		--calcular novo saldo
		vnova_qtde := vsal_qtde - vqtdeold + vqtdenew;

		--atualizar o estoque na tabela saldo
		UPDATE saldo
		   SET sal_qtde = vnova_qtde,
		       sal_data = CURRENT_DATE,
		       sal_lote = NEW.ite_lote,
		       sal_validade = NEW.ite_validade
		 WHERE set_codigo = vset_entrada
		   AND pro_codigo = OLD.pro_codigo
		   AND sal_lote = OLD.ite_lote
		   AND sal_validade = OLD.ite_validade;

	END IF;

	RETURN NEW;
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
/*256808 - Fim */

/* 255961 - Problemas ao cadastrar grupos de exames */
SELECT setval('grupoexame_gruex_codigo_seq', (SELECT MAX(gruex_codigo) FROM grupoexame));
/* 255961 - Fim */


/* 260450 - Problemas ao cadastrar grupos de exames */
-- insert grupoexame

insert into grupoexame (gruex_codigo, gruex_descricao, pre_natal)
	values (nextval('grupoexame_gruex_codigo_seq'),'GESTANTE 1º TRIMESTRE', 'S');
	
insert into grupoexame (gruex_codigo, gruex_descricao, pre_natal)
	values (nextval('grupoexame_gruex_codigo_seq'),'GESTANTE 2º TRIMESTRE', 'S');

insert into grupoexame (gruex_codigo, gruex_descricao, pre_natal)
	values (nextval('grupoexame_gruex_codigo_seq'),'GESTANTE 3º TRIMESTRE', 'S');

insert into grupoexame (gruex_codigo, gruex_descricao, pre_natal)
	values (nextval('grupoexame_gruex_codigo_seq'),'RISCO CARDIOVASCULAR', 'N');


-- insert tipoexame_grupo
	-- Gestante 1º Trimestre

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030970'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 1);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202031179'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 2);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202120023'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 3);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202120082'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 4);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202120090'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 5);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0203010019'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 6);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0205020143'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 7);
		
insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0214010040'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 8);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0214010082'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 9);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030300'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 10);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010473'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 11);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202050017'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 12);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202020380'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 13);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202080080'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 14);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030873'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 15);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030768'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 1º trimestre%'), 16);


-- Gestante 2º Trimestre

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010040'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 1);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202031179'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 2);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0205020143'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 3);	

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0214010082'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 4);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202050017'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 5);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202020380'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 6);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202080080'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 7);		

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030873'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 8);		

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030768'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 2º trimestre%'), 9);

-- Gestante 3º Trimestre		

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202031179'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 1);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0214010082'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 2);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030300'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 3);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202050017'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 4);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202020380'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 5);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202080080'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 6);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030873'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 7);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202030768'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%Gestante 3º trimestre%'), 8);

-- Risco Cardiovascular		

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010040'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 1);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010600'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 2);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010678'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 3);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0211020036'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 4);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010295'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 5);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010317'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 6);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010279'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 7);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010503'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 8);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202010287'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 9);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0214010015'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 10);

insert into tipoexame_grupo(txg_codigo, proc_codigo, gruex_codigo, tcg_ordem)
		values(nextval('tipoexame_grupo_txg_codigo_seq'), (select proc_codigo from procedimento where proc_codigo_sus = '0202050017'), (select gruex_codigo from grupoexame where gruex_descricao  ilike '%risco cardiovascular%'), 11);
		
/* 260450 - Fim */


/* Permissão para rodar as rotinas especiais */
INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto) VALUES ('Rotinas Especiais', 'zf/default/rotina','zf/default/rotina');