SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='141', script='V141__3.174.173.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.174.173' WHERE conf_chave='VERSAO_SAUDE';
-- UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/*251597 - Realizar validação na tela de cidadão para informações documento indígena */
CREATE TABLE IF NOT EXISTS as_tipo_certidao (
  cer_codigo BIGSERIAL NOT NULL,
  usu_codigo INTEGER NOT NULL,
  tipo_certidao INTEGER NOT NULL,
  nome_cartorio VARCHAR(60),
  numero_livro VARCHAR(20),
  numero_folha VARCHAR(10),
  numero_termo VARCHAR(30),
  data_registro DATE,
  estado_registro VARCHAR(60),
  municipio_registro VARCHAR(60),
  codigo_cartorio VARCHAR(20),
  CONSTRAINT pk_certidao_dados PRIMARY KEY (cer_codigo),
  CONSTRAINT fk_usuario_dados_usuario FOREIGN KEY (usu_codigo) REFERENCES usuario (usu_codigo)
);
/*252925 - Fim*/

/* 256815 - Implementação de tela para cadastro de grupos para reuniões*/
INSERT INTO acesso(ace_descricao,ace_pai,ace_modulo,ace_caminho) VALUES('Grupo de Reuniões',(SELECT ace_codigo FROM acesso WHERE ace_descricao = 'Cadastros' LIMIT 1),13,'zf/usuarios/usuarios/grupo-usuarios');

CREATE TABLE IF NOT EXISTS as_grupo_usuarios(
  asgpu_codigo BIGSERIAL NOT NULL ,
  asgpu_desc CHARACTER VARYING,
  asgpu_status VARCHAR(1),
  CONSTRAINT pk_as_grupo_usuarios PRIMARY KEY (asgpu_codigo)
);
COMMENT ON COLUMN as_grupo_usuarios.asgpu_status IS 'A - Ativo, I - Inativo';

CREATE TABLE IF NOT EXISTS as_grupo_usuarios_participante(
  asgpp_codigo BIGSERIAL NOT NULL,
  asgpu_codigo INTEGER NOT NULL,
  usr_codigo INTEGER NOT NULL,
  CONSTRAINT pk_as_grupo_usuarios_participante PRIMARY KEY (asgpp_codigo),
  CONSTRAINT fk_as_grupo_usuarios FOREIGN KEY (asgpu_codigo) REFERENCES as_grupo_usuarios (asgpu_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usuarios FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);
/* 256815 - Fim*/

/*255734 - Incluir opção de anonimato para lançamento de denuncia no atendimento básico */
INSERT INTO usuario (usu_codigo,
                     usu_nome,
                     usu_sexo,
                     id_usuario,
                     usu_bloqueado
                    ) VALUES (
                     9999999,
                     'Anônimo',
                     'M',
                     9999999,
                     true);
/*255734 - Fim*/

/* 253264 - Implementação de tela para controle de reuniões*/
INSERT INTO acesso(ace_descricao,ace_pai,ace_modulo,ace_caminho) VALUES('Reuniões',(SELECT ace_codigo FROM acesso WHERE ace_descricao = 'Cadastros' LIMIT 1),13,'zf/default/reunioes');

CREATE TABLE IF NOT EXISTS as_reunioes(
  asreu_codigo BIGSERIAL NOT NULL,
  asreu_titulo CHARACTER VARYING,
  asreu_desc TEXT,
  asreu_data DATE,
  asreu_hora_inicio TIME,
  asreu_hora_fim TIME,
  uni_codigo INTEGER,
  CONSTRAINT pk_as_reunioes PRIMARY KEY (asreu_codigo),
  CONSTRAINT fk_uni_codigo FOREIGN KEY (uni_codigo) REFERENCES unidade (uni_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);


CREATE TABLE IF NOT EXISTS as_reunioes_participantes(
  asreupar_codigo BIGSERIAL NOT NULL,
  asreu_codigo INTEGER,
  usr_codigo INTEGER,
  CONSTRAINT pk_as_reunioes_participantes PRIMARY KEY (asreupar_codigo),
  CONSTRAINT fk_asreu_codigo FOREIGN KEY (asreu_codigo) REFERENCES as_reunioes (asreu_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_usr_codigo FOREIGN KEY (usr_codigo) REFERENCES usuarios (usr_codigo) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION
);
/* 253264 - Fim*/



/*257846 - Alteração em nomenclaturas de situações de violência e violações de direitos*/
UPDATE as_situacoes_violacao SET assv_nome = 'Exploração Sexual Intrafamiliar'
       WHERE assv_codigo = 2;
UPDATE as_situacoes_violacao SET assv_nome = 'Abuso/Violência Sexual Intrafamiliar'
       WHERE assv_codigo = 3;
UPDATE as_situacoes_violacao SET assv_nome = 'Violência Física Intrafamiliar'
       WHERE assv_codigo = 4;
UPDATE as_situacoes_violacao SET assv_nome = 'Violência Psicológica Intrafamiliar'
       WHERE assv_codigo = 5;
UPDATE as_situacoes_violacao SET assv_nome = 'Negligência ou Abandono contra idoso'
       WHERE assv_codigo = 6;
UPDATE as_situacoes_violacao SET assv_nome = 'Negligência ou Abandono contra criança'
       WHERE assv_codigo = 7;
UPDATE as_situacoes_violacao SET assv_nome = 'Negligência ou Abandono contra PCD'
       WHERE assv_codigo = 8;
INSERT INTO as_situacoes_violacao (assv_codigo,
                                   assv_nome,
                                   assv_num,
                                   assv_situacao,
                                   assv_dtcadastro
                                 ) VALUES (
                                   14,
                                   'Exploração Sexual',
                                   14,
                                   true,
                                   '2018-09-11 10:31:08');
INSERT INTO as_situacoes_violacao (assv_codigo,
                                   assv_nome,
                                   assv_num,
                                   assv_situacao,
                                   assv_dtcadastro
                                 ) VALUES (
                                   15,
                                   'Abuso/Violência Sexual',
                                   15,
                                   true,
                                   '2018-09-11 10:31:08');
INSERT INTO as_situacoes_violacao (assv_codigo,
                                   assv_nome,
                                   assv_num,
                                   assv_situacao,
                                   assv_dtcadastro
                                 ) VALUES (
                                   16,
                                   'Violência Física',
                                   16,
                                   true,
                                   '2018-09-11 10:31:08');
INSERT INTO as_situacoes_violacao (assv_codigo,
                                   assv_nome,
                                   assv_num,
                                   assv_situacao,
                                   assv_dtcadastro
                                 ) VALUES (
                                   17,
                                   'Violência Psicológica',
                                   17,
                                   true,
                                   '2018-09-11 10:31:08');
/*257846 - Fim*/



/* 243506 - Registro do sistema */
TRUNCATE registro;
/* 243506 - Fim*/


/* 263980 - Erro ao realizar gestão de login no sistema de saúde */
ALTER TABLE logon DISABLE TRIGGER logon_before;
/* 263980 - Fim*/

/*257206 - Tela para cadastro de Cargos/Funções */
INSERT INTO acesso(ace_descricao,ace_pai,ace_modulo,ace_caminho) VALUES('Cargos',(SELECT ace_codigo FROM acesso WHERE ace_descricao = 'Cadastros' LIMIT 1),13,'zf/default/cargos');

CREATE TABLE cargos
(
  crg_codigo SERIAL NOT NULL,
  crg_nome CHARACTER VARYING,
  crg_status BOOLEAN DEFAULT TRUE,
  CONSTRAINT cargos_pkey PRIMARY KEY (crg_codigo)
);

ALTER TABLE usuarios ADD COLUMN crg_codigo INTEGER;

ALTER TABLE usuarios ADD CONSTRAINT fk_crg_codigo FOREIGN KEY (crg_codigo) REFERENCES cargos (crg_codigo);

ALTER TABLE as_certidao_liberatoria DROP COLUMN ascl_cargo;

ALTER TABLE as_certidao_liberatoria ADD COLUMN crg_codigo INTEGER;

/*257206 - Fim */

/*#265593 - Alteração de posicionamento de menus*/
UPDATE acesso SET ace_pai = (SELECT ace_codigo FROM acesso WHERE ace_descricao = 'Cadastros' LIMIT 1) WHERE ace_descricao = 'Certidão Liberatória';
/* #265593 - Fim*/
